/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __GROUP_EDIT_MEMBER_VIEW_H__
#define __GROUP_EDIT_MEMBER_VIEW_H__

#include <Evas.h>
#include <contacts.h>

enum sc_gedit_member_type
{
    EDIT_MEMBER_TYPE_ADD = 1,
    EDIT_MEMBER_TYPE_REMOVE,
};

/**
 * @brief Creates new edit member view
 * @param[in]   parent          Parent naviframe
 * @param[in]   group_record    Record of the group for which the details view will be created.
 * @param[in]   type            Edit type
 */
void sc_group_edit_member_view_add(Evas_Object *parent, int group_id, enum sc_gedit_member_type type);

#endif /* __GROUP_EDIT_MEMBER_VIEW_H__ */
