/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "model/contact-details.h"

#include "model/contacts-utils/contacts-db-utils.h"
#include "model/contacts-utils/contacts-list-utils.h"
#include "model/contacts-utils/contacts-record-utils.h"
#include "utils/logger.h"


bool sc_cdetails_toggle_favourites(int person_id)
{
    contacts_record_h person_record = NULL;
    sc_db_utils_is_success(contacts_db_get_record(_contacts_person._uri, person_id, &person_record));
    RETVM_IF(!person_record, false, "person record is null");
    bool is_favourite = false;
    if( sc_db_utils_is_success(contacts_record_get_bool(person_record, _contacts_person.is_favorite, &is_favourite))
     && sc_db_utils_is_success(contacts_record_set_bool(person_record, _contacts_person.is_favorite, !is_favourite)))
    {
        if(sc_db_utils_is_success(contacts_db_update_record(person_record)))
        {
            return true;
        }
    }
    contacts_record_destroy(person_record, true);
    return false;
}

bool sc_cdetails_is_favourite(int person_id)
{
    contacts_record_h person_record = NULL;
    sc_db_utils_is_success(contacts_db_get_record(_contacts_person._uri, person_id, &person_record));
    RETVM_IF(!person_record, false, "person record is null");
    bool is_favourite = false;
    sc_db_utils_is_success(contacts_record_get_bool(person_record, _contacts_person.is_favorite, &is_favourite));
    contacts_record_destroy(person_record, true);
    return is_favourite;
}

bool sc_cdetails_get_contact_val(sc_common_contact_fields field_type, int contact_id, char **value)
{
    RETVM_IF(field_type >= CF_MAX || field_type < CF_PHONE_NUMBER, false, "incorrect field type");
    RETVM_IF(NULL == value, false, "pointer to value is null");

    bool is_success = false;
    unsigned parent_property_id = 0, child_property_id = 0;
    char *tmp_value = NULL;
    sc_common_get_contact_properties(field_type, &parent_property_id, NULL, &child_property_id);

    contacts_record_h contact_record = NULL;
    if(sc_db_utils_is_success(contacts_db_get_record(_contacts_contact._uri, contact_id, &contact_record)))
    {
        if(CF_BIRTHDAY == field_type)
        {
            int ivalue = 0;
            if( sc_record_utils_get_child_int(contact_record, parent_property_id, child_property_id, &ivalue))
            {
                struct tm date = sc_common_int_to_date(ivalue);
                *value = sc_common_date_to_str(&date);
                is_success = true;
            }
        }
        else
        {
            if( sc_record_utils_get_child_str_p(contact_record, parent_property_id, child_property_id, &tmp_value)
             && tmp_value)
            {
                *value = strdup(tmp_value);
                is_success = true;
            }
        }
        contacts_record_destroy(contact_record, false);
    }
    return is_success;
}
