/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "model/contacts-utils/contacts-db-utils.h"
#include "model/contacts-utils/contacts-list-utils.h"
#include "utils/logger.h"

bool sc_gcreate_is_group_exist(const char *group_name)
{
    contacts_list_h group_list = sc_list_utils_get_records_list_str_filter(_contacts_group._uri, _contacts_group.name, group_name);
    RETVM_IF(!group_list, 0, "group_list is NULL");
    int count = 0;
    sc_db_utils_is_success(contacts_list_get_count(group_list, &count));
    sc_db_utils_is_success(contacts_list_destroy(group_list, true));
    return (count > 0);

}

bool sc_gcreate_db_create_group(const char *group_name)
{
    bool result = false;
    contacts_record_h record = NULL;
    result = sc_db_utils_is_success(contacts_record_create(_contacts_group._uri, &record));
    if(result)
    {
        result = sc_db_utils_is_success(contacts_record_set_str(record, _contacts_group.name, group_name));
        if(result)
        {
            result = sc_db_utils_is_success(contacts_db_insert_record(record, NULL));
        }
        contacts_record_destroy(record, true);
    }
    return result;
}
