/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include "utils/ui-utils.h"

#include "utils/logger.h"

#define PART_POPUP_BUTTON1      "button1"
#define PART_POPUP_BUTTON2      "button2"
#define PART_POPUP_BUTTON3      "button3"
#define STYLE_POPUP_BUTTON      "popup_button/default"


Evas_Object *ui_utils_navi_add(Evas_Object *parent, Eext_Event_Cb back_cb, void *cb_data)
{
    RETVM_IF(NULL == parent, NULL, "parent is null");
    Evas_Object *navi = elm_naviframe_add(parent);
    eext_object_event_callback_add(navi, EEXT_CALLBACK_BACK, back_cb, cb_data);
    eext_object_event_callback_add(navi, EEXT_CALLBACK_MORE, eext_naviframe_more_cb, NULL);
    elm_naviframe_prev_btn_auto_pushed_set(navi, EINA_FALSE);
    return navi;
}

Evas_Object *ui_utils_layout_add(Evas_Object *parent, Evas_Object_Event_Cb destroy_cb, void *cb_data)
{
    Evas_Object *layout = elm_layout_add(parent);
    RETVM_IF(NULL == layout, NULL, "layout is null");

    elm_layout_theme_set(layout, "layout", "application", "default");
    evas_object_event_callback_add(layout, EVAS_CALLBACK_FREE, destroy_cb, cb_data);
    return layout;
}

Evas_Object * ui_utils_popup_button_add(Evas_Object *popup, const char *text, Evas_Smart_Cb func, void *data)
{
    RETVM_IF(NULL == popup, NULL, "popup is null");
    static const char *button_parts[] =
    {
        PART_POPUP_BUTTON1,
        PART_POPUP_BUTTON2,
        PART_POPUP_BUTTON3,
        NULL
    };
    const char **part = button_parts;
    Evas_Object *button = NULL;

    while(*part && elm_object_part_content_get(popup, *part))
    {
        ++part;
    }

    RETVM_IF(NULL == part, NULL, "No empty button parts left");

    button = elm_button_add(popup);
    RETVM_IF(NULL == button, NULL, "Failed to create button");
    elm_object_style_set(button, STYLE_POPUP_BUTTON);
    elm_object_text_set(button, text);
    elm_object_part_content_set(popup, *part, button);
    evas_object_smart_callback_add(button, EVENT_CLICKED, func, data);
    return button;
}

Evas_Object *ui_utils_toolbar_add(Evas_Object *parent)
{
    Evas_Object *toolbar = elm_toolbar_add(parent);
    RETVM_IF(NULL == toolbar, NULL, "toolbar is null");

    elm_toolbar_shrink_mode_set(toolbar, ELM_TOOLBAR_SHRINK_EXPAND);
    elm_toolbar_transverse_expanded_set(toolbar, EINA_TRUE);
    return toolbar;
}
