/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __EFL_CORE_H__
#define __EFL_CORE_H__

#include <app.h>
#include <Elementary.h>
#include <system_settings.h>
#include <efl_extension.h>
#include <dlog.h>

#ifndef  LOG_TAG
#define LOG_TAG "$(appName)"
#endif

#if !defined(PACKAGE)
#define PACKAGE "$(packageName)"
#endif

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *nf;
	Evas_Object *layout;
} appdata_s;

void ecore_animator_cb(void *data, Evas_Object *obj, void *event_info);
void ecore_event_cb(void *data, Evas_Object *obj, void *event_info);
void ecore_idler_cb(void *data, Evas_Object *obj, void *event_info);
void ecore_job_cb(void *data, Evas_Object *obj, void *event_info);
void ecore_thread_1_cb(void *data, Evas_Object *obj, void *event_info);
void ecore_thread_2_cb(void *data, Evas_Object *obj, void *event_info);
void ecore_thread_3_cb(void *data, Evas_Object *obj, void *event_info);
void ecore_thread_4_cb(void *data, Evas_Object *obj, void *event_info);
void ecore_thread_5_cb(void *data, Evas_Object *obj, void *event_info);
void ecore_timer_cb(void *data, Evas_Object *obj, void *event_info);

void eina_inlist_cb(void *data, Evas_Object *obj, void *event_info);
void eina_list_cb(void *data, Evas_Object *obj, void *event_info);
void eina_stringshare_cb(void *data, Evas_Object *obj, void *event_info);

void evas_box_cb(void *data, Evas_Object *obj, void *event_info);
void evas_event_cb(void *data, Evas_Object *obj, void *event_info);
void evas_image_cb(void *data, Evas_Object *obj, void *event_info);
void evas_map_cb(void *data, Evas_Object *obj, void *event_info);
void evas_map_mapping_cb(void *data, Evas_Object *obj, void *event_info);
void evas_map_rotation_cb(void *data, Evas_Object *obj, void *event_info);
void evas_rectangle_cb(void *data, Evas_Object *obj, void *event_info);
void evas_proxy_object_cb(void *data, Evas_Object *obj, void *event_info);

void elm_transit_cb(void *data, Evas_Object *obj, void *event_info);

void edc_alignment_cb(void *data, Evas_Object *obj, void *event_info);
void edc_animation_cb(void *data, Evas_Object *obj, void *event_info);
void edc_format_cb(void *data, Evas_Object *obj, void *event_info);
void edc_layoutsignal_cb(void *data, Evas_Object *obj, void *event_info);
void edc_map_cb(void *data, Evas_Object *obj, void *event_info);
void edc_relativepositioning_cb(void *data, Evas_Object *obj, void *event_info);
void edc_theme_extension_cb(void *data, Evas_Object *obj, void *event_info);

#endif /* __EFL_CORE_H__ */
