/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

static Evas_Object *rect, *rect2;
static Ecore_Animator *anim, *anim2;
static Ecore_Timer *timer1, *timer2, *timer3;

static Eina_Bool _advance_frame(void *data, double pos)
{
	double frame = pos;
	frame = ecore_animator_pos_map(pos, ECORE_POS_MAP_SPRING, 1.2, 15);
	evas_object_resize(data, 50 * (1 + frame), 50 * (1 + frame));
	evas_object_move(data, 100 * frame, 100 * frame);
	evas_object_color_set(data, 255 * frame, 0, 255 * (1 - frame), 255);
	return ECORE_CALLBACK_RENEW;
}

static Eina_Bool _advance_frame2(void *data, double pos)
{
	double frame = pos;
	frame = ecore_animator_pos_map(pos, ECORE_POS_MAP_BOUNCE, 1.2, 50);
	evas_object_resize(data, 100 - (50 * frame), 100 - (50 * frame));
	evas_object_move(data, 100 * (1 - frame), 100 * (1 - frame));
	evas_object_color_set(data, 255 * (1 - frame), 0, 255 * frame, 255);
	return ECORE_CALLBACK_RENEW;
}

static Eina_Bool _advance_frame3(void *data)
{
	static int x = 0;
	if (x >= 250)
		x = 0;
	evas_object_move(data, ++x, 350);
	return ECORE_CALLBACK_RENEW;
}

static Eina_Bool _start_second_anim(void *data)
{
	ecore_animator_frametime_set(1. / 10);
	ecore_animator_timeline_add(20, _advance_frame2, data);
	return ECORE_CALLBACK_CANCEL;
}

static Eina_Bool _freeze_third_anim(void *data)
{
	dlog_print(DLOG_ERROR, LOG_TAG, "ANIMATOR = %p", data);

	ecore_animator_freeze(data);
	return ECORE_CALLBACK_CANCEL;
}

static Eina_Bool _thaw_third_anim(void *data)
{
	ecore_animator_thaw(data);
	return ECORE_CALLBACK_CANCEL;
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	ecore_animator_del(anim);
	ecore_animator_del(anim2);

	ecore_timer_del(timer1);
	ecore_timer_del(timer2);
	ecore_timer_del(timer3);

	evas_object_del(rect);
	evas_object_del(rect2);

	return EINA_TRUE;
}

void
ecore_animator_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;
	Evas *evas;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Animator */
	evas = evas_object_evas_get(ad->layout);

	rect = evas_object_rectangle_add(evas);
	evas_object_color_set(rect, 0, 0, 255, 255);
	evas_object_resize(rect, 50, 50);
	evas_object_show(rect);

	rect2 = evas_object_rectangle_add(evas);
	evas_object_color_set(rect2, 0, 55, 0, 255);
	evas_object_resize(rect2, 50, 50);
	evas_object_show(rect2);

	ecore_animator_frametime_set(1. / 50);
	anim = ecore_animator_timeline_add(5, _advance_frame, rect);

	anim2 = ecore_animator_add(_advance_frame3, rect2);
	timer1 = ecore_timer_add(10, _start_second_anim, rect);
	timer2 = ecore_timer_add(5, _freeze_third_anim, anim2);
	timer3 = ecore_timer_add(10, _thaw_third_anim, anim2);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
