/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#define LOG_TAG "eina_inlist"
#include "main.h"

struct my_struct {
     EINA_INLIST;
     int a, b;
};

Eina_Inlist *list, *itr, *tmp;

int sort_cb(const void *d1, const void *d2)
{
	const Eina_Inlist *l1, *l2;
	const struct my_struct *x1, *x2;

	l1 = d1;
	l2 = d2;

	x1 = EINA_INLIST_CONTAINER_GET(l1, struct my_struct);
	x2 = EINA_INLIST_CONTAINER_GET(l2, struct my_struct);

	return x1->a - x2->a;
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	return EINA_TRUE;
}

void
eina_inlist_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Label*/
	Evas_Object *label;
	label = elm_label_add(ad->layout);
	elm_object_text_set(label, "Eina Inlist");
	evas_object_size_hint_weight_set(label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_part_content_set(ad->layout, "elm.swallow.content", label);
	evas_object_show(label);

	/*InList Code*/
	struct my_struct *d, *cur;

	d = malloc(sizeof(*d));
	d->a = 1;
	d->b = 10;
	list = eina_inlist_append(NULL, EINA_INLIST_GET(d));
	d = malloc(sizeof(*d));
	d->a = 2;
	d->b = 20;
	list = eina_inlist_append(list, EINA_INLIST_GET(d));
	d = malloc(sizeof(*d));
	d->a = 3;
	d->b = 30;
	list = eina_inlist_prepend(list, EINA_INLIST_GET(d));
	dlog_print(DLOG_INFO, LOG_TAG, "list=%p\n", list);
	EINA_INLIST_FOREACH(list, cur)
	dlog_print(DLOG_INFO, LOG_TAG, "\ta=%d, b=%d\n", cur->a, cur->b);
	list = eina_inlist_promote(list, EINA_INLIST_GET(d));
	d = malloc(sizeof(*d));
	d->a = 4;
	d->b = 40;
	list = eina_inlist_append_relative(list, EINA_INLIST_GET(d), list);
	list = eina_inlist_demote(list, EINA_INLIST_GET(d));
	list = eina_inlist_sort(list, sort_cb);
	dlog_print(DLOG_INFO, LOG_TAG, "list after sort=%p\n", list);
	EINA_INLIST_FOREACH(list, cur)
	dlog_print(DLOG_INFO, LOG_TAG, "\ta=%d, b=%d\n", cur->a, cur->b);
	tmp = eina_inlist_find(list, EINA_INLIST_GET(d));
	if (tmp)
		cur = EINA_INLIST_CONTAINER_GET(tmp, struct my_struct);
	else
		cur = NULL;
	if (d != cur)
		dlog_print(DLOG_INFO, LOG_TAG, "wrong node! cur=%p\n", cur);
	list = eina_inlist_remove(list, EINA_INLIST_GET(d));
	free(d);
	printf("list=%p\n", list);
	for (itr = list; itr != NULL; itr = itr->next)
	{
		cur = EINA_INLIST_CONTAINER_GET(itr, struct my_struct);
		printf("\ta=%d, b=%d\n", cur->a, cur->b);
	}

	while (list)
	{
		struct my_struct *aux = EINA_INLIST_CONTAINER_GET(list,struct my_struct);
		list = eina_inlist_remove(list, list);
		free(aux);
	}

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
