/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

static pthread_t thread_id;
static Eina_Bool thread_finish;

static void *thread_run(void *arg)
{
   Evas_Object *btn = arg;
   double t = 0.0;
   Evas_Coord x, y;

   while (!thread_finish)
     {
        x = 150 + (150 * sin(t));
        y = 150 + (150 * cos(t));

        //begin critical section
        ecore_thread_main_loop_begin();
          {
             evas_object_move(btn, x, y);
          }
        //end critical section
        ecore_thread_main_loop_end();

        usleep(1000);
        t += 0.001;
     }

   pthread_exit(NULL);

   return NULL;
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	void *thread_result;

	thread_finish = EINA_TRUE;
	pthread_join(thread_id, &thread_result);

	return EINA_TRUE;
}

void
ecore_thread_1_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Evas_Object *btn;
	Elm_Object_Item *nf_it;
	thread_finish = EINA_FALSE;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	//Create a Button
	btn = elm_button_add(ad->layout);
	elm_object_text_set(btn, "Ecore Thread Main Loop");
	evas_object_resize(btn, ELM_SCALE_SIZE(400), ELM_SCALE_SIZE(100));
	evas_object_show(btn);

	//Create a thread
	if (!pthread_create(&thread_id, NULL, thread_run, btn))
		perror("pthread_create!\n");

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
