/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

#define EDC_THEME_EXTENSION
#include "edc_common.h"

static void
create_content(appdata_s *ad)
{
	Evas_Object *grid, *btn_origin, *btn_customized;

	grid = elm_grid_add(ad->layout);
	elm_object_part_content_set(ad->layout, "elm.swallow.content", grid);
	evas_object_show(grid);

	btn_origin = elm_button_add(grid);
	elm_object_text_set(btn_origin, "Default style");
	elm_grid_pack(grid, btn_origin, 25, 30, 50, 10);
	evas_object_show(btn_origin);

	btn_customized = elm_button_add(grid);
	/* Sets the style to be used by a button */
	elm_object_style_set(btn_customized, "customized");
	elm_object_text_set(btn_customized, "Customized style");
	elm_grid_pack(grid, btn_customized, 25, 60, 50, 20);
	evas_object_show(btn_customized);
}

static void
app_get_resource(const char *edj_file_in, char *edj_path_out, int edj_path_max)
{
	char *res_path = app_get_resource_path();
	if (res_path) {
		snprintf(edj_path_out, edj_path_max, "%s%s", res_path, edj_file_in);
		free(res_path);
	}
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	return EINA_TRUE;
}

void
edc_theme_extension_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;
	char edj_path[PATH_MAX] = {0, };

	/* Base Layout */
	app_get_resource(EDJ_FILE, edj_path, (int)PATH_MAX);

	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Appends a theme extension to the list of extensions */
	elm_theme_extension_add(NULL, edj_path);

	create_content(ad);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
