/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

static Elm_Transit *transit;

static void
transit_exam(Evas_Object *layout)
{
   Evas_Object *btn;

   //Create a Button
   btn = elm_button_add(layout);
   elm_object_text_set(btn, "Transit Test");
   evas_object_move(btn, 0, 0);
   evas_object_resize(btn, ELM_SCALE_SIZE(270), ELM_SCALE_SIZE(200));
   evas_object_show(btn);

   //Create a Transit
   transit = elm_transit_add();
   elm_transit_object_add(transit, btn);

   //TODO: move button to (200, 200)
   elm_transit_effect_translation_add(transit,0, 0, 200, 200);

   elm_transit_effect_rotation_add(transit, 0, 180);

   //TODO: default count 1 + repeat 3. So total animation time is 4.
   elm_transit_repeat_times_set(transit, 3);

   //TODO: reverse the effect
   elm_transit_auto_reverse_set(transit, 1);

   //1 second for one animation.
   elm_transit_duration_set(transit, 1);

   elm_transit_go(transit);
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	elm_transit_del(transit);
	transit = NULL;

	return EINA_TRUE;
}

void
elm_transit_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Label*/
	Evas_Object *label = elm_label_add(ad->layout);
	elm_object_text_set(label, "Elm Transit");
	evas_object_size_hint_weight_set(label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_part_content_set(ad->layout, "elm.swallow.content", label);
	evas_object_show(label);

	transit_exam(ad->layout);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
