/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

static Evas_Object *green_rect, *img;

// Rotate any evas object by using evas map
void
rotate(Evas_Object *obj, double degree)
{
	//Create a map consisted of 4 points
	Evas_Map *map = evas_map_new(4);

	Evas_Coord x, y, w, h;

	//Get the geometry information from the object
	evas_object_geometry_get(obj, &x, &y, &w, &h);

	//Set the object image uv values to map
	evas_map_util_points_populate_from_object_full(map, obj, 0);

	//Rotate by 45 degrees on object’s  local Y axis
	evas_map_util_3d_rotate(map, 0, degree, 0, x + w / 2, y + h / 2, 0);

	//Set the perspective transform
	evas_map_util_3d_perspective(map, x + w / 2, y + h / 2, 0, 400);

	//Enable the object’s map
	evas_object_map_enable_set(obj, EINA_TRUE);

	//Apply the new map to object
	evas_object_map_set(obj, map);

	//Free the map resource
	evas_map_free(map);
}

static void
app_get_resource(const char *res_file_in, char *res_path_out, int res_path_max)
{
	char *res_path = app_get_resource_path();
	if (res_path) {
		snprintf(res_path_out, res_path_max, "%s%s", res_path, res_file_in);
		free(res_path);
	}
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	evas_object_del(green_rect);
	evas_object_del(img);

	return EINA_TRUE;
}

void
evas_map_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Elm_Object_Item *nf_it;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* Evas Map */
	Evas *evas = evas_object_evas_get(ad->layout);
	green_rect = evas_object_rectangle_add(evas);
	evas_object_color_set(green_rect, 0, 255, 0, 255);
	evas_object_move(green_rect, 50, 75);
	evas_object_resize(green_rect, 200, 200);
	rotate(green_rect, 45);
	evas_object_show(green_rect);

	char img_path[PATH_MAX] = { 0, };
	app_get_resource("tizen.png", img_path, PATH_MAX);

	img = evas_object_image_filled_add(evas);
	evas_object_image_file_set(img, img_path, NULL);
	evas_object_move(img, 100, 325);
	evas_object_resize(img, 356, 96);
	rotate(img, 45);
	evas_object_show(img);

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
