/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

static void
win_delete_request_cb(void *data , Evas_Object *obj , void *event_info)
{
	ui_app_exit();
}

static void
list_selected_cb(void *data, Evas_Object *obj, void *event_info)
{
	Elm_Object_Item *it = event_info;
	elm_list_item_selected_set(it, EINA_FALSE);
}

static void
create_ecore_list(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	Evas_Object *list;

	list = elm_list_add(ad->nf);
	elm_list_mode_set(list, ELM_LIST_COMPRESS);
	evas_object_smart_callback_add(list, "selected", list_selected_cb, NULL);

	elm_list_item_append(list, "Ecore Animator", NULL, NULL, ecore_animator_cb, ad);
	elm_list_item_append(list, "Ecore Event", NULL, NULL, ecore_event_cb, ad);
	elm_list_item_append(list, "Ecore Idler", NULL, NULL, ecore_idler_cb, ad);
	elm_list_item_append(list, "Ecore Job", NULL, NULL, ecore_job_cb, ad);
	elm_list_item_append(list, "Ecore Thread 1", NULL, NULL, ecore_thread_1_cb, ad);
	elm_list_item_append(list, "Ecore Thread 2", NULL, NULL, ecore_thread_2_cb, ad);
	elm_list_item_append(list, "Ecore Thread 3", NULL, NULL, ecore_thread_3_cb, ad);
	elm_list_item_append(list, "Ecore Thread 4", NULL, NULL, ecore_thread_4_cb, ad);
	elm_list_item_append(list, "Ecore Thread 5", NULL, NULL, ecore_thread_5_cb, ad);
	elm_list_item_append(list, "Ecore Timer", NULL, NULL, ecore_timer_cb, ad);

	elm_list_go(list);

	evas_object_show(list);

	elm_naviframe_item_push(ad->nf, "Ecore", NULL, NULL, list, NULL);
}

static void
create_eina_list(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	Evas_Object *list;

	list = elm_list_add(ad->nf);
	elm_list_mode_set(list, ELM_LIST_COMPRESS);
	evas_object_smart_callback_add(list, "selected", list_selected_cb, NULL);

	elm_list_item_append(list, "Eina Inlist", NULL, NULL, eina_inlist_cb, ad);
	elm_list_item_append(list, "Eina List", NULL, NULL, eina_list_cb, ad);
	elm_list_item_append(list, "Eina Stringshare", NULL, NULL, eina_stringshare_cb, ad);

	elm_list_go(list);

	evas_object_show(list);

	elm_naviframe_item_push(ad->nf, "Eina", NULL, NULL, list, NULL);
}

static void
create_evas_list(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	Evas_Object *list;

	list = elm_list_add(ad->nf);
	elm_list_mode_set(list, ELM_LIST_COMPRESS);
	evas_object_smart_callback_add(list, "selected", list_selected_cb, NULL);

	elm_list_item_append(list, "Evas Box", NULL, NULL, evas_box_cb, ad);
	elm_list_item_append(list, "Evas Event", NULL, NULL, evas_event_cb, ad);
	elm_list_item_append(list, "Evas Image", NULL, NULL, evas_image_cb, ad);
	elm_list_item_append(list, "Evas Map", NULL, NULL, evas_map_cb, ad);
	elm_list_item_append(list, "Evas Map Mapping", NULL, NULL, evas_map_mapping_cb, ad);
	elm_list_item_append(list, "Evas Map Rotation", NULL, NULL, evas_map_rotation_cb, ad);
	elm_list_item_append(list, "Evas Rectangle", NULL, NULL, evas_rectangle_cb, ad);
	elm_list_item_append(list, "Proxy Object", NULL, NULL, evas_proxy_object_cb, ad);

	elm_list_go(list);

	evas_object_show(list);

	elm_naviframe_item_push(ad->nf, "Evas", NULL, NULL, list, NULL);
}

static void
create_elementary_list(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	Evas_Object *list;

	list = elm_list_add(ad->nf);
	elm_list_mode_set(list, ELM_LIST_COMPRESS);
	evas_object_smart_callback_add(list, "selected", list_selected_cb, NULL);

	elm_list_item_append(list, "Elm_Transit", NULL, NULL, elm_transit_cb, ad);

	elm_list_go(list);

	evas_object_show(list);

	elm_naviframe_item_push(ad->nf, "Elementary", NULL, NULL, list, NULL);
}

static void
create_edc_list(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	Evas_Object *list;

	list = elm_list_add(ad->nf);
	elm_list_mode_set(list, ELM_LIST_COMPRESS);
	evas_object_smart_callback_add(list, "selected", list_selected_cb, NULL);

	elm_list_item_append(list, "Alignment", NULL, NULL, edc_alignment_cb, ad);
	elm_list_item_append(list, "Animation", NULL, NULL, edc_animation_cb, ad);
	elm_list_item_append(list, "EDC Map", NULL, NULL, edc_map_cb, ad);
	elm_list_item_append(list, "EDC format", NULL, NULL, edc_format_cb, ad);
	elm_list_item_append(list, "Layout Signal", NULL, NULL, edc_layoutsignal_cb, ad);
	elm_list_item_append(list, "Relative Positioning", NULL, NULL, edc_relativepositioning_cb, ad);
	elm_list_item_append(list, "Theme Extension", NULL, NULL, edc_theme_extension_cb, ad);

	elm_list_go(list);

	evas_object_show(list);

	elm_naviframe_item_push(ad->nf, "EDC script", NULL, NULL, list, NULL);
}

static Evas_Object *
create_main_list(appdata_s *ad)
{
	Evas_Object *list;

	/* List */
	list = elm_list_add(ad->nf);
	elm_list_mode_set(list, ELM_LIST_COMPRESS);
	evas_object_smart_callback_add(list, "selected", list_selected_cb, NULL);

	/* Main Menu Items Here */
	elm_list_item_append(list, "Ecore", NULL, NULL, create_ecore_list, ad);
	elm_list_item_append(list, "Eina", NULL, NULL, create_eina_list, ad);
	elm_list_item_append(list, "Evas", NULL, NULL, create_evas_list, ad);
	elm_list_item_append(list, "Elementary", NULL, NULL, create_elementary_list, ad);
	elm_list_item_append(list, "EDC script", NULL, NULL, create_edc_list, ad);

	elm_list_go(list);

	return list;
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	appdata_s *ad = data;

	/* Let window go to hide state. */
	elm_win_lower(ad->win);

	return EINA_FALSE;
}

static void
create_base_gui(appdata_s *ad)
{
	Evas_Object *main_list;
	Elm_Object_Item *nf_it;

	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_conformant_set(ad->win, EINA_TRUE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);

	if (elm_win_wm_rotation_supported_get(ad->win)) {
		int rots[4] = { 0, 90, 180, 270 };
		elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);
	}

	evas_object_smart_callback_add(ad->win, "delete,request", win_delete_request_cb, NULL);

	/* Conformant */
	ad->conform = elm_conformant_add(ad->win);
	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);

	/* Naviframe */
	ad->nf = elm_naviframe_add(ad->conform);
	eext_object_event_callback_add(ad->nf, EEXT_CALLBACK_BACK, eext_naviframe_back_cb, ad);
	evas_object_size_hint_weight_set(ad->nf, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_content_set(ad->conform, ad->nf);
	evas_object_show(ad->nf);

	/* Main list */
	main_list = create_main_list(ad);
	nf_it = elm_naviframe_item_push(ad->nf, "EFL Core Samples", NULL, NULL, main_list, NULL);
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);

	/* Show window after base gui is set up */
	evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	elm_app_base_scale_set(1.8);

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

static void
ui_app_orient_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
	return;
}

static void
ui_app_region_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void
ui_app_low_battery(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void
ui_app_low_memory(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY], APP_EVENT_LOW_BATTERY, ui_app_low_battery, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY], APP_EVENT_LOW_MEMORY, ui_app_low_memory, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED], APP_EVENT_DEVICE_ORIENTATION_CHANGED, ui_app_orient_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED], APP_EVENT_REGION_FORMAT_CHANGED, ui_app_region_changed, &ad);
	ui_app_remove_event_handler(handlers[APP_EVENT_LOW_MEMORY]);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ui_app_main() is failed. err = %d", ret);
	}

	return ret;
}
