/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

typedef struct user_data {
	Evas_Object *btn;
	Evas_Coord x, y;
} user_data;

static pthread_t thread_id;
static pthread_mutex_t lock;
static Eina_Bool thread_finish;

static void
thread_safe_call_async_cb(void *data)
{
	//This function is in critical section.

	user_data *ud = data;
	evas_object_move(ud->btn, ud->x, ud->y);
}

static void *
thread_run(void *arg)
{
	Evas_Object *btn = arg;
	double t = 0.0;
	Evas_Coord x, y;

	user_data data;
	data.btn = btn;

	while (1) {
		x = 150 + (150 * sin(t));
		y = 200 + (150 * cos(t));

		data.x = x;
		data.y = y;

		//Now don't need to wait for synchronizing main loop here.
		ecore_main_loop_thread_safe_call_async(thread_safe_call_async_cb, &data);

		usleep(1000);
		t += 0.001;

		//Mutual Exclusive for shared data.
		pthread_mutex_lock(&lock);
		if (thread_finish) break;
		pthread_mutex_unlock(&lock);
	}

	pthread_exit(NULL);

	return NULL;
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	void *thread_result;

	//Mutual Exclusive for shared data.
	pthread_mutex_lock(&lock);
	thread_finish = EINA_TRUE;
	pthread_mutex_unlock(&lock);

	pthread_join(thread_id, &thread_result);

	return EINA_TRUE;
}

void
ecore_thread_3_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;

	Evas_Object *btn;
	Elm_Object_Item *nf_it;
	thread_finish = EINA_FALSE;

	/* Base Layout */
	ad->layout = elm_layout_add(ad->win);
	elm_layout_theme_set(ad->layout, "layout", "application", "default");
	evas_object_size_hint_weight_set(ad->layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(ad->layout);

	/* ecore_main_loop_thread_safe_call_async() */
	//Create a Button
	btn = elm_button_add(ad->layout);
	elm_object_text_set(btn, "Thread Safe Async");
	evas_object_resize(btn, ELM_SCALE_SIZE(350), ELM_SCALE_SIZE(100));
	evas_object_show(btn);

	pthread_mutex_init(&lock, NULL);

	//Create a thread
	if (!pthread_create(&thread_id, NULL, thread_run, btn))
		perror("pthread_create!\n");

	/* Push base layout into naviframe */
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, ad->layout, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
