/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __$(appName)_teapot_H__
#define __$(appName)_teapot_H__

const unsigned int MAX_V_COUNT = 3242;
const unsigned int MAX_F_COUNT = 6400;

const float TEAPOT_VERTICES[] =
{
	0.367734, 0.25645, -1.08055e-008, 0.39026, 0.587501, 0.7089,
	0.362129, 0.25645, 0.0714057, 0.404684, 0.608425, 0.682679,
	0.35781, 0.267465, 0.0706877, 0.156869, 0.640748, 0.751554,
	0.363358, 0.267465, -1.12923e-008, 0.146083, 0.591005, 0.79333,
	0.356114, 0.276034, 0.070406, 0.278578, 0.696439, 0.661337,
	0.361641, 0.276034, -1.16563e-008, 0.266705, 0.663563, 0.698965,
	0.356674, 0.282154, 0.070499, 0.37078, 0.715259, 0.59239,
	0.362208, 0.282154, -1.19268e-008, 0.362675, 0.696581, 0.619065,
	0.359122, 0.285825, 0.0709058, 0.443642, 0.713732, 0.542005,
	0.364688, 0.285825, -1.20889e-008, 0.440282, 0.705165, 0.555782,
	0.363087, 0.287049, 0.0715651, 0.504047, 0.700185, 0.505645,
	0.368705, 0.287049, -1.2143e-008, 0.505166, 0.698534, 0.506811,
	0.368204, 0.285825, 0.0724156, 0.55628, 0.678747, 0.479431,
	0.373889, 0.285825, -1.20889e-008, 0.561388, 0.681802, 0.46903,
	0.374104, 0.282154, 0.0733961, 0.603037, 0.651346, 0.460538,
	0.379865, 0.282154, -1.19268e-008, 0.611671, 0.657666, 0.439697,
	0.380417, 0.276034, 0.0744455, 0.645905, 0.618951, 0.446886,
	0.386261, 0.276034, -1.16563e-008, 0.657732, 0.627537, 0.416637,
	0.386777, 0.267465, 0.0755025, 0.685871, 0.58192, 0.436977,
	0.392703, 0.267465, -1.12923e-008, 0.700648, 0.592069, 0.39818,
	0.392813, 0.25645, 0.0765061, 0.777475, 0.520378, 0.353184,
	0.398819, 0.25645, -1.08055e-008, 0.800205, 0.531267, 0.278256,
	0.34587, 0.25645, 0.138842, 0.426536, 0.627994, 0.650915,
	0.341715, 0.267465, 0.137446, 0.180206, 0.694535, 0.696525,
	0.340083, 0.276034, 0.136899, 0.297245, 0.729509, 0.616004,
	0.340623, 0.282154, 0.137079, 0.381805, 0.733757, 0.561983,
	0.342977, 0.285825, 0.13787, 0.447526, 0.722798, 0.526577,
	0.346793, 0.287049, 0.139152, 0.501878, 0.703122, 0.503724,
	0.351715, 0.285825, 0.140806, 0.549043, 0.677539, 0.48938,
	0.357391, 0.282154, 0.142713, 0.59143, 0.647277, 0.480877,
	0.363465, 0.276034, 0.144754, 0.630462, 0.612799, 0.47644,
	0.369584, 0.267465, 0.146809, 0.666935, 0.574262, 0.474786,
	0.375393, 0.25645, 0.14876, 0.746546, 0.512084, 0.424781,
	0.319794, 0.25645, 0.201475, 0.458213, 0.643966, 0.612658,
	0.315901, 0.267465, 0.199449, 0.233654, 0.747589, 0.621705,
	0.314372, 0.276034, 0.198653, 0.331576, 0.757891, 0.561835,
	0.314877, 0.282154, 0.198917, 0.400753, 0.748422, 0.528452,
	0.317083, 0.285825, 0.200065, 0.454889, 0.729607, 0.510637,
	0.320658, 0.287049, 0.201925, 0.500342, 0.705208, 0.502335,
	0.325271, 0.285825, 0.204325, 0.540437, 0.676596, 0.500146,
	0.330588, 0.282154, 0.207091, 0.57697, 0.644298, 0.501981,
	0.33628, 0.276034, 0.210052, 0.610964, 0.608422, 0.506503,
	0.342012, 0.267465, 0.213035, 0.642998, 0.568859, 0.512789,
	0.347454, 0.25645, 0.215866, 0.707106, 0.506444, 0.493474,
	0.284735, 0.25645, 0.258467, 0.497316, 0.654023, 0.570027,
	0.281194, 0.267465, 0.255868, 0.316123, 0.788314, 0.527851,
	0.279805, 0.276034, 0.254849, 0.379491, 0.77732, 0.501756,
	0.280264, 0.282154, 0.255186, 0.426432, 0.757876, 0.49374,
	0.282269, 0.285825, 0.256658, 0.465235, 0.733866, 0.494972,
	0.285521, 0.287049, 0.259044, 0.499423, 0.706474, 0.501469,
	0.289716, 0.285825, 0.262123, 0.530732, 0.676041, 0.511167,
	0.294553, 0.282154, 0.265671, 0.560123, 0.642519, 0.522907,
	0.299728, 0.276034, 0.26947, 0.588044, 0.605823, 0.535894,
	0.304941, 0.267465, 0.273297, 0.614765, 0.565686, 0.549603,
	0.309891, 0.25645, 0.276929, 0.660039, 0.503229, 0.557771,
	0.241529, 0.25645, 0.308984, 0.540611, 0.656638, 0.525895,
	0.238423, 0.267465, 0.305878, 0.418196, 0.804161, 0.422419,
	0.237204, 0.276034, 0.304658, 0.43689, 0.784439, 0.440208,
	0.237607, 0.282154, 0.305061, 0.457125, 0.761291, 0.459861,
	0.239367, 0.285825, 0.30682, 0.477973, 0.735428, 0.4803,
	0.24222, 0.287049, 0.309674, 0.499074, 0.70699, 0.501089,
	0.245899, 0.285825, 0.313353, 0.520237, 0.675913, 0.52201,
	0.250142, 0.282154, 0.317597, 0.541351, 0.642001, 0.542932,
	0.254683, 0.276034, 0.322137, 0.562297, 0.60501, 0.563724,
	0.259258, 0.267465, 0.326712, 0.582933, 0.564677, 0.584234,
	0.2636, 0.25645, 0.331054, 0.606143, 0.5023, 0.616673,
	0.191013, 0.25645, 0.352189, 0.584599, 0.651385, 0.483676,
	0.188414, 0.267465, 0.348648, 0.523955, 0.78931, 0.320095,
	0.187395, 0.276034, 0.347259, 0.498452, 0.777966, 0.382511,
	0.187731, 0.282154, 0.347718, 0.490892, 0.758347, 0.428876,
	0.189204, 0.285825, 0.349723, 0.49249, 0.734231, 0.467288,
	0.19159, 0.287049, 0.352975, 0.499275, 0.706781, 0.501183,
	0.194668, 0.285825, 0.35717, 0.509232, 0.676272, 0.532296,
	0.198217, 0.282154, 0.362007, 0.521166, 0.642721, 0.561512,
	0.202016, 0.276034, 0.367182, 0.534325, 0.605975, 0.589314,
	0.205843, 0.267465, 0.372395, 0.548165, 0.565818, 0.615927,
	0.209475, 0.25645, 0.377345, 0.546131, 0.503619, 0.669409,
	0.134021, 0.25645, 0.387248, 0.626016, 0.639119, 0.4468,
	0.131995, 0.267465, 0.383355, 0.618523, 0.749217, 0.23686,
	0.131199, 0.276034, 0.381827, 0.558804, 0.759055, 0.334025,
	0.131463, 0.282154, 0.382331, 0.52569, 0.749302, 0.402736,
	0.132611, 0.285825, 0.384537, 0.508129, 0.730316, 0.456556,
	0.134471, 0.287049, 0.388112, 0.500072, 0.705783, 0.501796,
	0.13687, 0.285825, 0.392725, 0.498089, 0.677085, 0.541723,
	0.139637, 0.282154, 0.398043, 0.50012, 0.64469, 0.578148,
	0.142598, 0.276034, 0.403734, 0.50481, 0.608731, 0.612056,
	0.14558, 0.267465, 0.409466, 0.51123, 0.569121, 0.644007,
	0.148412, 0.25645, 0.414908, 0.480784, 0.507254, 0.715221,
	0.0713883, 0.25645, 0.413324, 0.662256, 0.621676, 0.418253,
	0.069992, 0.267465, 0.409169, 0.694166, 0.696343, 0.182317,
	0.0694449, 0.276034, 0.407538, 0.613477, 0.730951, 0.298926,
	0.0696252, 0.282154, 0.408077, 0.559479, 0.734944, 0.383198,
	0.070416, 0.285825, 0.410431, 0.524205, 0.72377, 0.448738,
	0.0716979, 0.287049, 0.414247, 0.501502, 0.70394, 0.502956,
	0.0733516, 0.285825, 0.419169, 0.487309, 0.678235, 0.550024,
	0.075259, 0.282154, 0.424846, 0.478968, 0.647847, 0.592354,
	0.0772994, 0.276034, 0.43092, 0.474666, 0.613286, 0.631326,
	0.0793547, 0.267465, 0.437038, 0.473143, 0.574659, 0.667759,
	0.0813056, 0.25645, 0.442847, 0.411213, 0.513374, 0.753227,
	0.00395144, 0.25645, 0.429583, 0.691558, 0.60149, 0.399948,
	0.00323363, 0.267465, 0.425265, 0.749993, 0.642364, 0.157733,
	0.00295188, 0.276034, 0.423569, 0.659424, 0.697923, 0.279399,
	0.00304488, 0.282154, 0.424128, 0.590316, 0.716579, 0.371539,
	0.00345172, 0.285825, 0.426576, 0.539925, 0.714862, 0.444357,
	0.00411084, 0.287049, 0.430542, 0.503615, 0.701168, 0.504713,
	0.00496132, 0.285825, 0.435658, 0.477496, 0.679586, 0.55692,
	0.00594199, 0.282154, 0.441558, 0.458703, 0.652079, 0.603643,
	0.00699129, 0.276034, 0.447871, 0.445162, 0.619579, 0.646493,
	0.00804842, 0.267465, 0.454231, 0.435354, 0.582473, 0.686434,
	0.00905184, 0.25645, 0.460267, 0.339153, 0.522247, 0.782453,
	-0.0674542, 0.25645, 0.435188, 0.710672, 0.581063, 0.396624,
	-0.0674542, 0.267465, 0.430813, 0.787173, 0.59497, 0.162385,
	-0.0674542, 0.276034, 0.429095, 0.695175, 0.664263, 0.274749,
	-0.0674542, 0.282154, 0.429662, 0.616708, 0.69667, 0.366499,
	-0.0674542, 0.285825, 0.432142, 0.553996, 0.705401, 0.442151,
	-0.0674542, 0.287049, 0.436159, 0.50516, 0.698981, 0.506201,
	-0.0674542, 0.285825, 0.441343, 0.467372, 0.682352, 0.562102,
	-0.0674542, 0.282154, 0.447319, 0.438035, 0.658219, 0.612269,
	-0.0674542, 0.276034, 0.453715, 0.415017, 0.628037, 0.658278,
	-0.0674542, 0.267465, 0.460157, 0.396637, 0.592499, 0.701159,
	-0.0674542, 0.25645, 0.466273, 0.263772, 0.533523, 0.803603,
	-0.145658, 0.25645, 0.429583, 0.741568, 0.552087, 0.381153,
	-0.143098, 0.267465, 0.425265, 0.827027, 0.540435, 0.154776,
	-0.141341, 0.276034, 0.423569, 0.731949, 0.627727, 0.264972,
	-0.140285, 0.282154, 0.424128, 0.643125, 0.676333, 0.359115,
	-0.139828, 0.285825, 0.426576, 0.567208, 0.697132, 0.4385,
	-0.139869, 0.287049, 0.430542, 0.504999, 0.699016, 0.506313,
	-0.140305, 0.285825, 0.435658, 0.454758, 0.687939, 0.565629,
	-0.141034, 0.282154, 0.441558, 0.414184, 0.667403, 0.61889,
	-0.141954, 0.276034, 0.447871, 0.381054, 0.639456, 0.667753,
	-0.142963, 0.267465, 0.454231, 0.353501, 0.605122, 0.713347,
	-0.14396, 0.25645, 0.460267, 0.182062, 0.546923, 0.817147,
	-0.217039, 0.25645, 0.413324, 0.777358, 0.512352, 0.36498,
	-0.212732, 0.267465, 0.409169, 0.875832, 0.464953, 0.12937,
	-0.209853, 0.276034, 0.407538, 0.775247, 0.58089, 0.248111,
	-0.208219, 0.282154, 0.408077, 0.67327, 0.651427, 0.349786,
	-0.207646, 0.285825, 0.410431, 0.582057, 0.687298, 0.434546,
	-0.207949, 0.287049, 0.414247, 0.505117, 0.699208, 0.50593,
	-0.208947, 0.285825, 0.419169, 0.441571, 0.69475, 0.567748,
	-0.210457, 0.282154, 0.424846, 0.389089, 0.678608, 0.622977,
	-0.212293, 0.276034, 0.43092, 0.345253, 0.653405, 0.673693,
	-0.214273, 0.267465, 0.437038, 0.307893, 0.620566, 0.72118,
	-0.216214, 0.25645, 0.442847, 0.0967001, 0.562982, 0.820793,
	-0.281267, 0.25645, 0.387248, 0.804219, 0.471415, 0.361939,
	-0.275897, 0.267465, 0.383355, 0.91083, 0.390877, 0.132677,
	-0.272425, 0.276034, 0.381827, 0.810727, 0.529909, 0.248833,
	-0.270602, 0.282154, 0.382331, 0.700392, 0.621884, 0.350302,
	-0.270183, 0.285825, 0.384537, 0.596667, 0.674193, 0.435261,
	-0.270921, 0.287049, 0.388112, 0.506392, 0.69776, 0.506654,
	-0.272568, 0.285825, 0.392725, 0.430145, 0.701366, 0.568384,
	-0.274878, 0.282154, 0.398042, 0.365946, 0.690765, 0.623641,
	-0.277605, 0.276034, 0.403734, 0.311291, 0.669297, 0.67464,
	-0.280501, 0.267465, 0.409466, 0.263856, 0.638708, 0.722795,
	-0.28332, 0.25645, 0.414908, 0.0115008, 0.5822, 0.812964,
	-0.338007, 0.25645, 0.352189, 0.818149, 0.439012, 0.37135,
	-0.332133, 0.267465, 0.348648, 0.928151, 0.335918, 0.160296,
	-0.32849, 0.276034, 0.347259, 0.832468, 0.486652, 0.264891,
	-0.326785, 0.282154, 0.347718, 0.71967, 0.59429, 0.359018,
	-0.326722, 0.285825, 0.349723, 0.608199, 0.661157, 0.439278,
	-0.328009, 0.287049, 0.352975, 0.507679, 0.696266, 0.50742,
	-0.33035, 0.285825, 0.35717, 0.420498, 0.708487, 0.566769,
	-0.333452, 0.282154, 0.362007, 0.345509, 0.70413, 0.620342,
	-0.337021, 0.276034, 0.367182, 0.28042, 0.687124, 0.670243,
	-0.340762, 0.267465, 0.372395, 0.22292, 0.659535, 0.717858,
	-0.344383, 0.25645, 0.377345, -0.0716215, 0.604695, 0.79323,
	-0.386929, 0.25645, 0.308984, 0.819479, 0.419926, 0.390022,
	-0.38098, 0.267465, 0.305878, 0.929598, 0.307027, 0.203917,
	-0.377483, 0.276034, 0.304658, 0.839573, 0.458118, 0.291968,
	-0.376113, 0.282154, 0.305061, 0.729061, 0.573405, 0.373735,
	-0.376541, 0.285825, 0.30682, 0.615027, 0.650656, 0.44541,
	-0.378438, 0.287049, 0.309674, 0.508235, 0.69578, 0.507531,
	-0.38148, 0.285825, 0.313353, 0.412739, 0.716392, 0.56252,
	-0.385334, 0.282154, 0.317597, 0.328491, 0.718703, 0.612829,
	-0.389675, 0.276034, 0.322137, 0.253793, 0.706799, 0.660321,
	-0.394176, 0.267465, 0.326712, 0.186555, 0.682975, 0.706217,
	-0.398508, 0.25645, 0.331054, -0.150889, 0.630708, 0.76121,
	-0.4277, 0.25645, 0.258467, 0.811066, 0.413236, 0.414015,
	-0.421976, 0.267465, 0.255868, 0.918815, 0.301001, 0.2553,
	-0.418837, 0.276034, 0.254849, 0.83439, 0.444863, 0.325407,
	-0.417935, 0.282154, 0.255186, 0.729174, 0.560674, 0.392364,
	-0.418918, 0.285825, 0.256658, 0.616904, 0.643674, 0.452893,
	-0.421436, 0.287049, 0.259044, 0.507883, 0.696554, 0.506821,
	-0.42514, 0.285825, 0.262123, 0.407113, 0.724927, 0.555643,
	-0.429679, 0.282154, 0.265671, 0.315672, 0.734126, 0.601175,
	-0.434701, 0.276034, 0.26947, 0.232637, 0.72801, 0.644889,
	-0.439858, 0.267465, 0.273297, 0.156347, 0.708881, 0.687781,
	-0.444799, 0.25645, 0.276929, -0.224308, 0.660588, 0.716456,
	-0.45999, 0.25645, 0.201475, 0.796413, 0.41468, 0.440189,
	-0.454663, 0.267465, 0.199449, 0.899472, 0.309522, 0.308459,
	-0.451988, 0.276034, 0.198653, 0.820501, 0.442748, 0.361596,
	-0.451598, 0.282154, 0.198917, 0.722141, 0.554647, 0.413375,
	-0.453133, 0.285825, 0.200065, 0.614694, 0.639671, 0.461489,
	-0.456228, 0.287049, 0.201925, 0.506954, 0.698115, 0.505601,
	-0.460517, 0.285825, 0.204325, 0.404085, 0.733438, 0.546612,
	-0.465639, 0.282154, 0.207091, 0.307941, 0.749706, 0.585759,
	-0.47123, 0.276034, 0.210052, 0.218382, 0.750146, 0.624172,
	-0.476925, 0.267465, 0.213035, 0.134252, 0.73683, 0.662614,
	-0.482362, 0.25645, 0.215866, -0.28923, 0.694734, 0.658552,
	-0.483464, 0.25645, 0.138842, 0.778695, 0.419234, 0.466773,
	-0.478581, 0.267465, 0.137446, 0.875001, 0.323587, 0.36009,
	-0.476367, 0.276034, 0.136899, 0.801467, 0.44599, 0.398426,
	-0.476451, 0.282154, 0.137079, 0.710599, 0.552271, 0.435942,
	-0.478466, 0.285825, 0.13787, 0.609845, 0.637111, 0.471358,
	-0.482037, 0.287049, 0.139152, 0.506165, 0.699436, 0.504565,
	-0.486796, 0.285825, 0.140806, 0.404251, 0.740951, 0.536258,
	-0.492372, 0.282154, 0.142713, 0.306286, 0.764379, 0.567374,
	-0.498396, 0.276034, 0.144754, 0.212644, 0.772183, 0.598762,
	-0.504496, 0.267465, 0.146809, 0.122618, 0.765973, 0.63107,
	-0.510301, 0.25645, 0.14876, -0.341954, 0.733415, 0.587512,
	-0.497792, 0.25645, 0.0714056, 0.760365, 0.422658, 0.493158,
	-0.493268, 0.267465, 0.0706877, 0.848518, 0.335704, 0.409048,
	-0.491409, 0.276034, 0.0704059, 0.78034, 0.449196, 0.435077,
	-0.491842, 0.282154, 0.070499, 0.697029, 0.550201, 0.459814,
	-0.494193, 0.285825, 0.0709057, 0.603938, 0.634114, 0.482864,
	-0.49809, 0.287049, 0.071565, 0.506376, 0.699281, 0.504569,
	-0.503161, 0.285825, 0.0724154, 0.408227, 0.746307, 0.525715,
	-0.509032, 0.282154, 0.073396, 0.311579, 0.776836, 0.547215,
	-0.515331, 0.276034, 0.0744454, 0.216987, 0.792591, 0.569839,
	-0.521685, 0.267465, 0.0755025, 0.123934, 0.794749, 0.594151,
	-0.527721, 0.25645, 0.076506, -0.377562, 0.77659, 0.504336,
	-0.502642, 0.25645, -9.79596e-008, 0.74523, 0.419034, 0.518693,
	-0.498267, 0.267465, -9.75633e-008, 0.824253, 0.33772, 0.45448,
	-0.49655, 0.276034, -9.75945e-008, 0.761119, 0.446768, 0.470208,
	-0.497117, 0.282154, -9.79807e-008, 0.684364, 0.545709, 0.483578,
	-0.499596, 0.285825, -9.86351e-008, 0.598083, 0.630409, 0.494855,
	-0.503613, 0.287049, -9.94998e-008, 0.50646, 0.699033, 0.504828,
	-0.508797, 0.285825, -1.00473e-007, 0.412723, 0.751595, 0.514553,
	-0.514773, 0.282154, -1.01513e-007, 0.318688, 0.789141, 0.525066,
	-0.521169, 0.276034, -1.0253e-007, 0.224843, 0.812941, 0.53719,
	-0.527611, 0.267465, -1.0344e-007, 0.130634, 0.823859, 0.551535,
	-0.533727, 0.25645, -1.04183e-007, -0.400828, 0.821264, 0.406031,
	-0.497037, 0.25645, -0.0714056, 0.731892, 0.409036, 0.544999,
	-0.492719, 0.267465, -0.0706878, 0.802636, 0.328098, 0.498124,
	-0.491023, 0.276034, -0.070406, 0.744592, 0.437545, 0.50412,
	-0.491582, 0.282154, -0.0704991, 0.67335, 0.53859, 0.506478,
	-0.49403, 0.285825, -0.0709058, 0.592302, 0.62711, 0.505877,
	-0.497996, 0.287049, -0.071565, 0.505101, 0.700971, 0.503501,
	-0.503112, 0.285825, -0.0724155, 0.414608, 0.759904, 0.500646,
	-0.509012, 0.282154, -0.0733961, 0.322504, 0.804641, 0.498541,
	-0.515325, 0.276034, -0.0744455, 0.229155, 0.836313, 0.498065,
	-0.521685, 0.267465, -0.0755026, 0.13383, 0.85572, 0.499832,
	-0.527721, 0.25645, -0.076506, -0.416235, 0.862714, 0.287181,
	-0.480778, 0.25645, -0.138842, 0.715617, 0.399764, 0.572784,
	-0.476623, 0.267465, -0.137446, 0.777996, 0.316428, 0.542767,
	-0.474992, 0.276034, -0.136899, 0.72577, 0.427526, 0.538961,
	-0.475531, 0.282154, -0.137079, 0.660615, 0.531609, 0.530075,
	-0.477885, 0.285825, -0.13787, 0.585387, 0.62445, 0.517092,
	-0.481701, 0.287049, -0.139152, 0.503353, 0.703654, 0.501505,
	-0.486624, 0.285825, -0.140806, 0.417185, 0.768671, 0.484873,
	-0.4923, 0.282154, -0.142713, 0.328416, 0.820156, 0.468495,
	-0.498374, 0.276034, -0.144753, 0.237357, 0.859172, 0.453304,
	-0.504492, 0.267465, -0.146809, 0.143068, 0.886654, 0.439745,
	-0.510301, 0.25645, -0.14876, -0.410358, 0.898763, 0.154374,
	-0.454702, 0.25645, -0.201475, 0.695543, 0.39345, 0.60118,
	-0.450809, 0.267465, -0.199449, 0.747899, 0.308454, 0.587795,
	-0.449281, 0.276034, -0.198655, 0.702241, 0.420504, 0.574486,
	-0.449785, 0.282154, -0.198917, 0.644373, 0.526579, 0.554524,
	-0.451991, 0.285825, -0.200065, 0.576721, 0.622398, 0.529164,
	-0.455566, 0.287049, -0.201925, 0.502157, 0.70546, 0.500164,
	-0.460179, 0.285825, -0.204325, 0.423146, 0.775052, 0.469299,
	-0.465496, 0.282154, -0.207091, 0.341096, 0.831799, 0.437908,
	-0.471188, 0.276034, -0.210052, 0.256254, 0.87684, 0.4068,
	-0.47692, 0.267465, -0.213034, 0.167618, 0.911251, 0.376199,
	-0.482362, 0.25645, -0.215866, -0.372978, 0.927659, 0.018335,
	-0.419643, 0.25645, -0.258467, 0.672448, 0.389938, 0.629096,
	-0.416102, 0.267465, -0.255868, 0.713245, 0.303821, 0.631644,
	-0.414713, 0.276034, -0.254849, 0.674811, 0.416358, 0.609324,
	-0.415172, 0.282154, -0.255186, 0.625262, 0.523523, 0.578767,
	-0.417177, 0.285825, -0.256658, 0.566637, 0.621075, 0.541469,
	-0.420429, 0.287049, -0.259044, 0.501492, 0.706441, 0.499446,
	-0.424624, 0.285825, -0.262122, 0.432069, 0.778874, 0.454611,
	-0.429461, 0.282154, -0.265671, 0.359747, 0.838952, 0.40834,
	-0.434636, 0.276034, -0.26947, 0.28478, 0.887932, 0.361216,
	-0.43985, 0.267465, -0.273297, 0.206297, 0.927049, 0.313085,
	-0.444799, 0.25645, -0.276929, -0.304257, 0.945981, -0.112013,
	-0.376438, 0.25645, -0.308984, 0.647008, 0.389105, 0.655728,
	-0.373332, 0.267465, -0.305878, 0.674822, 0.302274, 0.673235,
	-0.372112, 0.276034, -0.304658, 0.644247, 0.414911, 0.642491,
	-0.372515, 0.282154, -0.305061, 0.603874, 0.522434, 0.601996,
	-0.374275, 0.285825, -0.306821, 0.555472, 0.620547, 0.553509,
	-0.377128, 0.287049, -0.309674, 0.501314, 0.706671, 0.4993,
	-0.380807, 0.285825, -0.313354, 0.443462, 0.78006, 0.441416,
	-0.385051, 0.282154, -0.317597, 0.38328, 0.841294, 0.381209,
	-0.389592, 0.276034, -0.322137, 0.321195, 0.891636, 0.319092,
	-0.394166, 0.267465, -0.326712, 0.256629, 0.932406, 0.25448,
	-0.398508, 0.25645, -0.331054, -0.207611, 0.951375, -0.227557,
	-0.325921, 0.25645, -0.352189, 0.619863, 0.390885, 0.680425,
	-0.323322, 0.267465, -0.348648, 0.633345, 0.303706, 0.711785,
	-0.322303, 0.276034, -0.347259, 0.611214, 0.416144, 0.673232,
	-0.32264, 0.282154, -0.347718, 0.580802, 0.523259, 0.623593,
	-0.324112, 0.285825, -0.349723, 0.543588, 0.620808, 0.564898,
	-0.326498, 0.287049, -0.352975, 0.501602, 0.706186, 0.499696,
	-0.329577, 0.285825, -0.35717, 0.45678, 0.778626, 0.430225,
	-0.333125, 0.282154, -0.362007, 0.410494, 0.838715, 0.357843,
	-0.336924, 0.276034, -0.367182, 0.36337, 0.88768, 0.282819,
	-0.340751, 0.267465, -0.372395, 0.315256, 0.926762, 0.204268,
	-0.344383, 0.25645, -0.377345, -0.0893259, 0.943133, -0.320189,
	-0.268929, 0.25645, -0.387248, 0.591688, 0.395374, 0.702556,
	-0.266903, 0.267465, -0.383355, 0.589601, 0.308176, 0.746591,
	-0.266107, 0.276034, -0.381827, 0.576472, 0.420074, 0.700869,
	-0.266371, 0.282154, -0.382331, 0.556649, 0.526053, 0.64297,
	-0.267519, 0.285825, -0.384537, 0.531368, 0.621852, 0.575281,
	-0.269379, 0.287049, -0.388112, 0.502393, 0.704931, 0.500672,
	-0.271779, 0.285825, -0.392725, 0.4715, 0.774568, 0.421583,
	-0.274545, 0.282154, -0.398043, 0.440082, 0.831319, 0.339466,
	-0.277506, 0.276034, -0.403734, 0.408944, 0.876338, 0.254551,
	-0.280489, 0.267465, -0.409466, 0.378322, 0.910694, 0.165855,
	-0.28332, 0.25645, -0.414908, 0.0423441, 0.922382, -0.383951,
	-0.206297, 0.25645, -0.413324, 0.563376, 0.402682, 0.721426,
	-0.2049, 0.267465, -0.409169, 0.544636, 0.315956, 0.776881,
	-0.204353, 0.276034, -0.407537, 0.540986, 0.426843, 0.724665,
	-0.204533, 0.282154, -0.408077, 0.532217, 0.530808, 0.659535,
	-0.205324, 0.285825, -0.410431, 0.5193, 0.623613, 0.584324,
	-0.206606, 0.287049, -0.414247, 0.503715, 0.702854, 0.502263,
	-0.20826, 0.285825, -0.419169, 0.487043, 0.767922, 0.416034,
	-0.210167, 0.282154, -0.424846, 0.470623, 0.81942, 0.327208,
	-0.212208, 0.276034, -0.430919, 0.455364, 0.858434, 0.236083,
	-0.214263, 0.267465, -0.437038, 0.441775, 0.885854, 0.141768,
	-0.216214, 0.25645, -0.442847, 0.178361, 0.891809, -0.415768,
	-0.13886, 0.25645, -0.429583, 0.536098, 0.412906, 0.73628,
	-0.138142, 0.267465, -0.425265, 0.499969, 0.327356, 0.801791,
	-0.13786, 0.276034, -0.423569, 0.506097, 0.436587, 0.743813,
	-0.137953, 0.282154, -0.424129, 0.508541, 0.53752, 0.67265,
	-0.13836, 0.285825, -0.426576, 0.507993, 0.625984, 0.591682,
	-0.139019, 0.287049, -0.430542, 0.505599, 0.699891, 0.504503,
	-0.13987, 0.285825, -0.435658, 0.50271, 0.75886, 0.414021,
	-0.14085, 0.282154, -0.441558, 0.500535, 0.803642, 0.321907,
	-0.141899, 0.276034, -0.447871, 0.5, 0.835319, 0.228565,
	-0.142957, 0.267465, -0.454231, 0.501703, 0.854713, 0.13327,
	-0.14396, 0.25645, -0.460267, 0.310083, 0.855021, -0.415677,
	-0.067454, 0.25645, -0.435188, 0.509087, 0.421905, 0.750217,
	-0.067454, 0.267465, -0.430813, 0.454822, 0.338827, 0.82361,
	-0.067454, 0.276034, -0.429095, 0.47122, 0.447361, 0.760145,
	-0.067454, 0.282154, -0.429662, 0.485032, 0.545765, 0.683289,
	-0.067454, 0.285825, -0.432142, 0.496563, 0.630022, 0.597074,
	-0.067454, 0.287049, -0.436159, 0.506657, 0.698322, 0.505613,
	-0.067454, 0.285825, -0.441343, 0.516413, 0.750681, 0.412063,
	-0.067454, 0.282154, -0.447319, 0.526907, 0.788109, 0.318204,
	-0.067454, 0.276034, -0.453715, 0.538996, 0.811834, 0.224518,
	-0.067454, 0.267465, -0.460157, 0.553292, 0.82271, 0.130447,
	-0.067454, 0.25645, -0.466273, 0.425872, 0.81311, -0.396843,
	0.00395157, 0.25645, -0.429583, 0.480163, 0.427936, 0.765712,
	0.00323363, 0.267465, -0.425265, 0.40566, 0.345851, 0.846065,
	0.00295188, 0.276034, -0.423569, 0.43353, 0.456559, 0.77692,
	0.00304501, 0.282154, -0.424129, 0.459486, 0.554788, 0.693601,
	0.00345172, 0.285825, -0.426576, 0.48332, 0.636435, 0.601126,
	0.00411097, 0.287049, -0.430542, 0.505521, 0.700013, 0.504411,
	0.00496145, 0.285825, -0.435658, 0.526976, 0.746058, 0.407054,
	0.00594199, 0.282154, -0.441558, 0.548687, 0.776017, 0.311032,
	0.00699142, 0.276034, -0.447871, 0.571444, 0.791467, 0.216867,
	0.00804842, 0.267465, -0.454231, 0.595831, 0.793465, 0.124093,
	0.00905197, 0.25645, -0.460267, 0.521554, 0.768453, -0.370757,
	0.0713883, 0.25645, -0.413324, 0.45113, 0.435245, 0.77913,
	0.069992, 0.267465, -0.409169, 0.353442, 0.352434, 0.866527,
	0.0694449, 0.276034, -0.407537, 0.39393, 0.466511, 0.791951,
	0.0696252, 0.282154, -0.408077, 0.432851, 0.565165, 0.702302,
	0.070416, 0.285825, -0.410431, 0.469331, 0.644212, 0.60392,
	0.0716979, 0.287049, -0.414247, 0.503448, 0.702736, 0.502695,
	0.0733516, 0.285825, -0.419169, 0.535944, 0.742015, 0.402713,
	0.075259, 0.282154, -0.424846, 0.567752, 0.764207, 0.306015,
	0.0772994, 0.276034, -0.430919, 0.599697, 0.771334, 0.213091,
	0.0793547, 0.267465, -0.437038, 0.632327, 0.764809, 0.123408,
	0.0813056, 0.25645, -0.442847, 0.602339, 0.726134, -0.331539,
	0.134021, 0.25645, -0.387248, 0.424189, 0.445866, 0.788205,
	0.131995, 0.267465, -0.383355, 0.302236, 0.363442, 0.881228,
	0.131201, 0.276034, -0.381827, 0.355906, 0.480102, 0.801769,
	0.131463, 0.282154, -0.382331, 0.407938, 0.577735, 0.706972,
	0.132611, 0.285825, -0.384537, 0.456703, 0.652545, 0.604655,
	0.134471, 0.287049, -0.388112, 0.501924, 0.70463, 0.501566,
	0.13687, 0.285825, -0.392725, 0.544281, 0.736317, 0.401989,
	0.139637, 0.282154, -0.398043, 0.584762, 0.75055, 0.307779,
	0.142598, 0.276034, -0.403734, 0.624255, 0.749854, 0.219147,
	0.14558, 0.267465, -0.409466, 0.66339, 0.735927, 0.135369,
	0.148412, 0.25645, -0.414908, 0.670625, 0.688251, -0.27672,
	0.191013, 0.25645, -0.352189, 0.4006, 0.459629, 0.792629,
	0.188414, 0.267465, -0.348648, 0.253818, 0.379063, 0.889881,
	0.187395, 0.276034, -0.347259, 0.321003, 0.497304, 0.806006,
	0.187731, 0.282154, -0.347718, 0.385843, 0.59226, 0.707356,
	0.189204, 0.285825, -0.349723, 0.445972, 0.661208, 0.603252,
	0.19159, 0.287049, -0.352975, 0.500941, 0.705739, 0.50099,
	0.194668, 0.285825, -0.35717, 0.55154, 0.729431, 0.404641,
	0.198217, 0.282154, -0.362007, 0.598958, 0.735972, 0.315587,
	0.202016, 0.276034, -0.367182, 0.644231, 0.72829, 0.233582,
	0.205843, 0.267465, -0.372395, 0.688128, 0.708265, 0.157611,
	0.209475, 0.25645, -0.377345, 0.725821, 0.654846, -0.210619,
	0.241529, 0.25645, -0.308984, 0.381533, 0.476387, 0.792141,
	0.238423, 0.267465, -0.305878, 0.209951, 0.399683, 0.892286,
	0.237204, 0.276034, -0.304658, 0.290726, 0.518065, 0.804417,
	0.237607, 0.282154, -0.305061, 0.367544, 0.608475, 0.703328,
	0.239367, 0.285825, -0.306821, 0.437558, 0.669982, 0.599722,
	0.24222, 0.287049, -0.309674, 0.500472, 0.70612, 0.500921,
	0.245899, 0.285825, -0.313354, 0.557413, 0.721756, 0.410316,
	0.250142, 0.282154, -0.317597, 0.609893, 0.721168, 0.328554,
	0.254683, 0.276034, -0.322137, 0.659192, 0.707471, 0.254853,
	0.259258, 0.267465, -0.326712, 0.706235, 0.682595, 0.187872,
	0.2636, 0.25645, -0.331054, 0.768083, 0.625627, -0.136526,
	0.284735, 0.25645, -0.258467, 0.368237, 0.495919, 0.786426,
	0.281194, 0.267465, -0.255868, 0.172711, 0.42589, 0.888138,
	0.279805, 0.276034, -0.254849, 0.266691, 0.542401, 0.796666,
	0.280264, 0.282154, -0.255186, 0.354026, 0.625995, 0.694835,
	0.282269, 0.285825, -0.256658, 0.43186, 0.678573, 0.594168,
	0.285521, 0.287049, -0.259044, 0.500498, 0.705808, 0.501334,
	0.289716, 0.285825, -0.262122, 0.561685, 0.713616, 0.418643,
	0.294553, 0.282154, -0.265671, 0.617333, 0.706609, 0.345838,
	0.299728, 0.276034, -0.26947, 0.668972, 0.687886, 0.281585,
	0.304941, 0.267465, -0.273297, 0.71767, 0.659283, 0.224268,
	0.309891, 0.25645, -0.276929, 0.797811, 0.600221, -0.0568481,
	0.319794, 0.25645, -0.201475, 0.362055, 0.517897, 0.775047,
	0.315901, 0.267465, -0.199449, 0.144898, 0.458344, 0.876884,
	0.314372, 0.276034, -0.198655, 0.250871, 0.570091, 0.782343,
	0.314877, 0.282154, -0.198917, 0.346326, 0.644339, 0.681825,
	0.317083, 0.285825, -0.200065, 0.429256, 0.686646, 0.586734,
	0.320658, 0.287049, -0.201925, 0.50106, 0.704749, 0.502263,
	0.325271, 0.285825, -0.204325, 0.564239, 0.705226, 0.42929,
	0.330589, 0.282154, -0.207091, 0.621142, 0.692633, 0.366664,
	0.33628, 0.276034, -0.210052, 0.673501, 0.669842, 0.312582,
	0.342012, 0.267465, -0.213034, 0.722492, 0.638479, 0.265238,
	0.347454, 0.25645, -0.215866, 0.815393, 0.578299, 0.0265482,
	0.34587, 0.25645, -0.138842, 0.364333, 0.54153, 0.757632,
	0.341715, 0.267465, -0.137446, 0.130262, 0.497522, 0.857615,
	0.340083, 0.276034, -0.136899, 0.245556, 0.600452, 0.761025,
	0.340623, 0.282154, -0.137079, 0.345523, 0.66268, 0.664431,
	0.342977, 0.285825, -0.13787, 0.430117, 0.693736, 0.577693,
	0.346793, 0.287049, -0.139152, 0.5022, 0.702884, 0.503735,
	0.351715, 0.285825, -0.140806, 0.565037, 0.696747, 0.441901,
	0.357391, 0.282154, -0.142713, 0.621285, 0.679489, 0.390255,
	0.363465, 0.276034, -0.144753, 0.672795, 0.653569, 0.346691,
	0.369584, 0.267465, -0.146809, 0.720791, 0.620297, 0.309341,
	0.375393, 0.25645, -0.14876, 0.821132, 0.559656, 0.111931,
	0.362129, 0.25645, -0.0714056, 0.375969, 0.565427, 0.734125,
	0.35781, 0.267465, -0.0706877, 0.133307, 0.542891, 0.829156,
	0.356114, 0.276034, -0.070406, 0.252981, 0.631932, 0.732572,
	0.356674, 0.282154, -0.070499, 0.352468, 0.679798, 0.643149,
	0.359122, 0.285825, -0.0709058, 0.434684, 0.699301, 0.567475,
	0.363087, 0.287049, -0.071565, 0.503974, 0.700141, 0.50578,
	0.368204, 0.285825, -0.0724155, 0.564109, 0.688359, 0.456007,
	0.374104, 0.282154, -0.0733961, 0.61785, 0.667427, 0.415695,
	0.380417, 0.276034, -0.0744455, 0.66703, 0.639261, 0.382645,
	0.386777, 0.267465, -0.0755025, 0.71281, 0.604854, 0.35504,
	0.392813, 0.25645, -0.076506, 0.815388, 0.54423, 0.197374,
	0.41575, 0.207515, 0.0803186, 0.815061, 0.495181, 0.300784,
	0.422054, 0.207515, -8.67368e-009, 0.837716, 0.504809, 0.208327,
	0.438226, 0.158719, 0.0840546, 0.815973, 0.490825, 0.305415,
	0.444824, 0.158719, -6.52734e-009, 0.838835, 0.500606, 0.213893,
	0.459783, 0.110203, 0.0876377, 0.818835, 0.482584, 0.310842,
	0.466662, 0.110203, -4.40984e-009, 0.842028, 0.4925, 0.220073,
	0.479958, 0.0621075, 0.0909913, 0.823638, 0.470205, 0.31706,
	0.4871, 0.0621075, -2.30688e-009, 0.847281, 0.48025, 0.226878,
	0.498292, 0.0145713, 0.0940387, 0.830361, 0.453294, 0.324076,
	0.505674, 0.0145713, -2.32652e-010, 0.854591, 0.463436, 0.234311,
	0.514324, -0.0322661, 0.0967037, 0.838978, 0.431239, 0.331886,
	0.521915, -0.0322661, 1.81273e-009, 0.863937, 0.441435, 0.242381,
	0.527595, -0.0782642, 0.0989096, 0.849415, 0.403201, 0.340475,
	0.535359, -0.0782642, 3.82927e-009, 0.875248, 0.413393, 0.25109,
	0.537644, -0.123283, 0.10058, 0.861501, 0.36805, 0.349795,
	0.545539, -0.123283, 5.78799e-009, 0.888373, 0.378129, 0.260408,
	0.544011, -0.167182, 0.101638, 0.874895, 0.324292, 0.359714,
	0.551989, -0.167182, 7.71811e-009, 0.902958, 0.334112, 0.270252,
	0.546236, -0.209823, 0.102008, 0.89119, 0.258375, 0.372857,
	0.554243, -0.209823, 9.57592e-009, 0.920808, 0.267676, 0.283657,
	0.397462, 0.207515, 0.156173, 0.781713, 0.487675, 0.388714,
	0.419087, 0.158719, 0.163437, 0.782648, 0.483169, 0.392441,
	0.439827, 0.110203, 0.170405, 0.78541, 0.474777, 0.397136,
	0.459239, 0.0621075, 0.176925, 0.789995, 0.462241, 0.402792,
	0.476879, 0.0145713, 0.18285, 0.79638, 0.445156, 0.409408,
	0.492305, -0.0322661, 0.188032, 0.804524, 0.422936, 0.416973,
	0.505074, -0.0782642, 0.192322, 0.814356, 0.39473, 0.425455,
	0.514743, -0.123283, 0.19557, 0.825698, 0.35943, 0.434778,
	0.520869, -0.167182, 0.197628, 0.838205, 0.315584, 0.444769,
	0.523009, -0.209823, 0.198346, 0.85336, 0.249656, 0.457655,
	0.368131, 0.207515, 0.226624, 0.737577, 0.482551, 0.472361,
	0.388392, 0.158719, 0.237165, 0.738672, 0.477949, 0.47532,
	0.407824, 0.110203, 0.247274, 0.741471, 0.469454, 0.479409,
	0.426011, 0.0621075, 0.256736, 0.745961, 0.456818, 0.484624,
	0.442538, 0.0145713, 0.265335, 0.752128, 0.439622, 0.490954,
	0.45699, -0.0322661, 0.272854, 0.759924, 0.417292, 0.49838,
	0.468954, -0.0782642, 0.279079, 0.769272, 0.388993, 0.506859,
	0.478012, -0.123283, 0.283791, 0.780006, 0.353613, 0.516284,
	0.483751, -0.167182, 0.286778, 0.791783, 0.309739, 0.526442,
	0.485757, -0.209823, 0.287821, 0.806083, 0.24386, 0.539224,
	0.328695, 0.207515, 0.290729, 0.683704, 0.479562, 0.550063,
	0.347122, 0.158719, 0.304252, 0.685082, 0.47491, 0.552379,
	0.364795, 0.110203, 0.317222, 0.688036, 0.466359, 0.555982,
	0.381335, 0.0621075, 0.32936, 0.692549, 0.453664, 0.560861,
	0.396367, 0.0145713, 0.340392, 0.698604, 0.436413, 0.567006,
	0.409511, -0.0322661, 0.350038, 0.706163, 0.414021, 0.574387,
	0.420391, -0.0782642, 0.358023, 0.715143, 0.385676, 0.582945,
	0.428629, -0.123283, 0.36407, 0.725392, 0.350266, 0.592554,
	0.433849, -0.167182, 0.367901, 0.73659, 0.306388, 0.602961,
	0.435673, -0.209823, 0.369238, 0.750292, 0.24057, 0.615782,
	0.280097, 0.207515, 0.347551, 0.621041, 0.478566, 0.620712,
	0.296264, 0.158719, 0.363718, 0.622829, 0.473897, 0.6225,
	0.311768, 0.110203, 0.379222, 0.62605, 0.465327, 0.625725,
	0.326279, 0.0621075, 0.393733, 0.630691, 0.452615, 0.630372,
	0.339467, 0.0145713, 0.406921, 0.636739, 0.435349, 0.636424,
	0.350998, -0.0322661, 0.418452, 0.644161, 0.412939, 0.643846,
	0.360543, -0.0782642, 0.427998, 0.65288, 0.384581, 0.652568,
	0.367771, -0.123283, 0.435225, 0.662757, 0.349169, 0.662446,
	0.372351, -0.167182, 0.439805, 0.673501, 0.305302, 0.673192,
	0.373951, -0.209823, 0.441405, 0.686831, 0.239541, 0.68621,
	0.223275, 0.207515, 0.396149, 0.550418, 0.479509, 0.683455,
	0.236798, 0.158719, 0.414576, 0.552729, 0.474861, 0.684834,
	0.249768, 0.110203, 0.432249, 0.55633, 0.466309, 0.687788,
	0.261906, 0.0621075, 0.44879, 0.561208, 0.453614, 0.692301,
	0.272938, 0.0145713, 0.46382, 0.567346, 0.43637, 0.698356,
	0.282584, -0.0322661, 0.476965, 0.574722, 0.413988, 0.70591,
	0.290569, -0.0782642, 0.487845, 0.583279, 0.385644, 0.714887,
	0.296616, -0.123283, 0.496083, 0.592884, 0.350256, 0.725127,
	0.300446, -0.167182, 0.501303, 0.603292, 0.306403, 0.736312,
	0.301784, -0.209823, 0.503127, 0.616449, 0.240672, 0.749712,
	0.159169, 0.207515, 0.435585, 0.472677, 0.482448, 0.737442,
	0.169711, 0.158719, 0.455846, 0.475634, 0.477854, 0.738531,
	0.17982, 0.110203, 0.475278, 0.479722, 0.469362, 0.741327,
	0.189282, 0.0621075, 0.493465, 0.484936, 0.456729, 0.745812,
	0.197881, 0.0145713, 0.509992, 0.49127, 0.439542, 0.751969,
	0.2054, -0.0322661, 0.524444, 0.498697, 0.417226, 0.759752,
	0.211625, -0.0782642, 0.536408, 0.507181, 0.388941, 0.769086,
	0.216337, -0.123283, 0.545466, 0.516611, 0.353598, 0.779796,
	0.219324, -0.167182, 0.551206, 0.526777, 0.309778, 0.791545,
	0.220367, -0.209823, 0.553211, 0.539934, 0.24406, 0.805547,
	0.0887187, 0.207515, 0.464916, 0.388967, 0.487538, 0.781672,
	0.0959827, 0.158719, 0.486542, 0.392693, 0.483044, 0.782599,
	0.102951, 0.110203, 0.507281, 0.39739, 0.474657, 0.785355,
	0.109471, 0.0621075, 0.526693, 0.40305, 0.462131, 0.789927,
	0.115396, 0.0145713, 0.544333, 0.409671, 0.445061, 0.796298,
	0.120578, -0.0322661, 0.559759, 0.417245, 0.422857, 0.804424,
	0.124868, -0.0782642, 0.572528, 0.425742, 0.394688, 0.814227,
	0.128116, -0.123283, 0.582197, 0.435087, 0.359432, 0.825535,
	0.130174, -0.167182, 0.588323, 0.445104, 0.315662, 0.837997,
	0.130892, -0.209823, 0.590463, 0.45841, 0.249955, 0.852867,
	0.0128645, 0.207515, 0.483204, 0.301075, 0.495056, 0.81503,
	0.0166005, 0.158719, 0.50568, 0.305704, 0.490708, 0.815936,
	0.0201836, 0.110203, 0.527237, 0.311127, 0.482481, 0.818787,
	0.023537, 0.0621075, 0.547412, 0.317346, 0.470126, 0.823573,
	0.0265846, 0.0145713, 0.565746, 0.324367, 0.453231, 0.830282,
	0.0292494, -0.0322661, 0.581778, 0.332184, 0.431205, 0.838878,
	0.0314555, -0.0782642, 0.595049, 0.340784, 0.403214, 0.849285,
	0.0331258, -0.123283, 0.605098, 0.350118, 0.368114, 0.861341,
	0.0341841, -0.167182, 0.611465, 0.360059, 0.324447, 0.874695,
	0.0345539, -0.209823, 0.61369, 0.373636, 0.258769, 0.890749,
	-0.0674542, 0.207515, 0.489508, 0.208927, 0.504743, 0.837606,
	-0.0674542, 0.158719, 0.512279, 0.214482, 0.500539, 0.838724,
	-0.0674542, 0.110203, 0.534116, 0.220654, 0.492434, 0.841915,
	-0.0674542, 0.0621075, 0.554554, 0.227441, 0.480186, 0.847167,
	-0.0674542, 0.0145713, 0.573128, 0.234855, 0.463374, 0.854475,
	-0.0674542, -0.0322661, 0.589369, 0.242907, 0.441375, 0.86382,
	-0.0674542, -0.0782642, 0.602813, 0.251594, 0.413337, 0.87513,
	-0.0674542, -0.123283, 0.612993, 0.260891, 0.378078, 0.888253,
	-0.0674542, -0.167182, 0.619443, 0.270713, 0.334068, 0.902836,
	-0.0674542, -0.209823, 0.621697, 0.284517, 0.267605, 0.920564,
	-0.147773, 0.207515, 0.483204, 0.110538, 0.516044, 0.8494,
	-0.151509, 0.158719, 0.50568, 0.116871, 0.511921, 0.851045,
	-0.155092, 0.110203, 0.527237, 0.12361, 0.503842, 0.854906,
	-0.158445, 0.0621075, 0.547412, 0.130773, 0.491528, 0.860987,
	-0.161493, 0.0145713, 0.565746, 0.138366, 0.474544, 0.869289,
	-0.164158, -0.0322661, 0.581778, 0.146416, 0.452224, 0.879804,
	-0.166364, -0.0782642, 0.595049, 0.15494, 0.423643, 0.89248,
	-0.168034, -0.123283, 0.605098, 0.163927, 0.387554, 0.907155,
	-0.169092, -0.167182, 0.611465, 0.173347, 0.342295, 0.923464,
	-0.169462, -0.209823, 0.61369, 0.187048, 0.27354, 0.943498,
	-0.223627, 0.207515, 0.464916, 0.00808332, 0.529283, 0.848407,
	-0.230891, 0.158719, 0.486542, 0.0150491, 0.525251, 0.850814,
	-0.237859, 0.110203, 0.507281, 0.0221764, 0.517195, 0.85558,
	-0.244379, 0.0621075, 0.526693, 0.0294917, 0.504802, 0.862731,
	-0.250305, 0.0145713, 0.544333, 0.0370164, 0.487587, 0.872289,
	-0.255486, -0.0322661, 0.559759, 0.0447805, 0.464849, 0.884257,
	-0.259776, -0.0782642, 0.572528, 0.0528231, 0.435566, 0.898605,
	-0.263024, -0.123283, 0.582197, 0.0611674, 0.398381, 0.915178,
	-0.265082, -0.167182, 0.588323, 0.0698301, 0.351494, 0.933582,
	-0.2658, -0.209823, 0.590463, 0.0829945, 0.279818, 0.956459,
	-0.294078, 0.207515, 0.435585, -0.0942993, 0.545039, 0.833091,
	-0.304619, 0.158719, 0.455846, -0.0867935, 0.541189, 0.83641,
	-0.314728, 0.110203, 0.475278, -0.0793944, 0.533246, 0.842226,
	-0.32419, 0.0621075, 0.493465, -0.0720783, 0.520883, 0.85058,
	-0.33279, 0.0145713, 0.509992, -0.0648125, 0.503568, 0.861521,
	-0.340308, -0.0322661, 0.524444, -0.0575553, 0.480529, 0.875088,
	-0.346533, -0.0782642, 0.536408, -0.0502593, 0.450682, 0.891269,
	-0.351245, -0.123283, 0.545466, -0.0428616, 0.412518, 0.90994,
	-0.354232, -0.167182, 0.551206, -0.0352886, 0.364082, 0.930698,
	-0.355275, -0.209823, 0.553211, -0.0230678, 0.289487, 0.956904,
	-0.358183, 0.207515, 0.396149, -0.194347, 0.563292, 0.803076,
	-0.371707, 0.158719, 0.414576, -0.186414, 0.559728, 0.807437,
	-0.384676, 0.110203, 0.432249, -0.178887, 0.55202, 0.814416,
	-0.396814, 0.0621075, 0.44879, -0.17174, 0.539817, 0.824077,
	-0.407846, 0.0145713, 0.46382, -0.164952, 0.522554, 0.836497,
	-0.417492, -0.0322661, 0.476965, -0.158471, 0.49939, 0.851761,
	-0.425477, -0.0782642, 0.487845, -0.152233, 0.469138, 0.869905,
	-0.431524, -0.123283, 0.496083, -0.146155, 0.430157, 0.890844,
	-0.435355, -0.167182, 0.501303, -0.14009, 0.380268, 0.914205,
	-0.436693, -0.209823, 0.503127, -0.129365, 0.302758, 0.944247,
	-0.415005, 0.207515, 0.347551, -0.290045, 0.584146, 0.758054,
	-0.431172, 0.158719, 0.363718, -0.281799, 0.580986, 0.763573,
	-0.446676, 0.110203, 0.379222, -0.274301, 0.573659, 0.7718,
	-0.461187, 0.0621075, 0.393733, -0.267528, 0.561796, 0.782824,
	-0.474375, 0.0145713, 0.406921, -0.261458, 0.544768, 0.796786,
	-0.485906, -0.0322661, 0.418452, -0.256057, 0.52169, 0.813802,
	-0.495452, -0.0782642, 0.427998, -0.251256, 0.491262, 0.833986,
	-0.502679, -0.123283, 0.435225, -0.246951, 0.451676, 0.857324,
	-0.507259, -0.167182, 0.439805, -0.24294, 0.400498, 0.883505,
	-0.508859, -0.209823, 0.441405, -0.23446, 0.32013, 0.917903,
	-0.463603, 0.207515, 0.290729, -0.379256, 0.607794, 0.697676,
	-0.48203, 0.158719, 0.304252, -0.370828, 0.605196, 0.704432,
	-0.499703, 0.110203, 0.317222, -0.363522, 0.59843, 0.713956,
	-0.516244, 0.0621075, 0.32936, -0.357332, 0.587116, 0.726367,
	-0.531275, 0.0145713, 0.340392, -0.352257, 0.57059, 0.741851,
	-0.544419, -0.0322661, 0.350038, -0.348272, 0.547882, 0.760613,
	-0.555299, -0.0782642, 0.358023, -0.345336, 0.517589, 0.782844,
	-0.563537, -0.123283, 0.36407, -0.343353, 0.477716, 0.808638,
	-0.568757, -0.167182, 0.367901, -0.342075, 0.425511, 0.83781,
	-0.570581, -0.209823, 0.369238, -0.336853, 0.342428, 0.877082,
	-0.503039, 0.207515, 0.226624, -0.459303, 0.634499, 0.621652,
	-0.5233, 0.158719, 0.237164, -0.450816, 0.632644, 0.629704,
	-0.542732, 0.110203, 0.247274, -0.443863, 0.626683, 0.640511,
	-0.560919, 0.0621075, 0.256736, -0.438458, 0.6162, 0.654257,
	-0.577446, 0.0145713, 0.265335, -0.434637, 0.600511, 0.671176,
	-0.591898, -0.0322661, 0.272854, -0.432423, 0.57858, 0.69156,
	-0.603862, -0.0782642, 0.279079, -0.431828, 0.548869, 0.715728,
	-0.61292, -0.123283, 0.283791, -0.4328, 0.509182, 0.743921,
	-0.61866, -0.167182, 0.286778, -0.435101, 0.456411, 0.776129,
	-0.620665, -0.209823, 0.287821, -0.434472, 0.370986, 0.820733,
	-0.532371, 0.207515, 0.156173, -0.526607, 0.66453, 0.530175,
	-0.553996, 0.158719, 0.163437, -0.518149, 0.663654, 0.539523,
	-0.574735, 0.110203, 0.170405, -0.511658, 0.658788, 0.551547,
	-0.594147, 0.0621075, 0.176925, -0.507193, 0.64951, 0.566474,
	-0.611787, 0.0145713, 0.18285, -0.504844, 0.635111, 0.584608,
	-0.627213, -0.0322661, 0.188032, -0.504716, 0.614499, 0.606343,
	-0.639983, -0.0782642, 0.192322, -0.506923, 0.58603, 0.632138,
	-0.649651, -0.123283, 0.19557, -0.511529, 0.547262, 0.662452,
	-0.655777, -0.167182, 0.197628, -0.518387, 0.494686, 0.697539,
	-0.657917, -0.209823, 0.198346, -0.524072, 0.407716, 0.74774,
	-0.550658, 0.207515, 0.0803186, -0.576558, 0.698093, 0.424555,
	-0.573134, 0.158719, 0.0840546, -0.568143, 0.698475, 0.43514,
	-0.594691, 0.110203, 0.0876376, -0.562133, 0.695064, 0.44821,
	-0.614866, 0.0621075, 0.0909911, -0.558639, 0.687449, 0.464044,
	-0.6332, 0.0145713, 0.0940386, -0.557842, 0.674911, 0.483018,
	-0.649232, -0.0322661, 0.0967035, -0.559969, 0.656341, 0.505619,
	-0.662503, -0.0782642, 0.0989096, -0.5653, 0.630013, 0.532466,
	-0.672552, -0.123283, 0.10058, -0.574126, 0.593276, 0.564272,
	-0.678919, -0.167182, 0.101638, -0.586554, 0.542165, 0.601674,
	-0.681144, -0.209823, 0.102008, -0.600622, 0.455218, 0.657289,
	-0.556962, 0.207515, -1.06699e-007, -0.609864, 0.732254, 0.3031,
	-0.579733, 0.158719, -1.09126e-007, -0.601838, 0.734065, 0.314547,
	-0.60157, 0.110203, -1.1138e-007, -0.596672, 0.732326, 0.328147,
	-0.622008, 0.0621075, -1.13373e-007, -0.594547, 0.726669, 0.344188,
	-0.640582, 0.0145713, -1.1502e-007, -0.595759, 0.716402, 0.363098,
	-0.656823, -0.0322661, -1.16217e-007, -0.600725, 0.700395, 0.385457,
	-0.670267, -0.0782642, -1.16907e-007, -0.609977, 0.676885, 0.412012,
	-0.680448, -0.123283, -1.16974e-007, -0.624181, 0.643042, 0.443728,
	-0.686897, -0.167182, -1.16348e-007, -0.643944, 0.594408, 0.48168,
	-0.689151, -0.209823, -1.14939e-007, -0.669943, 0.508647, 0.540791,
	-0.550658, 0.207515, -0.0803187, -0.627573, 0.761288, 0.163072,
	-0.573134, 0.158719, -0.0840547, -0.620642, 0.764426, 0.174519,
	-0.594691, 0.110203, -0.0876377, -0.61702, 0.764283, 0.187505,
	-0.614866, 0.0621075, -0.0909912, -0.617, 0.760507, 0.202336,
	-0.6332, 0.0145713, -0.0940387, -0.621024, 0.752458, 0.2194,
	-0.649232, -0.0322661, -0.0967036, -0.629748, 0.73903, 0.239275,
	-0.662503, -0.0782642, -0.0989095, -0.644076, 0.718421, 0.262749,
	-0.672552, -0.123283, -0.10058, -0.66521, 0.68767, 0.290869,
	-0.678919, -0.167182, -0.101638, -0.694575, 0.641811, 0.32503,
	-0.681144, -0.209823, -0.102008, -0.737345, 0.557615, 0.381299,
	-0.532371, 0.207515, -0.156173, -0.620136, 0.784403, 0.0119788,
	-0.553996, 0.158719, -0.163438, -0.614359, 0.788703, 0.0225958,
	-0.574735, 0.110203, -0.170405, -0.612186, 0.789988, 0.0338732,
	-0.594147, 0.0621075, -0.176925, -0.614006, 0.787958, 0.0460345,
	-0.611787, 0.0145713, -0.182851, -0.620429, 0.782012, 0.0593685,
	-0.627213, -0.0322661, -0.188032, -0.63233, 0.771129, 0.0742856,
	-0.639983, -0.0782642, -0.192322, -0.651024, 0.753536, 0.0913851,
	-0.649651, -0.123283, -0.19557, -0.67835, 0.726229, 0.111505,
	-0.655777, -0.167182, -0.197628, -0.716779, 0.683934, 0.135875,
	-0.657917, -0.209823, -0.198346, -0.777224, 0.603248, 0.178924,
	-0.503039, 0.207515, -0.226624, -0.58003, 0.80267, -0.138873,
	-0.5233, 0.158719, -0.237165, -0.574782, 0.807982, -0.129583,
	-0.542732, 0.110203, -0.247274, -0.573138, 0.810524, -0.12068,
	-0.560919, 0.0621075, -0.256736, -0.575519, 0.810069, -0.112093,
	-0.577446, 0.0145713, -0.265335, -0.58263, 0.806088, -0.103746,
	-0.591898, -0.0322661, -0.272854, -0.595488, 0.797663, -0.0955402,
	-0.603862, -0.0782642, -0.279079, -0.615654, 0.783162, -0.0873371,
	-0.61292, -0.123283, -0.283791, -0.645494, 0.759676, -0.078932,
	-0.61866, -0.167182, -0.286778, -0.688421, 0.721928, -0.0699728,
	-0.620665, -0.209823, -0.287821, -0.760252, 0.647575, -0.0516025,
	-0.463603, 0.207515, -0.290729, -0.507886, 0.814319, -0.280957,
	-0.48203, 0.158719, -0.304252, -0.502425, 0.820323, -0.273203,
	-0.499703, 0.110203, -0.317222, -0.500191, 0.823742, -0.266941,
	-0.516244, 0.0621075, -0.32936, -0.50158, 0.824396, -0.262276,
	-0.531275, 0.0145713, -0.340392, -0.507241, 0.821831, -0.259422,
	-0.544419, -0.0322661, -0.350038, -0.518165, 0.81522, -0.258692,
	-0.555299, -0.0782642, -0.358023, -0.535868, 0.803079, -0.260596,
	-0.563537, -0.123283, -0.36407, -0.562758, 0.782678, -0.265931,
	-0.568757, -0.167182, -0.367901, -0.602521, 0.7489, -0.275894,
	-0.570581, -0.209823, -0.369238, -0.671859, 0.681108, -0.291029,
	-0.415005, 0.207515, -0.347551, -0.406822, 0.818199, -0.406259,
	-0.431172, 0.158719, -0.363718, -0.40046, 0.824452, -0.399888,
	-0.446676, 0.110203, -0.379222, -0.396586, 0.828189, -0.396007,
	-0.461187, 0.0621075, -0.393733, -0.395478, 0.829252, -0.394891,
	-0.474375, 0.0145713, -0.406921, -0.397619, 0.827211, -0.397015,
	-0.485906, -0.0322661, -0.418452, -0.403732, 0.821283, -0.403106,
	-0.495452, -0.0782642, -0.427997, -0.414954, 0.810044, -0.414297,
	-0.502679, -0.123283, -0.435225, -0.433101, 0.790858, -0.432397,
	-0.507259, -0.167182, -0.439805, -0.461005, 0.758721, -0.460236,
	-0.508859, -0.209823, -0.441405, -0.510037, 0.693943, -0.508238,
	-0.358183, 0.207515, -0.396149, -0.282064, 0.813937, -0.507885,
	-0.371707, 0.158719, -0.414576, -0.274311, 0.819956, -0.502421,
	-0.384676, 0.110203, -0.432249, -0.268054, 0.82339, -0.500177,
	-0.396814, 0.0621075, -0.44879, -0.263391, 0.824063, -0.501544,
	-0.407846, 0.0145713, -0.463821, -0.260528, 0.821523, -0.507173,
	-0.417492, -0.0322661, -0.476965, -0.25979, 0.814951, -0.518039,
	-0.425477, -0.0782642, -0.487845, -0.261679, 0.802859, -0.535669,
	-0.431524, -0.123283, -0.496083, -0.266987, 0.782544, -0.562444,
	-0.435355, -0.167182, -0.501303, -0.276929, 0.748897, -0.602049,
	-0.436693, -0.209823, -0.503127, -0.293084, 0.681582, -0.670483,
	-0.294078, 0.207515, -0.435585, -0.14042, 0.802015, -0.580563,
	-0.304619, 0.158719, -0.455846, -0.131136, 0.807354, -0.575312,
	-0.314728, 0.110203, -0.475278, -0.12223, 0.809928, -0.573652,
	-0.32419, 0.0621075, -0.493465, -0.113628, 0.809509, -0.576007,
	-0.33279, 0.0145713, -0.509992, -0.105257, 0.80558, -0.583062,
	-0.340308, -0.0322661, -0.524444, -0.0970115, 0.797225, -0.595836,
	-0.346533, -0.0782642, -0.536408, -0.0887546, 0.782818, -0.615889,
	-0.351245, -0.123283, -0.545466, -0.0802692, 0.759484, -0.645555,
	-0.354232, -0.167182, -0.551206, -0.0711887, 0.721966, -0.688256,
	-0.355275, -0.209823, -0.553211, -0.0536972, 0.648422, -0.759385,
	-0.223627, 0.207515, -0.464916, 0.0102147, 0.783706, -0.621048,
	-0.230891, 0.158719, -0.486541, 0.0208317, 0.788044, -0.615266,
	-0.237859, 0.110203, -0.507281, 0.0321216, 0.78937, -0.613077,
	-0.244379, 0.0621075, -0.526693, 0.0443081, 0.787389, -0.614862,
	-0.250304, 0.0145713, -0.544333, 0.0576841, 0.781512, -0.621218,
	-0.255486, -0.0322661, -0.559759, 0.0726622, 0.770715, -0.633024,
	-0.259776, -0.0782642, -0.572528, 0.0898413, 0.753249, -0.65157,
	-0.263024, -0.123283, -0.582197, 0.110071, 0.726116, -0.678705,
	-0.265082, -0.167182, -0.588323, 0.134595, 0.684093, -0.716869,
	-0.2658, -0.209823, -0.590463, 0.176909, 0.604353, -0.776827,
	-0.147773, 0.207515, -0.483204, 0.161515, 0.760906, -0.628438,
	-0.151509, 0.158719, -0.50568, 0.172973, 0.764077, -0.621504,
	-0.155092, 0.110203, -0.527237, 0.185981, 0.763974, -0.617863,
	-0.158445, 0.0621075, -0.547412, 0.200833, 0.760254, -0.617803,
	-0.161493, 0.0145713, -0.565746, 0.217931, 0.752263, -0.621777,
	-0.164158, -0.0322661, -0.581778, 0.237853, 0.738916, -0.63042,
	-0.166364, -0.0782642, -0.595049, 0.261387, 0.718422, -0.644629,
	-0.168034, -0.123283, -0.605098, 0.289598, 0.687816, -0.665614,
	-0.169092, -0.167182, -0.611465, 0.323869, 0.642189, -0.694768,
	-0.169462, -0.209823, -0.61369, 0.379433, 0.558858, -0.737366,
	-0.067454, 0.207515, -0.489509, 0.302274, 0.732456, -0.610031,
	-0.067454, 0.158719, -0.512278, 0.313732, 0.73427, -0.602013,
	-0.067454, 0.110203, -0.534116, 0.327337, 0.732544, -0.596849,
	-0.067454, 0.0621075, -0.554554, 0.343396, 0.726894, -0.59473,
	-0.067454, 0.0145713, -0.573128, 0.362326, 0.716633, -0.595951,
	-0.067454, -0.0322661, -0.589369, 0.384701, 0.700634, -0.60093,
	-0.067454, -0.0782642, -0.602813, 0.41128, 0.677131, -0.610199,
	-0.067454, -0.123283, -0.612993, 0.44302, 0.643294, -0.624425,
	-0.067454, -0.167182, -0.619443, 0.481001, 0.594661, -0.644218,
	-0.067454, -0.209823, -0.621697, 0.539533, 0.509135, -0.670586,
	0.0128645, 0.207515, -0.483204, 0.424396, 0.698681, -0.575962,
	0.0166006, 0.158719, -0.50568, 0.434984, 0.699044, -0.567562,
	0.0201836, 0.110203, -0.527237, 0.448057, 0.69561, -0.561579,
	0.0235371, 0.0621075, -0.547412, 0.46389, 0.687958, -0.55814,
	0.0265846, 0.0145713, -0.565746, 0.482855, 0.675383, -0.557412,
	0.0292495, -0.0322661, -0.581778, 0.505446, 0.656756, -0.559639,
	0.0314555, -0.0782642, -0.595049, 0.532279, 0.63034, -0.565111,
	0.0331258, -0.123283, -0.605098, 0.564057, 0.593495, -0.574111,
	0.0341842, -0.167182, -0.611465, 0.601425, 0.542202, -0.586775,
	0.034554, -0.209823, -0.61369, 0.656557, 0.454967, -0.601612,
	0.0887187, 0.207515, -0.464916, 0.530165, 0.665137, -0.52585,
	0.0959827, 0.158719, -0.486541, 0.539511, 0.66424, -0.51741,
	0.102951, 0.110203, -0.507281, 0.551528, 0.659354, -0.51095,
	0.109471, 0.0621075, -0.526693, 0.566443, 0.650046, -0.50654,
	0.115397, 0.0145713, -0.544333, 0.584564, 0.635604, -0.504274,
	0.120578, -0.0322661, -0.559759, 0.606275, 0.614944, -0.504257,
	0.124868, -0.0782642, -0.572528, 0.63204, 0.586395, -0.506622,
	0.128116, -0.123283, -0.582197, 0.662308, 0.547528, -0.51143,
	0.130174, -0.167182, -0.588323, 0.697339, 0.494793, -0.518554,
	0.130892, -0.209823, -0.590463, 0.74711, 0.407556, -0.525095,
	0.159169, 0.207515, -0.435585, 0.621542, 0.634949, -0.458831,
	0.169711, 0.158719, -0.455846, 0.629595, 0.633078, -0.450359,
	0.17982, 0.110203, -0.475278, 0.640399, 0.627101, -0.443433,
	0.189282, 0.0621075, -0.493465, 0.654136, 0.616604, -0.43807,
	0.197881, 0.0145713, -0.509992, 0.671048, 0.600887, -0.434314,
	0.2054, -0.0322661, -0.524444, 0.691421, 0.578922, -0.432189,
	0.211625, -0.0782642, -0.536408, 0.715569, 0.549169, -0.43171,
	0.216337, -0.123283, -0.545466, 0.743745, 0.509405, -0.43284,
	0.219324, -0.167182, -0.551206, 0.775927, 0.456528, -0.435338,
	0.220367, -0.209823, -0.553211, 0.82022, 0.370938, -0.435481,
	0.223275, 0.207515, -0.396149, 0.697451, 0.60806, -0.379244,
	0.236798, 0.158719, -0.414576, 0.704215, 0.605452, -0.370822,
	0.249768, 0.110203, -0.432249, 0.713738, 0.598684, -0.363532,
	0.261906, 0.0621075, -0.44879, 0.726152, 0.587362, -0.357364,
	0.272938, 0.0145713, -0.463821, 0.74164, 0.570826, -0.352319,
	0.282584, -0.0322661, -0.476965, 0.760404, 0.548103, -0.348381,
	0.290569, -0.0782642, -0.487845, 0.782636, 0.517791, -0.345505,
	0.296616, -0.123283, -0.496083, 0.808438, 0.477877, -0.343602,
	0.300446, -0.167182, -0.501303, 0.837608, 0.425622, -0.34243,
	0.301784, -0.209823, -0.503127, 0.876676, 0.342494, -0.337842,
	0.280097, 0.207515, -0.347551, 0.757795, 0.584256, -0.290502,
	0.296264, 0.158719, -0.363718, 0.763318, 0.581099, -0.282256,
	0.311768, 0.110203, -0.379222, 0.771553, 0.573773, -0.274756,
	0.326279, 0.0621075, -0.393733, 0.782587, 0.561911, -0.26798,
	0.339467, 0.0145713, -0.406921, 0.796555, 0.544886, -0.261913,
	0.350998, -0.0322661, -0.418452, 0.813586, 0.521804, -0.256512,
	0.360543, -0.0782642, -0.427997, 0.833781, 0.491376, -0.251713,
	0.367771, -0.123283, -0.435225, 0.857132, 0.451787, -0.247414,
	0.372351, -0.167182, -0.439805, 0.883329, 0.400602, -0.243409,
	0.373951, -0.209823, -0.441405, 0.917593, 0.320312, -0.235424,
	0.328695, 0.207515, -0.290729, 0.80287, 0.56329, -0.195204,
	0.347122, 0.158719, -0.304252, 0.807237, 0.559735, -0.187256,
	0.364795, 0.110203, -0.317222, 0.814226, 0.552032, -0.179713,
	0.381335, 0.0621075, -0.32936, 0.823893, 0.539841, -0.172546,
	0.396367, 0.0145713, -0.340392, 0.836327, 0.522582, -0.165725,
	0.409511, -0.0322661, -0.350038, 0.851603, 0.499426, -0.159207,
	0.420391, -0.0782642, -0.358023, 0.869757, 0.469188, -0.152924,
	0.428629, -0.123283, -0.36407, 0.890703, 0.430234, -0.146787,
	0.433849, -0.167182, -0.367901, 0.914074, 0.380375, -0.140656,
	0.435673, -0.209823, -0.369238, 0.944023, 0.30305, -0.130313,
	0.368131, 0.207515, -0.226624, 0.833009, 0.544969, -0.0954156,
	0.388392, 0.158719, -0.237165, 0.836331, 0.541134, -0.0878947,
	0.407824, 0.110203, -0.247274, 0.842154, 0.5332, -0.0804677,
	0.426011, 0.0621075, -0.256736, 0.850514, 0.520847, -0.0731097,
	0.442538, 0.0145713, -0.265335, 0.861461, 0.503545, -0.0657931,
	0.45699, -0.0322661, -0.272854, 0.875028, 0.480528, -0.0584739,
	0.468954, -0.0782642, -0.279079, 0.891211, 0.450702, -0.0510998,
	0.478012, -0.123283, -0.283791, 0.909876, 0.412583, -0.0436054,
	0.483751, -0.167182, -0.286778, 0.930625, 0.364207, -0.0359121,
	0.485757, -0.209823, -0.287821, 0.956764, 0.289874, -0.024005,
	0.397462, 0.207515, -0.156173, 0.848469, 0.529201, 0.00689747,
	0.419087, 0.158719, -0.163437, 0.850874, 0.525186, 0.013883,
	0.439827, 0.110203, -0.170405, 0.855643, 0.517138, 0.0210437,
	0.459239, 0.0621075, -0.176925, 0.862793, 0.504759, 0.0284039,
	0.476879, 0.0145713, -0.18285, 0.872345, 0.487565, 0.0359877,
	0.492305, -0.0322661, -0.188032, 0.884305, 0.464848, 0.0438254,
	0.505074, -0.0782642, -0.192322, 0.898637, 0.435605, 0.0519552,
	0.514743, -0.123283, -0.19557, 0.915191, 0.398467, 0.0604029,
	0.520869, -0.167182, -0.197628, 0.933567, 0.351662, 0.0691892,
	0.523009, -0.209823, -0.198346, 0.9564, 0.280298, 0.0820499,
	0.41575, 0.207515, -0.0803185, 0.849544, 0.51602, 0.109536,
	0.438226, 0.158719, -0.0840546, 0.851187, 0.511909, 0.115886,
	0.459783, 0.110203, -0.0876377, 0.855042, 0.503844, 0.122655,
	0.479958, 0.0621075, -0.0909911, 0.861112, 0.491554, 0.129851,
	0.498292, 0.0145713, -0.0940387, 0.869405, 0.474587, 0.137488,
	0.514324, -0.0322661, -0.0967036, 0.879905, 0.452295, 0.145591,
	0.527595, -0.0782642, -0.0989095, 0.892557, 0.423758, 0.154178,
	0.537644, -0.123283, -0.10058, 0.907209, 0.387716, 0.163244,
	0.544011, -0.167182, -0.101638, 0.923483, 0.342543, 0.172752,
	0.546236, -0.209823, -0.102008, 0.943523, 0.2741, 0.186098,
	0.54194, -0.249712, 0.101294, 0.906529, 0.159792, 0.390733,
	0.549891, -0.249712, 1.13232e-008, 0.938005, 0.167916, 0.303235,
	0.530279, -0.285546, 0.099356, 0.911608, 0.0502059, 0.407983,
	0.538079, -0.285546, 1.28831e-008, 0.944377, 0.0565316, 0.323969,
	0.513097, -0.317462, 0.0964996, 0.905786, -0.0459497, 0.421237,
	0.520672, -0.317462, 1.42843e-008, 0.938884, -0.0414073, 0.341733,
	0.492231, -0.345601, 0.0930314, 0.893492, -0.121579, 0.432308,
	0.499534, -0.345601, 1.55125e-008, 0.926217, -0.11842, 0.357908,
	0.469524, -0.370104, 0.0892571, 0.879819, -0.170009, 0.443864,
	0.476531, -0.370104, 1.6582e-008, 0.911824, -0.167583, 0.374824,
	0.446818, -0.39111, 0.0854828, 0.869383, -0.18289, 0.459048,
	0.453528, -0.39111, 1.75074e-008, 0.900597, -0.180313, 0.395489,
	0.425952, -0.408758, 0.0820146, 0.864584, -0.146108, 0.480777,
	0.432391, -0.408758, 1.82741e-008, 0.894918, -0.142206, 0.422964,
	0.40877, -0.423189, 0.0791582, 0.860211, -0.0347105, 0.508755,
	0.414983, -0.423189, 1.88966e-008, 0.888756, -0.0280675, 0.45752,
	0.397109, -0.434543, 0.0772202, 0.828954, 0.181191, 0.529155,
	0.403171, -0.434543, 1.94037e-008, 0.852542, 0.19099, 0.486513,
	0.392813, -0.442959, 0.0765061, 0.764202, 0.37663, 0.523588,
	0.398819, -0.442959, 1.97666e-008, 0.781501, 0.387053, 0.489333,
	0.518876, -0.249712, 0.196957, 0.867483, 0.151257, 0.473914,
	0.507657, -0.285546, 0.193189, 0.871901, 0.0421041, 0.487869,
	0.491123, -0.317462, 0.187636, 0.866187, -0.0535051, 0.496848,
	0.471049, -0.345601, 0.180892, 0.854595, -0.128737, 0.503085,
	0.449201, -0.370104, 0.173553, 0.841978, -0.177183, 0.509587,
	0.427354, -0.39111, 0.166215, 0.832801, -0.190706, 0.519686,
	0.407279, -0.408758, 0.15947, 0.829619, -0.155446, 0.536254,
	0.390745, -0.423189, 0.153917, 0.828147, -0.0463589, 0.558591,
	0.379526, -0.434543, 0.150149, 0.803081, 0.168209, 0.571635,
	0.375393, -0.442959, 0.14876, 0.744833, 0.365653, 0.558141,
	0.481885, -0.249712, 0.285807, 0.819555, 0.145678, 0.554173,
	0.471373, -0.285546, 0.280338, 0.824087, 0.0369285, 0.565258,
	0.455883, -0.317462, 0.272279, 0.819284, -0.0582138, 0.570425,
	0.437074, -0.345601, 0.262493, 0.809159, -0.133084, 0.572321,
	0.416606, -0.370104, 0.251843, 0.798293, -0.181462, 0.574283,
	0.396137, -0.39111, 0.241194, 0.790973, -0.19538, 0.579818,
	0.377328, -0.408758, 0.231408, 0.789844, -0.161156, 0.591755,
	0.361838, -0.423189, 0.223348, 0.791406, -0.0537681, 0.608922,
	0.351326, -0.434543, 0.21788, 0.772333, 0.159539, 0.614856,
	0.347454, -0.442959, 0.215866, 0.720837, 0.358053, 0.593458,
	0.432151, -0.249712, 0.366653, 0.763619, 0.142573, 0.629729,
	0.422591, -0.285546, 0.359638, 0.76895, 0.0341378, 0.638397,
	0.408504, -0.317462, 0.349299, 0.765766, -0.0606698, 0.640251,
	0.391398, -0.345601, 0.336746, 0.75779, -0.135276, 0.638321,
	0.372782, -0.370104, 0.323084, 0.749312, -0.183579, 0.636263,
	0.354166, -0.39111, 0.309421, 0.74442, -0.197697, 0.637773,
	0.337061, -0.408758, 0.296868, 0.745823, -0.164066, 0.645625,
	0.322973, -0.423189, 0.286529, 0.750694, -0.0577406, 0.658122,
	0.313413, -0.434543, 0.279514, 0.737607, 0.154606, 0.657292,
	0.309891, -0.442959, 0.276929, 0.693075, 0.353595, 0.628186,
	0.370861, -0.249712, 0.438315, 0.700466, 0.141645, 0.699488,
	0.362474, -0.285546, 0.429929, 0.707207, 0.0333698, 0.706219,
	0.350115, -0.317462, 0.417569, 0.706274, -0.0612728, 0.705282,
	0.335107, -0.345601, 0.402561, 0.701061, -0.135747, 0.700062,
	0.318775, -0.370104, 0.386229, 0.695549, -0.18398, 0.694523,
	0.302443, -0.39111, 0.369897, 0.693635, -0.198161, 0.692534,
	0.287436, -0.408758, 0.35489, 0.698064, -0.164755, 0.696824,
	0.275076, -0.423189, 0.34253, 0.706614, -0.0588474, 0.705148,
	0.26669, -0.434543, 0.334144, 0.699655, 0.153007, 0.697905,
	0.2636, -0.442959, 0.331054, 0.66231, 0.352082, 0.66135,
	0.299199, -0.249712, 0.499606, 0.630787, 0.142794, 0.762704,
	0.292184, -0.285546, 0.490045, 0.639488, 0.0344967, 0.768027,
	0.281845, -0.317462, 0.475958, 0.641377, -0.0601567, 0.764864,
	0.269292, -0.345601, 0.458852, 0.639495, -0.134646, 0.756912,
	0.25563, -0.370104, 0.440236, 0.637502, -0.182864, 0.748433,
	0.241967, -0.39111, 0.42162, 0.639094, -0.196959, 0.743483,
	0.229414, -0.408758, 0.404515, 0.647058, -0.163409, 0.744724,
	0.219075, -0.423189, 0.390427, 0.659726, -0.0573235, 0.749316,
	0.21206, -0.434543, 0.380867, 0.659153, 0.154558, 0.735954,
	0.209475, -0.442959, 0.377345, 0.629222, 0.35346, 0.692204,
	0.218353, -0.249712, 0.549339, 0.555329, 0.146121, 0.818693,
	0.212884, -0.285546, 0.538828, 0.566491, 0.0376297, 0.823208,
	0.204824, -0.317462, 0.523337, 0.571738, -0.0572464, 0.818436,
	0.195039, -0.345601, 0.504529, 0.573721, -0.13189, 0.808362,
	0.184389, -0.370104, 0.48406, 0.575773, -0.180123, 0.797522,
	0.17374, -0.39111, 0.463591, 0.581403, -0.194011, 0.790146,
	0.163954, -0.408758, 0.444782, 0.59343, -0.159936, 0.788835,
	0.155894, -0.423189, 0.429292, 0.610698, -0.053029, 0.790086,
	0.150426, -0.434543, 0.41878, 0.616838, 0.159356, 0.77079,
	0.148412, -0.442959, 0.414908, 0.594562, 0.35776, 0.720072,
	0.129503, -0.249712, 0.58633, 0.475171, 0.151888, 0.866685,
	0.125735, -0.285546, 0.575111, 0.48924, 0.0430554, 0.871086,
	0.120182, -0.317462, 0.558578, 0.498333, -0.0522418, 0.865411,
	0.113437, -0.345601, 0.538503, 0.504685, -0.127203, 0.853881,
	0.106099, -0.370104, 0.516655, 0.511297, -0.175488, 0.841296,
	0.0987604, -0.39111, 0.494808, 0.521487, -0.188997, 0.832064,
	0.0920162, -0.408758, 0.474733, 0.538122, -0.153967, 0.828685,
	0.086462, -0.423189, 0.4582, 0.56051, -0.0455809, 0.826892,
	0.0826945, -0.434543, 0.44698, 0.573712, 0.167729, 0.8017,
	0.0813056, -0.442959, 0.442847, 0.559291, 0.365158, 0.744213,
	0.0338398, -0.249712, 0.609394, 0.392021, 0.160513, 0.905845,
	0.0319017, -0.285546, 0.597733, 0.409372, 0.0511699, 0.910932,
	0.0290455, -0.317462, 0.580551, 0.422724, -0.0447605, 0.905152,
	0.0255772, -0.345601, 0.559685, 0.433891, -0.120207, 0.89291,
	0.0218029, -0.370104, 0.536979, 0.445536, -0.168567, 0.879251,
	0.0180287, -0.39111, 0.514272, 0.4608, -0.181517, 0.868743,
	0.0145603, -0.408758, 0.493406, 0.482592, -0.145039, 0.863752,
	0.0117041, -0.423189, 0.476224, 0.510632, -0.0344344, 0.85911,
	0.00976593, -0.434543, 0.464563, 0.531215, 0.180103, 0.827873,
	0.00905184, -0.442959, 0.460267, 0.524731, 0.375869, 0.763793,
	-0.0674542, -0.249712, 0.617345, 0.304531, 0.167843, 0.937598,
	-0.0674542, -0.285546, 0.605533, 0.325228, 0.0565053, 0.943946,
	-0.0674542, -0.317462, 0.588126, 0.342959, -0.0413875, 0.938438,
	-0.0674542, -0.345601, 0.566988, 0.359117, -0.118361, 0.925757,
	-0.0674542, -0.370104, 0.543985, 0.376055, -0.167493, 0.911334,
	-0.0674542, -0.39111, 0.520982, 0.396797, -0.180202, 0.900044,
	-0.0674542, -0.408758, 0.499845, 0.424421, -0.142099, 0.894245,
	-0.0674542, -0.423189, 0.482437, 0.459197, -0.0280399, 0.887892,
	-0.0674542, -0.434543, 0.470625, 0.488434, 0.190756, 0.851495,
	-0.0674542, -0.442959, 0.466273, 0.490363, 0.386795, 0.780982,
	-0.168748, -0.249712, 0.609394, 0.208352, 0.169783, 0.963205,
	-0.16681, -0.285546, 0.597733, 0.232196, 0.0534874, 0.971197,
	-0.163954, -0.317462, 0.580551, 0.254274, -0.0489991, 0.96589,
	-0.160485, -0.345601, 0.559685, 0.275505, -0.129611, 0.952522,
	-0.156711, -0.370104, 0.536979, 0.297898, -0.18111, 0.93726,
	-0.152937, -0.39111, 0.514272, 0.324421, -0.194728, 0.925652,
	-0.149469, -0.408758, 0.493406, 0.358531, -0.155552, 0.920467,
	-0.146612, -0.423189, 0.476224, 0.401522, -0.0369258, 0.915105,
	-0.144674, -0.434543, 0.464563, 0.441879, 0.191557, 0.876384,
	-0.14396, -0.442959, 0.460267, 0.453517, 0.393991, 0.799433,
	-0.264412, -0.249712, 0.58633, 0.105204, 0.170818, 0.97967,
	-0.260643, -0.285546, 0.575111, 0.132165, 0.0478108, 0.990074,
	-0.25509, -0.317462, 0.558578, 0.158876, -0.0608701, 0.98542,
	-0.248346, -0.345601, 0.538503, 0.185621, -0.146371, 0.971659,
	-0.241007, -0.370104, 0.516655, 0.213935, -0.201159, 0.955911,
	-0.233669, -0.39111, 0.494808, 0.246654, -0.216319, 0.944652,
	-0.226924, -0.408758, 0.474733, 0.287683, -0.176379, 0.941344,
	-0.221371, -0.423189, 0.4582, 0.339654, -0.052569, 0.93908,
	-0.217603, -0.434543, 0.44698, 0.392614, 0.188545, 0.900169,
	-0.216214, -0.442959, 0.442847, 0.415043, 0.400931, 0.816697,
	-0.353261, -0.249712, 0.549339, -0.000287024, 0.175009, 0.984567,
	-0.347792, -0.285546, 0.538828, 0.0298703, 0.0447465, 0.998552,
	-0.339733, -0.317462, 0.523337, 0.0617014, -0.0707407, 0.995585,
	-0.329947, -0.345601, 0.504529, 0.094639, -0.161564, 0.982314,
	-0.319297, -0.370104, 0.48406, 0.129558, -0.21979, 0.966906,
	-0.308648, -0.39111, 0.463591, 0.169054, -0.236353, 0.956848,
	-0.298862, -0.408758, 0.444782, 0.21745, -0.195133, 0.956367,
	-0.290803, -0.423189, 0.429292, 0.278785, -0.0650965, 0.958145,
	-0.285334, -0.434543, 0.41878, 0.344761, 0.189894, 0.919282,
	-0.28332, -0.442959, 0.414908, 0.378243, 0.41181, 0.829062,
	-0.434108, -0.249712, 0.499605, -0.106571, 0.18249, 0.977415,
	-0.427092, -0.285546, 0.490045, -0.0733313, 0.0442322, 0.996326,
	-0.416753, -0.317462, 0.475958, -0.0359802, -0.0789289, 0.996231,
	-0.4042, -0.345601, 0.458852, 0.00383266, -0.175735, 0.98443,
	-0.390538, -0.370104, 0.440236, 0.0460841, -0.237707, 0.970243,
	-0.376875, -0.39111, 0.42162, 0.0929955, -0.255562, 0.96231,
	-0.364322, -0.408758, 0.404515, 0.149304, -0.212435, 0.965702,
	-0.353983, -0.423189, 0.390427, 0.220557, -0.0748013, 0.972502,
	-0.346968, -0.434543, 0.380867, 0.30009, 0.195692, 0.933622,
	-0.344383, -0.442959, 0.377345, 0.344688, 0.426606, 0.83618,
	-0.505769, -0.249712, 0.438315, -0.2125, 0.193677, 0.957775,
	-0.497383, -0.285546, 0.429929, -0.176514, 0.046393, 0.983204,
	-0.485023, -0.317462, 0.417569, -0.133295, -0.0856593, 0.987368,
	-0.470016, -0.345601, 0.402561, -0.0858625, -0.189398, 0.978139,
	-0.453684, -0.370104, 0.386229, -0.0354453, -0.255556, 0.966144,
	-0.437352, -0.39111, 0.369897, 0.0196549, -0.274642, 0.961346,
	-0.422344, -0.408758, 0.35489, 0.0845978, -0.228883, 0.969771,
	-0.409984, -0.423189, 0.34253, 0.166583, -0.0818338, 0.982626,
	-0.401598, -0.434543, 0.334144, 0.260372, 0.206272, 0.943217,
	-0.398508, -0.442959, 0.331054, 0.315896, 0.445357, 0.837775,
	-0.56706, -0.249712, 0.366653, -0.316993, 0.209402, 0.925022,
	-0.5575, -0.285546, 0.359638, -0.278916, 0.0517287, 0.958921,
	-0.543412, -0.317462, 0.349299, -0.229523, -0.090891, 0.96905,
	-0.526306, -0.345601, 0.336746, -0.17356, -0.202907, 0.963694,
	-0.50769, -0.370104, 0.323084, -0.113906, -0.273931, 0.95498,
	-0.489074, -0.39111, 0.309421, -0.0496172, -0.294154, 0.954469,
	-0.471969, -0.408758, 0.296868, 0.0249654, -0.244778, 0.969258,
	-0.457881, -0.423189, 0.286529, 0.11889, -0.0859495, 0.98918,
	-0.448321, -0.434543, 0.279514, 0.227768, 0.222288, 0.948003,
	-0.444799, -0.442959, 0.276929, 0.293539, 0.468183, 0.83345,
	-0.616793, -0.249712, 0.285807, -0.418552, 0.231101, 0.878297,
	-0.606282, -0.285546, 0.280338, -0.379539, 0.0613214, 0.923141,
	-0.590791, -0.317462, 0.272279, -0.323713, -0.0942646, 0.941448,
	-0.571983, -0.345601, 0.262493, -0.258043, -0.216455, 0.941574,
	-0.551514, -0.370104, 0.251843, -0.187707, -0.29326, 0.937424,
	-0.531045, -0.39111, 0.241194, -0.112814, -0.314515, 0.942525,
	-0.512236, -0.408758, 0.231408, -0.0271308, -0.260131, 0.965192,
	-0.496746, -0.423189, 0.223348, 0.0804685, -0.0862273, 0.99302,
	-0.486234, -0.434543, 0.21788, 0.205192, 0.244809, 0.94761,
	-0.482362, -0.442959, 0.215866, 0.279636, 0.495011, 0.822659,
	-0.653784, -0.249712, 0.196957, -0.514765, 0.261033, 0.816626,
	-0.642565, -0.285546, 0.193189, -0.476795, 0.0770599, 0.87563,
	-0.626032, -0.317462, 0.187636, -0.414425, -0.094887, 0.905124,
	-0.605957, -0.345601, 0.180892, -0.337397, -0.230072, 0.912815,
	-0.584109, -0.370104, 0.173553, -0.254276, -0.313961, 0.914753,
	-0.562262, -0.39111, 0.166215, -0.166729, -0.335962, 0.927001,
	-0.542187, -0.408758, 0.15947, -0.0677579, -0.274448, 0.959212,
	-0.525654, -0.423189, 0.153916, 0.0559785, -0.0809262, 0.995147,
	-0.514435, -0.434543, 0.150149, 0.196587, 0.275135, 0.941092,
	-0.510301, -0.442959, 0.14876, 0.276518, 0.525375, 0.804685,
	-0.676848, -0.249712, 0.101294, -0.601711, 0.302647, 0.739154,
	-0.665187, -0.285546, 0.0993558, -0.568163, 0.102067, 0.816562,
	-0.648005, -0.317462, 0.0964996, -0.499442, -0.0912235, 0.861531,
	-0.62714, -0.345601, 0.0930313, -0.408623, -0.243681, 0.879572,
	-0.604433, -0.370104, 0.089257, -0.309511, -0.336489, 0.88937,
	-0.581726, -0.39111, 0.0854828, -0.206188, -0.35863, 0.910424,
	-0.56086, -0.408758, 0.0820144, -0.0906378, -0.286639, 0.953741,
	-0.543678, -0.423189, 0.0791582, 0.0524099, -0.0671895, 0.996363,
	-0.532017, -0.434543, 0.07722, 0.206677, 0.314155, 0.926602,
	-0.527721, -0.442959, 0.076506, 0.286369, 0.55794, 0.778907,
	-0.684799, -0.249712, -1.12323e-007, -0.688342, 0.35014, 0.635285,
	-0.672987, -0.285546, -1.08389e-007, -0.666222, 0.127655, 0.734747,
	-0.65558, -0.317462, -1.03498e-007, -0.592244, -0.0965378, 0.799954,
	-0.634442, -0.345601, -9.8044e-008, -0.483598, -0.273989, 0.831302,
	-0.611439, -0.370104, -9.2357e-008, -0.363551, -0.379022, 0.850983,
	-0.588436, -0.39111, -8.6843e-008, -0.240545, -0.401357, 0.883771,
	-0.567299, -0.408758, -8.18351e-008, -0.104829, -0.315737, 0.943038,
	-0.549891, -0.423189, -7.77097e-008, 0.0615718, -0.0608341, 0.996247,
	-0.538079, -0.434543, -7.48576e-008, 0.228115, 0.354196, 0.906923,
	-0.533727, -0.442959, -7.36117e-008, 0.302744, 0.590252, 0.748297,
	-0.676848, -0.249712, -0.101294, -0.784215, 0.391966, 0.481008,
	-0.665187, -0.285546, -0.0993559, -0.787389, 0.138378, 0.600724,
	-0.648005, -0.317462, -0.0964996, -0.711804, -0.132905, 0.689689,
	-0.62714, -0.345601, -0.0930314, -0.578879, -0.347118, 0.73784,
	-0.604433, -0.370104, -0.0892571, -0.430997, -0.46876, 0.771042,
	-0.581726, -0.39111, -0.0854827, -0.28493, -0.493309, 0.821864,
	-0.56086, -0.408758, -0.0820145, -0.127112, -0.394786, 0.909938,
	-0.543678, -0.423189, -0.0791582, 0.0683837, -0.0913659, 0.993467,
	-0.532017, -0.434543, -0.0772201, 0.251082, 0.385001, 0.888106,
	-0.527721, -0.442959, -0.076506, 0.318441, 0.621686, 0.715613,
	-0.653784, -0.249712, -0.196957, -0.860765, 0.433401, 0.266921,
	-0.642565, -0.285546, -0.19319, -0.907644, 0.142785, 0.394709,
	-0.626032, -0.317462, -0.187636, -0.838017, -0.195225, 0.509524,
	-0.605957, -0.345601, -0.180892, -0.671197, -0.458999, 0.582078,
	-0.584109, -0.370104, -0.173553, -0.486306, -0.598561, 0.636578,
	-0.562262, -0.39111, -0.166214, -0.314035, -0.626006, 0.713792,
	-0.542187, -0.408758, -0.15947, -0.132734, -0.51806, 0.844982,
	-0.525654, -0.423189, -0.153917, 0.0984122, -0.15221, 0.983436,
	-0.514435, -0.434543, -0.150149, 0.292431, 0.413975, 0.862037,
	-0.510301, -0.442959, -0.14876, 0.342455, 0.652764, 0.67574,
	-0.616793, -0.249712, -0.285807, -0.876791, 0.48087, -0.000788815,
	-0.606282, -0.285546, -0.280338, -0.982496, 0.154938, 0.10342,
	-0.590791, -0.317462, -0.272279, -0.931664, -0.273811, 0.238807,
	-0.571983, -0.345601, -0.262493, -0.717521, -0.601017, 0.352055,
	-0.551514, -0.370104, -0.251843, -0.485714, -0.753028, 0.443882,
	-0.531045, -0.39111, -0.241194, -0.284941, -0.77964, 0.557647,
	-0.512236, -0.408758, -0.231408, -0.076449, -0.665926, 0.74209,
	-0.496746, -0.423189, -0.223348, 0.198083, -0.222877, 0.95451,
	-0.486234, -0.434543, -0.21788, 0.371151, 0.447994, 0.813356,
	-0.482362, -0.442959, -0.215866, 0.382865, 0.680368, 0.624911,
	-0.567059, -0.249712, -0.366653, -0.79604, 0.52265, -0.305218,
	-0.5575, -0.285546, -0.359638, -0.942924, 0.171999, -0.285151,
	-0.543412, -0.317462, -0.349299, -0.916896, -0.363173, -0.165554,
	-0.526306, -0.345601, -0.336746, -0.652536, -0.757577, 0.0165186,
	-0.50769, -0.370104, -0.323084, -0.382694, -0.906988, 0.175838,
	-0.489074, -0.39111, -0.309421, -0.16278, -0.927185, 0.337389,
	-0.471969, -0.408758, -0.296868, 0.0751427, -0.815832, 0.573386,
	-0.457881, -0.423189, -0.286529, 0.396651, -0.294833, 0.869334,
	-0.448321, -0.434543, -0.279514, 0.48452, 0.477832, 0.732746,
	-0.444799, -0.442959, -0.276929, 0.436916, 0.699662, 0.565312,
	-0.505769, -0.249712, -0.438315, -0.596778, 0.540514, -0.593044,
	-0.497383, -0.285546, -0.429929, -0.697984, 0.182033, -0.692591,
	-0.485023, -0.317462, -0.417569, -0.647657, -0.411918, -0.640987,
	-0.470016, -0.345601, -0.402561, -0.38692, -0.839839, -0.380741,
	-0.453684, -0.370104, -0.386229, -0.14147, -0.980556, -0.136002,
	-0.437352, -0.39111, -0.369897, 0.0656997, -0.995294, 0.0712278,
	-0.422344, -0.408758, -0.35489, 0.321588, -0.888154, 0.328273,
	-0.409984, -0.423189, -0.34253, 0.663394, -0.329927, 0.671607,
	-0.401598, -0.434543, -0.334144, 0.613426, 0.490412, 0.619036,
	-0.398508, -0.442959, -0.331054, 0.499332, 0.706687, 0.501259,
	-0.434108, -0.249712, -0.499606, -0.309245, 0.524167, -0.793484,
	-0.427092, -0.285546, -0.490045, -0.290656, 0.174481, -0.940785,
	-0.416753, -0.317462, -0.475958, -0.171398, -0.362733, -0.915995,
	-0.4042, -0.345601, -0.458852, 0.0126664, -0.759859, -0.649964,
	-0.390538, -0.370104, -0.440236, 0.17351, -0.909349, -0.378126,
	-0.376875, -0.39111, -0.42162, 0.335624, -0.928874, -0.156681,
	-0.364322, -0.408758, -0.404515, 0.571287, -0.816515, 0.0832783,
	-0.353983, -0.423189, -0.390427, 0.865274, -0.293696, 0.406256,
	-0.346968, -0.434543, -0.380867, 0.728272, 0.478636, 0.490436,
	-0.344383, -0.442959, -0.377345, 0.563535, 0.699903, 0.438821,
	-0.353261, -0.249712, -0.549339, -0.00422441, 0.483355, -0.875414,
	-0.347792, -0.285546, -0.538827, 0.100413, 0.158694, -0.982208,
	-0.339733, -0.317462, -0.523337, 0.237706, -0.271571, -0.932601,
	-0.329947, -0.345601, -0.504528, 0.352926, -0.60131, -0.716847,
	-0.319297, -0.370104, -0.48406, 0.445629, -0.753993, -0.482606,
	-0.308648, -0.39111, -0.463591, 0.559546, -0.780132, -0.279826,
	-0.298862, -0.408758, -0.444782, 0.743393, -0.665246, -0.0693827,
	-0.290803, -0.423189, -0.429292, 0.953275, -0.220867, 0.206118,
	-0.285334, -0.434543, -0.41878, 0.810309, 0.449111, 0.376429,
	-0.28332, -0.442959, -0.414908, 0.623411, 0.680778, 0.384578,
	-0.264412, -0.249712, -0.58633, 0.264172, 0.4362, -0.860199,
	-0.260643, -0.285546, -0.575111, 0.393324, 0.146691, -0.907622,
	-0.25509, -0.317462, -0.558578, 0.510343, -0.191932, -0.838279,
	-0.248346, -0.345601, -0.538503, 0.58451, -0.45712, -0.670365,
	-0.241007, -0.370104, -0.516655, 0.639556, -0.597395, -0.483826,
	-0.233669, -0.39111, -0.494808, 0.716617, -0.624763, -0.310051,
	-0.226924, -0.408758, -0.474733, 0.846872, -0.516294, -0.127468,
	-0.22137, -0.423189, -0.4582, 0.983131, -0.15042, 0.104055,
	-0.217603, -0.434543, -0.44698, 0.860268, 0.414833, 0.2964,
	-0.216214, -0.442959, -0.442847, 0.674608, 0.653225, 0.343805,
	-0.168748, -0.249712, -0.609394, 0.478571, 0.394542, -0.784414,
	-0.16681, -0.285546, -0.597733, 0.599415, 0.141527, -0.787827,
	-0.163954, -0.317462, -0.580551, 0.689836, -0.130081, -0.712183,
	-0.160485, -0.345601, -0.559685, 0.739006, -0.345058, -0.578623,
	-0.156711, -0.370104, -0.536979, 0.772549, -0.467323, -0.429857,
	-0.152937, -0.39111, -0.514272, 0.823201, -0.492202, -0.282978,
	-0.149469, -0.408758, -0.493406, 0.910662, -0.393926, -0.124564,
	-0.146612, -0.423189, -0.476224, 0.993299, -0.0911284, 0.0710839,
	-0.144674, -0.434543, -0.464563, 0.887472, 0.385014, 0.253293,
	-0.14396, -0.442959, -0.460267, 0.714918, 0.622058, 0.319274,
	-0.067454, -0.249712, -0.617345, 0.633505, 0.350802, -0.689645,
	-0.067454, -0.285546, -0.605533, 0.733279, 0.127953, -0.66778,
	-0.067454, -0.317462, -0.588126, 0.798785, -0.096788, -0.59378,
	-0.067454, -0.345601, -0.566988, 0.830307, -0.274721, -0.48489,
	-0.067454, -0.370104, -0.543985, 0.850085, -0.38007, -0.364557,
	-0.067454, -0.39111, -0.520982, 0.883011, -0.402585, -0.241281,
	-0.067454, -0.408758, -0.499845, 0.942599, -0.316915, -0.10522,
	-0.067454, -0.423189, -0.482437, 0.996212, -0.0611143, 0.0618554,
	-0.067454, -0.434543, -0.470625, 0.906088, 0.355703, 0.229086,
	-0.067454, -0.442959, -0.466273, 0.747385, 0.591167, 0.303211,
	0.0338399, -0.249712, -0.609394, 0.737867, 0.301755, -0.603735,
	0.0319018, -0.285546, -0.597733, 0.815019, 0.100295, -0.570688,
	0.0290455, -0.317462, -0.580551, 0.859639, -0.0937731, -0.502223,
	0.0255773, -0.345601, -0.559685, 0.877377, -0.246746, -0.411493,
	0.021803, -0.370104, -0.536979, 0.887103, -0.33978, -0.312407,
	0.0180287, -0.39111, -0.514272, 0.908458, -0.361941, -0.209054,
	0.0145605, -0.408758, -0.493406, 0.952627, -0.289505, -0.0932133,
	0.0117041, -0.423189, -0.476224, 0.996388, -0.0679811, 0.050882,
	0.00976605, -0.434543, -0.464563, 0.925642, 0.316954, 0.206705,
	0.00905197, -0.442959, -0.460267, 0.777749, 0.559453, 0.286562,
	0.129503, -0.249712, -0.58633, 0.815495, 0.260277, -0.516938,
	0.125735, -0.285546, -0.575111, 0.874237, 0.0754492, -0.479601,
	0.120182, -0.317462, -0.558578, 0.903395, -0.097286, -0.417628,
	0.113437, -0.345601, -0.538503, 0.910784, -0.233065, -0.340812,
	0.106099, -0.370104, -0.516655, 0.912606, -0.317313, -0.257803,
	0.0987604, -0.39111, -0.494808, 0.925074, -0.339468, -0.170294,
	0.0920162, -0.408758, -0.474733, 0.958027, -0.277707, -0.0711517,
	0.0864632, -0.423189, -0.4582, 0.995152, -0.0825905, 0.0533998,
	0.0826945, -0.434543, -0.44698, 0.940806, 0.276841, 0.19556,
	0.0813056, -0.442959, -0.442847, 0.803916, 0.526666, 0.276301,
	0.218353, -0.249712, -0.549339, 0.877449, 0.230659, -0.420571,
	0.212884, -0.285546, -0.538827, 0.922178, 0.0602465, -0.382044,
	0.204824, -0.317462, -0.523337, 0.940304, -0.095961, -0.326527,
	0.195039, -0.345601, -0.504528, 0.940247, -0.21864, -0.261022,
	0.184389, -0.370104, -0.48406, 0.936018, -0.295763, -0.190771,
	0.17374, -0.39111, -0.463591, 0.941257, -0.317173, -0.115919,
	0.163954, -0.408758, -0.444782, 0.964421, -0.262646, -0.030152,
	0.155894, -0.423189, -0.429292, 0.993094, -0.0876906, 0.0779349,
	0.150426, -0.434543, -0.41878, 0.947649, 0.24589, 0.203713,
	0.148412, -0.442959, -0.414908, 0.822194, 0.496058, 0.279148,
	0.299199, -0.249712, -0.499605, 0.924434, 0.209295, -0.318774,
	0.292184, -0.285546, -0.490045, 0.958354, 0.0512471, -0.280946,
	0.281845, -0.317462, -0.475958, 0.968451, -0.0917697, -0.23169,
	0.269292, -0.345601, -0.458852, 0.963038, -0.204092, -0.175794,
	0.25563, -0.370104, -0.440236, 0.954301, -0.275342, -0.116178,
	0.241967, -0.39111, -0.42162, 0.953875, -0.295683, -0.0519112,
	0.229414, -0.408758, -0.404515, 0.968946, -0.246228, 0.022679,
	0.219075, -0.423189, -0.390427, 0.989358, -0.0868013, 0.116778,
	0.21206, -0.434543, -0.380867, 0.948213, 0.223036, 0.226157,
	0.209475, -0.442959, -0.377345, 0.83322, 0.469006, 0.292878,
	0.370861, -0.249712, -0.438315, 0.95739, 0.193871, -0.214051,
	0.362474, -0.285546, -0.429929, 0.982918, 0.0464441, -0.178086,
	0.350115, -0.317462, -0.417569, 0.987149, -0.0857609, -0.134842,
	0.335107, -0.345601, -0.402561, 0.97796, -0.189633, -0.0873655,
	0.318775, -0.370104, -0.386229, 0.965999, -0.255895, -0.0369194,
	0.302443, -0.39111, -0.369897, 0.961257, -0.275054, 0.0181564,
	0.287436, -0.408758, -0.35489, 0.969808, -0.229299, 0.0830257,
	0.275076, -0.423189, -0.34253, 0.982888, -0.082026, 0.164931,
	0.26669, -0.434543, -0.334144, 0.943535, 0.206859, 0.258747,
	0.2636, -0.442959, -0.331054, 0.837733, 0.445982, 0.315123,
	0.432152, -0.249712, -0.366653, 0.977179, 0.182949, -0.107935,
	0.422591, -0.285546, -0.359638, 0.996214, 0.0447463, -0.0745398,
	0.408504, -0.317462, -0.349299, 0.996238, -0.0783549, -0.0370241,
	0.391398, -0.345601, -0.336746, 0.98454, -0.175139, 0.00291939,
	0.372782, -0.370104, -0.323084, 0.97043, -0.237105, 0.0452412,
	0.354166, -0.39111, -0.309421, 0.962544, -0.254991, 0.0921346,
	0.337061, -0.408758, -0.296868, 0.965962, -0.211954, 0.148297,
	0.322973, -0.423189, -0.286529, 0.972825, -0.0744223, 0.219257,
	0.313413, -0.434543, -0.279514, 0.934044, 0.196159, 0.298468,
	0.309891, -0.442959, -0.276929, 0.836307, 0.427044, 0.343838,
	0.481885, -0.249712, -0.285807, 0.984442, 0.175703, -0.00153576,
	0.471373, -0.285546, -0.280338, 0.99854, 0.0456447, 0.0288817,
	0.455883, -0.317462, -0.272279, 0.995707, -0.0696459, 0.0609612,
	0.437074, -0.345601, -0.262493, 0.982571, -0.160313, 0.0940926,
	0.416606, -0.370104, -0.251843, 0.967266, -0.21846, 0.129116,
	0.396137, -0.39111, -0.241194, 0.957254, -0.235042, 0.168583,
	0.377328, -0.408758, -0.231408, 0.956756, -0.193982, 0.21677,
	0.361838, -0.423189, -0.223348, 0.95852, -0.0643339, 0.277669,
	0.351326, -0.434543, -0.21788, 0.91984, 0.190171, 0.343117,
	0.347454, -0.442959, -0.215866, 0.829355, 0.412055, 0.377333,
	0.518876, -0.249712, -0.196957, 0.97965, 0.171685, 0.103976,
	0.507657, -0.285546, -0.193189, 0.990144, 0.0489403, 0.131225,
	0.491123, -0.317462, -0.187636, 0.985613, -0.0594981, 0.158203,
	0.471049, -0.345601, -0.180892, 0.971984, -0.144798, 0.18515,
	0.449201, -0.370104, -0.173553, 0.956345, -0.199486, 0.213564,
	0.427354, -0.39111, -0.166214, 0.945133, -0.21468, 0.246243,
	0.407279, -0.408758, -0.15947, 0.941805, -0.174984, 0.287024,
	0.390745, -0.423189, -0.153916, 0.93954, -0.0517904, 0.338499,
	0.379526, -0.434543, -0.150149, 0.900933, 0.18849, 0.390885,
	0.375393, -0.442959, -0.14876, 0.817171, 0.400957, 0.414083,
	0.54194, -0.249712, -0.101294, 0.963323, 0.170698, 0.207053,
	0.530279, -0.285546, -0.0993558, 0.971397, 0.0545662, 0.231105,
	0.513097, -0.317462, -0.0964996, 0.966187, -0.0477788, 0.253375,
	0.492231, -0.345601, -0.0930313, 0.95292, -0.128286, 0.274748,
	0.469524, -0.370104, -0.0892569, 0.937738, -0.17978, 0.297199,
	0.446818, -0.39111, -0.0854827, 0.926175, -0.193517, 0.323654,
	0.425952, -0.408758, -0.0820144, 0.92101, -0.154654, 0.357523,
	0.40877, -0.423189, -0.0791582, 0.915744, -0.0367049, 0.400081,
	0.397109, -0.434543, -0.07722, 0.877467, 0.190893, 0.440014,
	0.392813, -0.442959, -0.0765059, 0.800116, 0.393746, 0.452525,
	0.391732, -0.44993, 0.0763263, 0.757391, 0.375142, 0.534441,
	0.397723, -0.44993, 2.0067e-008, 0.773373, 0.385916, 0.502955,
	0.386922, -0.456761, 0.0755268, 0.800401, 0.190535, 0.568379,
	0.392851, -0.456761, 2.03675e-008, 0.819063, 0.201669, 0.53709,
	0.376036, -0.463312, 0.0737174, 0.805701, -0.125987, 0.578769,
	0.381823, -0.463312, 2.06535e-008, 0.826751, -0.117109, 0.550244,
	0.356729, -0.469444, 0.070508, 0.702219, -0.492733, 0.513909,
	0.362263, -0.469444, 2.09251e-008, 0.720683, -0.489256, 0.491167,
	0.32665, -0.475015, 0.0655084, 0.532196, -0.745739, 0.4008,
	0.331792, -0.475015, 2.11679e-008, 0.544097, -0.745755, 0.384458,
	0.283454, -0.479888, 0.0583283, 0.389955, -0.868459, 0.306127,
	0.288032, -0.479888, 2.13818e-008, 0.39654, -0.869292, 0.295105,
	0.224792, -0.483921, 0.0485776, 0.297345, -0.922393, 0.246531,
	0.228606, -0.483921, 2.15524e-008, 0.300741, -0.923152, 0.239469,
	0.14832, -0.486975, 0.0358661, 0.241988, -0.946444, 0.213743,
	0.151135, -0.486975, 2.16942e-008, 0.243573, -0.94696, 0.209616,
	0.051686, -0.48891, 0.0198036, 0.257084, -0.935335, 0.243013,
	0.0532406, -0.48891, 2.17783e-008, 0.257849, -0.935635, 0.24104,
	-0.0674541, -0.489587, 2.18048e-008, 0.0257063, -0.999339, 0.0257062,
	0.374353, -0.44993, 0.14841, 0.739254, 0.364473, 0.566271,
	0.369725, -0.456761, 0.146856, 0.779921, 0.177404, 0.600208,
	0.359252, -0.463312, 0.143337, 0.782162, -0.140133, 0.607112,
	0.340674, -0.469444, 0.137097, 0.679419, -0.502367, 0.534806,
	0.311734, -0.475015, 0.127376, 0.515743, -0.749575, 0.414905,
	0.270172, -0.479888, 0.113414, 0.380115, -0.869413, 0.315648,
	0.213732, -0.483921, 0.094455, 0.292046, -0.922371, 0.252866,
	0.140153, -0.486975, 0.0697385, 0.239473, -0.946196, 0.217637,
	0.0471768, -0.48891, 0.0385065, 0.255935, -0.935141, 0.244966,
	0.346479, -0.44993, 0.215358, 0.716767, 0.35712, 0.598924,
	0.342144, -0.456761, 0.213103, 0.755432, 0.168655, 0.633149,
	0.332331, -0.463312, 0.207998, 0.756089, -0.148979, 0.637287,
	0.314926, -0.469444, 0.198942, 0.656145, -0.507806, 0.558218,
	0.287811, -0.475015, 0.184836, 0.49954, -0.751343, 0.431211,
	0.248872, -0.479888, 0.164576, 0.370375, -0.869578, 0.326582,
	0.195991, -0.483921, 0.137064, 0.286658, -0.922088, 0.259964,
	0.127055, -0.486975, 0.101198, 0.236796, -0.945887, 0.221867,
	0.0399449, -0.48891, 0.0558768, 0.254715, -0.934911, 0.247105,
	0.309005, -0.44993, 0.276279, 0.690772, 0.352876, 0.631121,
	0.305061, -0.456761, 0.273384, 0.727817, 0.163775, 0.665928,
	0.296137, -0.463312, 0.266835, 0.728118, -0.153555, 0.668031,
	0.280307, -0.469444, 0.255218, 0.632406, -0.510234, 0.582859,
	0.255648, -0.475015, 0.23712, 0.483247, -0.751832, 0.448577,
	0.220234, -0.479888, 0.211131, 0.360426, -0.869356, 0.338103,
	0.172142, -0.483921, 0.175836, 0.280964, -0.92175, 0.267276,
	0.109445, -0.486975, 0.129824, 0.233835, -0.945618, 0.226115,
	0.0302216, -0.48891, 0.071683, 0.253348, -0.934713, 0.249252,
	0.262821, -0.44993, 0.330275, 0.662011, 0.351556, 0.661929,
	0.259362, -0.456761, 0.326816, 0.697811, 0.162404, 0.697628,
	0.251533, -0.463312, 0.318987, 0.698764, -0.154572, 0.698453,
	0.237645, -0.469444, 0.305099, 0.608284, -0.510388, 0.60786,
	0.216011, -0.475015, 0.283465, 0.466741, -0.7515, 0.466263,
	0.184941, -0.479888, 0.252395, 0.350141, -0.868986, 0.349663,
	0.142748, -0.483921, 0.210202, 0.274893, -0.92147, 0.274459,
	0.0877439, -0.486975, 0.155198, 0.230559, -0.945438, 0.230193,
	0.0182392, -0.48891, 0.0856933, 0.25181, -0.934579, 0.251305,
	0.208824, -0.44993, 0.376459, 0.631159, 0.353082, 0.690631,
	0.20593, -0.456761, 0.372515, 0.666067, 0.16437, 0.727555,
	0.199381, -0.463312, 0.363591, 0.668514, -0.152264, 0.727945,
	0.187764, -0.469444, 0.347761, 0.584006, -0.508558, 0.632698,
	0.169666, -0.475015, 0.323102, 0.450114, -0.750526, 0.483847,
	0.143677, -0.479888, 0.287688, 0.339574, -0.868559, 0.360964,
	0.108382, -0.483921, 0.239596, 0.268476, -0.921296, 0.281308,
	0.06237, -0.486975, 0.176899, 0.226987, -0.945373, 0.233982,
	0.00422884, -0.48891, 0.0976757, 0.250109, -0.934523, 0.253205,
	0.147904, -0.44993, 0.413934, 0.598924, 0.357551, 0.716552,
	0.145649, -0.456761, 0.409598, 0.633273, 0.169802, 0.755071,
	0.140543, -0.463312, 0.399785, 0.637957, -0.146493, 0.75601,
	0.131488, -0.469444, 0.38238, 0.56001, -0.504615, 0.657079,
	0.117381, -0.475015, 0.355265, 0.433653, -0.748888, 0.50111,
	0.0971216, -0.479888, 0.316326, 0.328896, -0.868088, 0.371821,
	0.0696103, -0.483921, 0.263445, 0.261812, -0.921241, 0.287696,
	0.0337437, -0.486975, 0.194509, 0.223168, -0.94543, 0.237399,
	-0.0115773, -0.48891, 0.107399, 0.248262, -0.934555, 0.254899,
	0.0809562, -0.44993, 0.441807, 0.566246, 0.365098, 0.738965,
	0.079402, -0.456761, 0.437179, 0.600323, 0.179018, 0.779464,
	0.0758832, -0.463312, 0.426706, 0.607908, -0.136788, 0.782136,
	0.0696426, -0.469444, 0.408128, 0.536974, -0.498194, 0.68078,
	0.0599217, -0.475015, 0.379188, 0.417835, -0.746432, 0.517931,
	0.0459603, -0.479888, 0.337626, 0.318381, -0.867546, 0.382095,
	0.0270009, -0.483921, 0.281186, 0.255032, -0.921319, 0.29348,
	0.00228442, -0.486975, 0.207607, 0.219154, -0.945626, 0.240338,
	-0.0289477, -0.48891, 0.114631, 0.246281, -0.934688, 0.256329,
	0.00887205, -0.44993, 0.459186, 0.534375, 0.375911, 0.757056,
	0.00807267, -0.456761, 0.454376, 0.568445, 0.192352, 0.799919,
	0.00626329, -0.463312, 0.44349, 0.579485, -0.122576, 0.805712,
	0.00305383, -0.469444, 0.424183, 0.515826, -0.488822, 0.703546,
	-0.00194586, -0.475015, 0.394104, 0.403266, -0.743019, 0.534134,
	-0.00912596, -0.479888, 0.350908, 0.308343, -0.866943, 0.391578,
	-0.0188767, -0.483921, 0.292246, 0.248264, -0.92157, 0.298454,
	-0.0315881, -0.486975, 0.215774, 0.214977, -0.945997, 0.242643,
	-0.0476506, -0.48891, 0.11914, 0.244157, -0.934953, 0.257391,
	-0.0674542, -0.44993, 0.465178, 0.503033, 0.385895, 0.773332,
	-0.0674542, -0.456761, 0.460305, 0.53725, 0.201645, 0.818964,
	-0.0674542, -0.463312, 0.449277, 0.550502, -0.117085, 0.826582,
	-0.0674542, -0.469444, 0.429717, 0.49155, -0.489134, 0.720504,
	-0.0674542, -0.475015, 0.399247, 0.384953, -0.745589, 0.543975,
	-0.0674542, -0.479888, 0.355487, 0.295653, -0.869138, 0.39647,
	-0.0674542, -0.483921, 0.29606, 0.240009, -0.923025, 0.3007,
	-0.0674541, -0.486975, 0.218589, 0.210098, -0.94686, 0.243548,
	-0.0674541, -0.48891, 0.120695, 0.241716, -0.935473, 0.257805,
	-0.14378, -0.44993, 0.459186, 0.469628, 0.391857, 0.791137,
	-0.142981, -0.456761, 0.454376, 0.5041, 0.200002, 0.840168,
	-0.141171, -0.463312, 0.44349, 0.517186, -0.132226, 0.845598,
	-0.137962, -0.469444, 0.424183, 0.458728, -0.510385, 0.727376,
	-0.132962, -0.475015, 0.394104, 0.358277, -0.759943, 0.542332,
	-0.125782, -0.479888, 0.350908, 0.277589, -0.876404, 0.393522,
	-0.116032, -0.483921, 0.292246, 0.229013, -0.926474, 0.298661,
	-0.10332, -0.486975, 0.215774, 0.204116, -0.948436, 0.242498,
	-0.0872576, -0.48891, 0.11914, 0.238829, -0.936337, 0.25736,
	-0.215864, -0.44993, 0.441807, 0.434863, 0.398204, 0.807668,
	-0.21431, -0.456761, 0.437179, 0.469769, 0.195802, 0.860801,
	-0.210791, -0.463312, 0.426706, 0.482195, -0.154497, 0.862333,
	-0.204551, -0.469444, 0.408128, 0.423463, -0.538597, 0.728418,
	-0.19483, -0.475015, 0.379188, 0.3298, -0.777738, 0.535121,
	-0.180868, -0.479888, 0.337626, 0.258616, -0.885085, 0.386966,
	-0.161909, -0.483921, 0.281186, 0.217687, -0.930491, 0.294617,
	-0.137193, -0.486975, 0.207607, 0.198113, -0.950218, 0.240491,
	-0.105961, -0.48891, 0.114631, 0.236005, -0.937283, 0.256521,
	-0.282813, -0.44993, 0.413934, 0.401906, 0.408348, 0.819587,
	-0.280557, -0.456761, 0.409598, 0.43761, 0.195921, 0.87756,
	-0.275452, -0.463312, 0.399785, 0.450254, -0.172618, 0.876056,
	-0.266396, -0.469444, 0.38238, 0.392261, -0.562987, 0.727445,
	-0.25229, -0.475015, 0.355265, 0.305269, -0.792993, 0.527232,
	-0.23203, -0.479888, 0.316326, 0.242445, -0.892575, 0.38017,
	-0.204518, -0.483921, 0.263445, 0.208037, -0.934027, 0.29037,
	-0.168652, -0.486975, 0.194509, 0.192968, -0.951832, 0.238284,
	-0.123331, -0.48891, 0.107399, 0.233611, -0.938135, 0.255594,
	-0.343733, -0.44993, 0.376459, 0.372237, 0.42223, 0.826535,
	-0.340838, -0.456761, 0.372515, 0.409176, 0.200313, 0.890197,
	-0.334289, -0.463312, 0.363591, 0.422775, -0.187006, 0.88673,
	-0.322672, -0.469444, 0.347761, 0.365826, -0.584397, 0.724328,
	-0.304574, -0.475015, 0.323102, 0.284726, -0.806397, 0.518319,
	-0.278585, -0.479888, 0.287688, 0.228941, -0.899222, 0.372808,
	-0.24329, -0.483921, 0.239596, 0.199932, -0.937236, 0.285684,
	-0.197278, -0.486975, 0.176899, 0.188598, -0.953339, 0.235744,
	-0.139137, -0.48891, 0.0976757, 0.231586, -0.938936, 0.254493,
	-0.39773, -0.44993, 0.330275, 0.34727, 0.439824, 0.828226,
	-0.39427, -0.456761, 0.326816, 0.385978, 0.20911, 0.898495,
	-0.386441, -0.463312, 0.318987, 0.401144, -0.197848, 0.894394,
	-0.372553, -0.469444, 0.305099, 0.344863, -0.603339, 0.719063,
	-0.350919, -0.475015, 0.283465, 0.268318, -0.818341, 0.508255,
	-0.31985, -0.479888, 0.252395, 0.218075, -0.905213, 0.364738,
	-0.277656, -0.483921, 0.210202, 0.193334, -0.940189, 0.280477,
	-0.222652, -0.486975, 0.155198, 0.184985, -0.954761, 0.232833,
	-0.153147, -0.48891, 0.0856933, 0.229911, -0.9397, 0.25319,
	-0.443913, -0.44993, 0.276279, 0.328534, 0.461117, 0.82428,
	-0.439969, -0.456761, 0.273384, 0.369699, 0.222615, 0.902089,
	-0.431045, -0.463312, 0.266835, 0.386976, -0.204774, 0.899065,
	-0.415215, -0.469444, 0.255218, 0.330288, -0.619859, 0.711818,
	-0.390556, -0.475015, 0.23712, 0.256388, -0.828929, 0.497134,
	-0.355142, -0.479888, 0.211131, 0.209975, -0.910588, 0.356006,
	-0.30705, -0.483921, 0.175836, 0.188294, -0.942893, 0.274769,
	-0.244353, -0.486975, 0.129824, 0.182149, -0.956098, 0.229562,
	-0.16513, -0.48891, 0.071683, 0.22859, -0.940425, 0.251689,
	-0.481388, -0.44993, 0.215358, 0.317788, 0.486022, 0.814121,
	-0.477052, -0.456761, 0.213103, 0.362319, 0.241388, 0.900254,
	-0.467239, -0.463312, 0.207998, 0.382277, -0.206805, 0.900609,
	-0.449834, -0.469444, 0.198942, 0.323373, -0.633443, 0.70298,
	-0.422719, -0.475015, 0.184836, 0.249503, -0.838014, 0.485262,
	-0.38378, -0.479888, 0.164576, 0.204889, -0.915294, 0.346782,
	-0.3309, -0.483921, 0.137064, 0.184928, -0.945318, 0.268655,
	-0.261963, -0.486975, 0.101198, 0.180143, -0.957331, 0.225978,
	-0.174853, -0.48891, 0.0558768, 0.227639, -0.941105, 0.250002,
	-0.509261, -0.44993, 0.14841, 0.31699, 0.513949, 0.797103,
	-0.504633, -0.456761, 0.146856, 0.366008, 0.265939, 0.891804,
	-0.49416, -0.463312, 0.143337, 0.389384, -0.202201, 0.898607,
	-0.475582, -0.469444, 0.137097, 0.325695, -0.643055, 0.693111,
	-0.446642, -0.475015, 0.127376, 0.248415, -0.845237, 0.473144,
	-0.40508, -0.479888, 0.113414, 0.203148, -0.919203, 0.337339,
	-0.34864, -0.483921, 0.094455, 0.183368, -0.947416, 0.262257,
	-0.275061, -0.486975, 0.0697385, 0.179007, -0.958445, 0.222125,
	-0.182085, -0.48891, 0.0385065, 0.227064, -0.941737, 0.248139,
	-0.52664, -0.44993, 0.0763262, 0.3278, 0.543569, 0.772709,
	-0.52183, -0.456761, 0.0755268, 0.382552, 0.296149, 0.875186,
	-0.510944, -0.463312, 0.0737174, 0.410439, -0.188713, 0.892148,
	-0.491637, -0.469444, 0.070508, 0.338901, -0.647146, 0.682896,
	-0.461558, -0.475015, 0.0655083, 0.253877, -0.850101, 0.461383,
	-0.418362, -0.479888, 0.0583282, 0.20504, -0.922164, 0.327983,
	-0.3597, -0.483921, 0.0485775, 0.183693, -0.949146, 0.255693,
	-0.283228, -0.486975, 0.035866, 0.178737, -0.959435, 0.21803,
	-0.186594, -0.48891, 0.0198036, 0.226831, -0.942332, 0.246084,
	-0.532632, -0.44993, -7.30942e-008, 0.344466, 0.571415, 0.744868,
	-0.527759, -0.456761, -7.18094e-008, 0.406495, 0.32105, 0.855388,
	-0.516731, -0.463312, -6.93232e-008, 0.437788, -0.187039, 0.879408,
	-0.497171, -0.469444, -6.51289e-008, 0.353541, -0.65981, 0.663069,
	-0.466701, -0.475015, -5.87922e-008, 0.259371, -0.858148, 0.443068,
	-0.422941, -0.479888, -4.98064e-008, 0.206991, -0.926221, 0.31507,
	-0.363514, -0.483921, -3.77373e-008, 0.184212, -0.951254, 0.247349,
	-0.286043, -0.486975, -2.20926e-008, 0.17869, -0.960543, 0.213134,
	-0.188149, -0.48891, -2.39491e-009, 0.226717, -0.94299, 0.243658,
	-0.52664, -0.44993, -0.0763263, 0.360969, 0.597472, 0.716051,
	-0.52183, -0.456761, -0.0755268, 0.433044, 0.332413, 0.837839,
	-0.510944, -0.463312, -0.0737174, 0.46322, -0.219521, 0.858625,
	-0.491637, -0.469444, -0.0705079, 0.358662, -0.694259, 0.623992,
	-0.461558, -0.475016, -0.0655083, 0.258023, -0.873889, 0.411998,
	-0.418362, -0.479888, -0.0583282, 0.205455, -0.932985, 0.295511,
	-0.3597, -0.483921, -0.0485775, 0.183324, -0.954329, 0.235898,
	-0.283228, -0.486975, -0.0358661, 0.178316, -0.961948, 0.207024,
	-0.186594, -0.48891, -0.0198035, 0.22653, -0.943787, 0.240729,
	-0.509261, -0.44993, -0.14841, 0.384869, 0.623317, 0.6807,
	-0.504633, -0.456761, -0.146856, 0.470566, 0.339467, 0.814451,
	-0.49416, -0.463312, -0.143337, 0.495963, -0.264953, 0.826935,
	-0.475582, -0.469444, -0.137097, 0.364782, -0.731951, 0.575484,
	-0.446642, -0.475016, -0.127376, 0.257555, -0.889586, 0.377229,
	-0.40508, -0.479888, -0.113414, 0.204854, -0.939508, 0.274518,
	-0.34864, -0.483921, -0.0944549, 0.183279, -0.957215, 0.223939,
	-0.275061, -0.486975, -0.0697385, 0.178594, -0.963211, 0.200822,
	-0.182085, -0.48891, -0.0385064, 0.226738, -0.944475, 0.237816,
	-0.481388, -0.44993, -0.215358, 0.422599, 0.645938, 0.635747,
	-0.477052, -0.456761, -0.213103, 0.524744, 0.347846, 0.776947,
	-0.467239, -0.463312, -0.207998, 0.543967, -0.300379, 0.7835,
	-0.449834, -0.469444, -0.198942, 0.382079, -0.758232, 0.528299,
	-0.422719, -0.475016, -0.184836, 0.264605, -0.899975, 0.346452,
	-0.38378, -0.479888, -0.164576, 0.20882, -0.943758, 0.256349,
	-0.3309, -0.483921, -0.137064, 0.185852, -0.959076, 0.213617,
	-0.261963, -0.486975, -0.101198, 0.180223, -0.964015, 0.195438,
	-0.174853, -0.48891, -0.0558768, 0.227603, -0.944898, 0.235295,
	-0.443913, -0.44993, -0.276279, 0.47139, 0.661548, 0.58322,
	-0.439969, -0.456761, -0.273384, 0.590661, 0.354797, 0.724734,
	-0.431045, -0.463312, -0.266835, 0.603178, -0.32265, 0.729434,
	-0.415215, -0.469444, -0.255218, 0.409068, -0.773458, 0.484176,
	-0.390556, -0.475016, -0.23712, 0.278043, -0.905766, 0.319811,
	-0.355142, -0.479888, -0.211131, 0.21658, -0.946083, 0.240872,
	-0.30705, -0.483921, -0.175836, 0.190547, -0.960077, 0.204804,
	-0.244353, -0.486975, -0.129824, 0.182919, -0.964437, 0.190793,
	-0.16513, -0.48891, -0.0716829, 0.228968, -0.94511, 0.233109,
	-0.39773, -0.44993, -0.330275, 0.526637, 0.667191, 0.526792,
	-0.39427, -0.456761, -0.326816, 0.660086, 0.357831, 0.660488,
	-0.386441, -0.463312, -0.318987, 0.667301, -0.329445, 0.667964,
	-0.372553, -0.469444, -0.305099, 0.444002, -0.777914, 0.444648,
	-0.350919, -0.475016, -0.283465, 0.296931, -0.90737, 0.297509,
	-0.31985, -0.479888, -0.252395, 0.227546, -0.946683, 0.228067,
	-0.277656, -0.483921, -0.210202, 0.197018, -0.960307, 0.197471,
	-0.222652, -0.486975, -0.155198, 0.186502, -0.964518, 0.186875,
	-0.153147, -0.48891, -0.0856932, 0.230731, -0.94514, 0.231242,
	-0.343733, -0.44993, -0.376459, 0.582934, 0.661741, 0.471473,
	-0.340838, -0.456761, -0.372515, 0.724023, 0.35582, 0.590916,
	-0.334289, -0.463312, -0.363591, 0.729463, -0.319927, 0.60459,
	-0.322672, -0.469444, -0.347761, 0.485105, -0.771736, 0.411214,
	-0.304574, -0.475016, -0.323102, 0.320567, -0.904929, 0.279894,
	-0.278585, -0.479888, -0.287688, 0.241343, -0.945625, 0.218055,
	-0.24329, -0.483921, -0.239596, 0.205039, -0.959803, 0.19167,
	-0.197278, -0.486975, -0.176899, 0.190842, -0.964277, 0.183707,
	-0.139137, -0.48891, -0.0976757, 0.232833, -0.945, 0.229703,
	-0.282813, -0.44993, -0.413933, 0.635279, 0.646374, 0.422635,
	-0.280557, -0.456761, -0.409598, 0.775902, 0.349776, 0.525007,
	-0.275452, -0.463312, -0.399785, 0.784005, -0.295365, 0.545982,
	-0.266396, -0.469444, -0.38238, 0.530614, -0.754931, 0.385393,
	-0.25229, -0.475016, -0.355265, 0.348396, -0.898375, 0.267474,
	-0.23203, -0.479888, -0.316326, 0.257692, -0.942892, 0.211068,
	-0.204518, -0.483921, -0.263445, 0.214452, -0.958565, 0.187519,
	-0.168652, -0.486975, -0.194509, 0.195851, -0.96372, 0.181345,
	-0.123331, -0.48891, -0.107399, 0.235218, -0.944699, 0.228509,
	-0.215864, -0.44993, -0.441807, 0.680071, 0.624003, 0.38487,
	-0.21431, -0.456761, -0.437179, 0.813185, 0.342109, 0.470841,
	-0.210791, -0.463312, -0.426706, 0.827614, -0.258675, 0.498139,
	-0.204551, -0.469444, -0.408128, 0.578567, -0.72763, 0.368531,
	-0.19483, -0.475016, -0.379188, 0.379853, -0.887511, 0.260838,
	-0.180868, -0.479888, -0.337626, 0.276316, -0.938422, 0.207397,
	-0.161909, -0.483921, -0.281186, 0.225063, -0.956592, 0.185144,
	-0.137193, -0.486975, -0.207607, 0.201401, -0.962859, 0.179831,
	-0.105961, -0.48891, -0.114631, 0.23782, -0.94425, 0.227669,
	-0.14378, -0.44993, -0.459186, 0.715335, 0.598394, 0.360861,
	-0.142981, -0.456761, -0.454376, 0.836638, 0.335306, 0.433135,
	-0.141171, -0.463312, -0.44349, 0.859233, -0.213711, 0.464808,
	-0.137962, -0.469444, -0.424183, 0.626651, -0.690364, 0.361533,
	-0.132962, -0.475016, -0.394104, 0.414086, -0.872175, 0.260469,
	-0.125782, -0.479888, -0.350908, 0.296767, -0.932185, 0.20727,
	-0.116032, -0.483921, -0.292246, 0.236567, -0.953915, 0.184616,
	-0.10332, -0.486975, -0.215774, 0.207292, -0.961733, 0.179166,
	-0.0872576, -0.48891, -0.11914, 0.240515, -0.943691, 0.227158,
	-0.067454, -0.44993, -0.465178, 0.744798, 0.571481, 0.344506,
	-0.067454, -0.456761, -0.460305, 0.855292, 0.321148, 0.40662,
	-0.067454, -0.463312, -0.449277, 0.879274, -0.187136, 0.438016,
	-0.067454, -0.469444, -0.429717, 0.662686, -0.660108, 0.353702,
	-0.067454, -0.475016, -0.399246, 0.44253, -0.858402, 0.259446,
	-0.067454, -0.479888, -0.355486, 0.314494, -0.926407, 0.207035,
	-0.067454, -0.483921, -0.29606, 0.246794, -0.951393, 0.184239,
	-0.0674541, -0.486975, -0.218589, 0.212646, -0.960648, 0.17871,
	-0.0674541, -0.48891, -0.120695, 0.242978, -0.943156, 0.226756,
	0.00887217, -0.44993, -0.459186, 0.773232, 0.542758, 0.327912,
	0.00807267, -0.456761, -0.454376, 0.876017, 0.293662, 0.382567,
	0.00626329, -0.463312, -0.44349, 0.891444, -0.194052, 0.409477,
	0.00305383, -0.469444, -0.424183, 0.679685, -0.651678, 0.336666,
	-0.00194573, -0.475016, -0.394104, 0.45817, -0.852483, 0.251701,
	-0.00912584, -0.479888, -0.350908, 0.3255, -0.923417, 0.203349,
	-0.0188765, -0.483921, -0.292246, 0.253875, -0.94987, 0.182468,
	-0.031588, -0.486975, -0.215774, 0.216775, -0.95987, 0.177931,
	-0.0476506, -0.48891, -0.11914, 0.244942, -0.942761, 0.226284,
	0.0809562, -0.44993, -0.441807, 0.797526, 0.513318, 0.316949,
	0.079402, -0.456761, -0.437179, 0.892561, 0.263815, 0.3657,
	0.0758832, -0.463312, -0.426706, 0.89804, -0.207286, 0.388016,
	0.0696426, -0.469444, -0.408128, 0.689815, -0.647974, 0.322931,
	0.0599217, -0.475016, -0.379188, 0.469455, -0.848125, 0.245551,
	0.0459603, -0.479888, -0.337626, 0.334313, -0.920826, 0.200781,
	0.0270009, -0.483921, -0.281186, 0.259997, -0.948382, 0.181588,
	0.00228442, -0.486975, -0.207607, 0.220587, -0.959022, 0.177817,
	-0.0289477, -0.48891, -0.114631, 0.246838, -0.942284, 0.226212,
	0.147904, -0.44993, -0.413933, 0.814404, 0.485604, 0.317702,
	0.145649, -0.456761, -0.409598, 0.900779, 0.239945, 0.361971,
	0.140543, -0.463312, -0.399785, 0.900254, -0.210454, 0.38112,
	0.131488, -0.469444, -0.38238, 0.700541, -0.637276, 0.321127,
	0.117381, -0.475016, -0.355265, 0.482332, -0.840417, 0.247094,
	0.0971216, -0.479888, -0.316326, 0.344277, -0.916696, 0.202832,
	0.0696103, -0.483921, -0.263445, 0.266751, -0.946164, 0.18335,
	0.0337437, -0.486975, -0.194509, 0.224671, -0.95784, 0.179068,
	-0.0115773, -0.48891, -0.107399, 0.248874, -0.941605, 0.22681,
	0.208824, -0.44993, -0.376459, 0.824407, 0.460948, 0.328451,
	0.20593, -0.456761, -0.372515, 0.902361, 0.221922, 0.369452,
	0.199381, -0.463312, -0.363591, 0.898935, -0.206631, 0.386288,
	0.187764, -0.469444, -0.347761, 0.710548, -0.622013, 0.328971,
	0.169666, -0.475016, -0.323102, 0.49545, -0.830393, 0.254906,
	0.143677, -0.479888, -0.287688, 0.354486, -0.911483, 0.208659,
	0.108382, -0.483921, -0.239596, 0.273568, -0.943451, 0.187247,
	0.06237, -0.486975, -0.176899, 0.228703, -0.956445, 0.181404,
	0.00422884, -0.48891, -0.0976757, 0.250877, -0.940804, 0.227924,
	0.262821, -0.44993, -0.330275, 0.828224, 0.439876, 0.34721,
	0.259362, -0.456761, -0.326816, 0.898532, 0.209173, 0.385859,
	0.251533, -0.463312, -0.318987, 0.894457, -0.197949, 0.400952,
	0.237645, -0.469444, -0.305099, 0.718945, -0.603661, 0.344545,
	0.216011, -0.475016, -0.283465, 0.50794, -0.818672, 0.267905,
	0.184941, -0.479888, -0.252395, 0.364345, -0.905475, 0.217642,
	0.142748, -0.483921, -0.210202, 0.280093, -0.940386, 0.192931,
	0.0877439, -0.486975, -0.155198, 0.232499, -0.954909, 0.184643,
	0.0182392, -0.48891, -0.0856932, 0.252745, -0.93993, 0.229459,
	0.309005, -0.44993, -0.276279, 0.826419, 0.422503, 0.372187,
	0.305061, -0.456761, -0.273384, 0.890035, 0.201077, 0.409152,
	0.296137, -0.463312, -0.266835, 0.886936, -0.185519, 0.422999,
	0.280307, -0.469444, -0.255218, 0.725215, -0.582923, 0.366419,
	0.255648, -0.475016, -0.23712, 0.51931, -0.805536, 0.285357,
	0.220234, -0.479888, -0.211131, 0.373534, -0.898805, 0.229394,
	0.172142, -0.483921, -0.175836, 0.286119, -0.937051, 0.200179,
	0.109445, -0.486975, -0.129824, 0.235938, -0.953278, 0.188665,
	0.0302216, -0.48891, -0.0716829, 0.254421, -0.939012, 0.231358,
	0.346479, -0.44993, -0.215358, 0.819368, 0.408855, 0.401838,
	0.342144, -0.456761, -0.213103, 0.877253, 0.197278, 0.437618,
	0.332331, -0.463312, -0.207998, 0.876354, -0.169812, 0.45074,
	0.314926, -0.469444, -0.198942, 0.729106, -0.559929, 0.393554,
	0.287811, -0.475016, -0.184836, 0.529308, -0.791029, 0.306767,
	0.248872, -0.479888, -0.164576, 0.381859, -0.891525, 0.243654,
	0.195991, -0.483921, -0.137064, 0.291521, -0.933489, 0.208841,
	0.127055, -0.486975, -0.101198, 0.238943, -0.951582, 0.193384,
	0.0399449, -0.48891, -0.0558768, 0.255859, -0.938073, 0.233569,
	0.374353, -0.44993, -0.14841, 0.807387, 0.398902, 0.434745,
	0.369725, -0.456761, -0.146856, 0.860417, 0.197611, 0.469715,
	0.359252, -0.463312, -0.143337, 0.862682, -0.150875, 0.482717,
	0.340674, -0.469444, -0.137097, 0.73047, -0.534556, 0.425046,
	0.311734, -0.475016, -0.127376, 0.5378, -0.775067, 0.331727,
	0.270172, -0.479888, -0.113414, 0.389187, -0.883649, 0.260188,
	0.213732, -0.483921, -0.0944549, 0.296165, -0.92975, 0.218748,
	0.140153, -0.486975, -0.0697385, 0.241415, -0.949865, 0.198683,
	0.0471768, -0.48891, -0.0385064, 0.257003, -0.937144, 0.23603,
	0.391732, -0.44993, -0.0763261, 0.790843, 0.392688, 0.469429,
	0.386922, -0.456761, -0.0755268, 0.839828, 0.201948, 0.503891,
	0.376036, -0.463312, -0.0737174, 0.845978, -0.128703, 0.517452,
	0.356729, -0.469444, -0.0705079, 0.729228, -0.506667, 0.459907,
	0.32665, -0.475016, -0.0655082, 0.544632, -0.757623, 0.3597,
	0.283454, -0.479888, -0.0583281, 0.395331, -0.875255, 0.278643,
	0.224792, -0.483921, -0.0485774, 0.299867, -0.925933, 0.229627,
	0.14832, -0.486975, -0.0358659, 0.243208, -0.948199, 0.204375,
	0.051686, -0.48891, -0.0198035, 0.257756, -0.93628, 0.238626,
	-0.564812, 0.139882, -5.71018e-009, 0.435299, -0.770325, 0.465955,
	-0.563942, 0.14184, 0.0251788, 0.385648, -0.694521, 0.607385,
	-0.627123, 0.141768, 0.0251788, 0.204616, -0.898046, 0.389416,
	-0.627261, 0.139812, -5.70297e-009, 0.21787, -0.952655, 0.212085,
	-0.684424, 0.141265, 0.0251788, 0.225212, -0.890873, 0.394494,
	-0.683929, 0.139322, -5.68133e-009, 0.235908, -0.947794, 0.214554,
	-0.735662, 0.139899, 0.0251788, 0.26018, -0.878759, 0.40011,
	-0.734628, 0.137993, -5.63085e-009, 0.268841, -0.938189, 0.218004,
	-0.780657, 0.137238, 0.0251788, 0.314826, -0.857689, 0.406514,
	-0.779173, 0.135406, -5.50825e-009, 0.322833, -0.919841, 0.222871,
	-0.819225, 0.132853, 0.0251788, 0.396835, -0.819253, 0.413941,
	-0.817376, 0.13114, -5.32796e-009, 0.407007, -0.884073, 0.229694,
	-0.851189, 0.12631, 0.0251788, 0.514916, -0.746203, 0.421951,
	-0.849052, 0.124775, -5.04683e-009, 0.532443, -0.812166, 0.238518,
	-0.876366, 0.117179, 0.0251788, 0.669354, -0.608086, 0.426845,
	-0.874013, 0.115892, -4.66473e-009, 0.701535, -0.668515, 0.246855,
	-0.894573, 0.105028, 0.0251788, 0.826596, -0.375822, 0.418925,
	-0.892073, 0.104072, -4.13828e-009, 0.875623, -0.415559, 0.246159,
	-0.90563, 0.0894262, 0.0251788, 0.916354, -0.0805305, 0.392187,
	-0.903046, 0.0888953, -3.48214e-009, 0.969512, -0.0892246, 0.228224,
	-0.909357, 0.0699409, 0.0251788, 0.919157, 0.154594, 0.362286,
	-0.906745, 0.0699409, -2.65292e-009, 0.965287, 0.165046, 0.202436,
	-0.561579, 0.147156, 0.0447622, 0.339248, -0.565658, 0.751626,
	-0.626748, 0.147079, 0.0447622, 0.188771, -0.791562, 0.581202,
	-0.685766, 0.146538, 0.0447622, 0.209961, -0.782183, 0.586606,
	-0.738466, 0.145071, 0.0447622, 0.245381, -0.767055, 0.592802,
	-0.784681, 0.142215, 0.0447622, 0.298584, -0.742791, 0.599258,
	-0.824246, 0.137505, 0.0447622, 0.374867, -0.702156, 0.605353,
	-0.856992, 0.130477, 0.0447622, 0.479689, -0.631023, 0.609679,
	-0.882752, 0.120671, 0.0447622, 0.611124, -0.506396, 0.608351,
	-0.901358, 0.107622, 0.0447622, 0.742794, -0.309065, 0.593916,
	-0.912644, 0.0908661, 0.0447622, 0.823257, -0.0631046, 0.564151,
	-0.916444, 0.0699409, 0.0447622, 0.833166, 0.139853, 0.535047,
	-0.558098, 0.154989, 0.0587504, 0.298949, -0.353041, 0.886562,
	-0.626193, 0.154905, 0.0587504, 0.173731, -0.595274, 0.784517,
	-0.687743, 0.154309, 0.0587504, 0.193452, -0.584636, 0.787894,
	-0.742599, 0.152693, 0.0587504, 0.227063, -0.565682, 0.792746,
	-0.790615, 0.149546, 0.0587504, 0.275098, -0.537196, 0.797334,
	-0.831644, 0.144358, 0.0587504, 0.339272, -0.495133, 0.799836,
	-0.865542, 0.136619, 0.0587504, 0.420968, -0.43093, 0.798176,
	-0.892162, 0.125818, 0.0587504, 0.516471, -0.331555, 0.789512,
	-0.911357, 0.111444, 0.0587504, 0.608707, -0.187816, 0.770844,
	-0.922982, 0.0929885, 0.0587504, 0.668304, -0.0144605, 0.743747,
	-0.926888, 0.0699409, 0.0587504, 0.681257, 0.134535, 0.719576,
	-0.55387, 0.164501, 0.0671433, 0.26513, -0.0446023, 0.963181,
	-0.625522, 0.164407, 0.0671433, 0.159196, -0.271858, 0.949079,
	-0.690144, 0.163745, 0.0671433, 0.174259, -0.26391, 0.948676,
	-0.747617, 0.161948, 0.0671433, 0.201072, -0.244562, 0.948556,
	-0.797818, 0.15845, 0.0671433, 0.236409, -0.216767, 0.947166,
	-0.840628, 0.152681, 0.0671433, 0.278018, -0.18243, 0.943094,
	-0.875925, 0.144076, 0.0671433, 0.324054, -0.140724, 0.935514,
	-0.903588, 0.132067, 0.0671433, 0.371365, -0.0879117, 0.924316,
	-0.923499, 0.116086, 0.0671433, 0.413707, -0.0197765, 0.910195,
	-0.935533, 0.0955673, 0.0671433, 0.442446, 0.0617347, 0.894668,
	-0.939571, 0.0699409, 0.0671433, 0.451972, 0.138418, 0.881227,
	-0.549269, 0.174852, 0.069941, 0.240735, 0.303439, 0.921939,
	-0.624791, 0.174748, 0.069941, 0.146143, 0.145227, 0.978546,
	-0.692757, 0.174013, 0.069941, 0.153392, 0.14747, 0.9771,
	-0.753078, 0.17202, 0.069941, 0.16729, 0.16, 0.972838,
	-0.805657, 0.168138, 0.069941, 0.182061, 0.176213, 0.967369,
	-0.850405, 0.161738, 0.069941, 0.192605, 0.189544, 0.962796,
	-0.887224, 0.152191, 0.069941, 0.194987, 0.195026, 0.961221,
	-0.916025, 0.138867, 0.069941, 0.187141, 0.189418, 0.963898,
	-0.936711, 0.121138, 0.069941, 0.17212, 0.173663, 0.969647,
	-0.949191, 0.0983724, 0.069941, 0.159565, 0.156564, 0.974693,
	-0.953373, 0.0699409, 0.069941, 0.156326, 0.15014, 0.976228,
	-0.544669, 0.185204, 0.0671433, 0.227451, 0.584392, 0.778943,
	-0.624058, 0.185088, 0.0671433, 0.136832, 0.518151, 0.844273,
	-0.695371, 0.184281, 0.0671433, 0.136206, 0.518007, 0.844462,
	-0.758538, 0.182091, 0.0671433, 0.135232, 0.521723, 0.842329,
	-0.813497, 0.177827, 0.0671433, 0.127486, 0.52398, 0.842136,
	-0.86018, 0.170795, 0.0671433, 0.106141, 0.518414, 0.848517,
	-0.898523, 0.160307, 0.0671433, 0.064574, 0.49669, 0.865522,
	-0.92846, 0.145669, 0.0671433, -0.000439345, 0.447418, 0.894325,
	-0.949924, 0.12619, 0.0671433, -0.0787252, 0.362966, 0.928471,
	-0.962851, 0.101178, 0.0671433, -0.142042, 0.256783, 0.955974,
	-0.967174, 0.0699409, 0.0671433, -0.167328, 0.167726, 0.971529,
	-0.540441, 0.194716, 0.0587504, 0.223847, 0.761053, 0.608844,
	-0.623387, 0.194591, 0.0587504, 0.132992, 0.757742, 0.638859,
	-0.697772, 0.193717, 0.0587504, 0.126922, 0.757594, 0.640267,
	-0.763556, 0.191347, 0.0587504, 0.114089, 0.757555, 0.642724,
	-0.8207, 0.186731, 0.0587504, 0.0880798, 0.754851, 0.649955,
	-0.869164, 0.179118, 0.0587504, 0.0405512, 0.744391, 0.666511,
	-0.908906, 0.167764, 0.0587504, -0.0386716, 0.715674, 0.697363,
	-0.939887, 0.151918, 0.0587504, -0.156357, 0.649041, 0.744512,
	-0.962065, 0.130831, 0.0587504, -0.297626, 0.523225, 0.798533,
	-0.975402, 0.103755, 0.0587504, -0.414828, 0.348931, 0.840336,
	-0.979857, 0.0699409, 0.0587504, -0.466978, 0.188956, 0.863845,
	-0.53696, 0.202549, 0.0447622, 0.226931, 0.860175, 0.456729,
	-0.622832, 0.202416, 0.0447622, 0.133376, 0.885772, 0.444544,
	-0.699749, 0.201488, 0.0447622, 0.123946, 0.886082, 0.44665,
	-0.767689, 0.198968, 0.0447622, 0.103444, 0.886462, 0.451092,
	-0.826634, 0.194062, 0.0447622, 0.0653573, 0.885269, 0.460464,
	-0.876562, 0.185973, 0.0447622, -5.76002e-005, 0.878062, 0.478548,
	-0.917456, 0.173906, 0.0447622, -0.106261, 0.853493, 0.510155,
	-0.949297, 0.157064, 0.0447622, -0.264283, 0.786582, 0.558071,
	-0.972065, 0.134653, 0.0447622, -0.457862, 0.642999, 0.613934,
	-0.98574, 0.105878, 0.0447622, -0.622947, 0.424615, 0.656993,
	-0.990301, 0.0699409, 0.0447622, -0.701088, 0.212178, 0.680776,
	-0.534597, 0.207864, 0.0251788, 0.234159, 0.913897, 0.331606,
	-0.622457, 0.207726, 0.0251788, 0.13623, 0.949562, 0.282443,
	-0.70109, 0.206762, 0.0251788, 0.124631, 0.950496, 0.284649,
	-0.770493, 0.204141, 0.0251788, 0.0997334, 0.952189, 0.288772,
	-0.830658, 0.199038, 0.0251788, 0.0548598, 0.953474, 0.296443,
	-0.881583, 0.190624, 0.0251788, -0.020592, 0.950446, 0.310206,
	-0.923259, 0.178073, 0.0251788, -0.142056, 0.931918, 0.333691,
	-0.955683, 0.160557, 0.0251788, -0.323939, 0.870862, 0.36968,
	-0.97885, 0.137247, 0.0251788, -0.552029, 0.724459, 0.412824,
	-0.992754, 0.107319, 0.0251788, -0.753303, 0.483263, 0.446085,
	-0.997389, 0.0699409, 0.0251788, -0.853638, 0.237379, 0.46363,
	-0.533727, 0.209823, -4.21178e-008, 0.242492, 0.943508, 0.225811,
	-0.622319, 0.209684, -4.21179e-008, 0.139589, 0.979444, 0.145621,
	-0.701585, 0.208704, -4.20746e-008, 0.126147, 0.981071, 0.146924,
	-0.771526, 0.206045, -4.19592e-008, 0.098519, 0.983887, 0.1492,
	-0.832142, 0.20087, -4.17285e-008, 0.0498175, 0.986962, 0.153051,
	-0.883432, 0.192338, -4.13536e-008, -0.031032, 0.986697, 0.159582,
	-0.925396, 0.179608, -4.07911e-008, -0.160293, 0.972212, 0.170615,
	-0.958035, 0.161843, -4.00269e-008, -0.353843, 0.916212, 0.188019,
	-0.981349, 0.138203, -3.89885e-008, -0.599738, 0.772188, 0.209859,
	-0.995337, 0.107848, -3.76618e-008, -0.822405, 0.521984, 0.226237,
	-1, 0.0699409, -3.60034e-008, -0.937629, 0.257865, 0.233148,
	-0.534597, 0.207864, -0.0251787, 0.252322, 0.961608, 0.107903,
	-0.622457, 0.207726, -0.0251787, 0.142716, 0.989761, 0.00253332,
	-0.70109, 0.206762, -0.0251787, 0.12751, 0.991836, 0.00180862,
	-0.770493, 0.204141, -0.0251787, 0.098062, 0.99518, 0.00116239,
	-0.830658, 0.199038, -0.0251787, 0.04717, 0.998887, -0.000428438,
	-0.881583, 0.190624, -0.0251787, -0.0365126, 0.999325, -0.00395137,
	-0.923259, 0.178073, -0.0251787, -0.1692, 0.985532, -0.00992067,
	-0.955683, 0.160557, -0.0251787, -0.365992, 0.930453, -0.0175113,
	-0.97885, 0.137247, -0.0251787, -0.614948, 0.788175, -0.0248816,
	-0.992754, 0.107319, -0.0251787, -0.842607, 0.537564, -0.0322181,
	-0.997389, 0.0699409, -0.0251787, -0.962771, 0.267356, -0.0398984,
	-0.53696, 0.202549, -0.0447622, 0.268762, 0.962071, -0.0467644,
	-0.622832, 0.202416, -0.0447622, 0.147829, 0.972162, -0.18179,
	-0.699749, 0.201488, -0.0447622, 0.131764, 0.973953, -0.184535,
	-0.767689, 0.198968, -0.0447622, 0.102763, 0.97691, -0.187317,
	-0.826634, 0.194062, -0.0447622, 0.0533199, 0.979564, -0.193935,
	-0.876562, 0.185973, -0.0447622, -0.0275432, 0.977713, -0.208134,
	-0.917456, 0.173906, -0.0447622, -0.154183, 0.960184, -0.232967,
	-0.949297, 0.157064, -0.0447622, -0.337865, 0.902106, -0.268425,
	-0.972065, 0.134653, -0.0447622, -0.565947, 0.764293, -0.30913,
	-0.98574, 0.105878, -0.0447622, -0.775281, 0.528315, -0.346153,
	-0.990301, 0.0699409, -0.0447622, -0.887235, 0.271477, -0.372981,
	-0.540441, 0.194716, -0.0587504, 0.300991, 0.918338, -0.257019,
	-0.623387, 0.194591, -0.0587504, 0.158554, 0.890737, -0.425968,
	-0.697772, 0.193717, -0.0587504, 0.143407, 0.891667, -0.429376,
	-0.763556, 0.191347, -0.0587504, 0.119139, 0.894341, -0.43123,
	-0.8207, 0.186731, -0.0587504, 0.0776496, 0.894967, -0.439323,
	-0.869164, 0.179118, -0.0587504, 0.00940487, 0.887752, -0.460226,
	-0.908906, 0.167764, -0.0587504, -0.0954539, 0.861922, -0.497974,
	-0.939887, 0.151918, -0.0587504, -0.240815, 0.798972, -0.551046,
	-0.962065, 0.130831, -0.0587504, -0.412753, 0.674655, -0.611944,
	-0.975402, 0.103755, -0.0587504, -0.567354, 0.479548, -0.669435,
	-0.979857, 0.0699409, -0.0587504, -0.649353, 0.270044, -0.710927,
	-0.544669, 0.185204, -0.0671433, 0.368192, 0.762943, -0.531369,
	-0.624058, 0.185088, -0.0671433, 0.17942, 0.665513, -0.7245,
	-0.695371, 0.184281, -0.0671433, 0.167564, 0.666212, -0.726694,
	-0.758538, 0.182091, -0.0671433, 0.154442, 0.671453, -0.724775,
	-0.813497, 0.177827, -0.0671433, 0.130748, 0.671978, -0.728938,
	-0.86018, 0.170795, -0.0671433, 0.0891169, 0.660251, -0.745739,
	-0.898523, 0.160307, -0.0671433, 0.0259743, 0.629354, -0.776685,
	-0.92846, 0.145669, -0.0671433, -0.0546358, 0.574087, -0.816969,
	-0.949924, 0.12619, -0.0671433, -0.139843, 0.489691, -0.860608,
	-0.962851, 0.101178, -0.0671433, -0.209487, 0.37462, -0.903203,
	-0.967174, 0.0699409, -0.0671433, -0.244471, 0.254516, -0.935658,
	-0.549269, 0.174852, -0.0699409, 0.49356, 0.367781, -0.788122,
	-0.624791, 0.174748, -0.0699409, 0.210367, 0.202158, -0.956493,
	-0.692757, 0.174013, -0.0699409, 0.203678, 0.202558, -0.957855,
	-0.753078, 0.17202, -0.0699409, 0.208095, 0.209155, -0.955485,
	-0.805657, 0.168138, -0.0699409, 0.213442, 0.212927, -0.95347,
	-0.850405, 0.161738, -0.0699409, 0.214044, 0.210543, -0.953864,
	-0.887224, 0.152191, -0.0699409, 0.210331, 0.205065, -0.955881,
	-0.916025, 0.138867, -0.0699409, 0.208168, 0.205223, -0.956321,
	-0.936711, 0.121138, -0.0699409, 0.212437, 0.214923, -0.953247,
	-0.949191, 0.0983724, -0.0699409, 0.219714, 0.22602, -0.949021,
	-0.953373, 0.0699409, -0.0699409, 0.219663, 0.225226, -0.949221,
	-0.55387, 0.164501, -0.0671433, 0.611887, -0.274894, -0.741638,
	-0.625522, 0.164407, -0.0671433, 0.232496, -0.384199, -0.893497,
	-0.690144, 0.163745, -0.0671433, 0.231166, -0.38368, -0.894065,
	-0.747617, 0.161948, -0.0671433, 0.250185, -0.380477, -0.890306,
	-0.797818, 0.15845, -0.0671433, 0.282942, -0.371801, -0.884143,
	-0.840628, 0.152681, -0.0671433, 0.327466, -0.35043, -0.877476,
	-0.875925, 0.144076, -0.0671433, 0.386309, -0.303825, -0.870893,
	-0.903588, 0.132067, -0.0671433, 0.461457, -0.216031, -0.860458,
	-0.923499, 0.116086, -0.0671433, 0.541391, -0.0813685, -0.836824,
	-0.935533, 0.0955673, -0.0671433, 0.595549, 0.0750114, -0.799809,
	-0.939571, 0.0699409, -0.0671433, 0.603185, 0.192963, -0.773907,
	-0.558098, 0.154989, -0.0587504, 0.598991, -0.724305, -0.341456,
	-0.626193, 0.154905, -0.0587504, 0.234671, -0.780223, -0.579812,
	-0.687743, 0.154309, -0.0587504, 0.23833, -0.777416, -0.582085,
	-0.742599, 0.152693, -0.0587504, 0.262487, -0.771947, -0.578964,
	-0.790615, 0.149546, -0.0587504, 0.307288, -0.758292, -0.57495,
	-0.831644, 0.144358, -0.0587504, 0.377161, -0.72673, -0.574119,
	-0.865542, 0.136619, -0.0587504, 0.47989, -0.659742, -0.578313,
	-0.892162, 0.125818, -0.0587504, 0.617525, -0.528732, -0.582328,
	-0.911357, 0.111444, -0.0587504, 0.760894, -0.309986, -0.570043,
	-0.922982, 0.0929885, -0.0587504, 0.844262, -0.0394833, -0.534474,
	-0.926888, 0.0699409, -0.0587504, 0.84553, 0.168661, -0.50659,
	-0.561579, 0.147156, -0.0447622, 0.533835, -0.844745, 0.0377612,
	-0.626748, 0.147079, -0.0447622, 0.229292, -0.940549, -0.250584,
	-0.685766, 0.146538, -0.0447622, 0.237774, -0.937421, -0.254372,
	-0.738466, 0.145071, -0.0447622, 0.264068, -0.930325, -0.254486,
	-0.784681, 0.142215, -0.0447622, 0.312636, -0.915347, -0.253769,
	-0.824246, 0.137505, -0.0447622, 0.391894, -0.884048, -0.254714,
	-0.856992, 0.130477, -0.0447622, 0.513738, -0.817993, -0.258768,
	-0.882752, 0.120671, -0.0447622, 0.683617, -0.680665, -0.26337,
	-0.901358, 0.107622, -0.0447622, 0.86489, -0.429966, -0.259025,
	-0.912644, 0.0908661, -0.0447622, 0.965356, -0.0998186, -0.24109,
	-0.916444, 0.0699409, -0.0447622, 0.960392, 0.15771, -0.229727,
	-0.563942, 0.14184, -0.0251787, 0.481261, -0.824938, 0.29642,
	-0.627123, 0.141768, -0.0251787, 0.224677, -0.974362, 0.011777,
	-0.684424, 0.141265, -0.0251787, 0.238184, -0.971169, 0.00999653,
	-0.735662, 0.139899, -0.0251787, 0.267593, -0.963479, 0.0101419,
	-0.780657, 0.137238, -0.0251787, 0.318969, -0.947694, 0.0116179,
	-0.819225, 0.132853, -0.0251787, 0.40187, -0.915589, 0.0140253,
	-0.851189, 0.12631, -0.0251787, 0.528941, -0.848483, 0.0172462,
	-0.876366, 0.117179, -0.0251787, 0.705492, -0.708401, 0.0211971,
	-0.894573, 0.105028, -0.0251787, 0.892605, -0.450166, 0.0246297,
	-0.90563, 0.0894262, -0.0251787, 0.993944, -0.107416, 0.0231996,
	-0.909357, 0.0699409, -0.0251787, 0.986961, 0.160457, 0.0127214,
	-0.907422, 0.0464781, 0.0251788, 0.894564, 0.284085, 0.345038,
	-0.904849, 0.0470003, -1.64341e-009, 0.936568, 0.298661, 0.183416,
	-0.901495, 0.0197725, 0.0251788, 0.868529, 0.365344, 0.334935,
	-0.899036, 0.0207025, -5.04208e-010, 0.908617, 0.380751, 0.17159,
	-0.891391, -0.00935528, 0.0251788, 0.838512, 0.437069, 0.325374,
	-0.88912, -0.00811313, 7.64799e-010, 0.876204, 0.453359, 0.163502,
	-0.876926, -0.0400908, 0.0251788, 0.804386, 0.503852, 0.314795,
	-0.874915, -0.0386074, 2.0915e-009, 0.838948, 0.52085, 0.157735,
	-0.857919, -0.0716133, 0.0251788, 0.765154, 0.568029, 0.303122,
	-0.856233, -0.0699409, 3.46147e-009, 0.79601, 0.585484, 0.153549,
	-0.834183, -0.103107, 0.0251788, 0.719583, 0.630355, 0.291295,
	-0.832888, -0.101274, 4.83145e-009, 0.746444, 0.648194, 0.150551,
	-0.805536, -0.133754, 0.0251788, 0.666603, 0.690366, 0.281133,
	-0.804694, -0.131769, 6.15815e-009, 0.689435, 0.708954, 0.148537,
	-0.771791, -0.162735, 0.0251788, 0.605675, 0.746631, 0.275138,
	-0.771464, -0.160584, 7.42728e-009, 0.624524, 0.766963, 0.147439,
	-0.732768, -0.189235, 0.0251788, 0.537037, 0.797065, 0.276186,
	-0.733012, -0.186882, 8.56648e-009, 0.551819, 0.820872, 0.147189,
	-0.688281, -0.212434, 0.0251788, 0.526033, 0.785449, 0.326128,
	-0.689151, -0.209823, 9.57592e-009, 0.539273, 0.812221, 0.222444,
	-0.914403, 0.0450594, 0.0447622, 0.813169, 0.25979, 0.520832,
	-0.908165, 0.0172496, 0.0447622, 0.789194, 0.337583, 0.51304,
	-0.897553, -0.0127286, 0.0447622, 0.762631, 0.406236, 0.503356,
	-0.882389, -0.0441156, 0.0447622, 0.733812, 0.470585, 0.489969,
	-0.862496, -0.0761542, 0.0447622, 0.701531, 0.533077, 0.472952,
	-0.837699, -0.108083, 0.0447622, 0.663919, 0.594184, 0.454045,
	-0.807818, -0.139143, 0.0447622, 0.619255, 0.652619, 0.436591,
	-0.77268, -0.168576, 0.0447622, 0.566611, 0.705673, 0.425415,
	-0.732106, -0.195622, 0.0447622, 0.50633, 0.749755, 0.426024,
	-0.685919, -0.219521, 0.0447622, 0.503336, 0.742827, 0.44143,
	-0.924694, 0.0429692, 0.0587504, 0.667577, 0.229959, 0.708138,
	-0.917998, 0.0135319, 0.0587504, 0.6482, 0.294782, 0.702097,
	-0.906635, -0.0176985, 0.0587504, 0.627801, 0.352522, 0.69397,
	-0.890438, -0.0500491, 0.0587504, 0.607444, 0.407669, 0.681775,
	-0.869241, -0.0828449, 0.0587504, 0.586113, 0.462743, 0.665087,
	-0.842878, -0.115414, 0.0587504, 0.561658, 0.518116, 0.645055,
	-0.811183, -0.147085, 0.0587504, 0.531622, 0.5718, 0.624838,
	-0.773988, -0.177182, 0.0587504, 0.494306, 0.619568, 0.609751,
	-0.731128, -0.205033, 0.0587504, 0.449608, 0.655791, 0.606458,
	-0.682437, -0.229966, 0.0587504, 0.467506, 0.66914, 0.577658,
	-0.937187, 0.0404315, 0.0671433, 0.445741, 0.193029, 0.874102,
	-0.929936, 0.00901708, 0.0671433, 0.434333, 0.23188, 0.870394,
	-0.917662, -0.0237339, 0.0671433, 0.422447, 0.266707, 0.86626,
	-0.900213, -0.0572521, 0.0671433, 0.41179, 0.300686, 0.860242,
	-0.877432, -0.0909692, 0.0671433, 0.402307, 0.336095, 0.85158,
	-0.849169, -0.124318, 0.0671433, 0.392969, 0.373891, 0.840108,
	-0.815269, -0.156729, 0.0671433, 0.382213, 0.413219, 0.826537,
	-0.775578, -0.187633, 0.0671433, 0.368312, 0.45062, 0.813196,
	-0.729943, -0.216463, 0.0671433, 0.349873, 0.479807, 0.804596,
	-0.67821, -0.242648, 0.0671433, 0.411642, 0.546024, 0.729664,
	-0.950785, 0.0376686, 0.069941, 0.156353, 0.150479, 0.976171,
	-0.942928, 0.00410321, 0.069941, 0.155417, 0.150069, 0.976384,
	-0.929662, -0.0303015, 0.069941, 0.153837, 0.148654, 0.97685,
	-0.910849, -0.0650917, 0.069941, 0.152787, 0.147281, 0.977223,
	-0.886346, -0.099811, 0.069941, 0.153286, 0.147123, 0.977169,
	-0.856015, -0.134007, 0.069941, 0.15646, 0.1497, 0.976274,
	-0.819715, -0.167223, 0.069941, 0.1637, 0.157146, 0.973914,
	-0.777308, -0.199005, 0.069941, 0.175989, 0.171303, 0.969372,
	-0.728653, -0.228899, 0.069941, 0.192426, 0.191298, 0.962485,
	-0.673609, -0.25645, 0.069941, 0.328209, 0.353913, 0.875799,
	-0.964382, 0.034907, 0.0671433, -0.165433, 0.107837, 0.980308,
	-0.95592, -0.00081069, 0.0671433, -0.15599, 0.0591273, 0.985987,
	-0.941664, -0.0368704, 0.0671433, -0.145267, 0.0121511, 0.989318,
	-0.921485, -0.0729313, 0.0671433, -0.133968, -0.0332603, 0.990427,
	-0.89526, -0.108653, 0.0671433, -0.121117, -0.0770046, 0.989647,
	-0.862861, -0.143695, 0.0671433, -0.104542, -0.117634, 0.987539,
	-0.824162, -0.177717, 0.0671433, -0.0810506, -0.151293, 0.985161,
	-0.779038, -0.210377, 0.0671433, -0.0471024, -0.171542, 0.98405,
	-0.727362, -0.241337, 0.0671433, -0.0008626, -0.171179, 0.98524,
	-0.669008, -0.270252, 0.0671433, 0.21787, 0.0925714, 0.971578,
	-0.976877, 0.0323693, 0.0587504, -0.469353, 0.0725901, 0.880022,
	-0.967858, -0.00532545, 0.0587504, -0.452901, -0.0258266, 0.891187,
	-0.952691, -0.0429046, 0.0587504, -0.428489, -0.119945, 0.89555,
	-0.931259, -0.0801343, 0.0587504, -0.399264, -0.208236, 0.892875,
	-0.90345, -0.116778, 0.0587504, -0.366151, -0.289906, 0.884244,
	-0.869151, -0.152599, 0.0587504, -0.328326, -0.363445, 0.871843,
	-0.828247, -0.187361, 0.0587504, -0.284029, -0.425589, 0.859187,
	-0.780628, -0.220828, 0.0587504, -0.23115, -0.471025, 0.851296,
	-0.726176, -0.252765, 0.0587504, -0.168212, -0.493041, 0.853589,
	-0.664781, -0.282934, 0.0587504, 0.0991824, -0.196861, 0.975402,
	-0.987166, 0.0302791, 0.0447622, -0.712736, 0.0507241, 0.699596,
	-0.977691, -0.00904321, 0.0447622, -0.69443, -0.0910613, 0.713776,
	-0.961772, -0.0478757, 0.0447622, -0.657533, -0.226663, 0.718522,
	-0.939309, -0.0860678, 0.0447622, -0.607519, -0.349862, 0.713104,
	-0.910196, -0.123469, 0.0447622, -0.549064, -0.457508, 0.699439,
	-0.874331, -0.15993, 0.0447622, -0.485377, -0.548268, 0.681037,
	-0.831613, -0.195302, 0.0447622, -0.418267, -0.621353, 0.66255,
	-0.781936, -0.229435, 0.0447622, -0.348715, -0.67589, 0.649285,
	-0.7252, -0.262177, 0.0447622, -0.277193, -0.710605, 0.646688,
	-0.661299, -0.293379, 0.0447622, -0.00254636, -0.457833, 0.889035,
	-0.994149, 0.0288604, 0.0251788, -0.876521, 0.0449886, 0.479257,
	-0.984362, -0.011566, 0.0251788, -0.860795, -0.129027, 0.492325,
	-0.967935, -0.0512477, 0.0251788, -0.815543, -0.296335, 0.497066,
	-0.944771, -0.0900926, 0.0251788, -0.747844, -0.445009, 0.492643,
	-0.914773, -0.12801, 0.0251788, -0.666954, -0.56899, 0.481064,
	-0.877846, -0.164906, 0.0251788, -0.581017, -0.667512, 0.465668,
	-0.833896, -0.200691, 0.0251788, -0.495638, -0.742846, 0.450025,
	-0.782825, -0.235275, 0.0251788, -0.41391, -0.798258, 0.437564,
	-0.724537, -0.268563, 0.0251788, -0.33727, -0.836836, 0.431225,
	-0.658937, -0.300466, 0.0251788, -0.0744438, -0.661658, 0.746101,
	-0.996721, 0.0283382, -3.41803e-008, -0.969546, 0.0473767, 0.240285,
	-0.98682, -0.0124961, -3.23933e-008, -0.957721, -0.146199, 0.247784,
	-0.970206, -0.0524911, -3.06497e-008, -0.908604, -0.333289, 0.251708,
	-0.946783, -0.091576, -2.8942e-008, -0.829925, -0.49785, 0.251733,
	-0.916459, -0.129682, -2.72776e-008, -0.734479, -0.631453, 0.248611,
	-0.879142, -0.166739, -2.56637e-008, -0.634254, -0.733764, 0.243542,
	-0.834737, -0.202677, -2.4093e-008, -0.537406, -0.809174, 0.237556,
	-0.783152, -0.237426, -2.25728e-008, -0.448131, -0.863519, 0.231329,
	-0.724292, -0.270916, -2.11104e-008, -0.367895, -0.902181, 0.225219,
	-0.658067, -0.303077, -1.96982e-008, -0.120996, -0.812611, 0.570109,
	-0.994149, 0.0288604, -0.0251787, -0.997667, 0.0507711, -0.0456401,
	-0.984362, -0.011566, -0.0251787, -0.98782, -0.148008, -0.0480086,
	-0.967935, -0.0512477, -0.0251787, -0.939137, -0.340427, -0.0461687,
	-0.944771, -0.0900926, -0.0251787, -0.859102, -0.510298, -0.0392323,
	-0.914773, -0.12801, -0.0251787, -0.760781, -0.648379, -0.028597,
	-0.877846, -0.164906, -0.0251787, -0.656939, -0.753756, -0.0168042,
	-0.833896, -0.200691, -0.0251787, -0.556451, -0.830853, -0.00671043,
	-0.782825, -0.235275, -0.0251787, -0.463866, -0.885905, -0.00100887,
	-0.724537, -0.268563, -0.0251787, -0.380541, -0.924762, -0.00201205,
	-0.658937, -0.300466, -0.0251787, -0.151515, -0.927692, 0.34122,
	-0.987166, 0.0302791, -0.0447622, -0.916891, 0.0672207, -0.393437,
	-0.977691, -0.00904321, -0.0447622, -0.905849, -0.116134, -0.40737,
	-0.961772, -0.0478757, -0.0447622, -0.863418, -0.293784, -0.410123,
	-0.939309, -0.0860678, -0.0447622, -0.796335, -0.454504, -0.399095,
	-0.910196, -0.123469, -0.0447622, -0.713614, -0.590909, -0.376273,
	-0.874331, -0.15993, -0.0447622, -0.623857, -0.700224, -0.347116,
	-0.831613, -0.195302, -0.0447622, -0.53346, -0.783605, -0.318407,
	-0.781936, -0.229435, -0.0447622, -0.446018, -0.844331, -0.296939,
	-0.7252, -0.262177, -0.0447622, -0.362738, -0.886028, -0.288749,
	-0.661299, -0.293379, -0.0447622, -0.143056, -0.989698, -0.00579761,
	-0.976877, 0.0323693, -0.0587504, -0.66534, 0.107185, -0.738806,
	-0.967858, -0.00532545, -0.0587504, -0.651429, -0.0326167, -0.758008,
	-0.952691, -0.0429046, -0.0587504, -0.620606, -0.16762, -0.765997,
	-0.931259, -0.0801343, -0.0587504, -0.578994, -0.295037, -0.760078,
	-0.90345, -0.116778, -0.0587504, -0.530231, -0.412565, -0.740706,
	-0.869151, -0.152599, -0.0587504, -0.475783, -0.517261, -0.711387,
	-0.828247, -0.187361, -0.0587504, -0.415748, -0.6056, -0.678529,
	-0.780628, -0.220828, -0.0587504, -0.349515, -0.674289, -0.650518,
	-0.726176, -0.252765, -0.0587504, -0.276243, -0.719968, -0.636659,
	-0.664781, -0.282934, -0.0587504, -0.0178845, -0.854514, -0.519121,
	-0.964382, 0.034907, -0.0671433, -0.248126, 0.16378, -0.954783,
	-0.95592, -0.00081069, -0.0671433, -0.237671, 0.0910208, -0.967072,
	-0.941664, -0.0368704, -0.0671433, -0.221857, 0.0222627, -0.974825,
	-0.921485, -0.0729313, -0.0671433, -0.205162, -0.0446716, -0.977708,
	-0.89526, -0.108653, -0.0671433, -0.188742, -0.111401, -0.975688,
	-0.862861, -0.143695, -0.0671433, -0.171062, -0.177572, -0.969126,
	-0.824162, -0.177717, -0.0671433, -0.148423, -0.239947, -0.959373,
	-0.779038, -0.210377, -0.0671433, -0.115618, -0.292075, -0.949381,
	-0.727362, -0.241337, -0.0671433, -0.0680061, -0.324388, -0.943476,
	-0.669008, -0.270252, -0.0671433, 0.268668, -0.233732, -0.934445,
	-0.950785, 0.0376686, -0.0699409, 0.214097, 0.218799, -0.951992,
	-0.942928, 0.00410321, -0.0699409, 0.210322, 0.214711, -0.953763,
	-0.929662, -0.0303015, -0.0699409, 0.20863, 0.212079, -0.954723,
	-0.910849, -0.0650917, -0.0699409, 0.207331, 0.210204, -0.95542,
	-0.886346, -0.099811, -0.0699409, 0.205633, 0.208689, -0.956119,
	-0.856015, -0.134007, -0.0699409, 0.203594, 0.207531, -0.956807,
	-0.819715, -0.167223, -0.0699409, 0.202543, 0.207385, -0.957062,
	-0.777308, -0.199005, -0.0699409, 0.205242, 0.209879, -0.955943,
	-0.728653, -0.228899, -0.0699409, 0.213959, 0.216761, -0.952489,
	-0.673609, -0.25645, -0.0699409, 0.460461, 0.405024, -0.789893,
	-0.937187, 0.0404315, -0.0671433, 0.585707, 0.258438, -0.768217,
	-0.929936, 0.00901708, -0.0671433, 0.56557, 0.305149, -0.766169,
	-0.917662, -0.0237339, -0.0671433, 0.546899, 0.348604, -0.761168,
	-0.900213, -0.0572521, -0.0671433, 0.529531, 0.390992, -0.75281,
	-0.877432, -0.0909692, -0.0671433, 0.512114, 0.433827, -0.741305,
	-0.849169, -0.124318, -0.0671433, 0.492782, 0.477509, -0.727428,
	-0.815269, -0.156729, -0.0671433, 0.46985, 0.520942, -0.712643,
	-0.775578, -0.187633, -0.0671433, 0.442496, 0.561276, -0.699405,
	-0.729943, -0.216463, -0.0671433, 0.410656, 0.593414, -0.692258,
	-0.67821, -0.242648, -0.0671433, 0.523433, 0.691347, -0.498054,
	-0.924694, 0.0429692, -0.0587504, 0.817026, 0.281391, -0.503277,
	-0.917998, 0.0135319, -0.0587504, 0.786793, 0.356394, -0.503926,
	-0.906635, -0.0176985, -0.0587504, 0.756266, 0.423561, -0.498656,
	-0.890438, -0.0500491, -0.0587504, 0.725413, 0.486756, -0.486667,
	-0.869241, -0.0828449, -0.0587504, 0.692649, 0.548248, -0.46868,
	-0.842878, -0.115414, -0.0587504, 0.655712, 0.608581, -0.446845,
	-0.811183, -0.147085, -0.0587504, 0.612486, 0.666595, -0.424867,
	-0.773988, -0.177182, -0.0587504, 0.561787, 0.71948, -0.408342,
	-0.731128, -0.205033, -0.0587504, 0.503883, 0.76305, -0.404793,
	-0.682437, -0.229966, -0.0587504, 0.544012, 0.800656, -0.250999,
	-0.914403, 0.0450594, -0.0447622, 0.92676, 0.293133, -0.234925,
	-0.908165, 0.0172496, -0.0447622, 0.893698, 0.37864, -0.2407,
	-0.897553, -0.0127286, -0.0447622, 0.858224, 0.453903, -0.239634,
	-0.882389, -0.0441156, -0.0447622, 0.819994, 0.523441, -0.231558,
	-0.862496, -0.0761542, -0.0447622, 0.777718, 0.589713, -0.2177,
	-0.837699, -0.108083, -0.0447622, 0.729786, 0.653615, -0.2005,
	-0.807818, -0.139143, -0.0447622, 0.674818, 0.714753, -0.183709,
	-0.77268, -0.168576, -0.0447622, 0.612172, 0.771718, -0.172327,
	-0.732106, -0.195622, -0.0447622, 0.542206, 0.822382, -0.17234,
	-0.685919, -0.219521, -0.0447622, 0.549055, 0.833958, -0.0552617,
	-0.907422, 0.0464781, -0.0251787, 0.954101, 0.299479, -0.00175111,
	-0.901495, 0.0197725, -0.0251787, 0.922957, 0.384717, -0.0120053,
	-0.891391, -0.00935528, -0.0251787, 0.887933, 0.459683, -0.0163297,
	-0.876926, -0.0400908, -0.0251787, 0.848534, 0.528914, -0.0155084,
	-0.857919, -0.0716133, -0.0251787, 0.803803, 0.594798, -0.0107662,
	-0.834183, -0.103107, -0.0251787, 0.752683, 0.658373, -0.00375531,
	-0.805536, -0.133754, -0.0251787, 0.694275, 0.719702, 0.00341564,
	-0.771791, -0.162735, -0.0251787, 0.628148, 0.778052, 0.00805382,
	-0.732768, -0.189235, -0.0251787, 0.554485, 0.832163, 0.00707194,
	-0.688281, -0.212434, -0.0251787, 0.546644, 0.831379, 0.0999417,
	0.460989, -0.0466273, 2.44239e-009, 0.22052, 0.927478, 0.30192,
	0.460989, -0.0538079, 0.0553932, 0.201661, 0.864845, 0.459756,
	0.535405, -0.0471806, 0.0544297, 0.0234388, 0.926283, 0.376099,
	0.534318, -0.040659, 2.18762e-009, 0.0293691, 0.983628, 0.177803,
	0.590606, -0.0298042, 0.0518145, -0.151253, 0.908481, 0.389596,
	0.58881, -0.0240597, 1.457e-009, -0.150831, 0.967781, 0.201616,
	0.630232, -0.00367672, 0.0479605, -0.362009, 0.840028, 0.404108,
	0.628008, 0.0012123, 3.51371e-010, -0.369049, 0.901476, 0.226149,
	0.65792, 0.0292036, 0.0432806, -0.554158, 0.723339, 0.411934,
	0.655456, 0.0331987, -1.0426e-009, -0.574481, 0.782011, 0.241724,
	0.677308, 0.0668399, 0.0381878, -0.67621, 0.607234, 0.417142,
	0.674697, 0.0699409, -2.65292e-009, -0.713626, 0.656624, 0.244098,
	0.692034, 0.107235, 0.033095, -0.72118, 0.543153, 0.42998,
	0.689276, 0.109481, -4.37863e-009, -0.7769, 0.582974, 0.237839,
	0.705733, 0.148392, 0.0284151, -0.701296, 0.550692, 0.452683,
	0.702736, 0.14986, -6.1476e-009, -0.776493, 0.587664, 0.227398,
	0.722045, 0.188311, 0.024561, -0.621089, 0.623927, 0.474303,
	0.71862, 0.18912, -7.85889e-009, -0.712533, 0.668708, 0.212431,
	0.744608, 0.224996, 0.0219458, -0.479862, 0.738545, 0.473586,
	0.740473, 0.225303, -9.44036e-009, -0.574031, 0.796321, 0.190685,
	0.777059, 0.25645, 0.0209823, -0.27158, 0.838857, 0.471765,
	0.771837, 0.25645, -1.08055e-008, -0.366163, 0.90792, 0.203975,
	0.460989, -0.0732981, 0.0984769, 0.190802, 0.759026, 0.622474,
	0.538353, -0.0648816, 0.096764, 0.0314113, 0.814934, 0.578701,
	0.595482, -0.0453963, 0.0921147, -0.114023, 0.803508, 0.584272,
	0.636271, -0.0169475, 0.0852631, -0.292334, 0.750574, 0.592604,
	0.664611, 0.0183599, 0.0769433, -0.456066, 0.659784, 0.597235,
	0.684395, 0.0584234, 0.0678894, -0.557566, 0.568615, 0.604812,
	0.699518, 0.10114, 0.0588355, -0.584136, 0.517267, 0.625475,
	0.713869, 0.144405, 0.0505157, -0.545743, 0.520245, 0.656893,
	0.731345, 0.186114, 0.0436641, -0.454429, 0.570642, 0.684005,
	0.755835, 0.224164, 0.0390148, -0.318185, 0.652866, 0.687404,
	0.791234, 0.25645, 0.0373019, -0.117474, 0.732699, 0.670337,
	0.460989, -0.102021, 0.129251, 0.197746, 0.60605, 0.770454,
	0.542697, -0.0909667, 0.127003, 0.0652816, 0.640188, 0.76544,
	0.602668, -0.0683743, 0.1209, -0.0246615, 0.640374, 0.767667,
	0.645169, -0.0365061, 0.111908, -0.140968, 0.61611, 0.774943,
	0.674471, 0.00237987, 0.100988, -0.255131, 0.568585, 0.782061,
	0.69484, 0.0460205, 0.0891048, -0.330963, 0.514993, 0.790725,
	0.710547, 0.0921579, 0.0772215, -0.350481, 0.47948, 0.804526,
	0.72586, 0.138529, 0.0663018, -0.318696, 0.474909, 0.820302,
	0.745047, 0.182876, 0.0573091, -0.245631, 0.500736, 0.830017,
	0.772379, 0.222937, 0.0512069, -0.1343, 0.550543, 0.823933,
	0.812123, 0.25645, 0.0489587, 0.0431187, 0.615241, 0.787159,
	0.460989, -0.136898, 0.147715, 0.224614, 0.417261, 0.880592,
	0.547973, -0.122641, 0.145146, 0.124405, 0.413257, 0.902077,
	0.611393, -0.096276, 0.138172, 0.10606, 0.42514, 0.898892,
	0.655975, -0.0602537, 0.127894, 0.0708959, 0.431276, 0.89943,
	0.686443, -0.0170245, 0.115415, 0.0242707, 0.42894, 0.903007,
	0.707523, 0.0309605, 0.101834, -0.0206568, 0.417651, 0.908373,
	0.723939, 0.0812509, 0.0882532, -0.0508271, 0.404054, 0.913322,
	0.740419, 0.131396, 0.0757735, -0.056778, 0.398414, 0.915447,
	0.761687, 0.178944, 0.0654961, -0.0294421, 0.407891, 0.912556,
	0.792469, 0.221446, 0.0585221, 0.0403847, 0.433822, 0.900093,
	0.837488, 0.25645, 0.0559528, 0.179891, 0.496755, 0.849043,
	0.460989, -0.174852, 0.15387, 0.271109, 0.205962, 0.940255,
	0.553715, -0.15711, 0.151193, 0.203546, 0.155347, 0.966662,
	0.620889, -0.12664, 0.143929, 0.258175, 0.180663, 0.949056,
	0.667734, -0.0860976, 0.133224, 0.300795, 0.217764, 0.928494,
	0.699472, -0.0381411, 0.120224, 0.316611, 0.256373, 0.913253,
	0.721324, 0.0145713, 0.106077, 0.299062, 0.283627, 0.911108,
	0.738514, 0.0693814, 0.0919304, 0.254695, 0.293626, 0.921365,
	0.756264, 0.123632, 0.0789307, 0.205853, 0.291998, 0.934003,
	0.779795, 0.174666, 0.0682251, 0.181135, 0.290115, 0.939693,
	0.81433, 0.219825, 0.0609605, 0.203475, 0.295458, 0.933436,
	0.865092, 0.25645, 0.0582841, 0.298156, 0.365113, 0.881927,
	0.460989, -0.212807, 0.147715, 0.33598, -0.0170088, 0.941716,
	0.559457, -0.191581, 0.145146, 0.295304, -0.111482, 0.948877,
	0.630385, -0.157003, 0.138172, 0.411154, -0.063525, 0.90935,
	0.679493, -0.111942, 0.127894, 0.508721, 0.01141, 0.860856,
	0.7125, -0.0592577, 0.115415, 0.561872, 0.0893851, 0.822381,
	0.735126, -0.00181909, 0.101834, 0.562568, 0.146295, 0.813705,
	0.753089, 0.057512, 0.0882532, 0.518173, 0.170814, 0.838045,
	0.772108, 0.115869, 0.0757735, 0.448829, 0.166745, 0.877923,
	0.797903, 0.170387, 0.0654961, 0.38617, 0.147135, 0.910617,
	0.836192, 0.218203, 0.0585221, 0.36372, 0.123457, 0.923291,
	0.892695, 0.25645, 0.0559528, 0.411579, 0.19687, 0.889857,
	0.460989, -0.247684, 0.129251, 0.416403, -0.236889, 0.877777,
	0.564732, -0.223255, 0.127003, 0.390142, -0.362972, 0.846192,
	0.63911, -0.184905, 0.1209, 0.548177, -0.278962, 0.788469,
	0.690299, -0.135689, 0.111908, 0.673479, -0.158794, 0.721949,
	0.724473, -0.0786621, 0.100988, 0.739777, -0.0438328, 0.671423,
	0.747809, -0.0168791, 0.0891048, 0.750789, 0.0327087, 0.659732,
	0.766482, 0.0466049, 0.0772215, 0.719753, 0.0591241, 0.691708,
	0.786667, 0.108735, 0.0663018, 0.657732, 0.0390915, 0.752237,
	0.814543, 0.166456, 0.0573091, 0.582222, -0.0146877, 0.812897,
	0.856281, 0.216712, 0.0512069, 0.523529, -0.0879994, 0.847451,
	0.91806, 0.25645, 0.0489587, 0.526974, -0.0341746, 0.849194,
	0.460989, -0.276407, 0.0984769, 0.506232, -0.428864, 0.748201,
	0.569077, -0.24934, 0.096764, 0.476668, -0.570303, 0.668986,
	0.646297, -0.207883, 0.0921147, 0.657779, -0.442264, 0.609696,
	0.699197, -0.155246, 0.0852631, 0.790889, -0.277611, 0.545368,
	0.734333, -0.0946422, 0.0769433, 0.856744, -0.132918, 0.498319,
	0.758253, -0.0292819, 0.0678894, 0.872624, -0.0454552, 0.486273,
	0.777511, 0.0376226, 0.0588355, 0.857943, -0.0251318, 0.513129,
	0.798658, 0.10286, 0.0505157, 0.817935, -0.0702071, 0.571011,
	0.828245, 0.163218, 0.0436641, 0.750766, -0.172484, 0.637652,
	0.872826, 0.215485, 0.0390148, 0.664241, -0.31445, 0.678163,
	0.938949, 0.25645, 0.0373019, 0.626918, -0.321146, 0.709816,
	0.460989, -0.295897, 0.0553932, 0.597094, -0.564233, 0.570193,
	0.572025, -0.267041, 0.0544297, 0.545716, -0.70913, 0.446462,
	0.651172, -0.223475, 0.0518145, 0.736411, -0.541158, 0.406014,
	0.705236, -0.168517, 0.0479605, 0.867147, -0.342069, 0.362001,
	0.741023, -0.105486, 0.0432806, 0.92733, -0.178261, 0.329063,
	0.765341, -0.0376985, 0.0381878, 0.944286, -0.0864397, 0.317573,
	0.784995, 0.0315275, 0.033095, 0.941217, -0.0739426, 0.329611,
	0.806794, 0.0988735, 0.0284151, 0.9211, -0.142154, 0.362447,
	0.837544, 0.161021, 0.024561, 0.867169, -0.289421, 0.405281,
	0.884052, 0.214652, 0.0219458, 0.756509, -0.491024, 0.431961,
	0.953124, 0.25645, 0.0209823, 0.677996, -0.565859, 0.469175,
	0.460989, -0.303077, -5.97216e-008, 0.676865, -0.641957, 0.360202,
	0.573112, -0.273562, -5.97313e-008, 0.592517, -0.778741, 0.206121,
	0.652969, -0.22922, -5.82042e-008, 0.787018, -0.584369, 0.197776,
	0.70746, -0.173406, -5.5546e-008, 0.912911, -0.364048, 0.184564,
	0.743488, -0.109481, -5.21339e-008, 0.966728, -0.190169, 0.171093,
	0.767952, -0.0407983, -4.83881e-008, 0.982185, -0.0970761, 0.160902,
	0.787753, 0.0292819, -4.47143e-008, 0.983917, -0.0895332, 0.154568,
	0.809792, 0.0974051, -4.14897e-008, 0.973455, -0.170862, 0.152286,
	0.84097, 0.160211, -3.91345e-008, 0.926048, -0.343576, 0.156174,
	0.888188, 0.214346, -3.80399e-008, 0.800498, -0.574987, 0.169092,
	0.958346, 0.25645, -3.85976e-008, 0.689814, -0.693275, 0.20863,
	0.460989, -0.295897, -0.0553932, 0.744295, -0.663149, 0.0791107,
	0.572025, -0.267041, -0.0544297, 0.613312, -0.786958, -0.0674171,
	0.651172, -0.223475, -0.0518145, 0.810513, -0.584673, -0.0350306,
	0.705236, -0.168517, -0.0479604, 0.934311, -0.356335, -0.00935065,
	0.741023, -0.105486, -0.0432806, 0.984053, -0.177872, 0.00127045,
	0.765341, -0.0376985, -0.0381877, 0.996551, -0.0827031, -0.00675599,
	0.784995, 0.0315275, -0.0330949, 0.996705, -0.0737821, -0.0336825,
	0.806794, 0.0988735, -0.028415, 0.985153, -0.154103, -0.0756633,
	0.837544, 0.161021, -0.024561, 0.937876, -0.327712, -0.113988,
	0.884052, 0.214652, -0.0219458, 0.817811, -0.565663, -0.10588,
	0.953124, 0.25645, -0.0209823, 0.694686, -0.717101, -0.0563708,
	0.460989, -0.276407, -0.0984768, 0.781967, -0.556028, -0.28171,
	0.569077, -0.24934, -0.0967639, 0.598295, -0.700872, -0.388357,
	0.646297, -0.207883, -0.0921146, 0.797008, -0.517737, -0.311009,
	0.699197, -0.155246, -0.085263, 0.922848, -0.301541, -0.239636,
	0.734333, -0.0946422, -0.0769432, 0.97138, -0.128564, -0.199729,
	0.758253, -0.0292819, -0.0678893, 0.978423, -0.0331195, -0.203942,
	0.777511, 0.0376226, -0.0588354, 0.967617, -0.0172807, -0.251831,
	0.798658, 0.10286, -0.0505156, 0.939874, -0.0813969, -0.331679,
	0.828245, 0.163218, -0.043664, 0.883832, -0.229065, -0.407886,
	0.872826, 0.215485, -0.0390147, 0.791637, -0.451309, -0.411863,
	0.938949, 0.25645, -0.0373018, 0.698946, -0.623424, -0.350454,
	0.460989, -0.247684, -0.129251, 0.742535, -0.255184, -0.619293,
	0.564732, -0.223255, -0.127003, 0.534688, -0.478778, -0.696333,
	0.63911, -0.184905, -0.1209, 0.726804, -0.345023, -0.593899,
	0.690299, -0.135689, -0.111908, 0.856751, -0.169737, -0.486998,
	0.724473, -0.0786621, -0.100988, 0.907153, -0.0208901, -0.420282,
	0.747809, -0.0168791, -0.0891047, 0.905333, 0.0665047, -0.419463,
	0.766482, 0.0466049, -0.0772215, 0.872114, 0.0890554, -0.481131,
	0.786667, 0.108735, -0.0663017, 0.813164, 0.0490765, -0.579961,
	0.814543, 0.166456, -0.057309, 0.739067, -0.0532415, -0.671525,
	0.856281, 0.216712, -0.0512068, 0.679139, -0.224138, -0.698951,
	0.91806, 0.25645, -0.0489586, 0.669831, -0.367609, -0.645128,
	0.460989, -0.212807, -0.147715, 0.61572, 0.156719, -0.772223,
	0.559457, -0.191581, -0.145146, 0.42292, -0.13821, -0.895565,
	0.630385, -0.157003, -0.138172, 0.583597, -0.0612135, -0.809733,
	0.679493, -0.111942, -0.127894, 0.707731, 0.0531978, -0.704476,
	0.7125, -0.0592577, -0.115415, 0.759812, 0.158658, -0.630487,
	0.735126, -0.00181909, -0.101834, 0.746542, 0.224242, -0.62641,
	0.753089, 0.057512, -0.0882531, 0.685651, 0.243142, -0.686123,
	0.772108, 0.115869, -0.0757734, 0.59725, 0.219158, -0.771532,
	0.797903, 0.170387, -0.065496, 0.513079, 0.159752, -0.843344,
	0.836192, 0.218203, -0.0585221, 0.474347, 0.0629109, -0.878087,
	0.892695, 0.25645, -0.0559527, 0.543266, 0.0222434, -0.839266,
	0.460989, -0.174852, -0.15387, 0.468581, 0.517799, -0.715762,
	0.553715, -0.15711, -0.151194, 0.29081, 0.240867, -0.925966,
	0.620889, -0.12664, -0.143929, 0.382262, 0.285449, -0.87886,
	0.667734, -0.0860976, -0.133223, 0.462662, 0.349331, -0.814808,
	0.699472, -0.0381411, -0.120224, 0.495711, 0.406695, -0.767379,
	0.721324, 0.0145713, -0.106077, 0.466682, 0.435282, -0.769895,
	0.738514, 0.0693814, -0.0919304, 0.390942, 0.429068, -0.814288,
	0.756264, 0.123632, -0.0789307, 0.304748, 0.399085, -0.864789,
	0.779795, 0.174666, -0.068225, 0.243031, 0.362501, -0.899738,
	0.81433, 0.219825, -0.0609605, 0.229375, 0.326554, -0.916924,
	0.865092, 0.25645, -0.0582841, 0.331701, 0.383705, -0.861826,
	0.460989, -0.136898, -0.147715, 0.354354, 0.765034, -0.537733,
	0.547973, -0.122641, -0.145146, 0.172752, 0.574358, -0.800168,
	0.611393, -0.096276, -0.138172, 0.171477, 0.607921, -0.775259,
	0.655975, -0.0602537, -0.127894, 0.159999, 0.643776, -0.7483,
	0.686443, -0.0170245, -0.115415, 0.124998, 0.663812, -0.73738,
	0.707523, 0.0309605, -0.101834, 0.0645704, 0.649601, -0.757528,
	0.723939, 0.0812509, -0.0882531, 0.000942189, 0.60423, -0.796809,
	0.740419, 0.131396, -0.0757734, -0.0376821, 0.555592, -0.830601,
	0.761687, 0.178944, -0.065496, -0.0417186, 0.52819, -0.848101,
	0.792469, 0.221446, -0.0585221, -0.0120397, 0.530726, -0.847458,
	0.837488, 0.25645, -0.0559527, 0.109821, 0.630086, -0.768721,
	0.460989, -0.102021, -0.129251, 0.282892, 0.907582, -0.310269,
	0.542697, -0.0909655, -0.127003, 0.0894668, 0.815194, -0.572237,
	0.602668, -0.0683743, -0.1209, 0.00289807, 0.837319, -0.546707,
	0.645169, -0.0365061, -0.111908, -0.108938, 0.844915, -0.523691,
	0.674471, 0.00237987, -0.100988, -0.234851, 0.823302, -0.516738,
	0.69484, 0.0460205, -0.0891047, -0.341996, 0.768042, -0.541434,
	0.710547, 0.0921579, -0.0772215, -0.393569, 0.700836, -0.594922,
	0.72586, 0.13853, -0.0663017, -0.380989, 0.65414, -0.653413,
	0.745047, 0.182876, -0.057309, -0.322893, 0.645575, -0.692079,
	0.772379, 0.222937, -0.0512068, -0.238843, 0.679065, -0.694136,
	0.812123, 0.25645, -0.0489586, -0.0919727, 0.787312, -0.609656,
	0.460989, -0.0732981, -0.0984768, 0.246301, 0.966157, -0.0766595,
	0.538353, -0.0648803, -0.0967639, 0.0452797, 0.951935, -0.302935,
	0.595482, -0.0453963, -0.0921146, -0.0992138, 0.957218, -0.271826,
	0.636271, -0.0169475, -0.085263, -0.278654, 0.929721, -0.240772,
	0.664611, 0.0183599, -0.0769432, -0.462116, 0.858718, -0.22148,
	0.684395, 0.0584246, -0.0678893, -0.599938, 0.765311, -0.233182,
	0.699518, 0.10114, -0.0588354, -0.661386, 0.694076, -0.284302,
	0.713869, 0.144405, -0.0505156, -0.645069, 0.673518, -0.360916,
	0.731345, 0.186114, -0.043664, -0.56415, 0.704668, -0.430322,
	0.755835, 0.224164, -0.0390147, -0.437717, 0.775958, -0.454194,
	0.791234, 0.25645, -0.0373018, -0.26138, 0.884241, -0.387037,
	0.460989, -0.0538079, -0.0553932, 0.232646, 0.963327, 0.133702,
	0.535405, -0.0471806, -0.0544297, 0.0327232, 0.998544, -0.0428916,
	0.590606, -0.0298042, -0.0518145, -0.139434, 0.990157, -0.0121656,
	0.630232, -0.00367672, -0.0479604, -0.34943, 0.936758, 0.0195599,
	0.65792, 0.0292036, -0.0432806, -0.553785, 0.831627, 0.0414644,
	0.677308, 0.0668399, -0.0381877, -0.699483, 0.713525, 0.0400728,
	0.692034, 0.107235, -0.0330949, -0.769306, 0.638787, 0.0109001,
	0.705733, 0.148392, -0.028415, -0.770115, 0.636596, -0.0408424,
	0.722045, 0.188311, -0.024561, -0.702543, 0.704579, -0.100012,
	0.744608, 0.224996, -0.0219458, -0.563266, 0.814792, -0.13728,
	0.777059, 0.25645, -0.0209823, -0.363427, 0.926051, -0.101738,
	0.786574, 0.262793, 0.0207473, -0.0202654, 0.874936, 0.483815,
	0.781101, 0.262744, -1.10795e-008, -0.110516, 0.952903, 0.28242,
	0.795575, 0.267735, 0.0201094, 0.0549578, 0.886401, 0.459644,
	0.789991, 0.267641, -1.12959e-008, -0.0223403, 0.956912, 0.289517,
	0.803708, 0.271271, 0.0191694, 0.136842, 0.890767, 0.433369,
	0.798135, 0.271137, -1.14545e-008, 0.0746997, 0.950806, 0.300647,
	0.810616, 0.2734, 0.018028, 0.236265, 0.884256, 0.402828,
	0.80516, 0.273236, -1.15409e-008, 0.193521, 0.928074, 0.318166,
	0.815943, 0.274119, 0.0167858, 0.37225, 0.854588, 0.362089,
	0.810693, 0.273935, -1.15698e-008, 0.353994, 0.869554, 0.344331,
	0.819332, 0.273424, 0.0155437, 0.574947, 0.762839, 0.295826,
	0.814361, 0.273236, -1.15409e-008, 0.576966, 0.725224, 0.375713,
	0.82043, 0.271312, 0.0144023, 0.847602, 0.502879, 0.169361,
	0.815791, 0.271137, -1.14545e-008, 0.825837, 0.411921, 0.385116,
	0.818879, 0.267781, 0.0134623, 0.999764, 0.0178138, -0.0124688,
	0.81461, 0.267641, -1.12959e-008, 0.941317, -0.0203897, 0.336909,
	0.814322, 0.262829, 0.0128244, 0.917541, -0.379904, -0.117434,
	0.810445, 0.262744, -1.10795e-008, 0.897981, -0.345919, 0.271975,
	0.806404, 0.25645, 0.0125894, 0.963708, -0.210077, 0.164726,
	0.802922, 0.25645, -1.08055e-008, 0.880962, -0.127934, 0.455565,
	0.80143, 0.262924, 0.0368841, 0.110483, 0.770466, 0.627834,
	0.810733, 0.26799, 0.0357501, 0.169653, 0.793344, 0.584656,
	0.818834, 0.271634, 0.034079, 0.231937, 0.811503, 0.536347,
	0.825424, 0.273846, 0.0320498, 0.304888, 0.823589, 0.478273,
	0.830191, 0.274617, 0.0298415, 0.401504, 0.82384, 0.400104,
	0.832827, 0.273935, 0.0276332, 0.545197, 0.790998, 0.277637,
	0.833021, 0.271787, 0.025604, 0.760449, 0.646923, 0.0566401,
	0.830463, 0.268164, 0.0239329, 0.932037, 0.231544, -0.278738,
	0.824844, 0.263056, 0.0227989, 0.845006, -0.250951, -0.472216,
	0.815853, 0.25645, 0.0223811, 0.974371, -0.15639, -0.161686,
	0.823322, 0.263118, 0.0484103, 0.23505, 0.667083, 0.706931,
	0.833069, 0.268366, 0.046922, 0.275136, 0.704822, 0.653855,
	0.841125, 0.272169, 0.0447287, 0.316145, 0.73893, 0.595008,
	0.847245, 0.274505, 0.0420653, 0.363107, 0.769802, 0.524937,
	0.851189, 0.275352, 0.0391669, 0.424082, 0.79582, 0.432233,
	0.852714, 0.274686, 0.0362686, 0.513369, 0.807362, 0.290895,
	0.851577, 0.272486, 0.0336052, 0.64988, 0.759037, 0.0389746,
	0.847538, 0.268729, 0.0314119, 0.779818, 0.48935, -0.390411,
	0.840352, 0.263391, 0.0299236, 0.701512, -0.00760607, -0.712617,
	0.829779, 0.25645, 0.0293752, 0.904708, 0.0430392, -0.423852,
	0.849906, 0.263355, 0.0553261, 0.329076, 0.575634, 0.748568,
	0.860194, 0.268822, 0.0536251, 0.351703, 0.630817, 0.691646,
	0.868193, 0.272818, 0.0511185, 0.374234, 0.682357, 0.627964,
	0.873743, 0.275304, 0.0480746, 0.399858, 0.732019, 0.551599,
	0.876686, 0.276244, 0.0447622, 0.433139, 0.780772, 0.450316,
	0.876862, 0.2756, 0.0414498, 0.481091, 0.824973, 0.296601,
	0.874109, 0.273335, 0.038406, 0.548868, 0.835479, 0.0268201,
	0.868269, 0.269414, 0.0358993, 0.591702, 0.678426, -0.435461,
	0.859182, 0.263797, 0.0341983, 0.496386, 0.257946, -0.828894,
	0.84669, 0.25645, 0.0335717, 0.740919, 0.295648, -0.603019,
	0.878835, 0.263611, 0.0576314, 0.405442, 0.480458, 0.777674,
	0.889711, 0.269319, 0.0558595, 0.412989, 0.557342, 0.720285,
	0.897649, 0.273524, 0.0532484, 0.419148, 0.630285, 0.653495,
	0.90258, 0.276173, 0.0500777, 0.425407, 0.702354, 0.570726,
	0.904434, 0.277214, 0.0466273, 0.43295, 0.776264, 0.458223,
	0.90314, 0.276593, 0.0431769, 0.441202, 0.850683, 0.285797,
	0.898629, 0.274259, 0.0400062, 0.438984, 0.898458, -0.00810074,
	0.89083, 0.270159, 0.0373951, 0.381408, 0.801243, -0.461018,
	0.879674, 0.26424, 0.0356233, 0.266124, 0.496378, -0.826309,
	0.865092, 0.25645, 0.0349705, 0.49863, 0.535076, -0.681954,
	0.907765, 0.263867, 0.0553261, 0.481181, 0.355301, 0.80139,
	0.919228, 0.269817, 0.0536251, 0.475608, 0.462808, 0.748068,
	0.927106, 0.274231, 0.0511185, 0.465318, 0.567235, 0.679503,
	0.931417, 0.277043, 0.0480746, 0.44964, 0.672311, 0.588066,
	0.93218, 0.278185, 0.0447622, 0.425277, 0.780974, 0.457405,
	0.929418, 0.277587, 0.0414498, 0.382462, 0.887917, 0.25559,
	0.923148, 0.275183, 0.038406, 0.299688, 0.952207, -0.0590714,
	0.913391, 0.270903, 0.0358993, 0.17018, 0.880192, -0.443058,
	0.900167, 0.264683, 0.0341983, 0.0687091, 0.697766, -0.713023,
	0.883494, 0.25645, 0.0335717, 0.259043, 0.737854, -0.623273,
	0.934349, 0.264102, 0.0484103, 0.569754, 0.160756, 0.805939,
	0.946353, 0.270273, 0.046922, 0.556795, 0.31279, 0.769507,
	0.954174, 0.27488, 0.0447287, 0.529882, 0.469868, 0.706009,
	0.957915, 0.277841, 0.0420653, 0.483983, 0.632816, 0.604404,
	0.957679, 0.279076, 0.0391669, 0.4092, 0.796331, 0.445435,
	0.953566, 0.2785, 0.0362686, 0.292597, 0.933197, 0.20864,
	0.94568, 0.276031, 0.0336052, 0.140833, 0.98628, -0.0861243,
	0.934123, 0.271588, 0.0314119, 0.0084959, 0.937669, -0.347426,
	0.918997, 0.265089, 0.0299236, -0.0670895, 0.85162, -0.519849,
	0.900404, 0.25645, 0.0293752, 0.0925989, 0.895911, -0.434475,
	0.956241, 0.264296, 0.0368841, 0.663824, -0.138787, 0.734899,
	0.968689, 0.270648, 0.0357501, 0.666401, 0.0570106, 0.743411,
	0.976465, 0.275414, 0.034079, 0.635956, 0.297117, 0.712237,
	0.979737, 0.2785, 0.0320498, 0.54806, 0.570959, 0.611258,
	0.978676, 0.279811, 0.0298415, 0.386347, 0.821703, 0.418976,
	0.973452, 0.279252, 0.0276332, 0.186616, 0.966752, 0.174829,
	0.964235, 0.276731, 0.025604, 0.0209815, 0.998989, -0.0397492,
	0.951197, 0.272153, 0.0239329, -0.0845458, 0.977642, -0.192529,
	0.934504, 0.265424, 0.0227989, -0.145927, 0.946709, -0.287136,
	0.91433, 0.25645, 0.0223811, 0.0032164, 0.983133, -0.182862,
	0.971096, 0.264428, 0.0207473, 0.714551, -0.455767, 0.530747,
	0.983847, 0.270903, 0.0201094, 0.763744, -0.269987, 0.586346,
	0.991591, 0.275777, 0.0191694, 0.777811, 0.0395458, 0.627252,
	0.994544, 0.278947, 0.018028, 0.659541, 0.481049, 0.577579,
	0.992924, 0.280308, 0.0167858, 0.38279, 0.836286, 0.392553,
	0.986947, 0.279763, 0.0155437, 0.129991, 0.97114, 0.199974,
	0.976827, 0.277205, 0.0144023, -0.0273361, 0.997266, 0.0686544,
	0.962782, 0.272536, 0.0134623, -0.118574, 0.992892, -0.0102373,
	0.945027, 0.265651, 0.0128244, -0.173249, 0.983552, -0.0510817,
	0.92378, 0.25645, 0.0125894, -0.0312556, 0.998376, 0.0476335,
	0.97657, 0.264476, -3.86307e-008, 0.717125, -0.644052, 0.266324,
	0.989431, 0.270998, -3.80741e-008, 0.807253, -0.492419, 0.325372,
	0.997164, 0.275912, -3.70473e-008, 0.893152, -0.161627, 0.419711,
	1, 0.279111, -3.56699e-008, 0.776245, 0.419609, 0.470502,
	0.998174, 0.280492, -3.409e-008, 0.411737, 0.83077, 0.374559,
	0.991918, 0.27995, -3.24274e-008, 0.141536, 0.952106, 0.271039,
	0.981466, 0.27738, -3.08011e-008, -0.00828077, 0.977589, 0.210361,
	0.96705, 0.272676, -2.93454e-008, -0.0950353, 0.979172, 0.179416,
	0.948904, 0.265735, -2.8194e-008, -0.151259, 0.974651, 0.164855,
	0.927262, 0.25645, -2.74808e-008, -0.0139417, 0.969194, 0.245904,
	0.971096, 0.264428, -0.0207473, 0.719926, -0.69396, -0.0111741,
	0.983847, 0.270903, -0.0201094, 0.848325, -0.527818, 0.0418501,
	0.991591, 0.275777, -0.0191694, 0.97604, -0.130292, 0.174268,
	0.994544, 0.278947, -0.018028, 0.808526, 0.488429, 0.328211,
	0.992924, 0.280308, -0.0167858, 0.443528, 0.817564, 0.367249,
	0.986947, 0.279763, -0.0155437, 0.208108, 0.907124, 0.365811,
	0.976827, 0.277205, -0.0144022, 0.0742852, 0.927365, 0.366709,
	0.962782, 0.272536, -0.0134622, -0.010472, 0.928167, 0.372017,
	0.945027, 0.265651, -0.0128243, -0.072053, 0.922916, 0.378198,
	0.92378, 0.25645, -0.0125893, 0.0637266, 0.901024, 0.429062,
	0.956241, 0.264296, -0.036884, 0.744346, -0.598082, -0.297064,
	0.968689, 0.270648, -0.0357501, 0.914875, -0.334569, -0.225982,
	0.976465, 0.275414, -0.0340789, 0.980917, 0.19422, -0.00891247,
	0.979737, 0.2785, -0.0320497, 0.720064, 0.649698, 0.243723,
	0.978676, 0.279811, -0.0298414, 0.455771, 0.805292, 0.379179,
	0.973452, 0.279252, -0.0276332, 0.2947, 0.841416, 0.452959,
	0.964235, 0.276731, -0.025604, 0.193036, 0.841768, 0.504146,
	0.951197, 0.272153, -0.0239328, 0.119882, 0.830174, 0.544462,
	0.934504, 0.265424, -0.0227989, 0.0589852, 0.815214, 0.576148,
	0.91433, 0.25645, -0.0223811, 0.18522, 0.788231, 0.586844,
	0.934349, 0.264102, -0.0484103, 0.771111, -0.287585, -0.568052,
	0.946353, 0.270273, -0.046922, 0.910732, 0.160654, -0.380469,
	0.954174, 0.27488, -0.0447286, 0.804539, 0.593488, -0.0221158,
	0.957915, 0.277841, -0.0420653, 0.60157, 0.759968, 0.246095,
	0.957679, 0.279076, -0.0391669, 0.456314, 0.793105, 0.403438,
	0.953566, 0.2785, -0.0362686, 0.361243, 0.782353, 0.507372,
	0.94568, 0.276031, -0.0336052, 0.29421, 0.754873, 0.586179,
	0.934123, 0.271588, -0.0314119, 0.240954, 0.71973, 0.651099,
	0.918997, 0.265089, -0.0299235, 0.192075, 0.681805, 0.705868,
	0.900404, 0.25645, -0.0293752, 0.299462, 0.668261, 0.680992,
	0.907765, 0.263867, -0.0553261, 0.694774, 0.236346, -0.679286,
	0.919228, 0.269817, -0.0536251, 0.718452, 0.618375, -0.318495,
	0.927106, 0.274231, -0.0511184, 0.621817, 0.78245, 0.0334112,
	0.931417, 0.277043, -0.0480746, 0.523648, 0.80929, 0.266163,
	0.93218, 0.278185, -0.0447622, 0.451856, 0.786476, 0.421048,
	0.929418, 0.277587, -0.0414498, 0.400358, 0.743827, 0.535197,
	0.923148, 0.275183, -0.0384059, 0.361161, 0.689968, 0.627301,
	0.913391, 0.270903, -0.0358993, 0.328042, 0.627992, 0.705701,
	0.900167, 0.264683, -0.0341983, 0.29561, 0.560293, 0.773749,
	0.883494, 0.25645, -0.0335716, 0.382487, 0.570209, 0.727026,
	0.878835, 0.263611, -0.0576313, 0.495909, 0.652199, -0.573333,
	0.889711, 0.269319, -0.0558595, 0.519569, 0.826698, -0.215913,
	0.897649, 0.273524, -0.0532483, 0.498138, 0.86411, 0.0719201,
	0.90258, 0.276173, -0.0500777, 0.468823, 0.838533, 0.277609,
	0.904434, 0.277214, -0.0466273, 0.44344, 0.786535, 0.429795,
	0.90314, 0.276593, -0.0431769, 0.423331, 0.719901, 0.550031,
	0.898629, 0.274259, -0.0400062, 0.407084, 0.641598, 0.650104,
	0.89083, 0.270159, -0.0373951, 0.392378, 0.552226, 0.735585,
	0.879674, 0.26424, -0.0356232, 0.376251, 0.452819, 0.808326,
	0.865092, 0.25645, -0.0349705, 0.444195, 0.489514, 0.750377,
	0.849906, 0.263355, -0.0553261, 0.292985, 0.852955, -0.432004,
	0.860194, 0.268822, -0.0536251, 0.358994, 0.921101, -0.150652,
	0.868193, 0.272818, -0.0511184, 0.396103, 0.91415, 0.0862139,
	0.873743, 0.275304, -0.0480746, 0.416987, 0.866006, 0.275963,
	0.876686, 0.276244, -0.0447622, 0.429971, 0.79395, 0.429847,
	0.876862, 0.2756, -0.0414498, 0.439083, 0.70439, 0.557711,
	0.874109, 0.273335, -0.0384059, 0.445739, 0.599084, 0.665143,
	0.868269, 0.269414, -0.0358993, 0.449674, 0.478626, 0.754129,
	0.859182, 0.263797, -0.0341983, 0.449379, 0.344521, 0.824235,
	0.84669, 0.25645, -0.0335716, 0.498123, 0.412008, 0.762969,
	0.823322, 0.263118, -0.0484103, 0.109506, 0.945604, -0.306335,
	0.833069, 0.268366, -0.046922, 0.205645, 0.973099, -0.103869,
	0.841125, 0.272169, -0.0447286, 0.285935, 0.954334, 0.0865364,
	0.847245, 0.274505, -0.0420653, 0.352913, 0.898495, 0.261075,
	0.851189, 0.275352, -0.0391669, 0.409031, 0.810786, 0.418712,
	0.852714, 0.274686, -0.0362686, 0.455443, 0.694165, 0.55741,
	0.851577, 0.272486, -0.0336052, 0.492117, 0.551856, 0.673258,
	0.847538, 0.268729, -0.0314119, 0.518353, 0.388907, 0.761618,
	0.840352, 0.263391, -0.0299235, 0.53319, 0.212774, 0.818801,
	0.829779, 0.25645, -0.0293752, 0.558206, 0.320302, 0.765384,
	0.801429, 0.262924, -0.036884, -0.0454667, 0.986593, -0.156736,
	0.810733, 0.26799, -0.0357501, 0.0599324, 0.997709, -0.0313893,
	0.818834, 0.271634, -0.0340789, 0.164286, 0.981222, 0.101064,
	0.825424, 0.273846, -0.0320497, 0.270913, 0.931515, 0.242664,
	0.830191, 0.274617, -0.0298414, 0.379872, 0.837954, 0.39183,
	0.832827, 0.273935, -0.0276332, 0.484372, 0.690106, 0.537714,
	0.833021, 0.271787, -0.025604, 0.570681, 0.489806, 0.6591,
	0.830463, 0.268164, -0.0239328, 0.626141, 0.259456, 0.735275,
	0.824844, 0.263056, -0.0227989, 0.648608, 0.031331, 0.760477,
	0.815853, 0.25645, -0.0223811, 0.641742, 0.193506, 0.742107,
	0.786574, 0.262793, -0.0207473, -0.125467, 0.990879, 0.0491661,
	0.795575, 0.267735, -0.0201094, -0.0255758, 0.993947, 0.106845,
	0.803708, 0.271271, -0.0191694, 0.0811902, 0.981395, 0.173986,
	0.810616, 0.2734, -0.018028, 0.205056, 0.944648, 0.256108,
	0.815943, 0.274119, -0.0167858, 0.356613, 0.862865, 0.358179,
	0.819332, 0.273424, -0.0155437, 0.535011, 0.698683, 0.474979,
	0.82043, 0.271312, -0.0144022, 0.70061, 0.424851, 0.573278,
	0.818879, 0.267781, -0.0134622, 0.787998, 0.0963003, 0.608099,
	0.814322, 0.262829, -0.0128243, 0.791153, -0.182695, 0.583694,
	0.806404, 0.25645, -0.0125893, 0.757876, 0.0294314, 0.651734,
	-0.0674541, 0.489587, -2.09962e-008, 0.0244728, 0.999401, 0.0244727,
	-0.00773796, 0.486929, 0.00996207, 0.271486, 0.944769, 0.183597,
	-0.00696295, 0.486929, -2.08808e-008, 0.273971, 0.947122, 0.167034,
	0.0273061, 0.479515, 0.015808, 0.449734, 0.869179, 0.205591,
	0.028536, 0.479515, -2.05492e-008, 0.456567, 0.875103, 0.160438,
	0.0424652, 0.468185, 0.0183362, 0.7933, 0.535838, 0.289055,
	0.0438919, 0.468185, -2.00588e-008, 0.813488, 0.546925, 0.197764,
	0.0425264, 0.453777, 0.0183451, 0.947033, -0.037654, 0.318922,
	0.0439541, 0.453777, -1.94243e-008, 0.977757, -0.0357201, 0.206679,
	0.0322768, 0.43713, 0.0166329, 0.888188, -0.350219, 0.297438,
	0.0335717, 0.43713, -1.87033e-008, 0.915131, -0.354819, 0.191412,
	0.0165035, 0.419086, 0.0139982, 0.853653, -0.436838, 0.283634,
	0.0175941, 0.419086, -1.79101e-008, 0.878186, -0.442906, 0.180621,
	-6.4107e-006, 0.400481, 0.0112392, 0.874478, -0.395155, 0.281321,
	0.000870432, 0.400481, -1.71027e-008, 0.899619, -0.400789, 0.173358,
	-0.0124658, 0.382157, 0.00915441, 0.940908, -0.179617, 0.287105,
	-0.01175, 0.382157, -1.62951e-008, 0.968958, -0.182018, 0.167304,
	-0.0160879, 0.364951, 0.00854214, 0.912241, 0.302818, 0.275896,
	-0.015418, 0.364951, -1.55452e-008, 0.937828, 0.308395, 0.159284,
	-0.00608512, 0.349705, 0.0102008, 0.652685, 0.723843, 0.223726,
	-0.00528437, 0.349705, -1.48818e-008, 0.666002, 0.731684, 0.145189,
	-0.00998751, 0.486929, 0.0193571, 0.266328, 0.942991, 0.199595,
	0.0237363, 0.479515, 0.0307163, 0.435969, 0.864763, 0.24923,
	0.0383242, 0.468185, 0.0356291, 0.761221, 0.528098, 0.376372,
	0.0383826, 0.453777, 0.0356468, 0.904015, -0.0397431, 0.42565,
	0.0285186, 0.43713, 0.0323208, 0.848527, -0.348018, 0.398603,
	0.0133384, 0.419086, 0.0272025, 0.816208, -0.433263, 0.382213,
	-0.00255089, 0.400481, 0.0218434, 0.8358, -0.39178, 0.384638,
	-0.0145429, 0.382157, 0.0177947, 0.898256, -0.178689, 0.401505,
	-0.0180307, 0.364951, 0.016608, 0.872441, 0.298012, 0.387345,
	-0.00840778, 0.349705, 0.0198347, 0.628668, 0.717779, 0.299282,
	-0.0135981, 0.486929, 0.0280716, 0.258797, 0.941763, 0.214725,
	0.0180068, 0.479515, 0.0445449, 0.415836, 0.861723, 0.290713,
	0.0316778, 0.468185, 0.0516697, 0.717934, 0.523047, 0.45934,
	0.0317321, 0.453777, 0.0516959, 0.84893, -0.040911, 0.526919,
	0.0224867, 0.43713, 0.0468738, 0.797288, -0.346304, 0.494373,
	0.00825906, 0.419086, 0.0394528, 0.767238, -0.430639, 0.475285,
	-0.00663395, 0.400481, 0.0316833, 0.784971, -0.38936, 0.481891,
	-0.0178751, 0.382157, 0.025815, 0.842228, -0.178038, 0.508875,
	-0.0211471, 0.364951, 0.024098, 0.819207, 0.294728, 0.49197,
	-0.012133, 0.349705, 0.0287821, 0.594629, 0.713535, 0.37052,
	-0.0184563, 0.486929, 0.0359922, 0.249159, 0.94108, 0.228665,
	0.0102975, 0.479515, 0.0571135, 0.390012, 0.859998, 0.329081,
	0.0227349, 0.468185, 0.0662491, 0.664559, 0.520358, 0.536274,
	0.0227836, 0.453777, 0.0662835, 0.782758, -0.0413617, 0.62095,
	0.0143712, 0.43713, 0.060102, 0.735457, -0.34511, 0.583097,
	0.00142523, 0.419086, 0.0505891, 0.707784, -0.428946, 0.561291,
	-0.0121266, 0.400481, 0.0406301, 0.723123, -0.387831, 0.571559,
	-0.0223567, 0.382157, 0.0331095, 0.774063, -0.177606, 0.607687,
	-0.0253375, 0.364951, 0.0309126, 0.753818, 0.292832, 0.588225,
	-0.0171414, 0.349705, 0.0369239, 0.551582, 0.71101, 0.436145,
	-0.0244487, 0.486929, 0.0430053, 0.237665, 0.940934, 0.241162,
	0.000788367, 0.479515, 0.0682425, 0.359142, 0.859544, 0.363596,
	0.0117044, 0.468185, 0.0791585, 0.60214, 0.519829, 0.605974,
	0.0117464, 0.453777, 0.0792005, 0.706448, -0.0412203, 0.706563,
	0.00436164, 0.43713, 0.0718158, 0.663951, -0.344477, 0.663706,
	-0.00700274, 0.419086, 0.0604514, 0.638775, -0.428183, 0.639238,
	-0.0188997, 0.400481, 0.0485545, 0.65124, -0.387175, 0.652673,
	-0.0278818, 0.382157, 0.0395723, 0.694828, -0.177373, 0.69696,
	-0.0305022, 0.364951, 0.0369518, 0.677369, 0.292244, 0.675104,
	-0.0233136, 0.349705, 0.0441405, 0.500421, 0.710139, 0.49526,
	-0.0314619, 0.486929, 0.0489977, 0.224549, 0.941317, 0.251994,
	-0.0103405, 0.479515, 0.0777516, 0.323843, 0.860338, 0.393629,
	-0.00120504, 0.468185, 0.090189, 0.531635, 0.521379, 0.667479,
	-0.0011706, 0.453777, 0.0902378, 0.620854, -0.0405428, 0.782877,
	-0.00735213, 0.43713, 0.0818253, 0.583561, -0.344448, 0.7354,
	-0.016865, 0.419086, 0.0688794, 0.560984, -0.428382, 0.708368,
	-0.0268241, 0.400481, 0.0553275, 0.57011, -0.387404, 0.724495,
	-0.0343446, 0.382157, 0.0450973, 0.605359, -0.177355, 0.775942,
	-0.0365416, 0.364951, 0.0421165, 0.590728, 0.292926, 0.751821,
	-0.0305303, 0.349705, 0.0503127, 0.441902, 0.710892, 0.547133,
	-0.0393825, 0.486929, 0.0538559, 0.21007, 0.942221, 0.260942,
	-0.0229092, 0.479515, 0.0854609, 0.284787, 0.86238, 0.418565,
	-0.0157845, 0.468185, 0.0991319, 0.454051, 0.525019, 0.719856,
	-0.0157581, 0.453777, 0.0991862, 0.526844, -0.0393437, 0.849051,
	-0.0205804, 0.43713, 0.0899408, 0.495052, -0.345089, 0.797394,
	-0.0280012, 0.419086, 0.0757131, 0.475136, -0.429622, 0.7679,
	-0.0357708, 0.400481, 0.06082, 0.480449, -0.388591, 0.786235,
	-0.041639, 0.382157, 0.049579, 0.506397, -0.177601, 0.843813,
	-0.0433561, 0.364951, 0.0463069, 0.494688, 0.294859, 0.817522,
	-0.038672, 0.349705, 0.0553211, 0.376751, 0.713275, 0.591014,
	-0.0480971, 0.486929, 0.0574666, 0.194565, 0.94363, 0.267781,
	-0.0367378, 0.479515, 0.0911904, 0.242843, 0.86568, 0.43775,
	-0.031825, 0.468185, 0.105778, 0.370699, 0.530828, 0.762105,
	-0.0318073, 0.453777, 0.105837, 0.425545, -0.0376308, 0.904155,
	-0.0351333, 0.43713, 0.0959727, 0.399378, -0.34653, 0.848772,
	-0.0402516, 0.419086, 0.0807926, 0.382121, -0.432062, 0.816888,
	-0.0456108, 0.400481, 0.0649032, 0.383149, -0.390898, 0.836896,
	-0.0496594, 0.382157, 0.0529112, 0.398873, -0.178227, 0.89952,
	-0.0508461, 0.364951, 0.0494233, 0.390243, 0.29804, 0.871139,
	-0.0476195, 0.349705, 0.0590463, 0.305888, 0.717317, 0.626011,
	-0.057492, 0.486929, 0.059716, 0.178518, 0.945508, 0.272296,
	-0.0516461, 0.479515, 0.0947601, 0.199242, 0.870238, 0.450542,
	-0.0491179, 0.468185, 0.109919, 0.283453, 0.538925, 0.79323,
	-0.0491091, 0.453777, 0.109981, 0.318612, -0.0354451, 0.947222,
	-0.0508212, 0.43713, 0.0997308, 0.297943, -0.34902, 0.88849,
	-0.0534558, 0.419086, 0.0839576, 0.283259, -0.43599, 0.854211,
	-0.0562149, 0.400481, 0.0674477, 0.279545, -0.394609, 0.875293,
	-0.0582997, 0.382157, 0.0549881, 0.284241, -0.179449, 0.941809,
	-0.0589119, 0.364951, 0.0513663, 0.278956, 0.302456, 0.91143,
	-0.0572533, 0.349705, 0.061369, 0.230682, 0.723071, 0.651118,
	-0.0674541, 0.486929, 0.0604912, 0.162259, 0.947887, 0.274193,
	-0.0674541, 0.479515, 0.0959901, 0.154581, 0.875931, 0.457,
	-0.0674541, 0.468185, 0.111346, 0.192759, 0.547482, 0.814314,
	-0.0674541, 0.453777, 0.111408, 0.206092, -0.0357241, 0.97788,
	-0.0674541, 0.43713, 0.101026, 0.191262, -0.35483, 0.915158,
	-0.0674541, 0.419086, 0.0850482, 0.179557, -0.442993, 0.87836,
	-0.0674541, 0.400481, 0.0683246, 0.170958, -0.400961, 0.900002,
	-0.0674541, 0.382157, 0.0557041, 0.163984, -0.182121, 0.969506,
	-0.0674541, 0.364951, 0.0520361, 0.162455, 0.308235, 0.937337,
	-0.0674541, 0.349705, 0.0621697, 0.152603, 0.730858, 0.665251,
	-0.0774162, 0.486929, 0.059716, 0.145652, 0.950856, 0.273235,
	-0.0832621, 0.479515, 0.0947601, 0.108249, 0.882932, 0.456851,
	-0.0857903, 0.468185, 0.109919, 0.096572, 0.557118, 0.824799,
	-0.0857993, 0.453777, 0.109981, 0.0860824, -0.0395809, 0.995501,
	-0.0840871, 0.43713, 0.0997308, 0.0787289, -0.365683, 0.927404,
	-0.0814524, 0.419086, 0.0839576, 0.0711006, -0.454393, 0.887959,
	-0.0786933, 0.400481, 0.0674477, 0.0577453, -0.411099, 0.90976,
	-0.0766085, 0.382157, 0.0549881, 0.0383836, -0.187373, 0.981539,
	-0.0759963, 0.364951, 0.0513663, 0.0410915, 0.314783, 0.948274,
	-0.0776549, 0.349705, 0.061369, 0.0723151, 0.740724, 0.667906,
	-0.0868113, 0.486929, 0.0574666, 0.129208, 0.954288, 0.269518,
	-0.0981704, 0.479515, 0.0911904, 0.0615644, 0.891246, 0.449322,
	-0.103083, 0.468185, 0.105778, -0.00328791, 0.570009, 0.821632,
	-0.103101, 0.453777, 0.105837, -0.0398563, -0.0438825, 0.998241,
	-0.0997749, 0.43713, 0.0959727, -0.0377647, -0.379198, 0.924545,
	-0.0946566, 0.419086, 0.0807926, -0.040296, -0.468482, 0.882554,
	-0.0892974, 0.400481, 0.0649031, -0.058415, -0.423707, 0.903914,
	-0.0852488, 0.382157, 0.0529112, -0.0909802, -0.194299, 0.976714,
	-0.0840621, 0.364951, 0.0494233, -0.0837685, 0.322113, 0.942988,
	-0.0872887, 0.349705, 0.0590463, -0.00888884, 0.752231, 0.65884,
	-0.0955257, 0.486929, 0.0538559, 0.11359, 0.958014, 0.263262,
	-0.111999, 0.479515, 0.0854609, 0.0165172, 0.900497, 0.434547,
	-0.119124, 0.468185, 0.0991319, -0.103052, 0.585709, 0.803943,
	-0.11915, 0.453777, 0.0991862, -0.16794, -0.0474508, 0.984655,
	-0.114328, 0.43713, 0.0899408, -0.154745, -0.393596, 0.906166,
	-0.106907, 0.419086, 0.0757131, -0.151493, -0.483808, 0.861963,
	-0.0991374, 0.400481, 0.06082, -0.174484, -0.437541, 0.882107,
	-0.0932692, 0.382157, 0.049579, -0.220981, -0.201707, 0.954192,
	-0.0915521, 0.364951, 0.0463069, -0.208887, 0.331061, 0.920198,
	-0.0962362, 0.349705, 0.0553211, -0.088313, 0.765213, 0.637692,
	-0.103446, 0.486929, 0.0489977, 0.0992299, 0.961922, 0.254677,
	-0.124568, 0.479515, 0.0777516, -0.0255927, 0.910425, 0.412881,
	-0.133703, 0.468185, 0.090189, -0.200303, 0.60401, 0.771395,
	-0.133738, 0.453777, 0.0902378, -0.296092, -0.0504008, 0.953829,
	-0.127556, 0.43713, 0.0818253, -0.270157, -0.409007, 0.871624,
	-0.118043, 0.419086, 0.0688794, -0.260431, -0.500404, 0.825695,
	-0.108084, 0.400481, 0.0553275, -0.288321, -0.452571, 0.843831,
	-0.100564, 0.382157, 0.0450973, -0.349313, -0.209547, 0.913274,
	-0.0983666, 0.364951, 0.0421165, -0.331824, 0.341587, 0.879324,
	-0.104378, 0.349705, 0.0503127, -0.164027, 0.779419, 0.60465,
	-0.11046, 0.486929, 0.0430053, 0.086467, 0.965919, 0.243976,
	-0.135697, 0.479515, 0.0682425, -0.063672, 0.920824, 0.384746,
	-0.146613, 0.468185, 0.0791585, -0.292798, 0.624837, 0.723774,
	-0.146655, 0.453777, 0.0792005, -0.422471, -0.0527961, 0.904838,
	-0.13927, 0.43713, 0.0718158, -0.382128, -0.425584, 0.820278,
	-0.127905, 0.419086, 0.0604514, -0.365231, -0.518333, 0.773264,
	-0.116009, 0.400481, 0.0485545, -0.397982, -0.468812, 0.788559,
	-0.107026, 0.382157, 0.0395723, -0.473889, -0.217807, 0.853223,
	-0.104406, 0.364951, 0.0369518, -0.450346, 0.353696, 0.81981,
	-0.111595, 0.349705, 0.0441405, -0.234375, 0.794662, 0.559983,
	-0.116452, 0.486929, 0.0359922, 0.0756014, 0.969923, 0.231373,
	-0.145206, 0.479515, 0.0571135, -0.096689, 0.931508, 0.350633,
	-0.157643, 0.468185, 0.0662491, -0.378168, 0.648189, 0.660939,
	-0.157692, 0.453777, 0.0662835, -0.545175, -0.0546269, 0.836541,
	-0.149279, 0.43713, 0.060102, -0.488671, -0.443483, 0.751348,
	-0.136333, 0.419086, 0.0505891, -0.463876, -0.537659, 0.704089,
	-0.122782, 0.400481, 0.0406301, -0.501368, -0.486297, 0.715644,
	-0.112552, 0.382157, 0.0331095, -0.592477, -0.226493, 0.773092,
	-0.109571, 0.364951, 0.0309126, -0.562116, 0.36742, 0.740964,
	-0.117767, 0.349705, 0.0369239, -0.297748, 0.810767, 0.503988,
	-0.12131, 0.486929, 0.0280715, 0.0669447, 0.973846, 0.217121,
	-0.152915, 0.479515, 0.0445448, -0.123552, 0.942287, 0.311174,
	-0.166586, 0.468185, 0.0516697, -0.453609, 0.674083, 0.582968,
	-0.16664, 0.453777, 0.0516959, -0.661797, -0.0558336, 0.747601,
	-0.157395, 0.43713, 0.0468736, -0.587294, -0.462842, 0.663976,
	-0.143167, 0.419086, 0.0394528, -0.553879, -0.558413, 0.61757,
	-0.128274, 0.400481, 0.0316833, -0.595865, -0.505028, 0.624412,
	-0.117033, 0.382157, 0.025815, -0.702189, -0.235632, 0.671869,
	-0.113761, 0.364951, 0.024098, -0.664208, 0.382745, 0.642132,
	-0.122775, 0.349705, 0.0287821, -0.352351, 0.827523, 0.437099,
	-0.124921, 0.486929, 0.0193571, 0.0608483, 0.977583, 0.201566,
	-0.158645, 0.479515, 0.0307163, -0.143037, 0.952933, 0.26732,
	-0.173232, 0.468185, 0.0356291, -0.515658, 0.70246, 0.490557,
	-0.173291, 0.453777, 0.0356468, -0.769029, -0.0563098, 0.636728,
	-0.163427, 0.43713, 0.0323208, -0.674642, -0.483754, 0.55753,
	-0.148247, 0.419086, 0.0272025, -0.631944, -0.580542, 0.513438,
	-0.132357, 0.400481, 0.0218434, -0.678003, -0.524943, 0.514536,
	-0.120365, 0.382157, 0.0177947, -0.799131, -0.245244, 0.548858,
	-0.116878, 0.364951, 0.016608, -0.752787, 0.399541, 0.523143,
	-0.1265, 0.349705, 0.0198347, -0.396044, 0.84464, 0.360184,
	-0.12717, 0.486929, 0.00996206, 0.0577008, 0.981002, 0.185219,
	-0.162214, 0.479515, 0.015808, -0.153853, 0.963172, 0.220519,
	-0.177373, 0.468185, 0.0183362, -0.560251, 0.733106, 0.385584,
	-0.177435, 0.453777, 0.0183451, -0.862352, -0.0559824, 0.503204,
	-0.167185, 0.43713, 0.0166329, -0.7463, -0.506239, 0.432155,
	-0.151412, 0.419086, 0.0139982, -0.69386, -0.603857, 0.39232,
	-0.134902, 0.400481, 0.0112392, -0.743299, -0.545868, 0.386697,
	-0.122442, 0.382157, 0.0091544, -0.878163, -0.25537, 0.404494,
	-0.11882, 0.364951, 0.00854213, -0.823056, 0.417502, 0.38506,
	-0.128823, 0.349705, 0.0102008, -0.426388, 0.861748, 0.274923,
	-0.127945, 0.486929, -3.30544e-008, 0.0573428, 0.984041, 0.168448,
	-0.163444, 0.479515, -3.98589e-008, -0.157464, 0.972497, 0.171623,
	-0.1788, 0.468185, -4.24517e-008, -0.589505, 0.761919, 0.268258,
	-0.178862, 0.453777, -4.18317e-008, -0.937816, -0.0592887, 0.342032,
	-0.16848, 0.43713, -3.90263e-008, -0.797307, -0.531304, 0.286386,
	-0.152502, 0.419086, -3.50052e-008, -0.735008, -0.628401, 0.254706,
	-0.135779, 0.400481, -3.08249e-008, -0.786776, -0.567782, 0.242089,
	-0.123158, 0.382157, -2.74843e-008, -0.933523, -0.266429, 0.239896,
	-0.11949, 0.364951, -2.59816e-008, -0.870303, 0.435706, 0.229637,
	-0.129624, 0.349705, -2.73303e-008, -0.441738, 0.878205, 0.183369,
	-0.12717, 0.486929, -0.00996212, 0.0593546, 0.986728, 0.151147,
	-0.162214, 0.479515, -0.0158081, -0.155208, 0.98054, 0.120216,
	-0.177373, 0.468185, -0.0183363, -0.603268, 0.785819, 0.13622,
	-0.177435, 0.453777, -0.0183451, -0.986657, -0.0680172, 0.147924,
	-0.167185, 0.43713, -0.016633, -0.821099, -0.558, 0.120134,
	-0.151412, 0.419086, -0.0139982, -0.750201, -0.65326, 0.102222,
	-0.134902, 0.400481, -0.0112393, -0.803003, -0.590181, 0.0829027,
	-0.122442, 0.382157, -0.00915445, -0.958573, -0.279051, 0.0571678,
	-0.11882, 0.364951, -0.00854217, -0.890222, 0.451694, 0.058972,
	-0.128823, 0.349705, -0.0102008, -0.441926, 0.892807, 0.0871622,
	-0.124921, 0.486929, -0.0193571, 0.0639159, 0.988932, 0.133899,
	-0.158645, 0.479515, -0.0307164, -0.144972, 0.987084, 0.0681819,
	-0.173232, 0.468185, -0.0356291, -0.591976, 0.805942, -0.00465276,
	-0.173291, 0.453777, -0.0356469, -0.994599, -0.0768365, -0.0697814,
	-0.163427, 0.43713, -0.0323208, -0.810868, -0.582347, -0.057999,
	-0.148247, 0.419086, -0.0272026, -0.734918, -0.675661, -0.0581155,
	-0.132357, 0.400481, -0.0218434, -0.787405, -0.610661, -0.0841852,
	-0.120365, 0.382157, -0.0177948, -0.94679, -0.291478, -0.136489,
	-0.116878, 0.364951, -0.016608, -0.877205, 0.464662, -0.120836,
	-0.1265, 0.349705, -0.0198346, -0.425864, 0.904724, -0.0106894,
	-0.12131, 0.486929, -0.0280716, 0.0710917, 0.990531, 0.117446,
	-0.152915, 0.479515, -0.0445448, -0.12583, 0.991885, 0.0181932,
	-0.166586, 0.468185, -0.0516696, -0.550958, 0.821908, -0.144611,
	-0.16664, 0.453777, -0.051696, -0.951781, -0.0834158, -0.295221,
	-0.157395, 0.43713, -0.0468737, -0.762882, -0.601703, -0.236566,
	-0.143167, 0.419086, -0.0394529, -0.687145, -0.693325, -0.217101,
	-0.128274, 0.400481, -0.0316834, -0.737936, -0.626865, -0.249981,
	-0.117033, 0.382157, -0.0258151, -0.894504, -0.301394, -0.330189,
	-0.113761, 0.364951, -0.0240981, -0.827289, 0.475106, -0.299778,
	-0.122775, 0.349705, -0.0287821, -0.392435, 0.913715, -0.105452,
	-0.116452, 0.486929, -0.0359921, 0.0806866, 0.991478, 0.102279,
	-0.145206, 0.479515, -0.0571136, -0.0984409, 0.99475, -0.0279631,
	-0.157643, 0.468185, -0.066249, -0.481088, 0.832111, -0.275946,
	-0.157692, 0.453777, -0.0662836, -0.854117, -0.0872729, -0.512706,
	-0.149279, 0.43713, -0.0601019, -0.676864, -0.614216, -0.405702,
	-0.136333, 0.419086, -0.0505892, -0.607402, -0.704671, -0.366745,
	-0.122782, 0.400481, -0.0406301, -0.655031, -0.637264, -0.405992,
	-0.112552, 0.382157, -0.0331096, -0.801311, -0.307752, -0.513021,
	-0.109571, 0.364951, -0.0309125, -0.74067, 0.481918, -0.468148,
	-0.117767, 0.349705, -0.0369238, -0.34272, 0.9193, -0.193467,
	-0.11046, 0.486929, -0.0430054, 0.0924651, 0.99175, 0.0887793,
	-0.135697, 0.479515, -0.0682424, -0.0636827, 0.995593, -0.0688409,
	-0.146613, 0.468185, -0.0791585, -0.385384, 0.835567, -0.391545,
	-0.146655, 0.453777, -0.0792005, -0.704236, -0.0880378, -0.704486,
	-0.13927, 0.43713, -0.0718157, -0.555828, -0.618546, -0.555388,
	-0.127905, 0.419086, -0.0604513, -0.498546, -0.708618, -0.499312,
	-0.116009, 0.400481, -0.0485545, -0.541644, -0.640836, -0.544014,
	-0.107026, 0.382157, -0.0395723, -0.670443, -0.309852, -0.674165,
	-0.104406, 0.364951, -0.0369519, -0.620496, 0.484373, -0.616739,
	-0.111595, 0.349705, -0.0441405, -0.278403, 0.921232, -0.271706,
	-0.103446, 0.486929, -0.0489978, 0.106175, 0.991341, 0.0772711,
	-0.124568, 0.479515, -0.0777515, -0.0225575, 0.994403, -0.103217,
	-0.133703, 0.468185, -0.0901891, -0.268634, 0.831995, -0.485407,
	-0.133738, 0.453777, -0.0902377, -0.512331, -0.0856259, -0.854509,
	-0.127556, 0.43713, -0.0818253, -0.406006, -0.614157, -0.676735,
	-0.118043, 0.419086, -0.0688794, -0.365568, -0.70474, -0.60803,
	-0.108084, 0.400481, -0.0553276, -0.40301, -0.637192, -0.656939,
	-0.100564, 0.382157, -0.0450974, -0.508546, -0.307462, -0.804269,
	-0.0983666, 0.364951, -0.0421166, -0.472528, 0.482191, -0.737705,
	-0.104378, 0.349705, -0.0503127, -0.201556, 0.919436, -0.337656,
	-0.0955257, 0.486929, -0.053856, 0.121539, 0.99025, 0.0680723,
	-0.111999, 0.479515, -0.085461, 0.0237962, 0.991232, -0.12997,
	-0.119124, 0.468185, -0.099132, -0.136961, 0.821826, -0.553031,
	-0.11915, 0.453777, -0.0991862, -0.294389, -0.0803402, -0.952303,
	-0.114328, 0.43713, -0.0899409, -0.236224, -0.601458, -0.763182,
	-0.106907, 0.419086, -0.0757131, -0.215231, -0.693344, -0.687714,
	-0.0991374, 0.400481, -0.0608201, -0.246249, -0.626653, -0.73937,
	-0.0932692, 0.382157, -0.049579, -0.324981, -0.300867, -0.896586,
	-0.0915521, 0.364951, -0.046307, -0.304592, 0.475556, -0.82527,
	-0.0962362, 0.349705, -0.0553211, -0.114612, 0.914006, -0.389174,
	-0.0868111, 0.486929, -0.0574666, 0.138223, 0.988488, 0.061527,
	-0.0981704, 0.479515, -0.0911904, 0.0740117, 0.986209, -0.148033,
	-0.103083, 0.468185, -0.105778, 0.00264303, 0.806118, -0.59175,
	-0.103101, 0.453777, -0.105837, -0.0684496, -0.0728532, -0.994991,
	-0.0997749, 0.43713, -0.0959726, -0.0568788, -0.581783, -0.811353,
	-0.0946566, 0.419086, -0.0807925, -0.0555726, -0.675477, -0.735284,
	-0.0892974, 0.400481, -0.0649032, -0.0798058, -0.610248, -0.788181,
	-0.0852488, 0.382157, -0.0529113, -0.130741, -0.290864, -0.947789,
	-0.0840621, 0.364951, -0.0494234, -0.125852, 0.465083, -0.876276,
	-0.0872887, 0.349705, -0.0590463, -0.0204668, 0.905221, -0.424449,
	-0.0774162, 0.486929, -0.0597161, 0.155803, 0.986084, 0.0579997,
	-0.0832621, 0.479515, -0.0947602, 0.1264, 0.979561, -0.156471,
	-0.0857903, 0.468185, -0.109919, 0.142889, 0.786393, -0.600974,
	-0.0857991, 0.453777, -0.10998, 0.149275, -0.0640544, -0.986719,
	-0.084087, 0.43713, -0.0997309, 0.121368, -0.557217, -0.82145,
	-0.0814524, 0.419086, -0.0839576, 0.104786, -0.652874, -0.750183,
	-0.0786933, 0.400481, -0.0674477, 0.0872987, -0.589655, -0.802923,
	-0.0766085, 0.382157, -0.0549882, 0.0628802, -0.278678, -0.958324,
	-0.0759962, 0.364951, -0.0513663, 0.0541033, 0.451722, -0.890517,
	-0.0776549, 0.349705, -0.061369, 0.0774455, 0.893594, -0.442145,
	-0.0674541, 0.486929, -0.0604911, 0.173394, 0.983185, 0.0572928,
	-0.0674541, 0.479515, -0.09599, 0.178086, 0.971364, -0.157281,
	-0.0674541, 0.468185, -0.111346, 0.274962, 0.760423, -0.588347,
	-0.0674541, 0.453777, -0.111408, 0.342929, -0.0592681, -0.93749,
	-0.0674541, 0.43713, -0.101026, 0.2866, -0.531269, -0.797254,
	-0.0674541, 0.419086, -0.0850482, 0.256166, -0.62815, -0.734715,
	-0.0674541, 0.400481, -0.0683245, 0.245381, -0.567298, -0.786105,
	-0.0674541, 0.382157, -0.0557041, 0.244593, -0.266106, -0.932396,
	-0.0674541, 0.364951, -0.052036, 0.225275, 0.436162, -0.871214,
	-0.0674541, 0.349705, -0.0621697, 0.174549, 0.879637, -0.44246,
	-0.057492, 0.486929, -0.0597161, 0.19043, 0.97993, 0.0589456,
	-0.0516461, 0.479515, -0.0947602, 0.2275, 0.961804, -0.152242,
	-0.0491179, 0.468185, -0.109919, 0.393392, 0.729258, -0.559845,
	-0.0491089, 0.453777, -0.10998, 0.503325, -0.0594275, -0.862051,
	-0.0508211, 0.43713, -0.0997309, 0.430795, -0.507241, -0.746406,
	-0.0534558, 0.419086, -0.0839576, 0.392222, -0.604079, -0.693722,
	-0.0562149, 0.400481, -0.0674477, 0.388496, -0.5457, -0.742484,
	-0.0582997, 0.382157, -0.0549882, 0.407912, -0.255195, -0.876632,
	-0.0589119, 0.364951, -0.0513663, 0.381137, 0.418328, -0.824461,
	-0.0572533, 0.349705, -0.061369, 0.26695, 0.863694, -0.427516,
	-0.0480969, 0.486929, -0.0574666, 0.206662, 0.976375, 0.0631044,
	-0.0367378, 0.479515, -0.0911904, 0.274215, 0.951461, -0.13974,
	-0.031825, 0.468185, -0.105778, 0.498075, 0.698867, -0.513328,
	-0.0318073, 0.453777, -0.105837, 0.636343, -0.0594147, -0.769115,
	-0.0351333, 0.43713, -0.0959726, 0.555531, -0.485038, -0.67537,
	-0.0402516, 0.419086, -0.0807925, 0.512638, -0.581108, -0.632073,
	-0.0456108, 0.400481, -0.0649032, 0.515546, -0.525115, -0.677101,
	-0.0496594, 0.382157, -0.0529113, 0.551493, -0.245443, -0.797254,
	-0.0508461, 0.364951, -0.0494234, 0.519771, 0.399895, -0.754932,
	-0.0476195, 0.349705, -0.0590463, 0.352971, 0.846539, -0.398475,
	-0.0393825, 0.486929, -0.053856, 0.221756, 0.972601, 0.0698049,
	-0.0229092, 0.479515, -0.085461, 0.317377, 0.94076, -0.119344,
	-0.0157845, 0.468185, -0.099132, 0.589329, 0.671066, -0.449847,
	-0.0157581, 0.453777, -0.0991862, 0.747256, -0.0580175, -0.661999,
	-0.0205804, 0.43713, -0.0899409, 0.662344, -0.463966, -0.588248,
	-0.0280012, 0.419086, -0.0757131, 0.616935, -0.558989, -0.554006,
	-0.0357708, 0.400481, -0.0608201, 0.625302, -0.505235, -0.594756,
	-0.041639, 0.382157, -0.049579, 0.674109, -0.235846, -0.699967,
	-0.0433561, 0.364951, -0.046307, 0.639262, 0.382964, -0.666846,
	-0.038672, 0.349705, -0.0553211, 0.430623, 0.829281, -0.35617,
	-0.0314619, 0.486929, -0.0489978, 0.235376, 0.968702, 0.0788331,
	-0.0103405, 0.479515, -0.0777515, 0.355866, 0.929994, -0.0920318,
	-0.00120504, 0.468185, -0.0901891, 0.665745, 0.645985, -0.373478,
	-0.0011706, 0.453777, -0.0902377, 0.836417, -0.055717, -0.545253,
	-0.00735213, 0.43713, -0.0818253, 0.750443, -0.444151, -0.489454,
	-0.016865, 0.419086, -0.0688794, 0.703959, -0.537971, -0.463712,
	-0.0268241, 0.400481, -0.0553276, 0.716683, -0.48631, -0.499868,
	-0.0343446, 0.382157, -0.0450974, 0.775095, -0.226533, -0.58984,
	-0.0365416, 0.364951, -0.0421166, 0.738571, 0.367677, -0.56509,
	-0.0305303, 0.349705, -0.0503127, 0.498324, 0.812374, -0.302857,
	-0.0244487, 0.486929, -0.0430054, 0.247269, 0.964763, 0.0899489,
	0.000788367, 0.479515, -0.0682424, 0.388914, 0.919395, -0.0588088,
	0.0117044, 0.468185, -0.0791585, 0.726925, 0.623586, -0.287611,
	0.0117464, 0.453777, -0.0792005, 0.90492, -0.0527942, -0.422293,
	0.00436164, 0.43713, -0.0718157, 0.820084, -0.42564, -0.382483,
	-0.00700274, 0.419086, -0.0604513, 0.773648, -0.518213, -0.364587,
	-0.0188997, 0.400481, -0.0485545, 0.789755, -0.468494, -0.39598,
	-0.0278818, 0.382157, -0.0395723, 0.854979, -0.217591, -0.470813,
	-0.0305022, 0.364951, -0.0369519, 0.817886, 0.354053, -0.453552,
	-0.0233136, 0.349705, -0.0441405, 0.555234, 0.796133, -0.240597,
	-0.0184563, 0.486929, -0.0359921, 0.257225, 0.960856, 0.10291,
	0.0102975, 0.479515, -0.0571136, 0.415961, 0.909149, -0.0206235,
	0.0227349, 0.468185, -0.066249, 0.772956, 0.603769, -0.194944,
	0.0227836, 0.453777, -0.0662836, 0.954027, -0.0494053, -0.295621,
	0.0143712, 0.43713, -0.0601019, 0.871957, -0.408408, -0.269989,
	0.00142523, 0.419086, -0.0505892, 0.826439, -0.499786, -0.259253,
	-0.0121266, 0.400481, -0.0406301, 0.845062, -0.451872, -0.2858,
	-0.0223567, 0.382157, -0.0331096, 0.914715, -0.209073, -0.345811,
	-0.0253375, 0.364951, -0.0309125, 0.877873, 0.342037, -0.335187,
	-0.0171414, 0.349705, -0.0369238, 0.600917, 0.780771, -0.171158,
	-0.0135981, 0.486929, -0.0280716, 0.26505, 0.957053, 0.117464,
	0.0180068, 0.479515, -0.0445448, 0.436543, 0.899424, 0.0215921,
	0.0316779, 0.468185, -0.0516696, 0.804074, 0.586441, -0.0977336,
	0.0317321, 0.453777, -0.051696, 0.98486, -0.0456384, -0.167234,
	0.0224867, 0.43713, -0.0468737, 0.906778, -0.392426, -0.154126,
	0.00825906, 0.419086, -0.0394529, 0.862847, -0.482741, -0.149856,
	-0.00663395, 0.400481, -0.0316833, 0.883194, -0.436513, -0.171534,
	-0.0178751, 0.382157, -0.0258151, 0.955209, -0.201044, -0.217157,
	-0.0211471, 0.364951, -0.0240981, 0.919232, 0.331542, -0.212351,
	-0.012133, 0.349705, -0.0287821, 0.635075, 0.766448, -0.0961107,
	-0.00998751, 0.486929, -0.0193571, 0.270561, 0.953427, 0.13332,
	0.0237363, 0.479515, -0.0307163, 0.450249, 0.890399, 0.0668204,
	0.0383242, 0.468185, -0.0356291, 0.820567, 0.571547, 0.00187177,
	0.0383826, 0.453777, -0.0356469, 0.998373, -0.0415545, -0.0390442,
	0.0285186, 0.43713, -0.0323208, 0.92518, -0.377727, -0.0369307,
	0.0133384, 0.419086, -0.0272026, 0.883318, -0.467196, -0.0384384,
	-0.00255089, 0.400481, -0.0218434, 0.904656, -0.422545, -0.05526,
	-0.0145428, 0.382157, -0.0177947, 0.977209, -0.193621, -0.0870292,
	-0.0180307, 0.364951, -0.016608, 0.942549, 0.322471, -0.0872556,
	-0.00840778, 0.349705, -0.0198346, 0.657434, 0.75332, -0.0170319,
	-0.00773796, 0.486929, -0.00996211, 0.273606, 0.950056, 0.15011,
	0.0273061, 0.479515, -0.0158081, 0.456771, 0.882269, 0.113845,
	0.0424652, 0.468185, -0.0183363, 0.822877, 0.559066, 0.101583,
	0.0425264, 0.453777, -0.0183451, 0.995528, -0.0372534, 0.0868132,
	0.0322768, 0.43713, -0.016633, 0.927824, -0.364472, 0.0793848,
	0.0165035, 0.419086, -0.0139982, 0.888329, -0.453405, 0.0727715,
	-6.4107e-006, 0.400481, -0.0112392, 0.909956, -0.410233, 0.060736,
	-0.0124658, 0.382157, -0.00915443, 0.981453, -0.187002, 0.042192,
	-0.0160879, 0.364951, -0.00854216, 0.948432, 0.314732, 0.0376954,
	-0.00608512, 0.349705, -0.0102008, 0.667783, 0.741576, 0.0642711,
	0.0182783, 0.337022, 0.0142506, 0.437985, 0.878641, 0.190154,
	0.019397, 0.337022, -1.43242e-008, 0.444424, 0.884055, 0.144684,
	0.0525836, 0.326578, 0.0199528, 0.343983, 0.921703, 0.179276,
	0.0541499, 0.326578, -1.38676e-008, 0.348016, 0.925556, 0.149101,
	0.093885, 0.317812, 0.0268179, 0.300411, 0.93715, 0.177493,
	0.0959901, 0.317812, -1.3483e-008, 0.303455, 0.94014, 0.155089,
	0.139237, 0.310165, 0.0343563, 0.28461, 0.941269, 0.181688,
	0.141934, 0.310165, -1.31561e-008, 0.287327, 0.943842, 0.163111,
	0.185692, 0.303077, 0.0420784, 0.289095, 0.937941, 0.191549,
	0.188996, 0.303077, -1.28437e-008, 0.291929, 0.940446, 0.17418,
	0.230308, 0.29599, 0.0494943, 0.313702, 0.926352, 0.208479,
	0.234193, 0.29599, -1.25312e-008, 0.317079, 0.929168, 0.190022,
	0.270136, 0.288343, 0.0561147, 0.364469, 0.900817, 0.235991,
	0.274542, 0.288343, -1.22043e-008, 0.36898, 0.904522, 0.213759,
	0.302233, 0.279577, 0.0614497, 0.456258, 0.844283, 0.281096,
	0.307056, 0.279577, -1.18198e-008, 0.463054, 0.849997, 0.25117,
	0.323651, 0.269133, 0.0650098, 0.614462, 0.70496, 0.354215,
	0.328754, 0.269133, -1.13631e-008, 0.626613, 0.714745, 0.310639,
	0.331444, 0.25645, 0.0663053, 0.670644, 0.58087, 0.461332,
	0.336649, 0.25645, -1.08055e-008, 0.682808, 0.590099, 0.430763,
	0.0150336, 0.337022, 0.0277089, 0.424668, 0.874591, 0.233983,
	0.0480405, 0.326578, 0.0387965, 0.335082, 0.918886, 0.208252,
	0.0877787, 0.317812, 0.0521453, 0.293496, 0.935057, 0.198816,
	0.131414, 0.310165, 0.066803, 0.27843, 0.939584, 0.199146,
	0.176112, 0.303077, 0.0818179, 0.282797, 0.936432, 0.207653,
	0.219039, 0.29599, 0.0962376, 0.306507, 0.924786, 0.225443,
	0.257359, 0.288343, 0.10911, 0.355435, 0.898837, 0.256434,
	0.288241, 0.279577, 0.119484, 0.443924, 0.841129, 0.308922,
	0.308848, 0.269133, 0.126406, 0.595953, 0.698841, 0.395551,
	0.316347, 0.25645, 0.128925, 0.655745, 0.573625, 0.490869,
	0.00982946, 0.337022, 0.0402085, 0.405221, 0.871747, 0.275415,
	0.0407541, 0.326578, 0.0562978, 0.322035, 0.916912, 0.235725,
	0.0779845, 0.317812, 0.0756682, 0.283515, 0.933598, 0.219122,
	0.118867, 0.310165, 0.096938, 0.269755, 0.938417, 0.215883,
	0.160745, 0.303077, 0.118726, 0.274239, 0.935394, 0.223231,
	0.200964, 0.29599, 0.139651, 0.296979, 0.923708, 0.242005,
	0.236867, 0.288343, 0.15833, 0.343634, 0.897464, 0.276538,
	0.265801, 0.279577, 0.173384, 0.427838, 0.838928, 0.336384,
	0.285108, 0.269133, 0.183428, 0.57196, 0.694601, 0.436338,
	0.292133, 0.25645, 0.187084, 0.636673, 0.56835, 0.521177,
	0.00283276, 0.337022, 0.0515826, 0.380299, 0.870066, 0.313622,
	0.0309576, 0.326578, 0.072223, 0.3053, 0.915756, 0.261119,
	0.0648182, 0.317812, 0.0970728, 0.270814, 0.932754, 0.237968,
	0.101999, 0.310165, 0.124359, 0.258885, 0.937753, 0.231511,
	0.140086, 0.303077, 0.152311, 0.263698, 0.934811, 0.237889,
	0.176663, 0.29599, 0.179155, 0.28541, 0.923108, 0.257708,
	0.209316, 0.288343, 0.203118, 0.329396, 0.896696, 0.295694,
	0.23563, 0.279577, 0.22243, 0.408441, 0.837673, 0.3626,
	0.253189, 0.269133, 0.235316, 0.543149, 0.69218, 0.475264,
	0.259579, 0.25645, 0.240005, 0.614065, 0.565069, 0.551018,
	-0.00578981, 0.337022, 0.0616643, 0.35048, 0.869516, 0.348002,
	0.0188847, 0.326578, 0.0863388, 0.285288, 0.915399, 0.284,
	0.0485913, 0.317812, 0.116045, 0.255711, 0.932513, 0.255011,
	0.0812111, 0.310165, 0.148665, 0.246082, 0.937582, 0.245729,
	0.114626, 0.303077, 0.182079, 0.25142, 0.93468, 0.251321,
	0.146716, 0.29599, 0.21417, 0.272057, 0.922983, 0.27219,
	0.175362, 0.288343, 0.242816, 0.313038, 0.896531, 0.313432,
	0.198448, 0.279577, 0.265902, 0.386163, 0.837369, 0.3869,
	0.213853, 0.269133, 0.281307, 0.51018, 0.691528, 0.511376,
	0.219459, 0.25645, 0.286913, 0.588539, 0.563771, 0.579469,
	-0.0158715, 0.337022, 0.0702869, 0.316272, 0.870081, 0.378063,
	0.00476897, 0.326578, 0.0984117, 0.262362, 0.915829, 0.304012,
	0.0296187, 0.317812, 0.132272, 0.238493, 0.932865, 0.269969,
	0.0569052, 0.310165, 0.169454, 0.231598, 0.937896, 0.258288,
	0.0848568, 0.303077, 0.20754, 0.237652, 0.93499, 0.26328,
	0.1117, 0.29599, 0.244117, 0.257187, 0.923327, 0.285171,
	0.135664, 0.288343, 0.27677, 0.294885, 0.896965, 0.329389,
	0.154976, 0.279577, 0.303084, 0.361451, 0.838009, 0.408773,
	0.167862, 0.269133, 0.320643, 0.473685, 0.692635, 0.543948,
	0.172551, 0.25645, 0.327033, 0.560708, 0.564413, 0.605842,
	-0.0272455, 0.337022, 0.0772836, 0.278185, 0.871754, 0.403308,
	-0.0111563, 0.326578, 0.108208, 0.236909, 0.917036, 0.320809,
	0.00821404, 0.317812, 0.145439, 0.219479, 0.933796, 0.282585,
	0.0294841, 0.310165, 0.186321, 0.215722, 0.938678, 0.268975,
	0.0512721, 0.303077, 0.228199, 0.222686, 0.935722, 0.273562,
	0.0721965, 0.29599, 0.268418, 0.241135, 0.924114, 0.296426,
	0.090876, 0.288343, 0.304321, 0.275349, 0.897969, 0.343269,
	0.10593, 0.279577, 0.333255, 0.334851, 0.839568, 0.427785,
	0.115974, 0.269133, 0.352562, 0.434396, 0.695513, 0.57233,
	0.11963, 0.25645, 0.359587, 0.531211, 0.567019, 0.629527,
	-0.0397452, 0.337022, 0.0824877, 0.236869, 0.874532, 0.423187,
	-0.0286576, 0.326578, 0.115495, 0.209426, 0.919001, 0.334032,
	-0.0153089, 0.317812, 0.155233, 0.199094, 0.935277, 0.292606,
	-0.000651112, 0.310165, 0.198869, 0.198857, 0.939891, 0.277598,
	0.0143638, 0.303077, 0.243566, 0.206943, 0.93683, 0.282001,
	0.0287835, 0.29599, 0.286493, 0.224375, 0.925289, 0.305772,
	0.0416561, 0.288343, 0.324813, 0.255023, 0.899478, 0.354827,
	0.0520297, 0.279577, 0.355695, 0.307139, 0.841986, 0.443537,
	0.0589519, 0.269133, 0.376302, 0.393341, 0.700166, 0.59586,
	0.061471, 0.25645, 0.383801, 0.50089, 0.571625, 0.649888,
	-0.0532036, 0.337022, 0.0857325, 0.193286, 0.878398, 0.437101,
	-0.0475013, 0.326578, 0.120038, 0.180656, 0.92168, 0.343321,
	-0.0406362, 0.317812, 0.161339, 0.177969, 0.937252, 0.29981,
	-0.0330979, 0.310165, 0.206691, 0.181604, 0.941465, 0.284012,
	-0.0253758, 0.303077, 0.253146, 0.191049, 0.93823, 0.288488,
	-0.0179598, 0.29599, 0.297762, 0.207615, 0.926753, 0.31309,
	-0.0113395, 0.288343, 0.33759, 0.234757, 0.90138, 0.363871,
	-0.00600454, 0.279577, 0.369687, 0.279418, 0.845155, 0.455674,
	-0.00244445, 0.269133, 0.391105, 0.351994, 0.706571, 0.613887,
	-0.00114897, 0.25645, 0.398898, 0.470927, 0.578219, 0.666252,
	-0.0674541, 0.337022, 0.0868511, 0.148294, 0.883578, 0.444184,
	-0.0674541, 0.326578, 0.121604, 0.151, 0.925286, 0.347915,
	-0.0674541, 0.317812, 0.163444, 0.156146, 0.939981, 0.303404,
	-0.0674541, 0.310165, 0.209388, 0.163674, 0.943753, 0.2873,
	-0.0674542, 0.303077, 0.25645, 0.174392, 0.94041, 0.291918,
	-0.0674542, 0.29599, 0.301648, 0.189924, 0.929186, 0.317085,
	-0.0674542, 0.288343, 0.341996, 0.213324, 0.90461, 0.369016,
	-0.0674542, 0.279577, 0.37451, 0.250302, 0.850194, 0.463162,
	-0.0674542, 0.269133, 0.396208, 0.309191, 0.715099, 0.626924,
	-0.0674542, 0.25645, 0.404103, 0.441156, 0.586807, 0.678998,
	-0.0817046, 0.337022, 0.0857325, 0.102225, 0.890282, 0.443787,
	-0.0874069, 0.326578, 0.120038, 0.120397, 0.930066, 0.347104,
	-0.094272, 0.317812, 0.161339, 0.133207, 0.943783, 0.302537,
	-0.10181, 0.310165, 0.206691, 0.144295, 0.947183, 0.286398,
	-0.109532, 0.303077, 0.253146, 0.155808, 0.943966, 0.290952,
	-0.116948, 0.29599, 0.297762, 0.169679, 0.933429, 0.316099,
	-0.123569, 0.288343, 0.33759, 0.188556, 0.910371, 0.368335,
	-0.128904, 0.279577, 0.369687, 0.216951, 0.858801, 0.464104,
	-0.132464, 0.269133, 0.391105, 0.261269, 0.727652, 0.634241,
	-0.133759, 0.25645, 0.398898, 0.408597, 0.597556, 0.689909,
	-0.095163, 0.337022, 0.0824877, 0.0561495, 0.898143, 0.436104,
	-0.106251, 0.326578, 0.115495, 0.0897791, 0.93569, 0.341209,
	-0.119599, 0.317812, 0.155233, 0.110099, 0.948304, 0.297654,
	-0.134257, 0.310165, 0.198869, 0.124557, 0.951322, 0.281909,
	-0.149272, 0.303077, 0.243566, 0.136659, 0.948318, 0.286386,
	-0.163692, 0.29599, 0.286493, 0.14863, 0.938679, 0.311111,
	-0.176564, 0.288343, 0.324813, 0.162673, 0.917545, 0.362833,
	-0.186938, 0.279577, 0.355695, 0.181964, 0.869622, 0.458964,
	-0.19386, 0.269133, 0.376302, 0.210608, 0.743833, 0.634316,
	-0.196379, 0.25645, 0.383801, 0.37339, 0.610787, 0.698226,
	-0.107663, 0.337022, 0.0772836, 0.0118702, 0.906754, 0.421494,
	-0.123752, 0.326578, 0.108208, 0.0605932, 0.941766, 0.330765,
	-0.143122, 0.317812, 0.145439, 0.0882024, 0.953123, 0.289444,
	-0.164392, 0.310165, 0.186321, 0.105959, 0.95567, 0.274715,
	-0.18618, 0.303077, 0.228199, 0.118713, 0.952823, 0.279349,
	-0.207105, 0.29599, 0.268418, 0.128974, 0.944056, 0.303521,
	-0.225784, 0.288343, 0.304321, 0.138479, 0.924885, 0.354134,
	-0.240838, 0.279577, 0.333255, 0.148965, 0.880901, 0.449248,
	-0.250882, 0.269133, 0.352561, 0.161692, 0.761806, 0.627301,
	-0.254538, 0.25645, 0.359587, 0.339681, 0.626357, 0.701636,
	-0.119037, 0.337022, 0.0702869, -0.0294881, 0.915896, 0.40033,
	-0.139677, 0.326578, 0.0984117, 0.033593, 0.948133, 0.316094,
	-0.164527, 0.317812, 0.132272, 0.0680912, 0.958113, 0.278177,
	-0.191813, 0.310165, 0.169454, 0.088996, 0.960116, 0.265059,
	-0.219765, 0.303077, 0.20754, 0.102448, 0.957377, 0.270063,
	-0.246609, 0.29599, 0.244117, 0.11123, 0.949449, 0.293554,
	-0.270573, 0.288343, 0.27677, 0.116625, 0.932265, 0.342462,
	-0.289884, 0.279577, 0.303084, 0.118897, 0.892468, 0.435159,
	-0.30277, 0.269133, 0.320643, 0.116028, 0.781392, 0.613159,
	-0.307459, 0.25645, 0.327033, 0.308793, 0.644052, 0.699888,
	-0.129118, 0.337022, 0.0616643, -0.0670245, 0.925404, 0.373007,
	-0.153793, 0.326578, 0.0863388, 0.00936645, 0.954668, 0.297526,
	-0.183499, 0.317812, 0.116045, 0.0501986, 0.963182, 0.264121,
	-0.216119, 0.310165, 0.148665, 0.0740278, 0.964585, 0.253169,
	-0.249534, 0.303077, 0.182079, 0.0882076, 0.96191, 0.258744,
	-0.281624, 0.29599, 0.21417, 0.0957852, 0.954789, 0.281432,
	-0.31027, 0.288343, 0.242816, 0.0976203, 0.939595, 0.328074,
	-0.333356, 0.279577, 0.265902, 0.0925491, 0.904192, 0.416979,
	-0.348761, 0.269133, 0.281307, 0.0749875, 0.802438, 0.592005,
	-0.354367, 0.25645, 0.286913, 0.281907, 0.663692, 0.69285,
	-0.137741, 0.337022, 0.0515826, -0.0999263, 0.935131, 0.339918,
	-0.165866, 0.326578, 0.072223, -0.0115762, 0.961266, 0.275378,
	-0.199726, 0.317812, 0.0970728, 0.0349045, 0.968249, 0.247539,
	-0.236908, 0.310165, 0.124359, 0.0613804, 0.969008, 0.239281,
	-0.274994, 0.303077, 0.152311, 0.0763131, 0.966356, 0.245626,
	-0.311571, 0.29599, 0.179155, 0.0830002, 0.960004, 0.267403,
	-0.344224, 0.288343, 0.203118, 0.0819476, 0.946783, 0.311266,
	-0.370538, 0.279577, 0.22243, 0.0706877, 0.915932, 0.39506,
	-0.388097, 0.269133, 0.235316, 0.0400031, 0.82477, 0.564051,
	-0.394487, 0.25645, 0.240005, 0.260261, 0.684983, 0.680487,
	-0.144738, 0.337022, 0.0402085, -0.127324, 0.944917, 0.301532,
	-0.175662, 0.326578, 0.0562977, -0.0286868, 0.967814, 0.250026,
	-0.212893, 0.317812, 0.0756682, 0.0226214, 0.973223, 0.228747,
	-0.253776, 0.310165, 0.096938, 0.0514112, 0.973306, 0.223679,
	-0.295654, 0.303077, 0.118726, 0.0671249, 0.970637, 0.230995,
	-0.335872, 0.29599, 0.139651, 0.0732991, 0.964999, 0.251803,
	-0.371776, 0.288343, 0.15833, 0.0701689, 0.953705, 0.292443,
	-0.400709, 0.279577, 0.173384, 0.0542008, 0.927482, 0.369918,
	-0.420016, 0.269133, 0.183428, 0.0127783, 0.848093, 0.529693,
	-0.427041, 0.25645, 0.187084, 0.245247, 0.707487, 0.662809,
	-0.149942, 0.337022, 0.0277089, -0.148203, 0.954563, 0.258546,
	-0.182949, 0.326578, 0.0387965, -0.0413232, 0.974171, 0.221998,
	-0.222687, 0.317812, 0.0521453, 0.013846, 0.977991, 0.208187,
	-0.266323, 0.310165, 0.066803, 0.0445741, 0.97737, 0.206787,
	-0.31102, 0.303077, 0.0818177, 0.0611103, 0.974636, 0.215292,
	-0.353947, 0.29599, 0.0962376, 0.0672201, 0.969638, 0.235127,
	-0.392269, 0.288343, 0.10911, 0.062997, 0.960168, 0.272228,
	-0.423149, 0.279577, 0.119484, 0.0441762, 0.93853, 0.34236,
	-0.443756, 0.269133, 0.126406, -0.00457853, 0.871834, 0.489781,
	-0.451255, 0.25645, 0.128925, 0.238488, 0.730406, 0.640024,
	-0.153187, 0.337022, 0.0142504, -0.16141, 0.963829, 0.212085,
	-0.187492, 0.326578, 0.0199528, -0.0487359, 0.980161, 0.192119,
	-0.228793, 0.317812, 0.0268179, 0.00917374, 0.982404, 0.186543,
	-0.274145, 0.310165, 0.0343563, 0.0414188, 0.981057, 0.189241,
	-0.320601, 0.303077, 0.0420782, 0.0588463, 0.978193, 0.199186,
	-0.365216, 0.29599, 0.0494942, 0.0654277, 0.973722, 0.218137,
	-0.405044, 0.288343, 0.0561145, 0.0612671, 0.965901, 0.251559,
	-0.437141, 0.279577, 0.0614496, 0.0418308, 0.948625, 0.313627,
	-0.458559, 0.269133, 0.0650097, -0.00972493, 0.895038, 0.445883,
	-0.466352, 0.25645, 0.0663052, 0.241624, 0.752402, 0.612789,
	-0.154305, 0.337022, -3.17231e-008, -0.166499, 0.972441, 0.163209,
	-0.189058, 0.326578, -3.8229e-008, -0.0509801, 0.985661, 0.160853,
	-0.230898, 0.317812, -4.62254e-008, 0.00819111, 0.986449, 0.163865,
	-0.276842, 0.310165, -5.50902e-008, 0.0411715, 0.984457, 0.170733,
	-0.323904, 0.303077, -6.42011e-008, 0.0591236, 0.981517, 0.182015,
	-0.369102, 0.29599, -7.295e-008, 0.0661405, 0.977598, 0.19982,
	-0.40945, 0.288343, -8.06856e-008, 0.0623773, 0.971408, 0.229076,
	-0.441965, 0.279577, -8.68148e-008, 0.0432516, 0.958393, 0.282157,
	-0.463662, 0.269133, -9.07152e-008, -0.00890774, 0.91784, 0.396851,
	-0.471557, 0.25645, -9.17353e-008, 0.251191, 0.773684, 0.581649,
	-0.153187, 0.337022, -0.0142505, -0.1639, 0.980038, 0.112531,
	-0.187492, 0.326578, -0.0199529, -0.0487831, 0.990544, 0.128226,
	-0.228793, 0.317812, -0.0268179, 0.00988226, 0.990138, 0.13975,
	-0.274145, 0.310165, -0.0343563, 0.0424696, 0.987702, 0.150468,
	-0.320601, 0.303077, -0.0420783, 0.0601326, 0.984865, 0.162558,
	-0.365216, 0.29599, -0.0494943, 0.0669419, 0.981669, 0.178449,
	-0.405044, 0.288343, -0.0561146, 0.0630306, 0.97727, 0.202412,
	-0.437141, 0.279577, -0.0614497, 0.043735, 0.968614, 0.244692,
	-0.458559, 0.269133, -0.0650097, -0.00951207, 0.941127, 0.337919,
	-0.466352, 0.25645, -0.0663052, 0.257952, 0.797537, 0.54534,
	-0.149942, 0.337022, -0.027709, -0.15337, 0.986243, 0.0616574,
	-0.182949, 0.326578, -0.0387965, -0.0418469, 0.994556, 0.0954277,
	-0.222687, 0.317812, -0.0521452, 0.0147451, 0.99322, 0.115314,
	-0.266323, 0.310165, -0.0668031, 0.0461058, 0.990483, 0.129685,
	-0.31102, 0.303077, -0.0818178, 0.0630829, 0.987804, 0.142349,
	-0.353947, 0.29599, -0.0962376, 0.0696443, 0.985297, 0.156012,
	-0.392267, 0.288343, -0.10911, 0.0659724, 0.9825, 0.174189,
	-0.423149, 0.279577, -0.119484, 0.0476553, 0.97769, 0.204576,
	-0.443756, 0.269133, -0.126406, -0.00348307, 0.962169, 0.272431,
	-0.451255, 0.25645, -0.128925, 0.266367, 0.822376, 0.502739,
	-0.144738, 0.337022, -0.0402086, -0.134566, 0.99082, 0.0129702,
	-0.175662, 0.326578, -0.0562978, -0.0297181, 0.997496, 0.0641787,
	-0.212893, 0.317812, -0.0756681, 0.0234618, 0.995471, 0.0921216,
	-0.253776, 0.310165, -0.0969381, 0.053066, 0.992509, 0.110044,
	-0.295653, 0.303077, -0.118726, 0.0693553, 0.989938, 0.123337,
	-0.335872, 0.29599, -0.139651, 0.0761707, 0.987918, 0.134966,
	-0.371775, 0.288343, -0.15833, 0.0739341, 0.98627, 0.147669,
	-0.400709, 0.279577, -0.173384, 0.0591444, 0.984276, 0.166444,
	-0.420016, 0.269133, -0.183428, 0.0166248, 0.978073, 0.207595,
	-0.427041, 0.25645, -0.187084, 0.285676, 0.842415, 0.456866,
	-0.137741, 0.337022, -0.0515826, -0.108135, 0.993621, -0.0319905,
	-0.165866, 0.326578, -0.072223, -0.0128057, 0.999291, 0.0354052,
	-0.199726, 0.317812, -0.0970728, 0.0357404, 0.996847, 0.0708437,
	-0.236908, 0.310165, -0.124359, 0.063105, 0.993747, 0.0921137,
	-0.274994, 0.303077, -0.152311, 0.0787052, 0.991239, 0.106073,
	-0.311571, 0.29599, -0.179154, 0.0862289, 0.989508, 0.115925,
	-0.344224, 0.288343, -0.203118, 0.0865121, 0.988545, 0.123667,
	-0.370538, 0.279577, -0.22243, 0.0775773, 0.988255, 0.131659,
	-0.388097, 0.269133, -0.235316, 0.0498038, 0.987927, 0.146697,
	-0.394487, 0.25645, -0.240005, 0.314856, 0.855852, 0.410346,
	-0.129118, 0.337022, -0.0616643, -0.0748689, 0.994588, -0.0720352,
	-0.153793, 0.326578, -0.0863388, 0.00840365, 0.999917, 0.00981062,
	-0.183499, 0.317812, -0.116045, 0.0512298, 0.997333, 0.0519785,
	-0.216119, 0.310165, -0.148665, 0.0759264, 0.99419, 0.0762992,
	-0.249534, 0.303077, -0.18208, 0.0908359, 0.991705, 0.0909403,
	-0.281624, 0.29599, -0.21417, 0.0994678, 0.990071, 0.0993255,
	-0.31027, 0.288343, -0.242818, 0.103224, 0.989333, 0.102788,
	-0.333356, 0.279577, -0.265902, 0.102163, 0.989597, 0.101291,
	-0.348761, 0.269133, -0.281308, 0.094344, 0.991221, 0.0926294,
	-0.354367, 0.25645, -0.286913, 0.352064, 0.86148, 0.365926,
	-0.119037, 0.337022, -0.0702868, -0.0356165, 0.993708, -0.106185,
	-0.139677, 0.326578, -0.0984117, 0.0334137, 0.999369, -0.012033,
	-0.164527, 0.317812, -0.132272, 0.0695757, 0.996929, 0.0359406,
	-0.191813, 0.310165, -0.169454, 0.0912351, 0.993838, 0.0629533,
	-0.219765, 0.303077, -0.20754, 0.105458, 0.991338, 0.0782851,
	-0.246609, 0.29599, -0.244117, 0.115553, 0.98961, 0.0855598,
	-0.270573, 0.288343, -0.27677, 0.123598, 0.988636, 0.0855686,
	-0.289884, 0.279577, -0.303084, 0.132081, 0.9883, 0.0762712,
	-0.30277, 0.269133, -0.320643, 0.148117, 0.987809, 0.047908,
	-0.307459, 0.25645, -0.327033, 0.394977, 0.858791, 0.326299,
	-0.107663, 0.337022, -0.0772837, 0.00870513, 0.991006, -0.133533,
	-0.123752, 0.326578, -0.108208, 0.061706, 0.997656, -0.0295708,
	-0.143122, 0.317812, -0.14544, 0.0904275, 0.995634, 0.023143,
	-0.164392, 0.310165, -0.186321, 0.108751, 0.992685, 0.0524352,
	-0.18618, 0.303077, -0.2282, 0.122306, 0.990128, 0.0684729,
	-0.207105, 0.29599, -0.268418, 0.134174, 0.988111, 0.0750547,
	-0.225784, 0.288343, -0.304322, 0.147188, 0.986442, 0.0725775,
	-0.240838, 0.279577, -0.333255, 0.166487, 0.984364, 0.0575248,
	-0.250882, 0.269133, -0.352562, 0.208665, 0.977876, 0.0147336,
	-0.254538, 0.25645, -0.359587, 0.440994, 0.848006, 0.293956,
	-0.095163, 0.337022, -0.0824878, 0.0570139, 0.986554, -0.153169,
	-0.106251, 0.326578, -0.115495, 0.0926856, 0.994801, -0.0421984,
	-0.119599, 0.317812, -0.155233, 0.113395, 0.99345, 0.0140634,
	-0.134257, 0.310165, -0.198869, 0.128182, 0.990721, 0.0451823,
	-0.149272, 0.303077, -0.243566, 0.141115, 0.988053, 0.0619525,
	-0.163692, 0.29599, -0.286493, 0.155022, 0.985546, 0.0683229,
	-0.176564, 0.288343, -0.324814, 0.173518, 0.982718, 0.0644765,
	-0.186938, 0.279577, -0.355695, 0.204426, 0.977799, 0.0460245,
	-0.19386, 0.269133, -0.376302, 0.273187, 0.961948, -0.0050518,
	-0.196379, 0.25645, -0.383801, 0.487386, 0.83006, 0.271026,
	-0.0817046, 0.337022, -0.0857325, 0.107954, 0.980502, -0.164202,
	-0.0874069, 0.326578, -0.120038, 0.125606, 0.990856, -0.049268,
	-0.094272, 0.317812, -0.161339, 0.137997, 0.990389, 0.00924806,
	-0.10181, 0.310165, -0.206691, 0.149172, 0.987931, 0.0417091,
	-0.109532, 0.303077, -0.253148, 0.161566, 0.985081, 0.0592611,
	-0.116948, 0.29599, -0.297762, 0.177723, 0.981866, 0.0659752,
	-0.123569, 0.288343, -0.33759, 0.202005, 0.97742, 0.0619978,
	-0.128904, 0.279577, -0.369687, 0.244727, 0.968651, 0.0427139,
	-0.132464, 0.269133, -0.391105, 0.338525, 0.940902, -0.0102234,
	-0.133759, 0.25645, -0.398898, 0.531451, 0.806522, 0.259004,
	-0.0674541, 0.337022, -0.0868511, 0.159253, 0.973078, -0.166608,
	-0.0674541, 0.326578, -0.121604, 0.158836, 0.985987, -0.0509971,
	-0.0674541, 0.317812, -0.163444, 0.162759, 0.986632, 0.00819249,
	-0.0674541, 0.310165, -0.209388, 0.170147, 0.984558, 0.0411763,
	-0.067454, 0.303077, -0.25645, 0.181794, 0.981557, 0.0591259,
	-0.067454, 0.29599, -0.301648, 0.199923, 0.977577, 0.0661385,
	-0.067454, 0.288343, -0.341996, 0.22954, 0.971299, 0.0623705,
	-0.067454, 0.279577, -0.37451, 0.283117, 0.95811, 0.043239,
	-0.067454, 0.269133, -0.396208, 0.398581, 0.91709, -0.00890044,
	-0.067454, 0.25645, -0.404103, 0.57032, 0.781277, 0.253656,
	-0.0532036, 0.337022, -0.0857325, 0.20875, 0.964573, -0.161313,
	-0.0475013, 0.326578, -0.120038, 0.190704, 0.980459, -0.0482865,
	-0.0406362, 0.317812, -0.161339, 0.186079, 0.982486, 0.00980586,
	-0.0330977, 0.310165, -0.206691, 0.189358, 0.981002, 0.0421817,
	-0.0253758, 0.303077, -0.253148, 0.199736, 0.978028, 0.0597157,
	-0.0179598, 0.29599, -0.297762, 0.219079, 0.973446, 0.0663814,
	-0.0113395, 0.288343, -0.33759, 0.252931, 0.965478, 0.0622701,
	-0.00600442, 0.279577, -0.369687, 0.315603, 0.947925, 0.0428009,
	-0.00244434, 0.269133, -0.391105, 0.448954, 0.893509, -0.0090307,
	-0.00114884, 0.25645, -0.398898, 0.602889, 0.759107, 0.245523,
	-0.0397452, 0.337022, -0.0824878, 0.255578, 0.955306, -0.148559,
	-0.0286576, 0.326578, -0.115495, 0.220844, 0.974447, -0.0410007,
	-0.0153089, 0.317812, -0.155233, 0.207954, 0.978031, 0.0145195,
	-0.000651112, 0.310165, -0.198869, 0.20713, 0.977255, 0.0454902,
	0.0143638, 0.303077, -0.243566, 0.216071, 0.974393, 0.0622263,
	0.0287835, 0.29599, -0.286493, 0.236287, 0.969265, 0.0685108,
	0.0416563, 0.288343, -0.324813, 0.273778, 0.959632, 0.0644369,
	0.0520298, 0.279577, -0.355695, 0.344394, 0.937712, 0.0457067,
	0.0589519, 0.269133, -0.376302, 0.492578, 0.870263, -0.0031504,
	0.061471, 0.25645, -0.383801, 0.631336, 0.737774, 0.238964,
	-0.0272455, 0.337022, -0.0772835, 0.298763, 0.945646, -0.12843,
	-0.0111563, 0.326578, -0.108208, 0.248885, 0.968103, -0.0288421,
	0.00821404, 0.317812, -0.145439, 0.228438, 0.973288, 0.0229389,
	0.0294841, 0.310165, -0.186321, 0.22389, 0.973224, 0.0520351,
	0.0512721, 0.303077, -0.2282, 0.231593, 0.970434, 0.0679894,
	0.0721965, 0.29599, -0.268418, 0.252739, 0.964671, 0.0743784,
	0.090876, 0.288343, -0.304321, 0.293717, 0.953218, 0.0714564,
	0.10593, 0.279577, -0.333255, 0.371588, 0.926726, 0.0556863,
	0.115974, 0.269133, -0.352562, 0.531883, 0.846696, 0.0143917,
	0.11963, 0.25645, -0.359587, 0.655688, 0.715036, 0.242479,
	-0.0158715, 0.337022, -0.0702868, 0.337337, 0.935858, -0.101848,
	0.00476897, 0.326578, -0.0984117, 0.27419, 0.961597, -0.0123227,
	0.0296187, 0.317812, -0.132272, 0.247057, 0.968379, 0.0347197,
	0.0569052, 0.310165, -0.169454, 0.239228, 0.969012, 0.0615343,
	0.0848568, 0.303077, -0.20754, 0.245892, 0.966256, 0.0767217,
	0.1117, 0.29599, -0.244117, 0.26795, 0.959796, 0.0836387,
	0.135664, 0.288343, -0.27677, 0.312096, 0.946433, 0.082826,
	0.154976, 0.279577, -0.303084, 0.396218, 0.915341, 0.0718515,
	0.167862, 0.269133, -0.320643, 0.565549, 0.823669, 0.0415219,
	0.172551, 0.25645, -0.327033, 0.675124, 0.69234, 0.254702,
	-0.00578981, 0.337022, -0.0616643, 0.370667, 0.926145, -0.0697168,
	0.0188847, 0.326578, -0.0863388, 0.296305, 0.95506, 0.00802665,
	0.0485913, 0.317812, -0.116045, 0.263458, 0.963401, 0.0494868,
	0.0812111, 0.310165, -0.148665, 0.252836, 0.9647, 0.0736743,
	0.114626, 0.303077, -0.18208, 0.258652, 0.961944, 0.0881099,
	0.146716, 0.29599, -0.21417, 0.281555, 0.954739, 0.0959176,
	0.175362, 0.288343, -0.242818, 0.328429, 0.939429, 0.0980167,
	0.198448, 0.279577, -0.265902, 0.417606, 0.903825, 0.0933074,
	0.213853, 0.269133, -0.281308, 0.592842, 0.801696, 0.0763048,
	0.219459, 0.25645, -0.286913, 0.689311, 0.670624, 0.274069,
	0.00283276, 0.337022, -0.0515826, 0.398304, 0.916665, -0.0328545,
	0.0309576, 0.326578, -0.072223, 0.314889, 0.948598, 0.0317163,
	0.0648182, 0.317812, -0.0970728, 0.277368, 0.958432, 0.06689,
	0.101999, 0.310165, -0.124359, 0.264473, 0.960355, 0.0881614,
	0.140086, 0.303077, -0.152311, 0.269635, 0.95756, 0.101864,
	0.176663, 0.29599, -0.179154, 0.293278, 0.949576, 0.110878,
	0.209316, 0.288343, -0.203118, 0.342369, 0.932308, 0.116557,
	0.23563, 0.279577, -0.22243, 0.435286, 0.892358, 0.119261,
	0.253189, 0.269133, -0.235316, 0.613383, 0.781054, 0.117116,
	0.259579, 0.25645, -0.240005, 0.698178, 0.650428, 0.29915,
	0.00982946, 0.337022, -0.0402086, 0.419869, 0.90755, 0.00797223,
	0.0407541, 0.326578, -0.0562978, 0.329648, 0.942303, 0.0582816,
	0.0779845, 0.317812, -0.0756681, 0.288559, 0.953537, 0.0866033,
	0.118867, 0.310165, -0.0969381, 0.273944, 0.956026, 0.104735,
	0.160746, 0.303077, -0.118726, 0.278656, 0.953147, 0.117738,
	0.200964, 0.29599, -0.139651, 0.302916, 0.944351, 0.128231,
	0.236868, 0.288343, -0.15833, 0.353656, 0.925134, 0.13804,
	0.265801, 0.279577, -0.173384, 0.448928, 0.881055, 0.149014,
	0.285108, 0.269133, -0.183428, 0.626958, 0.7619, 0.162579,
	0.292133, 0.25645, -0.187084, 0.701747, 0.632067, 0.328698,
	0.0150336, 0.337022, -0.027709, 0.434995, 0.898933, 0.0519499,
	0.0480405, 0.326578, -0.0387965, 0.340305, 0.93626, 0.0872316,
	0.0877787, 0.317812, -0.0521452, 0.296828, 0.948771, 0.108294,
	0.131414, 0.310165, -0.0668031, 0.281099, 0.951746, 0.123139,
	0.176112, 0.303077, -0.0818178, 0.285582, 0.948727, 0.135498,
	0.219039, 0.29599, -0.0962376, 0.310329, 0.939083, 0.147713,
	0.25736, 0.288343, -0.10911, 0.362108, 0.917937, 0.16208,
	0.288241, 0.279577, -0.119484, 0.458295, 0.86999, 0.181887,
	0.308848, 0.269133, -0.126406, 0.633457, 0.744344, 0.211388,
	0.316347, 0.25645, -0.128925, 0.700074, 0.615768, 0.36156,
	0.0182783, 0.337022, -0.0142505, 0.443354, 0.890963, 0.0980948,
	0.0525836, 0.326578, -0.0199527, 0.346627, 0.930556, 0.117962,
	0.093885, 0.317812, -0.0268179, 0.302026, 0.944178, 0.131558,
	0.139237, 0.310165, -0.0343563, 0.285843, 0.947536, 0.143072,
	0.185692, 0.303077, -0.0420783, 0.290355, 0.944302, 0.154877,
	0.230308, 0.29599, -0.0494943, 0.31546, 0.933766, 0.169016,
	0.270136, 0.288343, -0.0561146, 0.36764, 0.910722, 0.18822,
	0.302233, 0.279577, -0.0614497, 0.463261, 0.859224, 0.21708,
	0.323651, 0.269133, -0.0650097, 0.632932, 0.728491, 0.262102,
	0.331444, 0.25645, -0.0663052, 0.693336, 0.601724, 0.396501
};

const unsigned short TEAPOT_INDICES[] =
{
	0, 1, 2,
	2, 3, 0,
	3, 2, 4,
	4, 5, 3,
	5, 4, 6,
	6, 7, 5,
	7, 6, 8,
	8, 9, 7,
	9, 8, 10,
	10, 11, 9,
	11, 10, 12,
	12, 13, 11,
	13, 12, 14,
	14, 15, 13,
	15, 14, 16,
	16, 17, 15,
	17, 16, 18,
	18, 19, 17,
	19, 18, 20,
	20, 21, 19,
	1, 22, 23,
	23, 2, 1,
	2, 23, 24,
	24, 4, 2,
	4, 24, 25,
	25, 6, 4,
	6, 25, 26,
	26, 8, 6,
	8, 26, 27,
	27, 10, 8,
	10, 27, 28,
	28, 12, 10,
	12, 28, 29,
	29, 14, 12,
	14, 29, 30,
	30, 16, 14,
	16, 30, 31,
	31, 18, 16,
	18, 31, 32,
	32, 20, 18,
	22, 33, 34,
	34, 23, 22,
	23, 34, 35,
	35, 24, 23,
	24, 35, 36,
	36, 25, 24,
	25, 36, 37,
	37, 26, 25,
	26, 37, 38,
	38, 27, 26,
	27, 38, 39,
	39, 28, 27,
	28, 39, 40,
	40, 29, 28,
	29, 40, 41,
	41, 30, 29,
	30, 41, 42,
	42, 31, 30,
	31, 42, 43,
	43, 32, 31,
	33, 44, 45,
	45, 34, 33,
	34, 45, 46,
	46, 35, 34,
	35, 46, 47,
	47, 36, 35,
	36, 47, 48,
	48, 37, 36,
	37, 48, 49,
	49, 38, 37,
	38, 49, 50,
	50, 39, 38,
	39, 50, 51,
	51, 40, 39,
	40, 51, 52,
	52, 41, 40,
	41, 52, 53,
	53, 42, 41,
	42, 53, 54,
	54, 43, 42,
	44, 55, 56,
	56, 45, 44,
	45, 56, 57,
	57, 46, 45,
	46, 57, 58,
	58, 47, 46,
	47, 58, 59,
	59, 48, 47,
	48, 59, 60,
	60, 49, 48,
	49, 60, 61,
	61, 50, 49,
	50, 61, 62,
	62, 51, 50,
	51, 62, 63,
	63, 52, 51,
	52, 63, 64,
	64, 53, 52,
	53, 64, 65,
	65, 54, 53,
	55, 66, 67,
	67, 56, 55,
	56, 67, 68,
	68, 57, 56,
	57, 68, 69,
	69, 58, 57,
	58, 69, 70,
	70, 59, 58,
	59, 70, 71,
	71, 60, 59,
	60, 71, 72,
	72, 61, 60,
	61, 72, 73,
	73, 62, 61,
	62, 73, 74,
	74, 63, 62,
	63, 74, 75,
	75, 64, 63,
	64, 75, 76,
	76, 65, 64,
	66, 77, 78,
	78, 67, 66,
	67, 78, 79,
	79, 68, 67,
	68, 79, 80,
	80, 69, 68,
	69, 80, 81,
	81, 70, 69,
	70, 81, 82,
	82, 71, 70,
	71, 82, 83,
	83, 72, 71,
	72, 83, 84,
	84, 73, 72,
	73, 84, 85,
	85, 74, 73,
	74, 85, 86,
	86, 75, 74,
	75, 86, 87,
	87, 76, 75,
	77, 88, 89,
	89, 78, 77,
	78, 89, 90,
	90, 79, 78,
	79, 90, 91,
	91, 80, 79,
	80, 91, 92,
	92, 81, 80,
	81, 92, 93,
	93, 82, 81,
	82, 93, 94,
	94, 83, 82,
	83, 94, 95,
	95, 84, 83,
	84, 95, 96,
	96, 85, 84,
	85, 96, 97,
	97, 86, 85,
	86, 97, 98,
	98, 87, 86,
	88, 99, 100,
	100, 89, 88,
	89, 100, 101,
	101, 90, 89,
	90, 101, 102,
	102, 91, 90,
	91, 102, 103,
	103, 92, 91,
	92, 103, 104,
	104, 93, 92,
	93, 104, 105,
	105, 94, 93,
	94, 105, 106,
	106, 95, 94,
	95, 106, 107,
	107, 96, 95,
	96, 107, 108,
	108, 97, 96,
	97, 108, 109,
	109, 98, 97,
	99, 110, 111,
	111, 100, 99,
	100, 111, 112,
	112, 101, 100,
	101, 112, 113,
	113, 102, 101,
	102, 113, 114,
	114, 103, 102,
	103, 114, 115,
	115, 104, 103,
	104, 115, 116,
	116, 105, 104,
	105, 116, 117,
	117, 106, 105,
	106, 117, 118,
	118, 107, 106,
	107, 118, 119,
	119, 108, 107,
	108, 119, 120,
	120, 109, 108,
	110, 121, 122,
	122, 111, 110,
	111, 122, 123,
	123, 112, 111,
	112, 123, 124,
	124, 113, 112,
	113, 124, 125,
	125, 114, 113,
	114, 125, 126,
	126, 115, 114,
	115, 126, 127,
	127, 116, 115,
	116, 127, 128,
	128, 117, 116,
	117, 128, 129,
	129, 118, 117,
	118, 129, 130,
	130, 119, 118,
	119, 130, 131,
	131, 120, 119,
	121, 132, 133,
	133, 122, 121,
	122, 133, 134,
	134, 123, 122,
	123, 134, 135,
	135, 124, 123,
	124, 135, 136,
	136, 125, 124,
	125, 136, 137,
	137, 126, 125,
	126, 137, 138,
	138, 127, 126,
	127, 138, 139,
	139, 128, 127,
	128, 139, 140,
	140, 129, 128,
	129, 140, 141,
	141, 130, 129,
	130, 141, 142,
	142, 131, 130,
	132, 143, 144,
	144, 133, 132,
	133, 144, 145,
	145, 134, 133,
	134, 145, 146,
	146, 135, 134,
	135, 146, 147,
	147, 136, 135,
	136, 147, 148,
	148, 137, 136,
	137, 148, 149,
	149, 138, 137,
	138, 149, 150,
	150, 139, 138,
	139, 150, 151,
	151, 140, 139,
	140, 151, 152,
	152, 141, 140,
	141, 152, 153,
	153, 142, 141,
	143, 154, 155,
	155, 144, 143,
	144, 155, 156,
	156, 145, 144,
	145, 156, 157,
	157, 146, 145,
	146, 157, 158,
	158, 147, 146,
	147, 158, 159,
	159, 148, 147,
	148, 159, 160,
	160, 149, 148,
	149, 160, 161,
	161, 150, 149,
	150, 161, 162,
	162, 151, 150,
	151, 162, 163,
	163, 152, 151,
	152, 163, 164,
	164, 153, 152,
	154, 165, 166,
	166, 155, 154,
	155, 166, 167,
	167, 156, 155,
	156, 167, 168,
	168, 157, 156,
	157, 168, 169,
	169, 158, 157,
	158, 169, 170,
	170, 159, 158,
	159, 170, 171,
	171, 160, 159,
	160, 171, 172,
	172, 161, 160,
	161, 172, 173,
	173, 162, 161,
	162, 173, 174,
	174, 163, 162,
	163, 174, 175,
	175, 164, 163,
	165, 176, 177,
	177, 166, 165,
	166, 177, 178,
	178, 167, 166,
	167, 178, 179,
	179, 168, 167,
	168, 179, 180,
	180, 169, 168,
	169, 180, 181,
	181, 170, 169,
	170, 181, 182,
	182, 171, 170,
	171, 182, 183,
	183, 172, 171,
	172, 183, 184,
	184, 173, 172,
	173, 184, 185,
	185, 174, 173,
	174, 185, 186,
	186, 175, 174,
	176, 187, 188,
	188, 177, 176,
	177, 188, 189,
	189, 178, 177,
	178, 189, 190,
	190, 179, 178,
	179, 190, 191,
	191, 180, 179,
	180, 191, 192,
	192, 181, 180,
	181, 192, 193,
	193, 182, 181,
	182, 193, 194,
	194, 183, 182,
	183, 194, 195,
	195, 184, 183,
	184, 195, 196,
	196, 185, 184,
	185, 196, 197,
	197, 186, 185,
	187, 198, 199,
	199, 188, 187,
	188, 199, 200,
	200, 189, 188,
	189, 200, 201,
	201, 190, 189,
	190, 201, 202,
	202, 191, 190,
	191, 202, 203,
	203, 192, 191,
	192, 203, 204,
	204, 193, 192,
	193, 204, 205,
	205, 194, 193,
	194, 205, 206,
	206, 195, 194,
	195, 206, 207,
	207, 196, 195,
	196, 207, 208,
	208, 197, 196,
	198, 209, 210,
	210, 199, 198,
	199, 210, 211,
	211, 200, 199,
	200, 211, 212,
	212, 201, 200,
	201, 212, 213,
	213, 202, 201,
	202, 213, 214,
	214, 203, 202,
	203, 214, 215,
	215, 204, 203,
	204, 215, 216,
	216, 205, 204,
	205, 216, 217,
	217, 206, 205,
	206, 217, 218,
	218, 207, 206,
	207, 218, 219,
	219, 208, 207,
	209, 220, 221,
	221, 210, 209,
	210, 221, 222,
	222, 211, 210,
	211, 222, 223,
	223, 212, 211,
	212, 223, 224,
	224, 213, 212,
	213, 224, 225,
	225, 214, 213,
	214, 225, 226,
	226, 215, 214,
	215, 226, 227,
	227, 216, 215,
	216, 227, 228,
	228, 217, 216,
	217, 228, 229,
	229, 218, 217,
	218, 229, 230,
	230, 219, 218,
	220, 231, 232,
	232, 221, 220,
	221, 232, 233,
	233, 222, 221,
	222, 233, 234,
	234, 223, 222,
	223, 234, 235,
	235, 224, 223,
	224, 235, 236,
	236, 225, 224,
	225, 236, 237,
	237, 226, 225,
	226, 237, 238,
	238, 227, 226,
	227, 238, 239,
	239, 228, 227,
	228, 239, 240,
	240, 229, 228,
	229, 240, 241,
	241, 230, 229,
	231, 242, 243,
	243, 232, 231,
	232, 243, 244,
	244, 233, 232,
	233, 244, 245,
	245, 234, 233,
	234, 245, 246,
	246, 235, 234,
	235, 246, 247,
	247, 236, 235,
	236, 247, 248,
	248, 237, 236,
	237, 248, 249,
	249, 238, 237,
	238, 249, 250,
	250, 239, 238,
	239, 250, 251,
	251, 240, 239,
	240, 251, 252,
	252, 241, 240,
	242, 253, 254,
	254, 243, 242,
	243, 254, 255,
	255, 244, 243,
	244, 255, 256,
	256, 245, 244,
	245, 256, 257,
	257, 246, 245,
	246, 257, 258,
	258, 247, 246,
	247, 258, 259,
	259, 248, 247,
	248, 259, 260,
	260, 249, 248,
	249, 260, 261,
	261, 250, 249,
	250, 261, 262,
	262, 251, 250,
	251, 262, 263,
	263, 252, 251,
	253, 264, 265,
	265, 254, 253,
	254, 265, 266,
	266, 255, 254,
	255, 266, 267,
	267, 256, 255,
	256, 267, 268,
	268, 257, 256,
	257, 268, 269,
	269, 258, 257,
	258, 269, 270,
	270, 259, 258,
	259, 270, 271,
	271, 260, 259,
	260, 271, 272,
	272, 261, 260,
	261, 272, 273,
	273, 262, 261,
	262, 273, 274,
	274, 263, 262,
	264, 275, 276,
	276, 265, 264,
	265, 276, 277,
	277, 266, 265,
	266, 277, 278,
	278, 267, 266,
	267, 278, 279,
	279, 268, 267,
	268, 279, 280,
	280, 269, 268,
	269, 280, 281,
	281, 270, 269,
	270, 281, 282,
	282, 271, 270,
	271, 282, 283,
	283, 272, 271,
	272, 283, 284,
	284, 273, 272,
	273, 284, 285,
	285, 274, 273,
	275, 286, 287,
	287, 276, 275,
	276, 287, 288,
	288, 277, 276,
	277, 288, 289,
	289, 278, 277,
	278, 289, 290,
	290, 279, 278,
	279, 290, 291,
	291, 280, 279,
	280, 291, 292,
	292, 281, 280,
	281, 292, 293,
	293, 282, 281,
	282, 293, 294,
	294, 283, 282,
	283, 294, 295,
	295, 284, 283,
	284, 295, 296,
	296, 285, 284,
	286, 297, 298,
	298, 287, 286,
	287, 298, 299,
	299, 288, 287,
	288, 299, 300,
	300, 289, 288,
	289, 300, 301,
	301, 290, 289,
	290, 301, 302,
	302, 291, 290,
	291, 302, 303,
	303, 292, 291,
	292, 303, 304,
	304, 293, 292,
	293, 304, 305,
	305, 294, 293,
	294, 305, 306,
	306, 295, 294,
	295, 306, 307,
	307, 296, 295,
	297, 308, 309,
	309, 298, 297,
	298, 309, 310,
	310, 299, 298,
	299, 310, 311,
	311, 300, 299,
	300, 311, 312,
	312, 301, 300,
	301, 312, 313,
	313, 302, 301,
	302, 313, 314,
	314, 303, 302,
	303, 314, 315,
	315, 304, 303,
	304, 315, 316,
	316, 305, 304,
	305, 316, 317,
	317, 306, 305,
	306, 317, 318,
	318, 307, 306,
	308, 319, 320,
	320, 309, 308,
	309, 320, 321,
	321, 310, 309,
	310, 321, 322,
	322, 311, 310,
	311, 322, 323,
	323, 312, 311,
	312, 323, 324,
	324, 313, 312,
	313, 324, 325,
	325, 314, 313,
	314, 325, 326,
	326, 315, 314,
	315, 326, 327,
	327, 316, 315,
	316, 327, 328,
	328, 317, 316,
	317, 328, 329,
	329, 318, 317,
	319, 330, 331,
	331, 320, 319,
	320, 331, 332,
	332, 321, 320,
	321, 332, 333,
	333, 322, 321,
	322, 333, 334,
	334, 323, 322,
	323, 334, 335,
	335, 324, 323,
	324, 335, 336,
	336, 325, 324,
	325, 336, 337,
	337, 326, 325,
	326, 337, 338,
	338, 327, 326,
	327, 338, 339,
	339, 328, 327,
	328, 339, 340,
	340, 329, 328,
	330, 341, 342,
	342, 331, 330,
	331, 342, 343,
	343, 332, 331,
	332, 343, 344,
	344, 333, 332,
	333, 344, 345,
	345, 334, 333,
	334, 345, 346,
	346, 335, 334,
	335, 346, 347,
	347, 336, 335,
	336, 347, 348,
	348, 337, 336,
	337, 348, 349,
	349, 338, 337,
	338, 349, 350,
	350, 339, 338,
	339, 350, 351,
	351, 340, 339,
	341, 352, 353,
	353, 342, 341,
	342, 353, 354,
	354, 343, 342,
	343, 354, 355,
	355, 344, 343,
	344, 355, 356,
	356, 345, 344,
	345, 356, 357,
	357, 346, 345,
	346, 357, 358,
	358, 347, 346,
	347, 358, 359,
	359, 348, 347,
	348, 359, 360,
	360, 349, 348,
	349, 360, 361,
	361, 350, 349,
	350, 361, 362,
	362, 351, 350,
	352, 363, 364,
	364, 353, 352,
	353, 364, 365,
	365, 354, 353,
	354, 365, 366,
	366, 355, 354,
	355, 366, 367,
	367, 356, 355,
	356, 367, 368,
	368, 357, 356,
	357, 368, 369,
	369, 358, 357,
	358, 369, 370,
	370, 359, 358,
	359, 370, 371,
	371, 360, 359,
	360, 371, 372,
	372, 361, 360,
	361, 372, 373,
	373, 362, 361,
	363, 374, 375,
	375, 364, 363,
	364, 375, 376,
	376, 365, 364,
	365, 376, 377,
	377, 366, 365,
	366, 377, 378,
	378, 367, 366,
	367, 378, 379,
	379, 368, 367,
	368, 379, 380,
	380, 369, 368,
	369, 380, 381,
	381, 370, 369,
	370, 381, 382,
	382, 371, 370,
	371, 382, 383,
	383, 372, 371,
	372, 383, 384,
	384, 373, 372,
	374, 385, 386,
	386, 375, 374,
	375, 386, 387,
	387, 376, 375,
	376, 387, 388,
	388, 377, 376,
	377, 388, 389,
	389, 378, 377,
	378, 389, 390,
	390, 379, 378,
	379, 390, 391,
	391, 380, 379,
	380, 391, 392,
	392, 381, 380,
	381, 392, 393,
	393, 382, 381,
	382, 393, 394,
	394, 383, 382,
	383, 394, 395,
	395, 384, 383,
	385, 396, 397,
	397, 386, 385,
	386, 397, 398,
	398, 387, 386,
	387, 398, 399,
	399, 388, 387,
	388, 399, 400,
	400, 389, 388,
	389, 400, 401,
	401, 390, 389,
	390, 401, 402,
	402, 391, 390,
	391, 402, 403,
	403, 392, 391,
	392, 403, 404,
	404, 393, 392,
	393, 404, 405,
	405, 394, 393,
	394, 405, 406,
	406, 395, 394,
	396, 407, 408,
	408, 397, 396,
	397, 408, 409,
	409, 398, 397,
	398, 409, 410,
	410, 399, 398,
	399, 410, 411,
	411, 400, 399,
	400, 411, 412,
	412, 401, 400,
	401, 412, 413,
	413, 402, 401,
	402, 413, 414,
	414, 403, 402,
	403, 414, 415,
	415, 404, 403,
	404, 415, 416,
	416, 405, 404,
	405, 416, 417,
	417, 406, 405,
	407, 418, 419,
	419, 408, 407,
	408, 419, 420,
	420, 409, 408,
	409, 420, 421,
	421, 410, 409,
	410, 421, 422,
	422, 411, 410,
	411, 422, 423,
	423, 412, 411,
	412, 423, 424,
	424, 413, 412,
	413, 424, 425,
	425, 414, 413,
	414, 425, 426,
	426, 415, 414,
	415, 426, 427,
	427, 416, 415,
	416, 427, 428,
	428, 417, 416,
	418, 429, 430,
	430, 419, 418,
	419, 430, 431,
	431, 420, 419,
	420, 431, 432,
	432, 421, 420,
	421, 432, 433,
	433, 422, 421,
	422, 433, 434,
	434, 423, 422,
	423, 434, 435,
	435, 424, 423,
	424, 435, 436,
	436, 425, 424,
	425, 436, 437,
	437, 426, 425,
	426, 437, 438,
	438, 427, 426,
	427, 438, 439,
	439, 428, 427,
	429, 0, 3,
	3, 430, 429,
	430, 3, 5,
	5, 431, 430,
	431, 5, 7,
	7, 432, 431,
	432, 7, 9,
	9, 433, 432,
	433, 9, 11,
	11, 434, 433,
	434, 11, 13,
	13, 435, 434,
	435, 13, 15,
	15, 436, 435,
	436, 15, 17,
	17, 437, 436,
	437, 17, 19,
	19, 438, 437,
	438, 19, 21,
	21, 439, 438,
	21, 20, 440,
	440, 441, 21,
	441, 440, 442,
	442, 443, 441,
	443, 442, 444,
	444, 445, 443,
	445, 444, 446,
	446, 447, 445,
	447, 446, 448,
	448, 449, 447,
	449, 448, 450,
	450, 451, 449,
	451, 450, 452,
	452, 453, 451,
	453, 452, 454,
	454, 455, 453,
	455, 454, 456,
	456, 457, 455,
	457, 456, 458,
	458, 459, 457,
	20, 32, 460,
	460, 440, 20,
	440, 460, 461,
	461, 442, 440,
	442, 461, 462,
	462, 444, 442,
	444, 462, 463,
	463, 446, 444,
	446, 463, 464,
	464, 448, 446,
	448, 464, 465,
	465, 450, 448,
	450, 465, 466,
	466, 452, 450,
	452, 466, 467,
	467, 454, 452,
	454, 467, 468,
	468, 456, 454,
	456, 468, 469,
	469, 458, 456,
	32, 43, 470,
	470, 460, 32,
	460, 470, 471,
	471, 461, 460,
	461, 471, 472,
	472, 462, 461,
	462, 472, 473,
	473, 463, 462,
	463, 473, 474,
	474, 464, 463,
	464, 474, 475,
	475, 465, 464,
	465, 475, 476,
	476, 466, 465,
	466, 476, 477,
	477, 467, 466,
	467, 477, 478,
	478, 468, 467,
	468, 478, 479,
	479, 469, 468,
	43, 54, 480,
	480, 470, 43,
	470, 480, 481,
	481, 471, 470,
	471, 481, 482,
	482, 472, 471,
	472, 482, 483,
	483, 473, 472,
	473, 483, 484,
	484, 474, 473,
	474, 484, 485,
	485, 475, 474,
	475, 485, 486,
	486, 476, 475,
	476, 486, 487,
	487, 477, 476,
	477, 487, 488,
	488, 478, 477,
	478, 488, 489,
	489, 479, 478,
	54, 65, 490,
	490, 480, 54,
	480, 490, 491,
	491, 481, 480,
	481, 491, 492,
	492, 482, 481,
	482, 492, 493,
	493, 483, 482,
	483, 493, 494,
	494, 484, 483,
	484, 494, 495,
	495, 485, 484,
	485, 495, 496,
	496, 486, 485,
	486, 496, 497,
	497, 487, 486,
	487, 497, 498,
	498, 488, 487,
	488, 498, 499,
	499, 489, 488,
	65, 76, 500,
	500, 490, 65,
	490, 500, 501,
	501, 491, 490,
	491, 501, 502,
	502, 492, 491,
	492, 502, 503,
	503, 493, 492,
	493, 503, 504,
	504, 494, 493,
	494, 504, 505,
	505, 495, 494,
	495, 505, 506,
	506, 496, 495,
	496, 506, 507,
	507, 497, 496,
	497, 507, 508,
	508, 498, 497,
	498, 508, 509,
	509, 499, 498,
	76, 87, 510,
	510, 500, 76,
	500, 510, 511,
	511, 501, 500,
	501, 511, 512,
	512, 502, 501,
	502, 512, 513,
	513, 503, 502,
	503, 513, 514,
	514, 504, 503,
	504, 514, 515,
	515, 505, 504,
	505, 515, 516,
	516, 506, 505,
	506, 516, 517,
	517, 507, 506,
	507, 517, 518,
	518, 508, 507,
	508, 518, 519,
	519, 509, 508,
	87, 98, 520,
	520, 510, 87,
	510, 520, 521,
	521, 511, 510,
	511, 521, 522,
	522, 512, 511,
	512, 522, 523,
	523, 513, 512,
	513, 523, 524,
	524, 514, 513,
	514, 524, 525,
	525, 515, 514,
	515, 525, 526,
	526, 516, 515,
	516, 526, 527,
	527, 517, 516,
	517, 527, 528,
	528, 518, 517,
	518, 528, 529,
	529, 519, 518,
	98, 109, 530,
	530, 520, 98,
	520, 530, 531,
	531, 521, 520,
	521, 531, 532,
	532, 522, 521,
	522, 532, 533,
	533, 523, 522,
	523, 533, 534,
	534, 524, 523,
	524, 534, 535,
	535, 525, 524,
	525, 535, 536,
	536, 526, 525,
	526, 536, 537,
	537, 527, 526,
	527, 537, 538,
	538, 528, 527,
	528, 538, 539,
	539, 529, 528,
	109, 120, 540,
	540, 530, 109,
	530, 540, 541,
	541, 531, 530,
	531, 541, 542,
	542, 532, 531,
	532, 542, 543,
	543, 533, 532,
	533, 543, 544,
	544, 534, 533,
	534, 544, 545,
	545, 535, 534,
	535, 545, 546,
	546, 536, 535,
	536, 546, 547,
	547, 537, 536,
	537, 547, 548,
	548, 538, 537,
	538, 548, 549,
	549, 539, 538,
	120, 131, 550,
	550, 540, 120,
	540, 550, 551,
	551, 541, 540,
	541, 551, 552,
	552, 542, 541,
	542, 552, 553,
	553, 543, 542,
	543, 553, 554,
	554, 544, 543,
	544, 554, 555,
	555, 545, 544,
	545, 555, 556,
	556, 546, 545,
	546, 556, 557,
	557, 547, 546,
	547, 557, 558,
	558, 548, 547,
	548, 558, 559,
	559, 549, 548,
	131, 142, 560,
	560, 550, 131,
	550, 560, 561,
	561, 551, 550,
	551, 561, 562,
	562, 552, 551,
	552, 562, 563,
	563, 553, 552,
	553, 563, 564,
	564, 554, 553,
	554, 564, 565,
	565, 555, 554,
	555, 565, 566,
	566, 556, 555,
	556, 566, 567,
	567, 557, 556,
	557, 567, 568,
	568, 558, 557,
	558, 568, 569,
	569, 559, 558,
	142, 153, 570,
	570, 560, 142,
	560, 570, 571,
	571, 561, 560,
	561, 571, 572,
	572, 562, 561,
	562, 572, 573,
	573, 563, 562,
	563, 573, 574,
	574, 564, 563,
	564, 574, 575,
	575, 565, 564,
	565, 575, 576,
	576, 566, 565,
	566, 576, 577,
	577, 567, 566,
	567, 577, 578,
	578, 568, 567,
	568, 578, 579,
	579, 569, 568,
	153, 164, 580,
	580, 570, 153,
	570, 580, 581,
	581, 571, 570,
	571, 581, 582,
	582, 572, 571,
	572, 582, 583,
	583, 573, 572,
	573, 583, 584,
	584, 574, 573,
	574, 584, 585,
	585, 575, 574,
	575, 585, 586,
	586, 576, 575,
	576, 586, 587,
	587, 577, 576,
	577, 587, 588,
	588, 578, 577,
	578, 588, 589,
	589, 579, 578,
	164, 175, 590,
	590, 580, 164,
	580, 590, 591,
	591, 581, 580,
	581, 591, 592,
	592, 582, 581,
	582, 592, 593,
	593, 583, 582,
	583, 593, 594,
	594, 584, 583,
	584, 594, 595,
	595, 585, 584,
	585, 595, 596,
	596, 586, 585,
	586, 596, 597,
	597, 587, 586,
	587, 597, 598,
	598, 588, 587,
	588, 598, 599,
	599, 589, 588,
	175, 186, 600,
	600, 590, 175,
	590, 600, 601,
	601, 591, 590,
	591, 601, 602,
	602, 592, 591,
	592, 602, 603,
	603, 593, 592,
	593, 603, 604,
	604, 594, 593,
	594, 604, 605,
	605, 595, 594,
	595, 605, 606,
	606, 596, 595,
	596, 606, 607,
	607, 597, 596,
	597, 607, 608,
	608, 598, 597,
	598, 608, 609,
	609, 599, 598,
	186, 197, 610,
	610, 600, 186,
	600, 610, 611,
	611, 601, 600,
	601, 611, 612,
	612, 602, 601,
	602, 612, 613,
	613, 603, 602,
	603, 613, 614,
	614, 604, 603,
	604, 614, 615,
	615, 605, 604,
	605, 615, 616,
	616, 606, 605,
	606, 616, 617,
	617, 607, 606,
	607, 617, 618,
	618, 608, 607,
	608, 618, 619,
	619, 609, 608,
	197, 208, 620,
	620, 610, 197,
	610, 620, 621,
	621, 611, 610,
	611, 621, 622,
	622, 612, 611,
	612, 622, 623,
	623, 613, 612,
	613, 623, 624,
	624, 614, 613,
	614, 624, 625,
	625, 615, 614,
	615, 625, 626,
	626, 616, 615,
	616, 626, 627,
	627, 617, 616,
	617, 627, 628,
	628, 618, 617,
	618, 628, 629,
	629, 619, 618,
	208, 219, 630,
	630, 620, 208,
	620, 630, 631,
	631, 621, 620,
	621, 631, 632,
	632, 622, 621,
	622, 632, 633,
	633, 623, 622,
	623, 633, 634,
	634, 624, 623,
	624, 634, 635,
	635, 625, 624,
	625, 635, 636,
	636, 626, 625,
	626, 636, 637,
	637, 627, 626,
	627, 637, 638,
	638, 628, 627,
	628, 638, 639,
	639, 629, 628,
	219, 230, 640,
	640, 630, 219,
	630, 640, 641,
	641, 631, 630,
	631, 641, 642,
	642, 632, 631,
	632, 642, 643,
	643, 633, 632,
	633, 643, 644,
	644, 634, 633,
	634, 644, 645,
	645, 635, 634,
	635, 645, 646,
	646, 636, 635,
	636, 646, 647,
	647, 637, 636,
	637, 647, 648,
	648, 638, 637,
	638, 648, 649,
	649, 639, 638,
	230, 241, 650,
	650, 640, 230,
	640, 650, 651,
	651, 641, 640,
	641, 651, 652,
	652, 642, 641,
	642, 652, 653,
	653, 643, 642,
	643, 653, 654,
	654, 644, 643,
	644, 654, 655,
	655, 645, 644,
	645, 655, 656,
	656, 646, 645,
	646, 656, 657,
	657, 647, 646,
	647, 657, 658,
	658, 648, 647,
	648, 658, 659,
	659, 649, 648,
	241, 252, 660,
	660, 650, 241,
	650, 660, 661,
	661, 651, 650,
	651, 661, 662,
	662, 652, 651,
	652, 662, 663,
	663, 653, 652,
	653, 663, 664,
	664, 654, 653,
	654, 664, 665,
	665, 655, 654,
	655, 665, 666,
	666, 656, 655,
	656, 666, 667,
	667, 657, 656,
	657, 667, 668,
	668, 658, 657,
	658, 668, 669,
	669, 659, 658,
	252, 263, 670,
	670, 660, 252,
	660, 670, 671,
	671, 661, 660,
	661, 671, 672,
	672, 662, 661,
	662, 672, 673,
	673, 663, 662,
	663, 673, 674,
	674, 664, 663,
	664, 674, 675,
	675, 665, 664,
	665, 675, 676,
	676, 666, 665,
	666, 676, 677,
	677, 667, 666,
	667, 677, 678,
	678, 668, 667,
	668, 678, 679,
	679, 669, 668,
	263, 274, 680,
	680, 670, 263,
	670, 680, 681,
	681, 671, 670,
	671, 681, 682,
	682, 672, 671,
	672, 682, 683,
	683, 673, 672,
	673, 683, 684,
	684, 674, 673,
	674, 684, 685,
	685, 675, 674,
	675, 685, 686,
	686, 676, 675,
	676, 686, 687,
	687, 677, 676,
	677, 687, 688,
	688, 678, 677,
	678, 688, 689,
	689, 679, 678,
	274, 285, 690,
	690, 680, 274,
	680, 690, 691,
	691, 681, 680,
	681, 691, 692,
	692, 682, 681,
	682, 692, 693,
	693, 683, 682,
	683, 693, 694,
	694, 684, 683,
	684, 694, 695,
	695, 685, 684,
	685, 695, 696,
	696, 686, 685,
	686, 696, 697,
	697, 687, 686,
	687, 697, 698,
	698, 688, 687,
	688, 698, 699,
	699, 689, 688,
	285, 296, 700,
	700, 690, 285,
	690, 700, 701,
	701, 691, 690,
	691, 701, 702,
	702, 692, 691,
	692, 702, 703,
	703, 693, 692,
	693, 703, 704,
	704, 694, 693,
	694, 704, 705,
	705, 695, 694,
	695, 705, 706,
	706, 696, 695,
	696, 706, 707,
	707, 697, 696,
	697, 707, 708,
	708, 698, 697,
	698, 708, 709,
	709, 699, 698,
	296, 307, 710,
	710, 700, 296,
	700, 710, 711,
	711, 701, 700,
	701, 711, 712,
	712, 702, 701,
	702, 712, 713,
	713, 703, 702,
	703, 713, 714,
	714, 704, 703,
	704, 714, 715,
	715, 705, 704,
	705, 715, 716,
	716, 706, 705,
	706, 716, 717,
	717, 707, 706,
	707, 717, 718,
	718, 708, 707,
	708, 718, 719,
	719, 709, 708,
	307, 318, 720,
	720, 710, 307,
	710, 720, 721,
	721, 711, 710,
	711, 721, 722,
	722, 712, 711,
	712, 722, 723,
	723, 713, 712,
	713, 723, 724,
	724, 714, 713,
	714, 724, 725,
	725, 715, 714,
	715, 725, 726,
	726, 716, 715,
	716, 726, 727,
	727, 717, 716,
	717, 727, 728,
	728, 718, 717,
	718, 728, 729,
	729, 719, 718,
	318, 329, 730,
	730, 720, 318,
	720, 730, 731,
	731, 721, 720,
	721, 731, 732,
	732, 722, 721,
	722, 732, 733,
	733, 723, 722,
	723, 733, 734,
	734, 724, 723,
	724, 734, 735,
	735, 725, 724,
	725, 735, 736,
	736, 726, 725,
	726, 736, 737,
	737, 727, 726,
	727, 737, 738,
	738, 728, 727,
	728, 738, 739,
	739, 729, 728,
	329, 340, 740,
	740, 730, 329,
	730, 740, 741,
	741, 731, 730,
	731, 741, 742,
	742, 732, 731,
	732, 742, 743,
	743, 733, 732,
	733, 743, 744,
	744, 734, 733,
	734, 744, 745,
	745, 735, 734,
	735, 745, 746,
	746, 736, 735,
	736, 746, 747,
	747, 737, 736,
	737, 747, 748,
	748, 738, 737,
	738, 748, 749,
	749, 739, 738,
	340, 351, 750,
	750, 740, 340,
	740, 750, 751,
	751, 741, 740,
	741, 751, 752,
	752, 742, 741,
	742, 752, 753,
	753, 743, 742,
	743, 753, 754,
	754, 744, 743,
	744, 754, 755,
	755, 745, 744,
	745, 755, 756,
	756, 746, 745,
	746, 756, 757,
	757, 747, 746,
	747, 757, 758,
	758, 748, 747,
	748, 758, 759,
	759, 749, 748,
	351, 362, 760,
	760, 750, 351,
	750, 760, 761,
	761, 751, 750,
	751, 761, 762,
	762, 752, 751,
	752, 762, 763,
	763, 753, 752,
	753, 763, 764,
	764, 754, 753,
	754, 764, 765,
	765, 755, 754,
	755, 765, 766,
	766, 756, 755,
	756, 766, 767,
	767, 757, 756,
	757, 767, 768,
	768, 758, 757,
	758, 768, 769,
	769, 759, 758,
	362, 373, 770,
	770, 760, 362,
	760, 770, 771,
	771, 761, 760,
	761, 771, 772,
	772, 762, 761,
	762, 772, 773,
	773, 763, 762,
	763, 773, 774,
	774, 764, 763,
	764, 774, 775,
	775, 765, 764,
	765, 775, 776,
	776, 766, 765,
	766, 776, 777,
	777, 767, 766,
	767, 777, 778,
	778, 768, 767,
	768, 778, 779,
	779, 769, 768,
	373, 384, 780,
	780, 770, 373,
	770, 780, 781,
	781, 771, 770,
	771, 781, 782,
	782, 772, 771,
	772, 782, 783,
	783, 773, 772,
	773, 783, 784,
	784, 774, 773,
	774, 784, 785,
	785, 775, 774,
	775, 785, 786,
	786, 776, 775,
	776, 786, 787,
	787, 777, 776,
	777, 787, 788,
	788, 778, 777,
	778, 788, 789,
	789, 779, 778,
	384, 395, 790,
	790, 780, 384,
	780, 790, 791,
	791, 781, 780,
	781, 791, 792,
	792, 782, 781,
	782, 792, 793,
	793, 783, 782,
	783, 793, 794,
	794, 784, 783,
	784, 794, 795,
	795, 785, 784,
	785, 795, 796,
	796, 786, 785,
	786, 796, 797,
	797, 787, 786,
	787, 797, 798,
	798, 788, 787,
	788, 798, 799,
	799, 789, 788,
	395, 406, 800,
	800, 790, 395,
	790, 800, 801,
	801, 791, 790,
	791, 801, 802,
	802, 792, 791,
	792, 802, 803,
	803, 793, 792,
	793, 803, 804,
	804, 794, 793,
	794, 804, 805,
	805, 795, 794,
	795, 805, 806,
	806, 796, 795,
	796, 806, 807,
	807, 797, 796,
	797, 807, 808,
	808, 798, 797,
	798, 808, 809,
	809, 799, 798,
	406, 417, 810,
	810, 800, 406,
	800, 810, 811,
	811, 801, 800,
	801, 811, 812,
	812, 802, 801,
	802, 812, 813,
	813, 803, 802,
	803, 813, 814,
	814, 804, 803,
	804, 814, 815,
	815, 805, 804,
	805, 815, 816,
	816, 806, 805,
	806, 816, 817,
	817, 807, 806,
	807, 817, 818,
	818, 808, 807,
	808, 818, 819,
	819, 809, 808,
	417, 428, 820,
	820, 810, 417,
	810, 820, 821,
	821, 811, 810,
	811, 821, 822,
	822, 812, 811,
	812, 822, 823,
	823, 813, 812,
	813, 823, 824,
	824, 814, 813,
	814, 824, 825,
	825, 815, 814,
	815, 825, 826,
	826, 816, 815,
	816, 826, 827,
	827, 817, 816,
	817, 827, 828,
	828, 818, 817,
	818, 828, 829,
	829, 819, 818,
	428, 439, 830,
	830, 820, 428,
	820, 830, 831,
	831, 821, 820,
	821, 831, 832,
	832, 822, 821,
	822, 832, 833,
	833, 823, 822,
	823, 833, 834,
	834, 824, 823,
	824, 834, 835,
	835, 825, 824,
	825, 835, 836,
	836, 826, 825,
	826, 836, 837,
	837, 827, 826,
	827, 837, 838,
	838, 828, 827,
	828, 838, 839,
	839, 829, 828,
	439, 21, 441,
	441, 830, 439,
	830, 441, 443,
	443, 831, 830,
	831, 443, 445,
	445, 832, 831,
	832, 445, 447,
	447, 833, 832,
	833, 447, 449,
	449, 834, 833,
	834, 449, 451,
	451, 835, 834,
	835, 451, 453,
	453, 836, 835,
	836, 453, 455,
	455, 837, 836,
	837, 455, 457,
	457, 838, 837,
	838, 457, 459,
	459, 839, 838,
	459, 458, 840,
	840, 841, 459,
	841, 840, 842,
	842, 843, 841,
	843, 842, 844,
	844, 845, 843,
	845, 844, 846,
	846, 847, 845,
	847, 846, 848,
	848, 849, 847,
	849, 848, 850,
	850, 851, 849,
	851, 850, 852,
	852, 853, 851,
	853, 852, 854,
	854, 855, 853,
	855, 854, 856,
	856, 857, 855,
	857, 856, 858,
	858, 859, 857,
	458, 469, 860,
	860, 840, 458,
	840, 860, 861,
	861, 842, 840,
	842, 861, 862,
	862, 844, 842,
	844, 862, 863,
	863, 846, 844,
	846, 863, 864,
	864, 848, 846,
	848, 864, 865,
	865, 850, 848,
	850, 865, 866,
	866, 852, 850,
	852, 866, 867,
	867, 854, 852,
	854, 867, 868,
	868, 856, 854,
	856, 868, 869,
	869, 858, 856,
	469, 479, 870,
	870, 860, 469,
	860, 870, 871,
	871, 861, 860,
	861, 871, 872,
	872, 862, 861,
	862, 872, 873,
	873, 863, 862,
	863, 873, 874,
	874, 864, 863,
	864, 874, 875,
	875, 865, 864,
	865, 875, 876,
	876, 866, 865,
	866, 876, 877,
	877, 867, 866,
	867, 877, 878,
	878, 868, 867,
	868, 878, 879,
	879, 869, 868,
	479, 489, 880,
	880, 870, 479,
	870, 880, 881,
	881, 871, 870,
	871, 881, 882,
	882, 872, 871,
	872, 882, 883,
	883, 873, 872,
	873, 883, 884,
	884, 874, 873,
	874, 884, 885,
	885, 875, 874,
	875, 885, 886,
	886, 876, 875,
	876, 886, 887,
	887, 877, 876,
	877, 887, 888,
	888, 878, 877,
	878, 888, 889,
	889, 879, 878,
	489, 499, 890,
	890, 880, 489,
	880, 890, 891,
	891, 881, 880,
	881, 891, 892,
	892, 882, 881,
	882, 892, 893,
	893, 883, 882,
	883, 893, 894,
	894, 884, 883,
	884, 894, 895,
	895, 885, 884,
	885, 895, 896,
	896, 886, 885,
	886, 896, 897,
	897, 887, 886,
	887, 897, 898,
	898, 888, 887,
	888, 898, 899,
	899, 889, 888,
	499, 509, 900,
	900, 890, 499,
	890, 900, 901,
	901, 891, 890,
	891, 901, 902,
	902, 892, 891,
	892, 902, 903,
	903, 893, 892,
	893, 903, 904,
	904, 894, 893,
	894, 904, 905,
	905, 895, 894,
	895, 905, 906,
	906, 896, 895,
	896, 906, 907,
	907, 897, 896,
	897, 907, 908,
	908, 898, 897,
	898, 908, 909,
	909, 899, 898,
	509, 519, 910,
	910, 900, 509,
	900, 910, 911,
	911, 901, 900,
	901, 911, 912,
	912, 902, 901,
	902, 912, 913,
	913, 903, 902,
	903, 913, 914,
	914, 904, 903,
	904, 914, 915,
	915, 905, 904,
	905, 915, 916,
	916, 906, 905,
	906, 916, 917,
	917, 907, 906,
	907, 917, 918,
	918, 908, 907,
	908, 918, 919,
	919, 909, 908,
	519, 529, 920,
	920, 910, 519,
	910, 920, 921,
	921, 911, 910,
	911, 921, 922,
	922, 912, 911,
	912, 922, 923,
	923, 913, 912,
	913, 923, 924,
	924, 914, 913,
	914, 924, 925,
	925, 915, 914,
	915, 925, 926,
	926, 916, 915,
	916, 926, 927,
	927, 917, 916,
	917, 927, 928,
	928, 918, 917,
	918, 928, 929,
	929, 919, 918,
	529, 539, 930,
	930, 920, 529,
	920, 930, 931,
	931, 921, 920,
	921, 931, 932,
	932, 922, 921,
	922, 932, 933,
	933, 923, 922,
	923, 933, 934,
	934, 924, 923,
	924, 934, 935,
	935, 925, 924,
	925, 935, 936,
	936, 926, 925,
	926, 936, 937,
	937, 927, 926,
	927, 937, 938,
	938, 928, 927,
	928, 938, 939,
	939, 929, 928,
	539, 549, 940,
	940, 930, 539,
	930, 940, 941,
	941, 931, 930,
	931, 941, 942,
	942, 932, 931,
	932, 942, 943,
	943, 933, 932,
	933, 943, 944,
	944, 934, 933,
	934, 944, 945,
	945, 935, 934,
	935, 945, 946,
	946, 936, 935,
	936, 946, 947,
	947, 937, 936,
	937, 947, 948,
	948, 938, 937,
	938, 948, 949,
	949, 939, 938,
	549, 559, 950,
	950, 940, 549,
	940, 950, 951,
	951, 941, 940,
	941, 951, 952,
	952, 942, 941,
	942, 952, 953,
	953, 943, 942,
	943, 953, 954,
	954, 944, 943,
	944, 954, 955,
	955, 945, 944,
	945, 955, 956,
	956, 946, 945,
	946, 956, 957,
	957, 947, 946,
	947, 957, 958,
	958, 948, 947,
	948, 958, 959,
	959, 949, 948,
	559, 569, 960,
	960, 950, 559,
	950, 960, 961,
	961, 951, 950,
	951, 961, 962,
	962, 952, 951,
	952, 962, 963,
	963, 953, 952,
	953, 963, 964,
	964, 954, 953,
	954, 964, 965,
	965, 955, 954,
	955, 965, 966,
	966, 956, 955,
	956, 966, 967,
	967, 957, 956,
	957, 967, 968,
	968, 958, 957,
	958, 968, 969,
	969, 959, 958,
	569, 579, 970,
	970, 960, 569,
	960, 970, 971,
	971, 961, 960,
	961, 971, 972,
	972, 962, 961,
	962, 972, 973,
	973, 963, 962,
	963, 973, 974,
	974, 964, 963,
	964, 974, 975,
	975, 965, 964,
	965, 975, 976,
	976, 966, 965,
	966, 976, 977,
	977, 967, 966,
	967, 977, 978,
	978, 968, 967,
	968, 978, 979,
	979, 969, 968,
	579, 589, 980,
	980, 970, 579,
	970, 980, 981,
	981, 971, 970,
	971, 981, 982,
	982, 972, 971,
	972, 982, 983,
	983, 973, 972,
	973, 983, 984,
	984, 974, 973,
	974, 984, 985,
	985, 975, 974,
	975, 985, 986,
	986, 976, 975,
	976, 986, 987,
	987, 977, 976,
	977, 987, 988,
	988, 978, 977,
	978, 988, 989,
	989, 979, 978,
	589, 599, 990,
	990, 980, 589,
	980, 990, 991,
	991, 981, 980,
	981, 991, 992,
	992, 982, 981,
	982, 992, 993,
	993, 983, 982,
	983, 993, 994,
	994, 984, 983,
	984, 994, 995,
	995, 985, 984,
	985, 995, 996,
	996, 986, 985,
	986, 996, 997,
	997, 987, 986,
	987, 997, 998,
	998, 988, 987,
	988, 998, 999,
	999, 989, 988,
	599, 609, 1000,
	1000, 990, 599,
	990, 1000, 1001,
	1001, 991, 990,
	991, 1001, 1002,
	1002, 992, 991,
	992, 1002, 1003,
	1003, 993, 992,
	993, 1003, 1004,
	1004, 994, 993,
	994, 1004, 1005,
	1005, 995, 994,
	995, 1005, 1006,
	1006, 996, 995,
	996, 1006, 1007,
	1007, 997, 996,
	997, 1007, 1008,
	1008, 998, 997,
	998, 1008, 1009,
	1009, 999, 998,
	609, 619, 1010,
	1010, 1000, 609,
	1000, 1010, 1011,
	1011, 1001, 1000,
	1001, 1011, 1012,
	1012, 1002, 1001,
	1002, 1012, 1013,
	1013, 1003, 1002,
	1003, 1013, 1014,
	1014, 1004, 1003,
	1004, 1014, 1015,
	1015, 1005, 1004,
	1005, 1015, 1016,
	1016, 1006, 1005,
	1006, 1016, 1017,
	1017, 1007, 1006,
	1007, 1017, 1018,
	1018, 1008, 1007,
	1008, 1018, 1019,
	1019, 1009, 1008,
	619, 629, 1020,
	1020, 1010, 619,
	1010, 1020, 1021,
	1021, 1011, 1010,
	1011, 1021, 1022,
	1022, 1012, 1011,
	1012, 1022, 1023,
	1023, 1013, 1012,
	1013, 1023, 1024,
	1024, 1014, 1013,
	1014, 1024, 1025,
	1025, 1015, 1014,
	1015, 1025, 1026,
	1026, 1016, 1015,
	1016, 1026, 1027,
	1027, 1017, 1016,
	1017, 1027, 1028,
	1028, 1018, 1017,
	1018, 1028, 1029,
	1029, 1019, 1018,
	629, 639, 1030,
	1030, 1020, 629,
	1020, 1030, 1031,
	1031, 1021, 1020,
	1021, 1031, 1032,
	1032, 1022, 1021,
	1022, 1032, 1033,
	1033, 1023, 1022,
	1023, 1033, 1034,
	1034, 1024, 1023,
	1024, 1034, 1035,
	1035, 1025, 1024,
	1025, 1035, 1036,
	1036, 1026, 1025,
	1026, 1036, 1037,
	1037, 1027, 1026,
	1027, 1037, 1038,
	1038, 1028, 1027,
	1028, 1038, 1039,
	1039, 1029, 1028,
	639, 649, 1040,
	1040, 1030, 639,
	1030, 1040, 1041,
	1041, 1031, 1030,
	1031, 1041, 1042,
	1042, 1032, 1031,
	1032, 1042, 1043,
	1043, 1033, 1032,
	1033, 1043, 1044,
	1044, 1034, 1033,
	1034, 1044, 1045,
	1045, 1035, 1034,
	1035, 1045, 1046,
	1046, 1036, 1035,
	1036, 1046, 1047,
	1047, 1037, 1036,
	1037, 1047, 1048,
	1048, 1038, 1037,
	1038, 1048, 1049,
	1049, 1039, 1038,
	649, 659, 1050,
	1050, 1040, 649,
	1040, 1050, 1051,
	1051, 1041, 1040,
	1041, 1051, 1052,
	1052, 1042, 1041,
	1042, 1052, 1053,
	1053, 1043, 1042,
	1043, 1053, 1054,
	1054, 1044, 1043,
	1044, 1054, 1055,
	1055, 1045, 1044,
	1045, 1055, 1056,
	1056, 1046, 1045,
	1046, 1056, 1057,
	1057, 1047, 1046,
	1047, 1057, 1058,
	1058, 1048, 1047,
	1048, 1058, 1059,
	1059, 1049, 1048,
	659, 669, 1060,
	1060, 1050, 659,
	1050, 1060, 1061,
	1061, 1051, 1050,
	1051, 1061, 1062,
	1062, 1052, 1051,
	1052, 1062, 1063,
	1063, 1053, 1052,
	1053, 1063, 1064,
	1064, 1054, 1053,
	1054, 1064, 1065,
	1065, 1055, 1054,
	1055, 1065, 1066,
	1066, 1056, 1055,
	1056, 1066, 1067,
	1067, 1057, 1056,
	1057, 1067, 1068,
	1068, 1058, 1057,
	1058, 1068, 1069,
	1069, 1059, 1058,
	669, 679, 1070,
	1070, 1060, 669,
	1060, 1070, 1071,
	1071, 1061, 1060,
	1061, 1071, 1072,
	1072, 1062, 1061,
	1062, 1072, 1073,
	1073, 1063, 1062,
	1063, 1073, 1074,
	1074, 1064, 1063,
	1064, 1074, 1075,
	1075, 1065, 1064,
	1065, 1075, 1076,
	1076, 1066, 1065,
	1066, 1076, 1077,
	1077, 1067, 1066,
	1067, 1077, 1078,
	1078, 1068, 1067,
	1068, 1078, 1079,
	1079, 1069, 1068,
	679, 689, 1080,
	1080, 1070, 679,
	1070, 1080, 1081,
	1081, 1071, 1070,
	1071, 1081, 1082,
	1082, 1072, 1071,
	1072, 1082, 1083,
	1083, 1073, 1072,
	1073, 1083, 1084,
	1084, 1074, 1073,
	1074, 1084, 1085,
	1085, 1075, 1074,
	1075, 1085, 1086,
	1086, 1076, 1075,
	1076, 1086, 1087,
	1087, 1077, 1076,
	1077, 1087, 1088,
	1088, 1078, 1077,
	1078, 1088, 1089,
	1089, 1079, 1078,
	689, 699, 1090,
	1090, 1080, 689,
	1080, 1090, 1091,
	1091, 1081, 1080,
	1081, 1091, 1092,
	1092, 1082, 1081,
	1082, 1092, 1093,
	1093, 1083, 1082,
	1083, 1093, 1094,
	1094, 1084, 1083,
	1084, 1094, 1095,
	1095, 1085, 1084,
	1085, 1095, 1096,
	1096, 1086, 1085,
	1086, 1096, 1097,
	1097, 1087, 1086,
	1087, 1097, 1098,
	1098, 1088, 1087,
	1088, 1098, 1099,
	1099, 1089, 1088,
	699, 709, 1100,
	1100, 1090, 699,
	1090, 1100, 1101,
	1101, 1091, 1090,
	1091, 1101, 1102,
	1102, 1092, 1091,
	1092, 1102, 1103,
	1103, 1093, 1092,
	1093, 1103, 1104,
	1104, 1094, 1093,
	1094, 1104, 1105,
	1105, 1095, 1094,
	1095, 1105, 1106,
	1106, 1096, 1095,
	1096, 1106, 1107,
	1107, 1097, 1096,
	1097, 1107, 1108,
	1108, 1098, 1097,
	1098, 1108, 1109,
	1109, 1099, 1098,
	709, 719, 1110,
	1110, 1100, 709,
	1100, 1110, 1111,
	1111, 1101, 1100,
	1101, 1111, 1112,
	1112, 1102, 1101,
	1102, 1112, 1113,
	1113, 1103, 1102,
	1103, 1113, 1114,
	1114, 1104, 1103,
	1104, 1114, 1115,
	1115, 1105, 1104,
	1105, 1115, 1116,
	1116, 1106, 1105,
	1106, 1116, 1117,
	1117, 1107, 1106,
	1107, 1117, 1118,
	1118, 1108, 1107,
	1108, 1118, 1119,
	1119, 1109, 1108,
	719, 729, 1120,
	1120, 1110, 719,
	1110, 1120, 1121,
	1121, 1111, 1110,
	1111, 1121, 1122,
	1122, 1112, 1111,
	1112, 1122, 1123,
	1123, 1113, 1112,
	1113, 1123, 1124,
	1124, 1114, 1113,
	1114, 1124, 1125,
	1125, 1115, 1114,
	1115, 1125, 1126,
	1126, 1116, 1115,
	1116, 1126, 1127,
	1127, 1117, 1116,
	1117, 1127, 1128,
	1128, 1118, 1117,
	1118, 1128, 1129,
	1129, 1119, 1118,
	729, 739, 1130,
	1130, 1120, 729,
	1120, 1130, 1131,
	1131, 1121, 1120,
	1121, 1131, 1132,
	1132, 1122, 1121,
	1122, 1132, 1133,
	1133, 1123, 1122,
	1123, 1133, 1134,
	1134, 1124, 1123,
	1124, 1134, 1135,
	1135, 1125, 1124,
	1125, 1135, 1136,
	1136, 1126, 1125,
	1126, 1136, 1137,
	1137, 1127, 1126,
	1127, 1137, 1138,
	1138, 1128, 1127,
	1128, 1138, 1139,
	1139, 1129, 1128,
	739, 749, 1140,
	1140, 1130, 739,
	1130, 1140, 1141,
	1141, 1131, 1130,
	1131, 1141, 1142,
	1142, 1132, 1131,
	1132, 1142, 1143,
	1143, 1133, 1132,
	1133, 1143, 1144,
	1144, 1134, 1133,
	1134, 1144, 1145,
	1145, 1135, 1134,
	1135, 1145, 1146,
	1146, 1136, 1135,
	1136, 1146, 1147,
	1147, 1137, 1136,
	1137, 1147, 1148,
	1148, 1138, 1137,
	1138, 1148, 1149,
	1149, 1139, 1138,
	749, 759, 1150,
	1150, 1140, 749,
	1140, 1150, 1151,
	1151, 1141, 1140,
	1141, 1151, 1152,
	1152, 1142, 1141,
	1142, 1152, 1153,
	1153, 1143, 1142,
	1143, 1153, 1154,
	1154, 1144, 1143,
	1144, 1154, 1155,
	1155, 1145, 1144,
	1145, 1155, 1156,
	1156, 1146, 1145,
	1146, 1156, 1157,
	1157, 1147, 1146,
	1147, 1157, 1158,
	1158, 1148, 1147,
	1148, 1158, 1159,
	1159, 1149, 1148,
	759, 769, 1160,
	1160, 1150, 759,
	1150, 1160, 1161,
	1161, 1151, 1150,
	1151, 1161, 1162,
	1162, 1152, 1151,
	1152, 1162, 1163,
	1163, 1153, 1152,
	1153, 1163, 1164,
	1164, 1154, 1153,
	1154, 1164, 1165,
	1165, 1155, 1154,
	1155, 1165, 1166,
	1166, 1156, 1155,
	1156, 1166, 1167,
	1167, 1157, 1156,
	1157, 1167, 1168,
	1168, 1158, 1157,
	1158, 1168, 1169,
	1169, 1159, 1158,
	769, 779, 1170,
	1170, 1160, 769,
	1160, 1170, 1171,
	1171, 1161, 1160,
	1161, 1171, 1172,
	1172, 1162, 1161,
	1162, 1172, 1173,
	1173, 1163, 1162,
	1163, 1173, 1174,
	1174, 1164, 1163,
	1164, 1174, 1175,
	1175, 1165, 1164,
	1165, 1175, 1176,
	1176, 1166, 1165,
	1166, 1176, 1177,
	1177, 1167, 1166,
	1167, 1177, 1178,
	1178, 1168, 1167,
	1168, 1178, 1179,
	1179, 1169, 1168,
	779, 789, 1180,
	1180, 1170, 779,
	1170, 1180, 1181,
	1181, 1171, 1170,
	1171, 1181, 1182,
	1182, 1172, 1171,
	1172, 1182, 1183,
	1183, 1173, 1172,
	1173, 1183, 1184,
	1184, 1174, 1173,
	1174, 1184, 1185,
	1185, 1175, 1174,
	1175, 1185, 1186,
	1186, 1176, 1175,
	1176, 1186, 1187,
	1187, 1177, 1176,
	1177, 1187, 1188,
	1188, 1178, 1177,
	1178, 1188, 1189,
	1189, 1179, 1178,
	789, 799, 1190,
	1190, 1180, 789,
	1180, 1190, 1191,
	1191, 1181, 1180,
	1181, 1191, 1192,
	1192, 1182, 1181,
	1182, 1192, 1193,
	1193, 1183, 1182,
	1183, 1193, 1194,
	1194, 1184, 1183,
	1184, 1194, 1195,
	1195, 1185, 1184,
	1185, 1195, 1196,
	1196, 1186, 1185,
	1186, 1196, 1197,
	1197, 1187, 1186,
	1187, 1197, 1198,
	1198, 1188, 1187,
	1188, 1198, 1199,
	1199, 1189, 1188,
	799, 809, 1200,
	1200, 1190, 799,
	1190, 1200, 1201,
	1201, 1191, 1190,
	1191, 1201, 1202,
	1202, 1192, 1191,
	1192, 1202, 1203,
	1203, 1193, 1192,
	1193, 1203, 1204,
	1204, 1194, 1193,
	1194, 1204, 1205,
	1205, 1195, 1194,
	1195, 1205, 1206,
	1206, 1196, 1195,
	1196, 1206, 1207,
	1207, 1197, 1196,
	1197, 1207, 1208,
	1208, 1198, 1197,
	1198, 1208, 1209,
	1209, 1199, 1198,
	809, 819, 1210,
	1210, 1200, 809,
	1200, 1210, 1211,
	1211, 1201, 1200,
	1201, 1211, 1212,
	1212, 1202, 1201,
	1202, 1212, 1213,
	1213, 1203, 1202,
	1203, 1213, 1214,
	1214, 1204, 1203,
	1204, 1214, 1215,
	1215, 1205, 1204,
	1205, 1215, 1216,
	1216, 1206, 1205,
	1206, 1216, 1217,
	1217, 1207, 1206,
	1207, 1217, 1218,
	1218, 1208, 1207,
	1208, 1218, 1219,
	1219, 1209, 1208,
	819, 829, 1220,
	1220, 1210, 819,
	1210, 1220, 1221,
	1221, 1211, 1210,
	1211, 1221, 1222,
	1222, 1212, 1211,
	1212, 1222, 1223,
	1223, 1213, 1212,
	1213, 1223, 1224,
	1224, 1214, 1213,
	1214, 1224, 1225,
	1225, 1215, 1214,
	1215, 1225, 1226,
	1226, 1216, 1215,
	1216, 1226, 1227,
	1227, 1217, 1216,
	1217, 1227, 1228,
	1228, 1218, 1217,
	1218, 1228, 1229,
	1229, 1219, 1218,
	829, 839, 1230,
	1230, 1220, 829,
	1220, 1230, 1231,
	1231, 1221, 1220,
	1221, 1231, 1232,
	1232, 1222, 1221,
	1222, 1232, 1233,
	1233, 1223, 1222,
	1223, 1233, 1234,
	1234, 1224, 1223,
	1224, 1234, 1235,
	1235, 1225, 1224,
	1225, 1235, 1236,
	1236, 1226, 1225,
	1226, 1236, 1237,
	1237, 1227, 1226,
	1227, 1237, 1238,
	1238, 1228, 1227,
	1228, 1238, 1239,
	1239, 1229, 1228,
	839, 459, 841,
	841, 1230, 839,
	1230, 841, 843,
	843, 1231, 1230,
	1231, 843, 845,
	845, 1232, 1231,
	1232, 845, 847,
	847, 1233, 1232,
	1233, 847, 849,
	849, 1234, 1233,
	1234, 849, 851,
	851, 1235, 1234,
	1235, 851, 853,
	853, 1236, 1235,
	1236, 853, 855,
	855, 1237, 1236,
	1237, 855, 857,
	857, 1238, 1237,
	1238, 857, 859,
	859, 1239, 1238,
	859, 858, 1240,
	1240, 1241, 859,
	1241, 1240, 1242,
	1242, 1243, 1241,
	1243, 1242, 1244,
	1244, 1245, 1243,
	1245, 1244, 1246,
	1246, 1247, 1245,
	1247, 1246, 1248,
	1248, 1249, 1247,
	1249, 1248, 1250,
	1250, 1251, 1249,
	1251, 1250, 1252,
	1252, 1253, 1251,
	1253, 1252, 1254,
	1254, 1255, 1253,
	1255, 1254, 1256,
	1256, 1257, 1255,
	1257, 1256, 1258,
	1258, 1258, 1257,
	858, 869, 1259,
	1259, 1240, 858,
	1240, 1259, 1260,
	1260, 1242, 1240,
	1242, 1260, 1261,
	1261, 1244, 1242,
	1244, 1261, 1262,
	1262, 1246, 1244,
	1246, 1262, 1263,
	1263, 1248, 1246,
	1248, 1263, 1264,
	1264, 1250, 1248,
	1250, 1264, 1265,
	1265, 1252, 1250,
	1252, 1265, 1266,
	1266, 1254, 1252,
	1254, 1266, 1267,
	1267, 1256, 1254,
	1256, 1267, 1258,
	1258, 1258, 1256,
	869, 879, 1268,
	1268, 1259, 869,
	1259, 1268, 1269,
	1269, 1260, 1259,
	1260, 1269, 1270,
	1270, 1261, 1260,
	1261, 1270, 1271,
	1271, 1262, 1261,
	1262, 1271, 1272,
	1272, 1263, 1262,
	1263, 1272, 1273,
	1273, 1264, 1263,
	1264, 1273, 1274,
	1274, 1265, 1264,
	1265, 1274, 1275,
	1275, 1266, 1265,
	1266, 1275, 1276,
	1276, 1267, 1266,
	1267, 1276, 1258,
	1258, 1258, 1267,
	879, 889, 1277,
	1277, 1268, 879,
	1268, 1277, 1278,
	1278, 1269, 1268,
	1269, 1278, 1279,
	1279, 1270, 1269,
	1270, 1279, 1280,
	1280, 1271, 1270,
	1271, 1280, 1281,
	1281, 1272, 1271,
	1272, 1281, 1282,
	1282, 1273, 1272,
	1273, 1282, 1283,
	1283, 1274, 1273,
	1274, 1283, 1284,
	1284, 1275, 1274,
	1275, 1284, 1285,
	1285, 1276, 1275,
	1276, 1285, 1258,
	1258, 1258, 1276,
	889, 899, 1286,
	1286, 1277, 889,
	1277, 1286, 1287,
	1287, 1278, 1277,
	1278, 1287, 1288,
	1288, 1279, 1278,
	1279, 1288, 1289,
	1289, 1280, 1279,
	1280, 1289, 1290,
	1290, 1281, 1280,
	1281, 1290, 1291,
	1291, 1282, 1281,
	1282, 1291, 1292,
	1292, 1283, 1282,
	1283, 1292, 1293,
	1293, 1284, 1283,
	1284, 1293, 1294,
	1294, 1285, 1284,
	1285, 1294, 1258,
	1258, 1258, 1285,
	899, 909, 1295,
	1295, 1286, 899,
	1286, 1295, 1296,
	1296, 1287, 1286,
	1287, 1296, 1297,
	1297, 1288, 1287,
	1288, 1297, 1298,
	1298, 1289, 1288,
	1289, 1298, 1299,
	1299, 1290, 1289,
	1290, 1299, 1300,
	1300, 1291, 1290,
	1291, 1300, 1301,
	1301, 1292, 1291,
	1292, 1301, 1302,
	1302, 1293, 1292,
	1293, 1302, 1303,
	1303, 1294, 1293,
	1294, 1303, 1258,
	1258, 1258, 1294,
	909, 919, 1304,
	1304, 1295, 909,
	1295, 1304, 1305,
	1305, 1296, 1295,
	1296, 1305, 1306,
	1306, 1297, 1296,
	1297, 1306, 1307,
	1307, 1298, 1297,
	1298, 1307, 1308,
	1308, 1299, 1298,
	1299, 1308, 1309,
	1309, 1300, 1299,
	1300, 1309, 1310,
	1310, 1301, 1300,
	1301, 1310, 1311,
	1311, 1302, 1301,
	1302, 1311, 1312,
	1312, 1303, 1302,
	1303, 1312, 1258,
	1258, 1258, 1303,
	919, 929, 1313,
	1313, 1304, 919,
	1304, 1313, 1314,
	1314, 1305, 1304,
	1305, 1314, 1315,
	1315, 1306, 1305,
	1306, 1315, 1316,
	1316, 1307, 1306,
	1307, 1316, 1317,
	1317, 1308, 1307,
	1308, 1317, 1318,
	1318, 1309, 1308,
	1309, 1318, 1319,
	1319, 1310, 1309,
	1310, 1319, 1320,
	1320, 1311, 1310,
	1311, 1320, 1321,
	1321, 1312, 1311,
	1312, 1321, 1258,
	1258, 1258, 1312,
	929, 939, 1322,
	1322, 1313, 929,
	1313, 1322, 1323,
	1323, 1314, 1313,
	1314, 1323, 1324,
	1324, 1315, 1314,
	1315, 1324, 1325,
	1325, 1316, 1315,
	1316, 1325, 1326,
	1326, 1317, 1316,
	1317, 1326, 1327,
	1327, 1318, 1317,
	1318, 1327, 1328,
	1328, 1319, 1318,
	1319, 1328, 1329,
	1329, 1320, 1319,
	1320, 1329, 1330,
	1330, 1321, 1320,
	1321, 1330, 1258,
	1258, 1258, 1321,
	939, 949, 1331,
	1331, 1322, 939,
	1322, 1331, 1332,
	1332, 1323, 1322,
	1323, 1332, 1333,
	1333, 1324, 1323,
	1324, 1333, 1334,
	1334, 1325, 1324,
	1325, 1334, 1335,
	1335, 1326, 1325,
	1326, 1335, 1336,
	1336, 1327, 1326,
	1327, 1336, 1337,
	1337, 1328, 1327,
	1328, 1337, 1338,
	1338, 1329, 1328,
	1329, 1338, 1339,
	1339, 1330, 1329,
	1330, 1339, 1258,
	1258, 1258, 1330,
	949, 959, 1340,
	1340, 1331, 949,
	1331, 1340, 1341,
	1341, 1332, 1331,
	1332, 1341, 1342,
	1342, 1333, 1332,
	1333, 1342, 1343,
	1343, 1334, 1333,
	1334, 1343, 1344,
	1344, 1335, 1334,
	1335, 1344, 1345,
	1345, 1336, 1335,
	1336, 1345, 1346,
	1346, 1337, 1336,
	1337, 1346, 1347,
	1347, 1338, 1337,
	1338, 1347, 1348,
	1348, 1339, 1338,
	1339, 1348, 1258,
	1258, 1258, 1339,
	959, 969, 1349,
	1349, 1340, 959,
	1340, 1349, 1350,
	1350, 1341, 1340,
	1341, 1350, 1351,
	1351, 1342, 1341,
	1342, 1351, 1352,
	1352, 1343, 1342,
	1343, 1352, 1353,
	1353, 1344, 1343,
	1344, 1353, 1354,
	1354, 1345, 1344,
	1345, 1354, 1355,
	1355, 1346, 1345,
	1346, 1355, 1356,
	1356, 1347, 1346,
	1347, 1356, 1357,
	1357, 1348, 1347,
	1348, 1357, 1258,
	1258, 1258, 1348,
	969, 979, 1358,
	1358, 1349, 969,
	1349, 1358, 1359,
	1359, 1350, 1349,
	1350, 1359, 1360,
	1360, 1351, 1350,
	1351, 1360, 1361,
	1361, 1352, 1351,
	1352, 1361, 1362,
	1362, 1353, 1352,
	1353, 1362, 1363,
	1363, 1354, 1353,
	1354, 1363, 1364,
	1364, 1355, 1354,
	1355, 1364, 1365,
	1365, 1356, 1355,
	1356, 1365, 1366,
	1366, 1357, 1356,
	1357, 1366, 1258,
	1258, 1258, 1357,
	979, 989, 1367,
	1367, 1358, 979,
	1358, 1367, 1368,
	1368, 1359, 1358,
	1359, 1368, 1369,
	1369, 1360, 1359,
	1360, 1369, 1370,
	1370, 1361, 1360,
	1361, 1370, 1371,
	1371, 1362, 1361,
	1362, 1371, 1372,
	1372, 1363, 1362,
	1363, 1372, 1373,
	1373, 1364, 1363,
	1364, 1373, 1374,
	1374, 1365, 1364,
	1365, 1374, 1375,
	1375, 1366, 1365,
	1366, 1375, 1258,
	1258, 1258, 1366,
	989, 999, 1376,
	1376, 1367, 989,
	1367, 1376, 1377,
	1377, 1368, 1367,
	1368, 1377, 1378,
	1378, 1369, 1368,
	1369, 1378, 1379,
	1379, 1370, 1369,
	1370, 1379, 1380,
	1380, 1371, 1370,
	1371, 1380, 1381,
	1381, 1372, 1371,
	1372, 1381, 1382,
	1382, 1373, 1372,
	1373, 1382, 1383,
	1383, 1374, 1373,
	1374, 1383, 1384,
	1384, 1375, 1374,
	1375, 1384, 1258,
	1258, 1258, 1375,
	999, 1009, 1385,
	1385, 1376, 999,
	1376, 1385, 1386,
	1386, 1377, 1376,
	1377, 1386, 1387,
	1387, 1378, 1377,
	1378, 1387, 1388,
	1388, 1379, 1378,
	1379, 1388, 1389,
	1389, 1380, 1379,
	1380, 1389, 1390,
	1390, 1381, 1380,
	1381, 1390, 1391,
	1391, 1382, 1381,
	1382, 1391, 1392,
	1392, 1383, 1382,
	1383, 1392, 1393,
	1393, 1384, 1383,
	1384, 1393, 1258,
	1258, 1258, 1384,
	1009, 1019, 1394,
	1394, 1385, 1009,
	1385, 1394, 1395,
	1395, 1386, 1385,
	1386, 1395, 1396,
	1396, 1387, 1386,
	1387, 1396, 1397,
	1397, 1388, 1387,
	1388, 1397, 1398,
	1398, 1389, 1388,
	1389, 1398, 1399,
	1399, 1390, 1389,
	1390, 1399, 1400,
	1400, 1391, 1390,
	1391, 1400, 1401,
	1401, 1392, 1391,
	1392, 1401, 1402,
	1402, 1393, 1392,
	1393, 1402, 1258,
	1258, 1258, 1393,
	1019, 1029, 1403,
	1403, 1394, 1019,
	1394, 1403, 1404,
	1404, 1395, 1394,
	1395, 1404, 1405,
	1405, 1396, 1395,
	1396, 1405, 1406,
	1406, 1397, 1396,
	1397, 1406, 1407,
	1407, 1398, 1397,
	1398, 1407, 1408,
	1408, 1399, 1398,
	1399, 1408, 1409,
	1409, 1400, 1399,
	1400, 1409, 1410,
	1410, 1401, 1400,
	1401, 1410, 1411,
	1411, 1402, 1401,
	1402, 1411, 1258,
	1258, 1258, 1402,
	1029, 1039, 1412,
	1412, 1403, 1029,
	1403, 1412, 1413,
	1413, 1404, 1403,
	1404, 1413, 1414,
	1414, 1405, 1404,
	1405, 1414, 1415,
	1415, 1406, 1405,
	1406, 1415, 1416,
	1416, 1407, 1406,
	1407, 1416, 1417,
	1417, 1408, 1407,
	1408, 1417, 1418,
	1418, 1409, 1408,
	1409, 1418, 1419,
	1419, 1410, 1409,
	1410, 1419, 1420,
	1420, 1411, 1410,
	1411, 1420, 1258,
	1258, 1258, 1411,
	1039, 1049, 1421,
	1421, 1412, 1039,
	1412, 1421, 1422,
	1422, 1413, 1412,
	1413, 1422, 1423,
	1423, 1414, 1413,
	1414, 1423, 1424,
	1424, 1415, 1414,
	1415, 1424, 1425,
	1425, 1416, 1415,
	1416, 1425, 1426,
	1426, 1417, 1416,
	1417, 1426, 1427,
	1427, 1418, 1417,
	1418, 1427, 1428,
	1428, 1419, 1418,
	1419, 1428, 1429,
	1429, 1420, 1419,
	1420, 1429, 1258,
	1258, 1258, 1420,
	1049, 1059, 1430,
	1430, 1421, 1049,
	1421, 1430, 1431,
	1431, 1422, 1421,
	1422, 1431, 1432,
	1432, 1423, 1422,
	1423, 1432, 1433,
	1433, 1424, 1423,
	1424, 1433, 1434,
	1434, 1425, 1424,
	1425, 1434, 1435,
	1435, 1426, 1425,
	1426, 1435, 1436,
	1436, 1427, 1426,
	1427, 1436, 1437,
	1437, 1428, 1427,
	1428, 1437, 1438,
	1438, 1429, 1428,
	1429, 1438, 1258,
	1258, 1258, 1429,
	1059, 1069, 1439,
	1439, 1430, 1059,
	1430, 1439, 1440,
	1440, 1431, 1430,
	1431, 1440, 1441,
	1441, 1432, 1431,
	1432, 1441, 1442,
	1442, 1433, 1432,
	1433, 1442, 1443,
	1443, 1434, 1433,
	1434, 1443, 1444,
	1444, 1435, 1434,
	1435, 1444, 1445,
	1445, 1436, 1435,
	1436, 1445, 1446,
	1446, 1437, 1436,
	1437, 1446, 1447,
	1447, 1438, 1437,
	1438, 1447, 1258,
	1258, 1258, 1438,
	1069, 1079, 1448,
	1448, 1439, 1069,
	1439, 1448, 1449,
	1449, 1440, 1439,
	1440, 1449, 1450,
	1450, 1441, 1440,
	1441, 1450, 1451,
	1451, 1442, 1441,
	1442, 1451, 1452,
	1452, 1443, 1442,
	1443, 1452, 1453,
	1453, 1444, 1443,
	1444, 1453, 1454,
	1454, 1445, 1444,
	1445, 1454, 1455,
	1455, 1446, 1445,
	1446, 1455, 1456,
	1456, 1447, 1446,
	1447, 1456, 1258,
	1258, 1258, 1447,
	1079, 1089, 1457,
	1457, 1448, 1079,
	1448, 1457, 1458,
	1458, 1449, 1448,
	1449, 1458, 1459,
	1459, 1450, 1449,
	1450, 1459, 1460,
	1460, 1451, 1450,
	1451, 1460, 1461,
	1461, 1452, 1451,
	1452, 1461, 1462,
	1462, 1453, 1452,
	1453, 1462, 1463,
	1463, 1454, 1453,
	1454, 1463, 1464,
	1464, 1455, 1454,
	1455, 1464, 1465,
	1465, 1456, 1455,
	1456, 1465, 1258,
	1258, 1258, 1456,
	1089, 1099, 1466,
	1466, 1457, 1089,
	1457, 1466, 1467,
	1467, 1458, 1457,
	1458, 1467, 1468,
	1468, 1459, 1458,
	1459, 1468, 1469,
	1469, 1460, 1459,
	1460, 1469, 1470,
	1470, 1461, 1460,
	1461, 1470, 1471,
	1471, 1462, 1461,
	1462, 1471, 1472,
	1472, 1463, 1462,
	1463, 1472, 1473,
	1473, 1464, 1463,
	1464, 1473, 1474,
	1474, 1465, 1464,
	1465, 1474, 1258,
	1258, 1258, 1465,
	1099, 1109, 1475,
	1475, 1466, 1099,
	1466, 1475, 1476,
	1476, 1467, 1466,
	1467, 1476, 1477,
	1477, 1468, 1467,
	1468, 1477, 1478,
	1478, 1469, 1468,
	1469, 1478, 1479,
	1479, 1470, 1469,
	1470, 1479, 1480,
	1480, 1471, 1470,
	1471, 1480, 1481,
	1481, 1472, 1471,
	1472, 1481, 1482,
	1482, 1473, 1472,
	1473, 1482, 1483,
	1483, 1474, 1473,
	1474, 1483, 1258,
	1258, 1258, 1474,
	1109, 1119, 1484,
	1484, 1475, 1109,
	1475, 1484, 1485,
	1485, 1476, 1475,
	1476, 1485, 1486,
	1486, 1477, 1476,
	1477, 1486, 1487,
	1487, 1478, 1477,
	1478, 1487, 1488,
	1488, 1479, 1478,
	1479, 1488, 1489,
	1489, 1480, 1479,
	1480, 1489, 1490,
	1490, 1481, 1480,
	1481, 1490, 1491,
	1491, 1482, 1481,
	1482, 1491, 1492,
	1492, 1483, 1482,
	1483, 1492, 1258,
	1258, 1258, 1483,
	1119, 1129, 1493,
	1493, 1484, 1119,
	1484, 1493, 1494,
	1494, 1485, 1484,
	1485, 1494, 1495,
	1495, 1486, 1485,
	1486, 1495, 1496,
	1496, 1487, 1486,
	1487, 1496, 1497,
	1497, 1488, 1487,
	1488, 1497, 1498,
	1498, 1489, 1488,
	1489, 1498, 1499,
	1499, 1490, 1489,
	1490, 1499, 1500,
	1500, 1491, 1490,
	1491, 1500, 1501,
	1501, 1492, 1491,
	1492, 1501, 1258,
	1258, 1258, 1492,
	1129, 1139, 1502,
	1502, 1493, 1129,
	1493, 1502, 1503,
	1503, 1494, 1493,
	1494, 1503, 1504,
	1504, 1495, 1494,
	1495, 1504, 1505,
	1505, 1496, 1495,
	1496, 1505, 1506,
	1506, 1497, 1496,
	1497, 1506, 1507,
	1507, 1498, 1497,
	1498, 1507, 1508,
	1508, 1499, 1498,
	1499, 1508, 1509,
	1509, 1500, 1499,
	1500, 1509, 1510,
	1510, 1501, 1500,
	1501, 1510, 1258,
	1258, 1258, 1501,
	1139, 1149, 1511,
	1511, 1502, 1139,
	1502, 1511, 1512,
	1512, 1503, 1502,
	1503, 1512, 1513,
	1513, 1504, 1503,
	1504, 1513, 1514,
	1514, 1505, 1504,
	1505, 1514, 1515,
	1515, 1506, 1505,
	1506, 1515, 1516,
	1516, 1507, 1506,
	1507, 1516, 1517,
	1517, 1508, 1507,
	1508, 1517, 1518,
	1518, 1509, 1508,
	1509, 1518, 1519,
	1519, 1510, 1509,
	1510, 1519, 1258,
	1258, 1258, 1510,
	1149, 1159, 1520,
	1520, 1511, 1149,
	1511, 1520, 1521,
	1521, 1512, 1511,
	1512, 1521, 1522,
	1522, 1513, 1512,
	1513, 1522, 1523,
	1523, 1514, 1513,
	1514, 1523, 1524,
	1524, 1515, 1514,
	1515, 1524, 1525,
	1525, 1516, 1515,
	1516, 1525, 1526,
	1526, 1517, 1516,
	1517, 1526, 1527,
	1527, 1518, 1517,
	1518, 1527, 1528,
	1528, 1519, 1518,
	1519, 1528, 1258,
	1258, 1258, 1519,
	1159, 1169, 1529,
	1529, 1520, 1159,
	1520, 1529, 1530,
	1530, 1521, 1520,
	1521, 1530, 1531,
	1531, 1522, 1521,
	1522, 1531, 1532,
	1532, 1523, 1522,
	1523, 1532, 1533,
	1533, 1524, 1523,
	1524, 1533, 1534,
	1534, 1525, 1524,
	1525, 1534, 1535,
	1535, 1526, 1525,
	1526, 1535, 1536,
	1536, 1527, 1526,
	1527, 1536, 1537,
	1537, 1528, 1527,
	1528, 1537, 1258,
	1258, 1258, 1528,
	1169, 1179, 1538,
	1538, 1529, 1169,
	1529, 1538, 1539,
	1539, 1530, 1529,
	1530, 1539, 1540,
	1540, 1531, 1530,
	1531, 1540, 1541,
	1541, 1532, 1531,
	1532, 1541, 1542,
	1542, 1533, 1532,
	1533, 1542, 1543,
	1543, 1534, 1533,
	1534, 1543, 1544,
	1544, 1535, 1534,
	1535, 1544, 1545,
	1545, 1536, 1535,
	1536, 1545, 1546,
	1546, 1537, 1536,
	1537, 1546, 1258,
	1258, 1258, 1537,
	1179, 1189, 1547,
	1547, 1538, 1179,
	1538, 1547, 1548,
	1548, 1539, 1538,
	1539, 1548, 1549,
	1549, 1540, 1539,
	1540, 1549, 1550,
	1550, 1541, 1540,
	1541, 1550, 1551,
	1551, 1542, 1541,
	1542, 1551, 1552,
	1552, 1543, 1542,
	1543, 1552, 1553,
	1553, 1544, 1543,
	1544, 1553, 1554,
	1554, 1545, 1544,
	1545, 1554, 1555,
	1555, 1546, 1545,
	1546, 1555, 1258,
	1258, 1258, 1546,
	1189, 1199, 1556,
	1556, 1547, 1189,
	1547, 1556, 1557,
	1557, 1548, 1547,
	1548, 1557, 1558,
	1558, 1549, 1548,
	1549, 1558, 1559,
	1559, 1550, 1549,
	1550, 1559, 1560,
	1560, 1551, 1550,
	1551, 1560, 1561,
	1561, 1552, 1551,
	1552, 1561, 1562,
	1562, 1553, 1552,
	1553, 1562, 1563,
	1563, 1554, 1553,
	1554, 1563, 1564,
	1564, 1555, 1554,
	1555, 1564, 1258,
	1258, 1258, 1555,
	1199, 1209, 1565,
	1565, 1556, 1199,
	1556, 1565, 1566,
	1566, 1557, 1556,
	1557, 1566, 1567,
	1567, 1558, 1557,
	1558, 1567, 1568,
	1568, 1559, 1558,
	1559, 1568, 1569,
	1569, 1560, 1559,
	1560, 1569, 1570,
	1570, 1561, 1560,
	1561, 1570, 1571,
	1571, 1562, 1561,
	1562, 1571, 1572,
	1572, 1563, 1562,
	1563, 1572, 1573,
	1573, 1564, 1563,
	1564, 1573, 1258,
	1258, 1258, 1564,
	1209, 1219, 1574,
	1574, 1565, 1209,
	1565, 1574, 1575,
	1575, 1566, 1565,
	1566, 1575, 1576,
	1576, 1567, 1566,
	1567, 1576, 1577,
	1577, 1568, 1567,
	1568, 1577, 1578,
	1578, 1569, 1568,
	1569, 1578, 1579,
	1579, 1570, 1569,
	1570, 1579, 1580,
	1580, 1571, 1570,
	1571, 1580, 1581,
	1581, 1572, 1571,
	1572, 1581, 1582,
	1582, 1573, 1572,
	1573, 1582, 1258,
	1258, 1258, 1573,
	1219, 1229, 1583,
	1583, 1574, 1219,
	1574, 1583, 1584,
	1584, 1575, 1574,
	1575, 1584, 1585,
	1585, 1576, 1575,
	1576, 1585, 1586,
	1586, 1577, 1576,
	1577, 1586, 1587,
	1587, 1578, 1577,
	1578, 1587, 1588,
	1588, 1579, 1578,
	1579, 1588, 1589,
	1589, 1580, 1579,
	1580, 1589, 1590,
	1590, 1581, 1580,
	1581, 1590, 1591,
	1591, 1582, 1581,
	1582, 1591, 1258,
	1258, 1258, 1582,
	1229, 1239, 1592,
	1592, 1583, 1229,
	1583, 1592, 1593,
	1593, 1584, 1583,
	1584, 1593, 1594,
	1594, 1585, 1584,
	1585, 1594, 1595,
	1595, 1586, 1585,
	1586, 1595, 1596,
	1596, 1587, 1586,
	1587, 1596, 1597,
	1597, 1588, 1587,
	1588, 1597, 1598,
	1598, 1589, 1588,
	1589, 1598, 1599,
	1599, 1590, 1589,
	1590, 1599, 1600,
	1600, 1591, 1590,
	1591, 1600, 1258,
	1258, 1258, 1591,
	1239, 859, 1241,
	1241, 1592, 1239,
	1592, 1241, 1243,
	1243, 1593, 1592,
	1593, 1243, 1245,
	1245, 1594, 1593,
	1594, 1245, 1247,
	1247, 1595, 1594,
	1595, 1247, 1249,
	1249, 1596, 1595,
	1596, 1249, 1251,
	1251, 1597, 1596,
	1597, 1251, 1253,
	1253, 1598, 1597,
	1598, 1253, 1255,
	1255, 1599, 1598,
	1599, 1255, 1257,
	1257, 1600, 1599,
	1600, 1257, 1258,
	1258, 1258, 1600,
	1601, 1602, 1603,
	1603, 1604, 1601,
	1604, 1603, 1605,
	1605, 1606, 1604,
	1606, 1605, 1607,
	1607, 1608, 1606,
	1608, 1607, 1609,
	1609, 1610, 1608,
	1610, 1609, 1611,
	1611, 1612, 1610,
	1612, 1611, 1613,
	1613, 1614, 1612,
	1614, 1613, 1615,
	1615, 1616, 1614,
	1616, 1615, 1617,
	1617, 1618, 1616,
	1618, 1617, 1619,
	1619, 1620, 1618,
	1620, 1619, 1621,
	1621, 1622, 1620,
	1602, 1623, 1624,
	1624, 1603, 1602,
	1603, 1624, 1625,
	1625, 1605, 1603,
	1605, 1625, 1626,
	1626, 1607, 1605,
	1607, 1626, 1627,
	1627, 1609, 1607,
	1609, 1627, 1628,
	1628, 1611, 1609,
	1611, 1628, 1629,
	1629, 1613, 1611,
	1613, 1629, 1630,
	1630, 1615, 1613,
	1615, 1630, 1631,
	1631, 1617, 1615,
	1617, 1631, 1632,
	1632, 1619, 1617,
	1619, 1632, 1633,
	1633, 1621, 1619,
	1623, 1634, 1635,
	1635, 1624, 1623,
	1624, 1635, 1636,
	1636, 1625, 1624,
	1625, 1636, 1637,
	1637, 1626, 1625,
	1626, 1637, 1638,
	1638, 1627, 1626,
	1627, 1638, 1639,
	1639, 1628, 1627,
	1628, 1639, 1640,
	1640, 1629, 1628,
	1629, 1640, 1641,
	1641, 1630, 1629,
	1630, 1641, 1642,
	1642, 1631, 1630,
	1631, 1642, 1643,
	1643, 1632, 1631,
	1632, 1643, 1644,
	1644, 1633, 1632,
	1634, 1645, 1646,
	1646, 1635, 1634,
	1635, 1646, 1647,
	1647, 1636, 1635,
	1636, 1647, 1648,
	1648, 1637, 1636,
	1637, 1648, 1649,
	1649, 1638, 1637,
	1638, 1649, 1650,
	1650, 1639, 1638,
	1639, 1650, 1651,
	1651, 1640, 1639,
	1640, 1651, 1652,
	1652, 1641, 1640,
	1641, 1652, 1653,
	1653, 1642, 1641,
	1642, 1653, 1654,
	1654, 1643, 1642,
	1643, 1654, 1655,
	1655, 1644, 1643,
	1645, 1656, 1657,
	1657, 1646, 1645,
	1646, 1657, 1658,
	1658, 1647, 1646,
	1647, 1658, 1659,
	1659, 1648, 1647,
	1648, 1659, 1660,
	1660, 1649, 1648,
	1649, 1660, 1661,
	1661, 1650, 1649,
	1650, 1661, 1662,
	1662, 1651, 1650,
	1651, 1662, 1663,
	1663, 1652, 1651,
	1652, 1663, 1664,
	1664, 1653, 1652,
	1653, 1664, 1665,
	1665, 1654, 1653,
	1654, 1665, 1666,
	1666, 1655, 1654,
	1656, 1667, 1668,
	1668, 1657, 1656,
	1657, 1668, 1669,
	1669, 1658, 1657,
	1658, 1669, 1670,
	1670, 1659, 1658,
	1659, 1670, 1671,
	1671, 1660, 1659,
	1660, 1671, 1672,
	1672, 1661, 1660,
	1661, 1672, 1673,
	1673, 1662, 1661,
	1662, 1673, 1674,
	1674, 1663, 1662,
	1663, 1674, 1675,
	1675, 1664, 1663,
	1664, 1675, 1676,
	1676, 1665, 1664,
	1665, 1676, 1677,
	1677, 1666, 1665,
	1667, 1678, 1679,
	1679, 1668, 1667,
	1668, 1679, 1680,
	1680, 1669, 1668,
	1669, 1680, 1681,
	1681, 1670, 1669,
	1670, 1681, 1682,
	1682, 1671, 1670,
	1671, 1682, 1683,
	1683, 1672, 1671,
	1672, 1683, 1684,
	1684, 1673, 1672,
	1673, 1684, 1685,
	1685, 1674, 1673,
	1674, 1685, 1686,
	1686, 1675, 1674,
	1675, 1686, 1687,
	1687, 1676, 1675,
	1676, 1687, 1688,
	1688, 1677, 1676,
	1678, 1689, 1690,
	1690, 1679, 1678,
	1679, 1690, 1691,
	1691, 1680, 1679,
	1680, 1691, 1692,
	1692, 1681, 1680,
	1681, 1692, 1693,
	1693, 1682, 1681,
	1682, 1693, 1694,
	1694, 1683, 1682,
	1683, 1694, 1695,
	1695, 1684, 1683,
	1684, 1695, 1696,
	1696, 1685, 1684,
	1685, 1696, 1697,
	1697, 1686, 1685,
	1686, 1697, 1698,
	1698, 1687, 1686,
	1687, 1698, 1699,
	1699, 1688, 1687,
	1689, 1700, 1701,
	1701, 1690, 1689,
	1690, 1701, 1702,
	1702, 1691, 1690,
	1691, 1702, 1703,
	1703, 1692, 1691,
	1692, 1703, 1704,
	1704, 1693, 1692,
	1693, 1704, 1705,
	1705, 1694, 1693,
	1694, 1705, 1706,
	1706, 1695, 1694,
	1695, 1706, 1707,
	1707, 1696, 1695,
	1696, 1707, 1708,
	1708, 1697, 1696,
	1697, 1708, 1709,
	1709, 1698, 1697,
	1698, 1709, 1710,
	1710, 1699, 1698,
	1700, 1711, 1712,
	1712, 1701, 1700,
	1701, 1712, 1713,
	1713, 1702, 1701,
	1702, 1713, 1714,
	1714, 1703, 1702,
	1703, 1714, 1715,
	1715, 1704, 1703,
	1704, 1715, 1716,
	1716, 1705, 1704,
	1705, 1716, 1717,
	1717, 1706, 1705,
	1706, 1717, 1718,
	1718, 1707, 1706,
	1707, 1718, 1719,
	1719, 1708, 1707,
	1708, 1719, 1720,
	1720, 1709, 1708,
	1709, 1720, 1721,
	1721, 1710, 1709,
	1711, 1722, 1723,
	1723, 1712, 1711,
	1712, 1723, 1724,
	1724, 1713, 1712,
	1713, 1724, 1725,
	1725, 1714, 1713,
	1714, 1725, 1726,
	1726, 1715, 1714,
	1715, 1726, 1727,
	1727, 1716, 1715,
	1716, 1727, 1728,
	1728, 1717, 1716,
	1717, 1728, 1729,
	1729, 1718, 1717,
	1718, 1729, 1730,
	1730, 1719, 1718,
	1719, 1730, 1731,
	1731, 1720, 1719,
	1720, 1731, 1732,
	1732, 1721, 1720,
	1722, 1733, 1734,
	1734, 1723, 1722,
	1723, 1734, 1735,
	1735, 1724, 1723,
	1724, 1735, 1736,
	1736, 1725, 1724,
	1725, 1736, 1737,
	1737, 1726, 1725,
	1726, 1737, 1738,
	1738, 1727, 1726,
	1727, 1738, 1739,
	1739, 1728, 1727,
	1728, 1739, 1740,
	1740, 1729, 1728,
	1729, 1740, 1741,
	1741, 1730, 1729,
	1730, 1741, 1742,
	1742, 1731, 1730,
	1731, 1742, 1743,
	1743, 1732, 1731,
	1733, 1744, 1745,
	1745, 1734, 1733,
	1734, 1745, 1746,
	1746, 1735, 1734,
	1735, 1746, 1747,
	1747, 1736, 1735,
	1736, 1747, 1748,
	1748, 1737, 1736,
	1737, 1748, 1749,
	1749, 1738, 1737,
	1738, 1749, 1750,
	1750, 1739, 1738,
	1739, 1750, 1751,
	1751, 1740, 1739,
	1740, 1751, 1752,
	1752, 1741, 1740,
	1741, 1752, 1753,
	1753, 1742, 1741,
	1742, 1753, 1754,
	1754, 1743, 1742,
	1744, 1755, 1756,
	1756, 1745, 1744,
	1745, 1756, 1757,
	1757, 1746, 1745,
	1746, 1757, 1758,
	1758, 1747, 1746,
	1747, 1758, 1759,
	1759, 1748, 1747,
	1748, 1759, 1760,
	1760, 1749, 1748,
	1749, 1760, 1761,
	1761, 1750, 1749,
	1750, 1761, 1762,
	1762, 1751, 1750,
	1751, 1762, 1763,
	1763, 1752, 1751,
	1752, 1763, 1764,
	1764, 1753, 1752,
	1753, 1764, 1765,
	1765, 1754, 1753,
	1755, 1766, 1767,
	1767, 1756, 1755,
	1756, 1767, 1768,
	1768, 1757, 1756,
	1757, 1768, 1769,
	1769, 1758, 1757,
	1758, 1769, 1770,
	1770, 1759, 1758,
	1759, 1770, 1771,
	1771, 1760, 1759,
	1760, 1771, 1772,
	1772, 1761, 1760,
	1761, 1772, 1773,
	1773, 1762, 1761,
	1762, 1773, 1774,
	1774, 1763, 1762,
	1763, 1774, 1775,
	1775, 1764, 1763,
	1764, 1775, 1776,
	1776, 1765, 1764,
	1766, 1777, 1778,
	1778, 1767, 1766,
	1767, 1778, 1779,
	1779, 1768, 1767,
	1768, 1779, 1780,
	1780, 1769, 1768,
	1769, 1780, 1781,
	1781, 1770, 1769,
	1770, 1781, 1782,
	1782, 1771, 1770,
	1771, 1782, 1783,
	1783, 1772, 1771,
	1772, 1783, 1784,
	1784, 1773, 1772,
	1773, 1784, 1785,
	1785, 1774, 1773,
	1774, 1785, 1786,
	1786, 1775, 1774,
	1775, 1786, 1787,
	1787, 1776, 1775,
	1777, 1788, 1789,
	1789, 1778, 1777,
	1778, 1789, 1790,
	1790, 1779, 1778,
	1779, 1790, 1791,
	1791, 1780, 1779,
	1780, 1791, 1792,
	1792, 1781, 1780,
	1781, 1792, 1793,
	1793, 1782, 1781,
	1782, 1793, 1794,
	1794, 1783, 1782,
	1783, 1794, 1795,
	1795, 1784, 1783,
	1784, 1795, 1796,
	1796, 1785, 1784,
	1785, 1796, 1797,
	1797, 1786, 1785,
	1786, 1797, 1798,
	1798, 1787, 1786,
	1788, 1799, 1800,
	1800, 1789, 1788,
	1789, 1800, 1801,
	1801, 1790, 1789,
	1790, 1801, 1802,
	1802, 1791, 1790,
	1791, 1802, 1803,
	1803, 1792, 1791,
	1792, 1803, 1804,
	1804, 1793, 1792,
	1793, 1804, 1805,
	1805, 1794, 1793,
	1794, 1805, 1806,
	1806, 1795, 1794,
	1795, 1806, 1807,
	1807, 1796, 1795,
	1796, 1807, 1808,
	1808, 1797, 1796,
	1797, 1808, 1809,
	1809, 1798, 1797,
	1799, 1810, 1811,
	1811, 1800, 1799,
	1800, 1811, 1812,
	1812, 1801, 1800,
	1801, 1812, 1813,
	1813, 1802, 1801,
	1802, 1813, 1814,
	1814, 1803, 1802,
	1803, 1814, 1815,
	1815, 1804, 1803,
	1804, 1815, 1816,
	1816, 1805, 1804,
	1805, 1816, 1817,
	1817, 1806, 1805,
	1806, 1817, 1818,
	1818, 1807, 1806,
	1807, 1818, 1819,
	1819, 1808, 1807,
	1808, 1819, 1820,
	1820, 1809, 1808,
	1810, 1601, 1604,
	1604, 1811, 1810,
	1811, 1604, 1606,
	1606, 1812, 1811,
	1812, 1606, 1608,
	1608, 1813, 1812,
	1813, 1608, 1610,
	1610, 1814, 1813,
	1814, 1610, 1612,
	1612, 1815, 1814,
	1815, 1612, 1614,
	1614, 1816, 1815,
	1816, 1614, 1616,
	1616, 1817, 1816,
	1817, 1616, 1618,
	1618, 1818, 1817,
	1818, 1618, 1620,
	1620, 1819, 1818,
	1819, 1620, 1622,
	1622, 1820, 1819,
	1622, 1621, 1821,
	1821, 1822, 1622,
	1822, 1821, 1823,
	1823, 1824, 1822,
	1824, 1823, 1825,
	1825, 1826, 1824,
	1826, 1825, 1827,
	1827, 1828, 1826,
	1828, 1827, 1829,
	1829, 1830, 1828,
	1830, 1829, 1831,
	1831, 1832, 1830,
	1832, 1831, 1833,
	1833, 1834, 1832,
	1834, 1833, 1835,
	1835, 1836, 1834,
	1836, 1835, 1837,
	1837, 1838, 1836,
	1838, 1837, 1839,
	1839, 1840, 1838,
	1621, 1633, 1841,
	1841, 1821, 1621,
	1821, 1841, 1842,
	1842, 1823, 1821,
	1823, 1842, 1843,
	1843, 1825, 1823,
	1825, 1843, 1844,
	1844, 1827, 1825,
	1827, 1844, 1845,
	1845, 1829, 1827,
	1829, 1845, 1846,
	1846, 1831, 1829,
	1831, 1846, 1847,
	1847, 1833, 1831,
	1833, 1847, 1848,
	1848, 1835, 1833,
	1835, 1848, 1849,
	1849, 1837, 1835,
	1837, 1849, 1850,
	1850, 1839, 1837,
	1633, 1644, 1851,
	1851, 1841, 1633,
	1841, 1851, 1852,
	1852, 1842, 1841,
	1842, 1852, 1853,
	1853, 1843, 1842,
	1843, 1853, 1854,
	1854, 1844, 1843,
	1844, 1854, 1855,
	1855, 1845, 1844,
	1845, 1855, 1856,
	1856, 1846, 1845,
	1846, 1856, 1857,
	1857, 1847, 1846,
	1847, 1857, 1858,
	1858, 1848, 1847,
	1848, 1858, 1859,
	1859, 1849, 1848,
	1849, 1859, 1860,
	1860, 1850, 1849,
	1644, 1655, 1861,
	1861, 1851, 1644,
	1851, 1861, 1862,
	1862, 1852, 1851,
	1852, 1862, 1863,
	1863, 1853, 1852,
	1853, 1863, 1864,
	1864, 1854, 1853,
	1854, 1864, 1865,
	1865, 1855, 1854,
	1855, 1865, 1866,
	1866, 1856, 1855,
	1856, 1866, 1867,
	1867, 1857, 1856,
	1857, 1867, 1868,
	1868, 1858, 1857,
	1858, 1868, 1869,
	1869, 1859, 1858,
	1859, 1869, 1870,
	1870, 1860, 1859,
	1655, 1666, 1871,
	1871, 1861, 1655,
	1861, 1871, 1872,
	1872, 1862, 1861,
	1862, 1872, 1873,
	1873, 1863, 1862,
	1863, 1873, 1874,
	1874, 1864, 1863,
	1864, 1874, 1875,
	1875, 1865, 1864,
	1865, 1875, 1876,
	1876, 1866, 1865,
	1866, 1876, 1877,
	1877, 1867, 1866,
	1867, 1877, 1878,
	1878, 1868, 1867,
	1868, 1878, 1879,
	1879, 1869, 1868,
	1869, 1879, 1880,
	1880, 1870, 1869,
	1666, 1677, 1881,
	1881, 1871, 1666,
	1871, 1881, 1882,
	1882, 1872, 1871,
	1872, 1882, 1883,
	1883, 1873, 1872,
	1873, 1883, 1884,
	1884, 1874, 1873,
	1874, 1884, 1885,
	1885, 1875, 1874,
	1875, 1885, 1886,
	1886, 1876, 1875,
	1876, 1886, 1887,
	1887, 1877, 1876,
	1877, 1887, 1888,
	1888, 1878, 1877,
	1878, 1888, 1889,
	1889, 1879, 1878,
	1879, 1889, 1890,
	1890, 1880, 1879,
	1677, 1688, 1891,
	1891, 1881, 1677,
	1881, 1891, 1892,
	1892, 1882, 1881,
	1882, 1892, 1893,
	1893, 1883, 1882,
	1883, 1893, 1894,
	1894, 1884, 1883,
	1884, 1894, 1895,
	1895, 1885, 1884,
	1885, 1895, 1896,
	1896, 1886, 1885,
	1886, 1896, 1897,
	1897, 1887, 1886,
	1887, 1897, 1898,
	1898, 1888, 1887,
	1888, 1898, 1899,
	1899, 1889, 1888,
	1889, 1899, 1900,
	1900, 1890, 1889,
	1688, 1699, 1901,
	1901, 1891, 1688,
	1891, 1901, 1902,
	1902, 1892, 1891,
	1892, 1902, 1903,
	1903, 1893, 1892,
	1893, 1903, 1904,
	1904, 1894, 1893,
	1894, 1904, 1905,
	1905, 1895, 1894,
	1895, 1905, 1906,
	1906, 1896, 1895,
	1896, 1906, 1907,
	1907, 1897, 1896,
	1897, 1907, 1908,
	1908, 1898, 1897,
	1898, 1908, 1909,
	1909, 1899, 1898,
	1899, 1909, 1910,
	1910, 1900, 1899,
	1699, 1710, 1911,
	1911, 1901, 1699,
	1901, 1911, 1912,
	1912, 1902, 1901,
	1902, 1912, 1913,
	1913, 1903, 1902,
	1903, 1913, 1914,
	1914, 1904, 1903,
	1904, 1914, 1915,
	1915, 1905, 1904,
	1905, 1915, 1916,
	1916, 1906, 1905,
	1906, 1916, 1917,
	1917, 1907, 1906,
	1907, 1917, 1918,
	1918, 1908, 1907,
	1908, 1918, 1919,
	1919, 1909, 1908,
	1909, 1919, 1920,
	1920, 1910, 1909,
	1710, 1721, 1921,
	1921, 1911, 1710,
	1911, 1921, 1922,
	1922, 1912, 1911,
	1912, 1922, 1923,
	1923, 1913, 1912,
	1913, 1923, 1924,
	1924, 1914, 1913,
	1914, 1924, 1925,
	1925, 1915, 1914,
	1915, 1925, 1926,
	1926, 1916, 1915,
	1916, 1926, 1927,
	1927, 1917, 1916,
	1917, 1927, 1928,
	1928, 1918, 1917,
	1918, 1928, 1929,
	1929, 1919, 1918,
	1919, 1929, 1930,
	1930, 1920, 1919,
	1721, 1732, 1931,
	1931, 1921, 1721,
	1921, 1931, 1932,
	1932, 1922, 1921,
	1922, 1932, 1933,
	1933, 1923, 1922,
	1923, 1933, 1934,
	1934, 1924, 1923,
	1924, 1934, 1935,
	1935, 1925, 1924,
	1925, 1935, 1936,
	1936, 1926, 1925,
	1926, 1936, 1937,
	1937, 1927, 1926,
	1927, 1937, 1938,
	1938, 1928, 1927,
	1928, 1938, 1939,
	1939, 1929, 1928,
	1929, 1939, 1940,
	1940, 1930, 1929,
	1732, 1743, 1941,
	1941, 1931, 1732,
	1931, 1941, 1942,
	1942, 1932, 1931,
	1932, 1942, 1943,
	1943, 1933, 1932,
	1933, 1943, 1944,
	1944, 1934, 1933,
	1934, 1944, 1945,
	1945, 1935, 1934,
	1935, 1945, 1946,
	1946, 1936, 1935,
	1936, 1946, 1947,
	1947, 1937, 1936,
	1937, 1947, 1948,
	1948, 1938, 1937,
	1938, 1948, 1949,
	1949, 1939, 1938,
	1939, 1949, 1950,
	1950, 1940, 1939,
	1743, 1754, 1951,
	1951, 1941, 1743,
	1941, 1951, 1952,
	1952, 1942, 1941,
	1942, 1952, 1953,
	1953, 1943, 1942,
	1943, 1953, 1954,
	1954, 1944, 1943,
	1944, 1954, 1955,
	1955, 1945, 1944,
	1945, 1955, 1956,
	1956, 1946, 1945,
	1946, 1956, 1957,
	1957, 1947, 1946,
	1947, 1957, 1958,
	1958, 1948, 1947,
	1948, 1958, 1959,
	1959, 1949, 1948,
	1949, 1959, 1960,
	1960, 1950, 1949,
	1754, 1765, 1961,
	1961, 1951, 1754,
	1951, 1961, 1962,
	1962, 1952, 1951,
	1952, 1962, 1963,
	1963, 1953, 1952,
	1953, 1963, 1964,
	1964, 1954, 1953,
	1954, 1964, 1965,
	1965, 1955, 1954,
	1955, 1965, 1966,
	1966, 1956, 1955,
	1956, 1966, 1967,
	1967, 1957, 1956,
	1957, 1967, 1968,
	1968, 1958, 1957,
	1958, 1968, 1969,
	1969, 1959, 1958,
	1959, 1969, 1970,
	1970, 1960, 1959,
	1765, 1776, 1971,
	1971, 1961, 1765,
	1961, 1971, 1972,
	1972, 1962, 1961,
	1962, 1972, 1973,
	1973, 1963, 1962,
	1963, 1973, 1974,
	1974, 1964, 1963,
	1964, 1974, 1975,
	1975, 1965, 1964,
	1965, 1975, 1976,
	1976, 1966, 1965,
	1966, 1976, 1977,
	1977, 1967, 1966,
	1967, 1977, 1978,
	1978, 1968, 1967,
	1968, 1978, 1979,
	1979, 1969, 1968,
	1969, 1979, 1980,
	1980, 1970, 1969,
	1776, 1787, 1981,
	1981, 1971, 1776,
	1971, 1981, 1982,
	1982, 1972, 1971,
	1972, 1982, 1983,
	1983, 1973, 1972,
	1973, 1983, 1984,
	1984, 1974, 1973,
	1974, 1984, 1985,
	1985, 1975, 1974,
	1975, 1985, 1986,
	1986, 1976, 1975,
	1976, 1986, 1987,
	1987, 1977, 1976,
	1977, 1987, 1988,
	1988, 1978, 1977,
	1978, 1988, 1989,
	1989, 1979, 1978,
	1979, 1989, 1990,
	1990, 1980, 1979,
	1787, 1798, 1991,
	1991, 1981, 1787,
	1981, 1991, 1992,
	1992, 1982, 1981,
	1982, 1992, 1993,
	1993, 1983, 1982,
	1983, 1993, 1994,
	1994, 1984, 1983,
	1984, 1994, 1995,
	1995, 1985, 1984,
	1985, 1995, 1996,
	1996, 1986, 1985,
	1986, 1996, 1997,
	1997, 1987, 1986,
	1987, 1997, 1998,
	1998, 1988, 1987,
	1988, 1998, 1999,
	1999, 1989, 1988,
	1989, 1999, 2000,
	2000, 1990, 1989,
	1798, 1809, 2001,
	2001, 1991, 1798,
	1991, 2001, 2002,
	2002, 1992, 1991,
	1992, 2002, 2003,
	2003, 1993, 1992,
	1993, 2003, 2004,
	2004, 1994, 1993,
	1994, 2004, 2005,
	2005, 1995, 1994,
	1995, 2005, 2006,
	2006, 1996, 1995,
	1996, 2006, 2007,
	2007, 1997, 1996,
	1997, 2007, 2008,
	2008, 1998, 1997,
	1998, 2008, 2009,
	2009, 1999, 1998,
	1999, 2009, 2010,
	2010, 2000, 1999,
	1809, 1820, 2011,
	2011, 2001, 1809,
	2001, 2011, 2012,
	2012, 2002, 2001,
	2002, 2012, 2013,
	2013, 2003, 2002,
	2003, 2013, 2014,
	2014, 2004, 2003,
	2004, 2014, 2015,
	2015, 2005, 2004,
	2005, 2015, 2016,
	2016, 2006, 2005,
	2006, 2016, 2017,
	2017, 2007, 2006,
	2007, 2017, 2018,
	2018, 2008, 2007,
	2008, 2018, 2019,
	2019, 2009, 2008,
	2009, 2019, 2020,
	2020, 2010, 2009,
	1820, 1622, 1822,
	1822, 2011, 1820,
	2011, 1822, 1824,
	1824, 2012, 2011,
	2012, 1824, 1826,
	1826, 2013, 2012,
	2013, 1826, 1828,
	1828, 2014, 2013,
	2014, 1828, 1830,
	1830, 2015, 2014,
	2015, 1830, 1832,
	1832, 2016, 2015,
	2016, 1832, 1834,
	1834, 2017, 2016,
	2017, 1834, 1836,
	1836, 2018, 2017,
	2018, 1836, 1838,
	1838, 2019, 2018,
	2019, 1838, 1840,
	1840, 2020, 2019,
	2021, 2022, 2023,
	2023, 2024, 2021,
	2024, 2023, 2025,
	2025, 2026, 2024,
	2026, 2025, 2027,
	2027, 2028, 2026,
	2028, 2027, 2029,
	2029, 2030, 2028,
	2030, 2029, 2031,
	2031, 2032, 2030,
	2032, 2031, 2033,
	2033, 2034, 2032,
	2034, 2033, 2035,
	2035, 2036, 2034,
	2036, 2035, 2037,
	2037, 2038, 2036,
	2038, 2037, 2039,
	2039, 2040, 2038,
	2040, 2039, 2041,
	2041, 2042, 2040,
	2022, 2043, 2044,
	2044, 2023, 2022,
	2023, 2044, 2045,
	2045, 2025, 2023,
	2025, 2045, 2046,
	2046, 2027, 2025,
	2027, 2046, 2047,
	2047, 2029, 2027,
	2029, 2047, 2048,
	2048, 2031, 2029,
	2031, 2048, 2049,
	2049, 2033, 2031,
	2033, 2049, 2050,
	2050, 2035, 2033,
	2035, 2050, 2051,
	2051, 2037, 2035,
	2037, 2051, 2052,
	2052, 2039, 2037,
	2039, 2052, 2053,
	2053, 2041, 2039,
	2043, 2054, 2055,
	2055, 2044, 2043,
	2044, 2055, 2056,
	2056, 2045, 2044,
	2045, 2056, 2057,
	2057, 2046, 2045,
	2046, 2057, 2058,
	2058, 2047, 2046,
	2047, 2058, 2059,
	2059, 2048, 2047,
	2048, 2059, 2060,
	2060, 2049, 2048,
	2049, 2060, 2061,
	2061, 2050, 2049,
	2050, 2061, 2062,
	2062, 2051, 2050,
	2051, 2062, 2063,
	2063, 2052, 2051,
	2052, 2063, 2064,
	2064, 2053, 2052,
	2054, 2065, 2066,
	2066, 2055, 2054,
	2055, 2066, 2067,
	2067, 2056, 2055,
	2056, 2067, 2068,
	2068, 2057, 2056,
	2057, 2068, 2069,
	2069, 2058, 2057,
	2058, 2069, 2070,
	2070, 2059, 2058,
	2059, 2070, 2071,
	2071, 2060, 2059,
	2060, 2071, 2072,
	2072, 2061, 2060,
	2061, 2072, 2073,
	2073, 2062, 2061,
	2062, 2073, 2074,
	2074, 2063, 2062,
	2063, 2074, 2075,
	2075, 2064, 2063,
	2065, 2076, 2077,
	2077, 2066, 2065,
	2066, 2077, 2078,
	2078, 2067, 2066,
	2067, 2078, 2079,
	2079, 2068, 2067,
	2068, 2079, 2080,
	2080, 2069, 2068,
	2069, 2080, 2081,
	2081, 2070, 2069,
	2070, 2081, 2082,
	2082, 2071, 2070,
	2071, 2082, 2083,
	2083, 2072, 2071,
	2072, 2083, 2084,
	2084, 2073, 2072,
	2073, 2084, 2085,
	2085, 2074, 2073,
	2074, 2085, 2086,
	2086, 2075, 2074,
	2076, 2087, 2088,
	2088, 2077, 2076,
	2077, 2088, 2089,
	2089, 2078, 2077,
	2078, 2089, 2090,
	2090, 2079, 2078,
	2079, 2090, 2091,
	2091, 2080, 2079,
	2080, 2091, 2092,
	2092, 2081, 2080,
	2081, 2092, 2093,
	2093, 2082, 2081,
	2082, 2093, 2094,
	2094, 2083, 2082,
	2083, 2094, 2095,
	2095, 2084, 2083,
	2084, 2095, 2096,
	2096, 2085, 2084,
	2085, 2096, 2097,
	2097, 2086, 2085,
	2087, 2098, 2099,
	2099, 2088, 2087,
	2088, 2099, 2100,
	2100, 2089, 2088,
	2089, 2100, 2101,
	2101, 2090, 2089,
	2090, 2101, 2102,
	2102, 2091, 2090,
	2091, 2102, 2103,
	2103, 2092, 2091,
	2092, 2103, 2104,
	2104, 2093, 2092,
	2093, 2104, 2105,
	2105, 2094, 2093,
	2094, 2105, 2106,
	2106, 2095, 2094,
	2095, 2106, 2107,
	2107, 2096, 2095,
	2096, 2107, 2108,
	2108, 2097, 2096,
	2098, 2109, 2110,
	2110, 2099, 2098,
	2099, 2110, 2111,
	2111, 2100, 2099,
	2100, 2111, 2112,
	2112, 2101, 2100,
	2101, 2112, 2113,
	2113, 2102, 2101,
	2102, 2113, 2114,
	2114, 2103, 2102,
	2103, 2114, 2115,
	2115, 2104, 2103,
	2104, 2115, 2116,
	2116, 2105, 2104,
	2105, 2116, 2117,
	2117, 2106, 2105,
	2106, 2117, 2118,
	2118, 2107, 2106,
	2107, 2118, 2119,
	2119, 2108, 2107,
	2109, 2120, 2121,
	2121, 2110, 2109,
	2110, 2121, 2122,
	2122, 2111, 2110,
	2111, 2122, 2123,
	2123, 2112, 2111,
	2112, 2123, 2124,
	2124, 2113, 2112,
	2113, 2124, 2125,
	2125, 2114, 2113,
	2114, 2125, 2126,
	2126, 2115, 2114,
	2115, 2126, 2127,
	2127, 2116, 2115,
	2116, 2127, 2128,
	2128, 2117, 2116,
	2117, 2128, 2129,
	2129, 2118, 2117,
	2118, 2129, 2130,
	2130, 2119, 2118,
	2120, 2131, 2132,
	2132, 2121, 2120,
	2121, 2132, 2133,
	2133, 2122, 2121,
	2122, 2133, 2134,
	2134, 2123, 2122,
	2123, 2134, 2135,
	2135, 2124, 2123,
	2124, 2135, 2136,
	2136, 2125, 2124,
	2125, 2136, 2137,
	2137, 2126, 2125,
	2126, 2137, 2138,
	2138, 2127, 2126,
	2127, 2138, 2139,
	2139, 2128, 2127,
	2128, 2139, 2140,
	2140, 2129, 2128,
	2129, 2140, 2141,
	2141, 2130, 2129,
	2131, 2142, 2143,
	2143, 2132, 2131,
	2132, 2143, 2144,
	2144, 2133, 2132,
	2133, 2144, 2145,
	2145, 2134, 2133,
	2134, 2145, 2146,
	2146, 2135, 2134,
	2135, 2146, 2147,
	2147, 2136, 2135,
	2136, 2147, 2148,
	2148, 2137, 2136,
	2137, 2148, 2149,
	2149, 2138, 2137,
	2138, 2149, 2150,
	2150, 2139, 2138,
	2139, 2150, 2151,
	2151, 2140, 2139,
	2140, 2151, 2152,
	2152, 2141, 2140,
	2142, 2153, 2154,
	2154, 2143, 2142,
	2143, 2154, 2155,
	2155, 2144, 2143,
	2144, 2155, 2156,
	2156, 2145, 2144,
	2145, 2156, 2157,
	2157, 2146, 2145,
	2146, 2157, 2158,
	2158, 2147, 2146,
	2147, 2158, 2159,
	2159, 2148, 2147,
	2148, 2159, 2160,
	2160, 2149, 2148,
	2149, 2160, 2161,
	2161, 2150, 2149,
	2150, 2161, 2162,
	2162, 2151, 2150,
	2151, 2162, 2163,
	2163, 2152, 2151,
	2153, 2164, 2165,
	2165, 2154, 2153,
	2154, 2165, 2166,
	2166, 2155, 2154,
	2155, 2166, 2167,
	2167, 2156, 2155,
	2156, 2167, 2168,
	2168, 2157, 2156,
	2157, 2168, 2169,
	2169, 2158, 2157,
	2158, 2169, 2170,
	2170, 2159, 2158,
	2159, 2170, 2171,
	2171, 2160, 2159,
	2160, 2171, 2172,
	2172, 2161, 2160,
	2161, 2172, 2173,
	2173, 2162, 2161,
	2162, 2173, 2174,
	2174, 2163, 2162,
	2164, 2175, 2176,
	2176, 2165, 2164,
	2165, 2176, 2177,
	2177, 2166, 2165,
	2166, 2177, 2178,
	2178, 2167, 2166,
	2167, 2178, 2179,
	2179, 2168, 2167,
	2168, 2179, 2180,
	2180, 2169, 2168,
	2169, 2180, 2181,
	2181, 2170, 2169,
	2170, 2181, 2182,
	2182, 2171, 2170,
	2171, 2182, 2183,
	2183, 2172, 2171,
	2172, 2183, 2184,
	2184, 2173, 2172,
	2173, 2184, 2185,
	2185, 2174, 2173,
	2175, 2186, 2187,
	2187, 2176, 2175,
	2176, 2187, 2188,
	2188, 2177, 2176,
	2177, 2188, 2189,
	2189, 2178, 2177,
	2178, 2189, 2190,
	2190, 2179, 2178,
	2179, 2190, 2191,
	2191, 2180, 2179,
	2180, 2191, 2192,
	2192, 2181, 2180,
	2181, 2192, 2193,
	2193, 2182, 2181,
	2182, 2193, 2194,
	2194, 2183, 2182,
	2183, 2194, 2195,
	2195, 2184, 2183,
	2184, 2195, 2196,
	2196, 2185, 2184,
	2186, 2197, 2198,
	2198, 2187, 2186,
	2187, 2198, 2199,
	2199, 2188, 2187,
	2188, 2199, 2200,
	2200, 2189, 2188,
	2189, 2200, 2201,
	2201, 2190, 2189,
	2190, 2201, 2202,
	2202, 2191, 2190,
	2191, 2202, 2203,
	2203, 2192, 2191,
	2192, 2203, 2204,
	2204, 2193, 2192,
	2193, 2204, 2205,
	2205, 2194, 2193,
	2194, 2205, 2206,
	2206, 2195, 2194,
	2195, 2206, 2207,
	2207, 2196, 2195,
	2197, 2208, 2209,
	2209, 2198, 2197,
	2198, 2209, 2210,
	2210, 2199, 2198,
	2199, 2210, 2211,
	2211, 2200, 2199,
	2200, 2211, 2212,
	2212, 2201, 2200,
	2201, 2212, 2213,
	2213, 2202, 2201,
	2202, 2213, 2214,
	2214, 2203, 2202,
	2203, 2214, 2215,
	2215, 2204, 2203,
	2204, 2215, 2216,
	2216, 2205, 2204,
	2205, 2216, 2217,
	2217, 2206, 2205,
	2206, 2217, 2218,
	2218, 2207, 2206,
	2208, 2219, 2220,
	2220, 2209, 2208,
	2209, 2220, 2221,
	2221, 2210, 2209,
	2210, 2221, 2222,
	2222, 2211, 2210,
	2211, 2222, 2223,
	2223, 2212, 2211,
	2212, 2223, 2224,
	2224, 2213, 2212,
	2213, 2224, 2225,
	2225, 2214, 2213,
	2214, 2225, 2226,
	2226, 2215, 2214,
	2215, 2226, 2227,
	2227, 2216, 2215,
	2216, 2227, 2228,
	2228, 2217, 2216,
	2217, 2228, 2229,
	2229, 2218, 2217,
	2219, 2230, 2231,
	2231, 2220, 2219,
	2220, 2231, 2232,
	2232, 2221, 2220,
	2221, 2232, 2233,
	2233, 2222, 2221,
	2222, 2233, 2234,
	2234, 2223, 2222,
	2223, 2234, 2235,
	2235, 2224, 2223,
	2224, 2235, 2236,
	2236, 2225, 2224,
	2225, 2236, 2237,
	2237, 2226, 2225,
	2226, 2237, 2238,
	2238, 2227, 2226,
	2227, 2238, 2239,
	2239, 2228, 2227,
	2228, 2239, 2240,
	2240, 2229, 2228,
	2230, 2021, 2024,
	2024, 2231, 2230,
	2231, 2024, 2026,
	2026, 2232, 2231,
	2232, 2026, 2028,
	2028, 2233, 2232,
	2233, 2028, 2030,
	2030, 2234, 2233,
	2234, 2030, 2032,
	2032, 2235, 2234,
	2235, 2032, 2034,
	2034, 2236, 2235,
	2236, 2034, 2036,
	2036, 2237, 2236,
	2237, 2036, 2038,
	2038, 2238, 2237,
	2238, 2038, 2040,
	2040, 2239, 2238,
	2239, 2040, 2042,
	2042, 2240, 2239,
	2042, 2041, 2241,
	2241, 2242, 2042,
	2242, 2241, 2243,
	2243, 2244, 2242,
	2244, 2243, 2245,
	2245, 2246, 2244,
	2246, 2245, 2247,
	2247, 2248, 2246,
	2248, 2247, 2249,
	2249, 2250, 2248,
	2250, 2249, 2251,
	2251, 2252, 2250,
	2252, 2251, 2253,
	2253, 2254, 2252,
	2254, 2253, 2255,
	2255, 2256, 2254,
	2256, 2255, 2257,
	2257, 2258, 2256,
	2258, 2257, 2259,
	2259, 2260, 2258,
	2041, 2053, 2261,
	2261, 2241, 2041,
	2241, 2261, 2262,
	2262, 2243, 2241,
	2243, 2262, 2263,
	2263, 2245, 2243,
	2245, 2263, 2264,
	2264, 2247, 2245,
	2247, 2264, 2265,
	2265, 2249, 2247,
	2249, 2265, 2266,
	2266, 2251, 2249,
	2251, 2266, 2267,
	2267, 2253, 2251,
	2253, 2267, 2268,
	2268, 2255, 2253,
	2255, 2268, 2269,
	2269, 2257, 2255,
	2257, 2269, 2270,
	2270, 2259, 2257,
	2053, 2064, 2271,
	2271, 2261, 2053,
	2261, 2271, 2272,
	2272, 2262, 2261,
	2262, 2272, 2273,
	2273, 2263, 2262,
	2263, 2273, 2274,
	2274, 2264, 2263,
	2264, 2274, 2275,
	2275, 2265, 2264,
	2265, 2275, 2276,
	2276, 2266, 2265,
	2266, 2276, 2277,
	2277, 2267, 2266,
	2267, 2277, 2278,
	2278, 2268, 2267,
	2268, 2278, 2279,
	2279, 2269, 2268,
	2269, 2279, 2280,
	2280, 2270, 2269,
	2064, 2075, 2281,
	2281, 2271, 2064,
	2271, 2281, 2282,
	2282, 2272, 2271,
	2272, 2282, 2283,
	2283, 2273, 2272,
	2273, 2283, 2284,
	2284, 2274, 2273,
	2274, 2284, 2285,
	2285, 2275, 2274,
	2275, 2285, 2286,
	2286, 2276, 2275,
	2276, 2286, 2287,
	2287, 2277, 2276,
	2277, 2287, 2288,
	2288, 2278, 2277,
	2278, 2288, 2289,
	2289, 2279, 2278,
	2279, 2289, 2290,
	2290, 2280, 2279,
	2075, 2086, 2291,
	2291, 2281, 2075,
	2281, 2291, 2292,
	2292, 2282, 2281,
	2282, 2292, 2293,
	2293, 2283, 2282,
	2283, 2293, 2294,
	2294, 2284, 2283,
	2284, 2294, 2295,
	2295, 2285, 2284,
	2285, 2295, 2296,
	2296, 2286, 2285,
	2286, 2296, 2297,
	2297, 2287, 2286,
	2287, 2297, 2298,
	2298, 2288, 2287,
	2288, 2298, 2299,
	2299, 2289, 2288,
	2289, 2299, 2300,
	2300, 2290, 2289,
	2086, 2097, 2301,
	2301, 2291, 2086,
	2291, 2301, 2302,
	2302, 2292, 2291,
	2292, 2302, 2303,
	2303, 2293, 2292,
	2293, 2303, 2304,
	2304, 2294, 2293,
	2294, 2304, 2305,
	2305, 2295, 2294,
	2295, 2305, 2306,
	2306, 2296, 2295,
	2296, 2306, 2307,
	2307, 2297, 2296,
	2297, 2307, 2308,
	2308, 2298, 2297,
	2298, 2308, 2309,
	2309, 2299, 2298,
	2299, 2309, 2310,
	2310, 2300, 2299,
	2097, 2108, 2311,
	2311, 2301, 2097,
	2301, 2311, 2312,
	2312, 2302, 2301,
	2302, 2312, 2313,
	2313, 2303, 2302,
	2303, 2313, 2314,
	2314, 2304, 2303,
	2304, 2314, 2315,
	2315, 2305, 2304,
	2305, 2315, 2316,
	2316, 2306, 2305,
	2306, 2316, 2317,
	2317, 2307, 2306,
	2307, 2317, 2318,
	2318, 2308, 2307,
	2308, 2318, 2319,
	2319, 2309, 2308,
	2309, 2319, 2320,
	2320, 2310, 2309,
	2108, 2119, 2321,
	2321, 2311, 2108,
	2311, 2321, 2322,
	2322, 2312, 2311,
	2312, 2322, 2323,
	2323, 2313, 2312,
	2313, 2323, 2324,
	2324, 2314, 2313,
	2314, 2324, 2325,
	2325, 2315, 2314,
	2315, 2325, 2326,
	2326, 2316, 2315,
	2316, 2326, 2327,
	2327, 2317, 2316,
	2317, 2327, 2328,
	2328, 2318, 2317,
	2318, 2328, 2329,
	2329, 2319, 2318,
	2319, 2329, 2330,
	2330, 2320, 2319,
	2119, 2130, 2331,
	2331, 2321, 2119,
	2321, 2331, 2332,
	2332, 2322, 2321,
	2322, 2332, 2333,
	2333, 2323, 2322,
	2323, 2333, 2334,
	2334, 2324, 2323,
	2324, 2334, 2335,
	2335, 2325, 2324,
	2325, 2335, 2336,
	2336, 2326, 2325,
	2326, 2336, 2337,
	2337, 2327, 2326,
	2327, 2337, 2338,
	2338, 2328, 2327,
	2328, 2338, 2339,
	2339, 2329, 2328,
	2329, 2339, 2340,
	2340, 2330, 2329,
	2130, 2141, 2341,
	2341, 2331, 2130,
	2331, 2341, 2342,
	2342, 2332, 2331,
	2332, 2342, 2343,
	2343, 2333, 2332,
	2333, 2343, 2344,
	2344, 2334, 2333,
	2334, 2344, 2345,
	2345, 2335, 2334,
	2335, 2345, 2346,
	2346, 2336, 2335,
	2336, 2346, 2347,
	2347, 2337, 2336,
	2337, 2347, 2348,
	2348, 2338, 2337,
	2338, 2348, 2349,
	2349, 2339, 2338,
	2339, 2349, 2350,
	2350, 2340, 2339,
	2141, 2152, 2351,
	2351, 2341, 2141,
	2341, 2351, 2352,
	2352, 2342, 2341,
	2342, 2352, 2353,
	2353, 2343, 2342,
	2343, 2353, 2354,
	2354, 2344, 2343,
	2344, 2354, 2355,
	2355, 2345, 2344,
	2345, 2355, 2356,
	2356, 2346, 2345,
	2346, 2356, 2357,
	2357, 2347, 2346,
	2347, 2357, 2358,
	2358, 2348, 2347,
	2348, 2358, 2359,
	2359, 2349, 2348,
	2349, 2359, 2360,
	2360, 2350, 2349,
	2152, 2163, 2361,
	2361, 2351, 2152,
	2351, 2361, 2362,
	2362, 2352, 2351,
	2352, 2362, 2363,
	2363, 2353, 2352,
	2353, 2363, 2364,
	2364, 2354, 2353,
	2354, 2364, 2365,
	2365, 2355, 2354,
	2355, 2365, 2366,
	2366, 2356, 2355,
	2356, 2366, 2367,
	2367, 2357, 2356,
	2357, 2367, 2368,
	2368, 2358, 2357,
	2358, 2368, 2369,
	2369, 2359, 2358,
	2359, 2369, 2370,
	2370, 2360, 2359,
	2163, 2174, 2371,
	2371, 2361, 2163,
	2361, 2371, 2372,
	2372, 2362, 2361,
	2362, 2372, 2373,
	2373, 2363, 2362,
	2363, 2373, 2374,
	2374, 2364, 2363,
	2364, 2374, 2375,
	2375, 2365, 2364,
	2365, 2375, 2376,
	2376, 2366, 2365,
	2366, 2376, 2377,
	2377, 2367, 2366,
	2367, 2377, 2378,
	2378, 2368, 2367,
	2368, 2378, 2379,
	2379, 2369, 2368,
	2369, 2379, 2380,
	2380, 2370, 2369,
	2174, 2185, 2381,
	2381, 2371, 2174,
	2371, 2381, 2382,
	2382, 2372, 2371,
	2372, 2382, 2383,
	2383, 2373, 2372,
	2373, 2383, 2384,
	2384, 2374, 2373,
	2374, 2384, 2385,
	2385, 2375, 2374,
	2375, 2385, 2386,
	2386, 2376, 2375,
	2376, 2386, 2387,
	2387, 2377, 2376,
	2377, 2387, 2388,
	2388, 2378, 2377,
	2378, 2388, 2389,
	2389, 2379, 2378,
	2379, 2389, 2390,
	2390, 2380, 2379,
	2185, 2196, 2391,
	2391, 2381, 2185,
	2381, 2391, 2392,
	2392, 2382, 2381,
	2382, 2392, 2393,
	2393, 2383, 2382,
	2383, 2393, 2394,
	2394, 2384, 2383,
	2384, 2394, 2395,
	2395, 2385, 2384,
	2385, 2395, 2396,
	2396, 2386, 2385,
	2386, 2396, 2397,
	2397, 2387, 2386,
	2387, 2397, 2398,
	2398, 2388, 2387,
	2388, 2398, 2399,
	2399, 2389, 2388,
	2389, 2399, 2400,
	2400, 2390, 2389,
	2196, 2207, 2401,
	2401, 2391, 2196,
	2391, 2401, 2402,
	2402, 2392, 2391,
	2392, 2402, 2403,
	2403, 2393, 2392,
	2393, 2403, 2404,
	2404, 2394, 2393,
	2394, 2404, 2405,
	2405, 2395, 2394,
	2395, 2405, 2406,
	2406, 2396, 2395,
	2396, 2406, 2407,
	2407, 2397, 2396,
	2397, 2407, 2408,
	2408, 2398, 2397,
	2398, 2408, 2409,
	2409, 2399, 2398,
	2399, 2409, 2410,
	2410, 2400, 2399,
	2207, 2218, 2411,
	2411, 2401, 2207,
	2401, 2411, 2412,
	2412, 2402, 2401,
	2402, 2412, 2413,
	2413, 2403, 2402,
	2403, 2413, 2414,
	2414, 2404, 2403,
	2404, 2414, 2415,
	2415, 2405, 2404,
	2405, 2415, 2416,
	2416, 2406, 2405,
	2406, 2416, 2417,
	2417, 2407, 2406,
	2407, 2417, 2418,
	2418, 2408, 2407,
	2408, 2418, 2419,
	2419, 2409, 2408,
	2409, 2419, 2420,
	2420, 2410, 2409,
	2218, 2229, 2421,
	2421, 2411, 2218,
	2411, 2421, 2422,
	2422, 2412, 2411,
	2412, 2422, 2423,
	2423, 2413, 2412,
	2413, 2423, 2424,
	2424, 2414, 2413,
	2414, 2424, 2425,
	2425, 2415, 2414,
	2415, 2425, 2426,
	2426, 2416, 2415,
	2416, 2426, 2427,
	2427, 2417, 2416,
	2417, 2427, 2428,
	2428, 2418, 2417,
	2418, 2428, 2429,
	2429, 2419, 2418,
	2419, 2429, 2430,
	2430, 2420, 2419,
	2229, 2240, 2431,
	2431, 2421, 2229,
	2421, 2431, 2432,
	2432, 2422, 2421,
	2422, 2432, 2433,
	2433, 2423, 2422,
	2423, 2433, 2434,
	2434, 2424, 2423,
	2424, 2434, 2435,
	2435, 2425, 2424,
	2425, 2435, 2436,
	2436, 2426, 2425,
	2426, 2436, 2437,
	2437, 2427, 2426,
	2427, 2437, 2438,
	2438, 2428, 2427,
	2428, 2438, 2439,
	2439, 2429, 2428,
	2429, 2439, 2440,
	2440, 2430, 2429,
	2240, 2042, 2242,
	2242, 2431, 2240,
	2431, 2242, 2244,
	2244, 2432, 2431,
	2432, 2244, 2246,
	2246, 2433, 2432,
	2433, 2246, 2248,
	2248, 2434, 2433,
	2434, 2248, 2250,
	2250, 2435, 2434,
	2435, 2250, 2252,
	2252, 2436, 2435,
	2436, 2252, 2254,
	2254, 2437, 2436,
	2437, 2254, 2256,
	2256, 2438, 2437,
	2438, 2256, 2258,
	2258, 2439, 2438,
	2439, 2258, 2260,
	2260, 2440, 2439,
	2441, 2441, 2442,
	2442, 2443, 2441,
	2443, 2442, 2444,
	2444, 2445, 2443,
	2445, 2444, 2446,
	2446, 2447, 2445,
	2447, 2446, 2448,
	2448, 2449, 2447,
	2449, 2448, 2450,
	2450, 2451, 2449,
	2451, 2450, 2452,
	2452, 2453, 2451,
	2453, 2452, 2454,
	2454, 2455, 2453,
	2455, 2454, 2456,
	2456, 2457, 2455,
	2457, 2456, 2458,
	2458, 2459, 2457,
	2459, 2458, 2460,
	2460, 2461, 2459,
	2441, 2441, 2462,
	2462, 2442, 2441,
	2442, 2462, 2463,
	2463, 2444, 2442,
	2444, 2463, 2464,
	2464, 2446, 2444,
	2446, 2464, 2465,
	2465, 2448, 2446,
	2448, 2465, 2466,
	2466, 2450, 2448,
	2450, 2466, 2467,
	2467, 2452, 2450,
	2452, 2467, 2468,
	2468, 2454, 2452,
	2454, 2468, 2469,
	2469, 2456, 2454,
	2456, 2469, 2470,
	2470, 2458, 2456,
	2458, 2470, 2471,
	2471, 2460, 2458,
	2441, 2441, 2472,
	2472, 2462, 2441,
	2462, 2472, 2473,
	2473, 2463, 2462,
	2463, 2473, 2474,
	2474, 2464, 2463,
	2464, 2474, 2475,
	2475, 2465, 2464,
	2465, 2475, 2476,
	2476, 2466, 2465,
	2466, 2476, 2477,
	2477, 2467, 2466,
	2467, 2477, 2478,
	2478, 2468, 2467,
	2468, 2478, 2479,
	2479, 2469, 2468,
	2469, 2479, 2480,
	2480, 2470, 2469,
	2470, 2480, 2481,
	2481, 2471, 2470,
	2441, 2441, 2482,
	2482, 2472, 2441,
	2472, 2482, 2483,
	2483, 2473, 2472,
	2473, 2483, 2484,
	2484, 2474, 2473,
	2474, 2484, 2485,
	2485, 2475, 2474,
	2475, 2485, 2486,
	2486, 2476, 2475,
	2476, 2486, 2487,
	2487, 2477, 2476,
	2477, 2487, 2488,
	2488, 2478, 2477,
	2478, 2488, 2489,
	2489, 2479, 2478,
	2479, 2489, 2490,
	2490, 2480, 2479,
	2480, 2490, 2491,
	2491, 2481, 2480,
	2441, 2441, 2492,
	2492, 2482, 2441,
	2482, 2492, 2493,
	2493, 2483, 2482,
	2483, 2493, 2494,
	2494, 2484, 2483,
	2484, 2494, 2495,
	2495, 2485, 2484,
	2485, 2495, 2496,
	2496, 2486, 2485,
	2486, 2496, 2497,
	2497, 2487, 2486,
	2487, 2497, 2498,
	2498, 2488, 2487,
	2488, 2498, 2499,
	2499, 2489, 2488,
	2489, 2499, 2500,
	2500, 2490, 2489,
	2490, 2500, 2501,
	2501, 2491, 2490,
	2441, 2441, 2502,
	2502, 2492, 2441,
	2492, 2502, 2503,
	2503, 2493, 2492,
	2493, 2503, 2504,
	2504, 2494, 2493,
	2494, 2504, 2505,
	2505, 2495, 2494,
	2495, 2505, 2506,
	2506, 2496, 2495,
	2496, 2506, 2507,
	2507, 2497, 2496,
	2497, 2507, 2508,
	2508, 2498, 2497,
	2498, 2508, 2509,
	2509, 2499, 2498,
	2499, 2509, 2510,
	2510, 2500, 2499,
	2500, 2510, 2511,
	2511, 2501, 2500,
	2441, 2441, 2512,
	2512, 2502, 2441,
	2502, 2512, 2513,
	2513, 2503, 2502,
	2503, 2513, 2514,
	2514, 2504, 2503,
	2504, 2514, 2515,
	2515, 2505, 2504,
	2505, 2515, 2516,
	2516, 2506, 2505,
	2506, 2516, 2517,
	2517, 2507, 2506,
	2507, 2517, 2518,
	2518, 2508, 2507,
	2508, 2518, 2519,
	2519, 2509, 2508,
	2509, 2519, 2520,
	2520, 2510, 2509,
	2510, 2520, 2521,
	2521, 2511, 2510,
	2441, 2441, 2522,
	2522, 2512, 2441,
	2512, 2522, 2523,
	2523, 2513, 2512,
	2513, 2523, 2524,
	2524, 2514, 2513,
	2514, 2524, 2525,
	2525, 2515, 2514,
	2515, 2525, 2526,
	2526, 2516, 2515,
	2516, 2526, 2527,
	2527, 2517, 2516,
	2517, 2527, 2528,
	2528, 2518, 2517,
	2518, 2528, 2529,
	2529, 2519, 2518,
	2519, 2529, 2530,
	2530, 2520, 2519,
	2520, 2530, 2531,
	2531, 2521, 2520,
	2441, 2441, 2532,
	2532, 2522, 2441,
	2522, 2532, 2533,
	2533, 2523, 2522,
	2523, 2533, 2534,
	2534, 2524, 2523,
	2524, 2534, 2535,
	2535, 2525, 2524,
	2525, 2535, 2536,
	2536, 2526, 2525,
	2526, 2536, 2537,
	2537, 2527, 2526,
	2527, 2537, 2538,
	2538, 2528, 2527,
	2528, 2538, 2539,
	2539, 2529, 2528,
	2529, 2539, 2540,
	2540, 2530, 2529,
	2530, 2540, 2541,
	2541, 2531, 2530,
	2441, 2441, 2542,
	2542, 2532, 2441,
	2532, 2542, 2543,
	2543, 2533, 2532,
	2533, 2543, 2544,
	2544, 2534, 2533,
	2534, 2544, 2545,
	2545, 2535, 2534,
	2535, 2545, 2546,
	2546, 2536, 2535,
	2536, 2546, 2547,
	2547, 2537, 2536,
	2537, 2547, 2548,
	2548, 2538, 2537,
	2538, 2548, 2549,
	2549, 2539, 2538,
	2539, 2549, 2550,
	2550, 2540, 2539,
	2540, 2550, 2551,
	2551, 2541, 2540,
	2441, 2441, 2552,
	2552, 2542, 2441,
	2542, 2552, 2553,
	2553, 2543, 2542,
	2543, 2553, 2554,
	2554, 2544, 2543,
	2544, 2554, 2555,
	2555, 2545, 2544,
	2545, 2555, 2556,
	2556, 2546, 2545,
	2546, 2556, 2557,
	2557, 2547, 2546,
	2547, 2557, 2558,
	2558, 2548, 2547,
	2548, 2558, 2559,
	2559, 2549, 2548,
	2549, 2559, 2560,
	2560, 2550, 2549,
	2550, 2560, 2561,
	2561, 2551, 2550,
	2441, 2441, 2562,
	2562, 2552, 2441,
	2552, 2562, 2563,
	2563, 2553, 2552,
	2553, 2563, 2564,
	2564, 2554, 2553,
	2554, 2564, 2565,
	2565, 2555, 2554,
	2555, 2565, 2566,
	2566, 2556, 2555,
	2556, 2566, 2567,
	2567, 2557, 2556,
	2557, 2567, 2568,
	2568, 2558, 2557,
	2558, 2568, 2569,
	2569, 2559, 2558,
	2559, 2569, 2570,
	2570, 2560, 2559,
	2560, 2570, 2571,
	2571, 2561, 2560,
	2441, 2441, 2572,
	2572, 2562, 2441,
	2562, 2572, 2573,
	2573, 2563, 2562,
	2563, 2573, 2574,
	2574, 2564, 2563,
	2564, 2574, 2575,
	2575, 2565, 2564,
	2565, 2575, 2576,
	2576, 2566, 2565,
	2566, 2576, 2577,
	2577, 2567, 2566,
	2567, 2577, 2578,
	2578, 2568, 2567,
	2568, 2578, 2579,
	2579, 2569, 2568,
	2569, 2579, 2580,
	2580, 2570, 2569,
	2570, 2580, 2581,
	2581, 2571, 2570,
	2441, 2441, 2582,
	2582, 2572, 2441,
	2572, 2582, 2583,
	2583, 2573, 2572,
	2573, 2583, 2584,
	2584, 2574, 2573,
	2574, 2584, 2585,
	2585, 2575, 2574,
	2575, 2585, 2586,
	2586, 2576, 2575,
	2576, 2586, 2587,
	2587, 2577, 2576,
	2577, 2587, 2588,
	2588, 2578, 2577,
	2578, 2588, 2589,
	2589, 2579, 2578,
	2579, 2589, 2590,
	2590, 2580, 2579,
	2580, 2590, 2591,
	2591, 2581, 2580,
	2441, 2441, 2592,
	2592, 2582, 2441,
	2582, 2592, 2593,
	2593, 2583, 2582,
	2583, 2593, 2594,
	2594, 2584, 2583,
	2584, 2594, 2595,
	2595, 2585, 2584,
	2585, 2595, 2596,
	2596, 2586, 2585,
	2586, 2596, 2597,
	2597, 2587, 2586,
	2587, 2597, 2598,
	2598, 2588, 2587,
	2588, 2598, 2599,
	2599, 2589, 2588,
	2589, 2599, 2600,
	2600, 2590, 2589,
	2590, 2600, 2601,
	2601, 2591, 2590,
	2441, 2441, 2602,
	2602, 2592, 2441,
	2592, 2602, 2603,
	2603, 2593, 2592,
	2593, 2603, 2604,
	2604, 2594, 2593,
	2594, 2604, 2605,
	2605, 2595, 2594,
	2595, 2605, 2606,
	2606, 2596, 2595,
	2596, 2606, 2607,
	2607, 2597, 2596,
	2597, 2607, 2608,
	2608, 2598, 2597,
	2598, 2608, 2609,
	2609, 2599, 2598,
	2599, 2609, 2610,
	2610, 2600, 2599,
	2600, 2610, 2611,
	2611, 2601, 2600,
	2441, 2441, 2612,
	2612, 2602, 2441,
	2602, 2612, 2613,
	2613, 2603, 2602,
	2603, 2613, 2614,
	2614, 2604, 2603,
	2604, 2614, 2615,
	2615, 2605, 2604,
	2605, 2615, 2616,
	2616, 2606, 2605,
	2606, 2616, 2617,
	2617, 2607, 2606,
	2607, 2617, 2618,
	2618, 2608, 2607,
	2608, 2618, 2619,
	2619, 2609, 2608,
	2609, 2619, 2620,
	2620, 2610, 2609,
	2610, 2620, 2621,
	2621, 2611, 2610,
	2441, 2441, 2622,
	2622, 2612, 2441,
	2612, 2622, 2623,
	2623, 2613, 2612,
	2613, 2623, 2624,
	2624, 2614, 2613,
	2614, 2624, 2625,
	2625, 2615, 2614,
	2615, 2625, 2626,
	2626, 2616, 2615,
	2616, 2626, 2627,
	2627, 2617, 2616,
	2617, 2627, 2628,
	2628, 2618, 2617,
	2618, 2628, 2629,
	2629, 2619, 2618,
	2619, 2629, 2630,
	2630, 2620, 2619,
	2620, 2630, 2631,
	2631, 2621, 2620,
	2441, 2441, 2632,
	2632, 2622, 2441,
	2622, 2632, 2633,
	2633, 2623, 2622,
	2623, 2633, 2634,
	2634, 2624, 2623,
	2624, 2634, 2635,
	2635, 2625, 2624,
	2625, 2635, 2636,
	2636, 2626, 2625,
	2626, 2636, 2637,
	2637, 2627, 2626,
	2627, 2637, 2638,
	2638, 2628, 2627,
	2628, 2638, 2639,
	2639, 2629, 2628,
	2629, 2639, 2640,
	2640, 2630, 2629,
	2630, 2640, 2641,
	2641, 2631, 2630,
	2441, 2441, 2642,
	2642, 2632, 2441,
	2632, 2642, 2643,
	2643, 2633, 2632,
	2633, 2643, 2644,
	2644, 2634, 2633,
	2634, 2644, 2645,
	2645, 2635, 2634,
	2635, 2645, 2646,
	2646, 2636, 2635,
	2636, 2646, 2647,
	2647, 2637, 2636,
	2637, 2647, 2648,
	2648, 2638, 2637,
	2638, 2648, 2649,
	2649, 2639, 2638,
	2639, 2649, 2650,
	2650, 2640, 2639,
	2640, 2650, 2651,
	2651, 2641, 2640,
	2441, 2441, 2652,
	2652, 2642, 2441,
	2642, 2652, 2653,
	2653, 2643, 2642,
	2643, 2653, 2654,
	2654, 2644, 2643,
	2644, 2654, 2655,
	2655, 2645, 2644,
	2645, 2655, 2656,
	2656, 2646, 2645,
	2646, 2656, 2657,
	2657, 2647, 2646,
	2647, 2657, 2658,
	2658, 2648, 2647,
	2648, 2658, 2659,
	2659, 2649, 2648,
	2649, 2659, 2660,
	2660, 2650, 2649,
	2650, 2660, 2661,
	2661, 2651, 2650,
	2441, 2441, 2662,
	2662, 2652, 2441,
	2652, 2662, 2663,
	2663, 2653, 2652,
	2653, 2663, 2664,
	2664, 2654, 2653,
	2654, 2664, 2665,
	2665, 2655, 2654,
	2655, 2665, 2666,
	2666, 2656, 2655,
	2656, 2666, 2667,
	2667, 2657, 2656,
	2657, 2667, 2668,
	2668, 2658, 2657,
	2658, 2668, 2669,
	2669, 2659, 2658,
	2659, 2669, 2670,
	2670, 2660, 2659,
	2660, 2670, 2671,
	2671, 2661, 2660,
	2441, 2441, 2672,
	2672, 2662, 2441,
	2662, 2672, 2673,
	2673, 2663, 2662,
	2663, 2673, 2674,
	2674, 2664, 2663,
	2664, 2674, 2675,
	2675, 2665, 2664,
	2665, 2675, 2676,
	2676, 2666, 2665,
	2666, 2676, 2677,
	2677, 2667, 2666,
	2667, 2677, 2678,
	2678, 2668, 2667,
	2668, 2678, 2679,
	2679, 2669, 2668,
	2669, 2679, 2680,
	2680, 2670, 2669,
	2670, 2680, 2681,
	2681, 2671, 2670,
	2441, 2441, 2682,
	2682, 2672, 2441,
	2672, 2682, 2683,
	2683, 2673, 2672,
	2673, 2683, 2684,
	2684, 2674, 2673,
	2674, 2684, 2685,
	2685, 2675, 2674,
	2675, 2685, 2686,
	2686, 2676, 2675,
	2676, 2686, 2687,
	2687, 2677, 2676,
	2677, 2687, 2688,
	2688, 2678, 2677,
	2678, 2688, 2689,
	2689, 2679, 2678,
	2679, 2689, 2690,
	2690, 2680, 2679,
	2680, 2690, 2691,
	2691, 2681, 2680,
	2441, 2441, 2692,
	2692, 2682, 2441,
	2682, 2692, 2693,
	2693, 2683, 2682,
	2683, 2693, 2694,
	2694, 2684, 2683,
	2684, 2694, 2695,
	2695, 2685, 2684,
	2685, 2695, 2696,
	2696, 2686, 2685,
	2686, 2696, 2697,
	2697, 2687, 2686,
	2687, 2697, 2698,
	2698, 2688, 2687,
	2688, 2698, 2699,
	2699, 2689, 2688,
	2689, 2699, 2700,
	2700, 2690, 2689,
	2690, 2700, 2701,
	2701, 2691, 2690,
	2441, 2441, 2702,
	2702, 2692, 2441,
	2692, 2702, 2703,
	2703, 2693, 2692,
	2693, 2703, 2704,
	2704, 2694, 2693,
	2694, 2704, 2705,
	2705, 2695, 2694,
	2695, 2705, 2706,
	2706, 2696, 2695,
	2696, 2706, 2707,
	2707, 2697, 2696,
	2697, 2707, 2708,
	2708, 2698, 2697,
	2698, 2708, 2709,
	2709, 2699, 2698,
	2699, 2709, 2710,
	2710, 2700, 2699,
	2700, 2710, 2711,
	2711, 2701, 2700,
	2441, 2441, 2712,
	2712, 2702, 2441,
	2702, 2712, 2713,
	2713, 2703, 2702,
	2703, 2713, 2714,
	2714, 2704, 2703,
	2704, 2714, 2715,
	2715, 2705, 2704,
	2705, 2715, 2716,
	2716, 2706, 2705,
	2706, 2716, 2717,
	2717, 2707, 2706,
	2707, 2717, 2718,
	2718, 2708, 2707,
	2708, 2718, 2719,
	2719, 2709, 2708,
	2709, 2719, 2720,
	2720, 2710, 2709,
	2710, 2720, 2721,
	2721, 2711, 2710,
	2441, 2441, 2722,
	2722, 2712, 2441,
	2712, 2722, 2723,
	2723, 2713, 2712,
	2713, 2723, 2724,
	2724, 2714, 2713,
	2714, 2724, 2725,
	2725, 2715, 2714,
	2715, 2725, 2726,
	2726, 2716, 2715,
	2716, 2726, 2727,
	2727, 2717, 2716,
	2717, 2727, 2728,
	2728, 2718, 2717,
	2718, 2728, 2729,
	2729, 2719, 2718,
	2719, 2729, 2730,
	2730, 2720, 2719,
	2720, 2730, 2731,
	2731, 2721, 2720,
	2441, 2441, 2732,
	2732, 2722, 2441,
	2722, 2732, 2733,
	2733, 2723, 2722,
	2723, 2733, 2734,
	2734, 2724, 2723,
	2724, 2734, 2735,
	2735, 2725, 2724,
	2725, 2735, 2736,
	2736, 2726, 2725,
	2726, 2736, 2737,
	2737, 2727, 2726,
	2727, 2737, 2738,
	2738, 2728, 2727,
	2728, 2738, 2739,
	2739, 2729, 2728,
	2729, 2739, 2740,
	2740, 2730, 2729,
	2730, 2740, 2741,
	2741, 2731, 2730,
	2441, 2441, 2742,
	2742, 2732, 2441,
	2732, 2742, 2743,
	2743, 2733, 2732,
	2733, 2743, 2744,
	2744, 2734, 2733,
	2734, 2744, 2745,
	2745, 2735, 2734,
	2735, 2745, 2746,
	2746, 2736, 2735,
	2736, 2746, 2747,
	2747, 2737, 2736,
	2737, 2747, 2748,
	2748, 2738, 2737,
	2738, 2748, 2749,
	2749, 2739, 2738,
	2739, 2749, 2750,
	2750, 2740, 2739,
	2740, 2750, 2751,
	2751, 2741, 2740,
	2441, 2441, 2752,
	2752, 2742, 2441,
	2742, 2752, 2753,
	2753, 2743, 2742,
	2743, 2753, 2754,
	2754, 2744, 2743,
	2744, 2754, 2755,
	2755, 2745, 2744,
	2745, 2755, 2756,
	2756, 2746, 2745,
	2746, 2756, 2757,
	2757, 2747, 2746,
	2747, 2757, 2758,
	2758, 2748, 2747,
	2748, 2758, 2759,
	2759, 2749, 2748,
	2749, 2759, 2760,
	2760, 2750, 2749,
	2750, 2760, 2761,
	2761, 2751, 2750,
	2441, 2441, 2762,
	2762, 2752, 2441,
	2752, 2762, 2763,
	2763, 2753, 2752,
	2753, 2763, 2764,
	2764, 2754, 2753,
	2754, 2764, 2765,
	2765, 2755, 2754,
	2755, 2765, 2766,
	2766, 2756, 2755,
	2756, 2766, 2767,
	2767, 2757, 2756,
	2757, 2767, 2768,
	2768, 2758, 2757,
	2758, 2768, 2769,
	2769, 2759, 2758,
	2759, 2769, 2770,
	2770, 2760, 2759,
	2760, 2770, 2771,
	2771, 2761, 2760,
	2441, 2441, 2772,
	2772, 2762, 2441,
	2762, 2772, 2773,
	2773, 2763, 2762,
	2763, 2773, 2774,
	2774, 2764, 2763,
	2764, 2774, 2775,
	2775, 2765, 2764,
	2765, 2775, 2776,
	2776, 2766, 2765,
	2766, 2776, 2777,
	2777, 2767, 2766,
	2767, 2777, 2778,
	2778, 2768, 2767,
	2768, 2778, 2779,
	2779, 2769, 2768,
	2769, 2779, 2780,
	2780, 2770, 2769,
	2770, 2780, 2781,
	2781, 2771, 2770,
	2441, 2441, 2782,
	2782, 2772, 2441,
	2772, 2782, 2783,
	2783, 2773, 2772,
	2773, 2783, 2784,
	2784, 2774, 2773,
	2774, 2784, 2785,
	2785, 2775, 2774,
	2775, 2785, 2786,
	2786, 2776, 2775,
	2776, 2786, 2787,
	2787, 2777, 2776,
	2777, 2787, 2788,
	2788, 2778, 2777,
	2778, 2788, 2789,
	2789, 2779, 2778,
	2779, 2789, 2790,
	2790, 2780, 2779,
	2780, 2790, 2791,
	2791, 2781, 2780,
	2441, 2441, 2792,
	2792, 2782, 2441,
	2782, 2792, 2793,
	2793, 2783, 2782,
	2783, 2793, 2794,
	2794, 2784, 2783,
	2784, 2794, 2795,
	2795, 2785, 2784,
	2785, 2795, 2796,
	2796, 2786, 2785,
	2786, 2796, 2797,
	2797, 2787, 2786,
	2787, 2797, 2798,
	2798, 2788, 2787,
	2788, 2798, 2799,
	2799, 2789, 2788,
	2789, 2799, 2800,
	2800, 2790, 2789,
	2790, 2800, 2801,
	2801, 2791, 2790,
	2441, 2441, 2802,
	2802, 2792, 2441,
	2792, 2802, 2803,
	2803, 2793, 2792,
	2793, 2803, 2804,
	2804, 2794, 2793,
	2794, 2804, 2805,
	2805, 2795, 2794,
	2795, 2805, 2806,
	2806, 2796, 2795,
	2796, 2806, 2807,
	2807, 2797, 2796,
	2797, 2807, 2808,
	2808, 2798, 2797,
	2798, 2808, 2809,
	2809, 2799, 2798,
	2799, 2809, 2810,
	2810, 2800, 2799,
	2800, 2810, 2811,
	2811, 2801, 2800,
	2441, 2441, 2812,
	2812, 2802, 2441,
	2802, 2812, 2813,
	2813, 2803, 2802,
	2803, 2813, 2814,
	2814, 2804, 2803,
	2804, 2814, 2815,
	2815, 2805, 2804,
	2805, 2815, 2816,
	2816, 2806, 2805,
	2806, 2816, 2817,
	2817, 2807, 2806,
	2807, 2817, 2818,
	2818, 2808, 2807,
	2808, 2818, 2819,
	2819, 2809, 2808,
	2809, 2819, 2820,
	2820, 2810, 2809,
	2810, 2820, 2821,
	2821, 2811, 2810,
	2441, 2441, 2822,
	2822, 2812, 2441,
	2812, 2822, 2823,
	2823, 2813, 2812,
	2813, 2823, 2824,
	2824, 2814, 2813,
	2814, 2824, 2825,
	2825, 2815, 2814,
	2815, 2825, 2826,
	2826, 2816, 2815,
	2816, 2826, 2827,
	2827, 2817, 2816,
	2817, 2827, 2828,
	2828, 2818, 2817,
	2818, 2828, 2829,
	2829, 2819, 2818,
	2819, 2829, 2830,
	2830, 2820, 2819,
	2820, 2830, 2831,
	2831, 2821, 2820,
	2441, 2441, 2832,
	2832, 2822, 2441,
	2822, 2832, 2833,
	2833, 2823, 2822,
	2823, 2833, 2834,
	2834, 2824, 2823,
	2824, 2834, 2835,
	2835, 2825, 2824,
	2825, 2835, 2836,
	2836, 2826, 2825,
	2826, 2836, 2837,
	2837, 2827, 2826,
	2827, 2837, 2838,
	2838, 2828, 2827,
	2828, 2838, 2839,
	2839, 2829, 2828,
	2829, 2839, 2840,
	2840, 2830, 2829,
	2830, 2840, 2841,
	2841, 2831, 2830,
	2441, 2441, 2443,
	2443, 2832, 2441,
	2832, 2443, 2445,
	2445, 2833, 2832,
	2833, 2445, 2447,
	2447, 2834, 2833,
	2834, 2447, 2449,
	2449, 2835, 2834,
	2835, 2449, 2451,
	2451, 2836, 2835,
	2836, 2451, 2453,
	2453, 2837, 2836,
	2837, 2453, 2455,
	2455, 2838, 2837,
	2838, 2455, 2457,
	2457, 2839, 2838,
	2839, 2457, 2459,
	2459, 2840, 2839,
	2840, 2459, 2461,
	2461, 2841, 2840,
	2461, 2460, 2842,
	2842, 2843, 2461,
	2843, 2842, 2844,
	2844, 2845, 2843,
	2845, 2844, 2846,
	2846, 2847, 2845,
	2847, 2846, 2848,
	2848, 2849, 2847,
	2849, 2848, 2850,
	2850, 2851, 2849,
	2851, 2850, 2852,
	2852, 2853, 2851,
	2853, 2852, 2854,
	2854, 2855, 2853,
	2855, 2854, 2856,
	2856, 2857, 2855,
	2857, 2856, 2858,
	2858, 2859, 2857,
	2859, 2858, 2860,
	2860, 2861, 2859,
	2460, 2471, 2862,
	2862, 2842, 2460,
	2842, 2862, 2863,
	2863, 2844, 2842,
	2844, 2863, 2864,
	2864, 2846, 2844,
	2846, 2864, 2865,
	2865, 2848, 2846,
	2848, 2865, 2866,
	2866, 2850, 2848,
	2850, 2866, 2867,
	2867, 2852, 2850,
	2852, 2867, 2868,
	2868, 2854, 2852,
	2854, 2868, 2869,
	2869, 2856, 2854,
	2856, 2869, 2870,
	2870, 2858, 2856,
	2858, 2870, 2871,
	2871, 2860, 2858,
	2471, 2481, 2872,
	2872, 2862, 2471,
	2862, 2872, 2873,
	2873, 2863, 2862,
	2863, 2873, 2874,
	2874, 2864, 2863,
	2864, 2874, 2875,
	2875, 2865, 2864,
	2865, 2875, 2876,
	2876, 2866, 2865,
	2866, 2876, 2877,
	2877, 2867, 2866,
	2867, 2877, 2878,
	2878, 2868, 2867,
	2868, 2878, 2879,
	2879, 2869, 2868,
	2869, 2879, 2880,
	2880, 2870, 2869,
	2870, 2880, 2881,
	2881, 2871, 2870,
	2481, 2491, 2882,
	2882, 2872, 2481,
	2872, 2882, 2883,
	2883, 2873, 2872,
	2873, 2883, 2884,
	2884, 2874, 2873,
	2874, 2884, 2885,
	2885, 2875, 2874,
	2875, 2885, 2886,
	2886, 2876, 2875,
	2876, 2886, 2887,
	2887, 2877, 2876,
	2877, 2887, 2888,
	2888, 2878, 2877,
	2878, 2888, 2889,
	2889, 2879, 2878,
	2879, 2889, 2890,
	2890, 2880, 2879,
	2880, 2890, 2891,
	2891, 2881, 2880,
	2491, 2501, 2892,
	2892, 2882, 2491,
	2882, 2892, 2893,
	2893, 2883, 2882,
	2883, 2893, 2894,
	2894, 2884, 2883,
	2884, 2894, 2895,
	2895, 2885, 2884,
	2885, 2895, 2896,
	2896, 2886, 2885,
	2886, 2896, 2897,
	2897, 2887, 2886,
	2887, 2897, 2898,
	2898, 2888, 2887,
	2888, 2898, 2899,
	2899, 2889, 2888,
	2889, 2899, 2900,
	2900, 2890, 2889,
	2890, 2900, 2901,
	2901, 2891, 2890,
	2501, 2511, 2902,
	2902, 2892, 2501,
	2892, 2902, 2903,
	2903, 2893, 2892,
	2893, 2903, 2904,
	2904, 2894, 2893,
	2894, 2904, 2905,
	2905, 2895, 2894,
	2895, 2905, 2906,
	2906, 2896, 2895,
	2896, 2906, 2907,
	2907, 2897, 2896,
	2897, 2907, 2908,
	2908, 2898, 2897,
	2898, 2908, 2909,
	2909, 2899, 2898,
	2899, 2909, 2910,
	2910, 2900, 2899,
	2900, 2910, 2911,
	2911, 2901, 2900,
	2511, 2521, 2912,
	2912, 2902, 2511,
	2902, 2912, 2913,
	2913, 2903, 2902,
	2903, 2913, 2914,
	2914, 2904, 2903,
	2904, 2914, 2915,
	2915, 2905, 2904,
	2905, 2915, 2916,
	2916, 2906, 2905,
	2906, 2916, 2917,
	2917, 2907, 2906,
	2907, 2917, 2918,
	2918, 2908, 2907,
	2908, 2918, 2919,
	2919, 2909, 2908,
	2909, 2919, 2920,
	2920, 2910, 2909,
	2910, 2920, 2921,
	2921, 2911, 2910,
	2521, 2531, 2922,
	2922, 2912, 2521,
	2912, 2922, 2923,
	2923, 2913, 2912,
	2913, 2923, 2924,
	2924, 2914, 2913,
	2914, 2924, 2925,
	2925, 2915, 2914,
	2915, 2925, 2926,
	2926, 2916, 2915,
	2916, 2926, 2927,
	2927, 2917, 2916,
	2917, 2927, 2928,
	2928, 2918, 2917,
	2918, 2928, 2929,
	2929, 2919, 2918,
	2919, 2929, 2930,
	2930, 2920, 2919,
	2920, 2930, 2931,
	2931, 2921, 2920,
	2531, 2541, 2932,
	2932, 2922, 2531,
	2922, 2932, 2933,
	2933, 2923, 2922,
	2923, 2933, 2934,
	2934, 2924, 2923,
	2924, 2934, 2935,
	2935, 2925, 2924,
	2925, 2935, 2936,
	2936, 2926, 2925,
	2926, 2936, 2937,
	2937, 2927, 2926,
	2927, 2937, 2938,
	2938, 2928, 2927,
	2928, 2938, 2939,
	2939, 2929, 2928,
	2929, 2939, 2940,
	2940, 2930, 2929,
	2930, 2940, 2941,
	2941, 2931, 2930,
	2541, 2551, 2942,
	2942, 2932, 2541,
	2932, 2942, 2943,
	2943, 2933, 2932,
	2933, 2943, 2944,
	2944, 2934, 2933,
	2934, 2944, 2945,
	2945, 2935, 2934,
	2935, 2945, 2946,
	2946, 2936, 2935,
	2936, 2946, 2947,
	2947, 2937, 2936,
	2937, 2947, 2948,
	2948, 2938, 2937,
	2938, 2948, 2949,
	2949, 2939, 2938,
	2939, 2949, 2950,
	2950, 2940, 2939,
	2940, 2950, 2951,
	2951, 2941, 2940,
	2551, 2561, 2952,
	2952, 2942, 2551,
	2942, 2952, 2953,
	2953, 2943, 2942,
	2943, 2953, 2954,
	2954, 2944, 2943,
	2944, 2954, 2955,
	2955, 2945, 2944,
	2945, 2955, 2956,
	2956, 2946, 2945,
	2946, 2956, 2957,
	2957, 2947, 2946,
	2947, 2957, 2958,
	2958, 2948, 2947,
	2948, 2958, 2959,
	2959, 2949, 2948,
	2949, 2959, 2960,
	2960, 2950, 2949,
	2950, 2960, 2961,
	2961, 2951, 2950,
	2561, 2571, 2962,
	2962, 2952, 2561,
	2952, 2962, 2963,
	2963, 2953, 2952,
	2953, 2963, 2964,
	2964, 2954, 2953,
	2954, 2964, 2965,
	2965, 2955, 2954,
	2955, 2965, 2966,
	2966, 2956, 2955,
	2956, 2966, 2967,
	2967, 2957, 2956,
	2957, 2967, 2968,
	2968, 2958, 2957,
	2958, 2968, 2969,
	2969, 2959, 2958,
	2959, 2969, 2970,
	2970, 2960, 2959,
	2960, 2970, 2971,
	2971, 2961, 2960,
	2571, 2581, 2972,
	2972, 2962, 2571,
	2962, 2972, 2973,
	2973, 2963, 2962,
	2963, 2973, 2974,
	2974, 2964, 2963,
	2964, 2974, 2975,
	2975, 2965, 2964,
	2965, 2975, 2976,
	2976, 2966, 2965,
	2966, 2976, 2977,
	2977, 2967, 2966,
	2967, 2977, 2978,
	2978, 2968, 2967,
	2968, 2978, 2979,
	2979, 2969, 2968,
	2969, 2979, 2980,
	2980, 2970, 2969,
	2970, 2980, 2981,
	2981, 2971, 2970,
	2581, 2591, 2982,
	2982, 2972, 2581,
	2972, 2982, 2983,
	2983, 2973, 2972,
	2973, 2983, 2984,
	2984, 2974, 2973,
	2974, 2984, 2985,
	2985, 2975, 2974,
	2975, 2985, 2986,
	2986, 2976, 2975,
	2976, 2986, 2987,
	2987, 2977, 2976,
	2977, 2987, 2988,
	2988, 2978, 2977,
	2978, 2988, 2989,
	2989, 2979, 2978,
	2979, 2989, 2990,
	2990, 2980, 2979,
	2980, 2990, 2991,
	2991, 2981, 2980,
	2591, 2601, 2992,
	2992, 2982, 2591,
	2982, 2992, 2993,
	2993, 2983, 2982,
	2983, 2993, 2994,
	2994, 2984, 2983,
	2984, 2994, 2995,
	2995, 2985, 2984,
	2985, 2995, 2996,
	2996, 2986, 2985,
	2986, 2996, 2997,
	2997, 2987, 2986,
	2987, 2997, 2998,
	2998, 2988, 2987,
	2988, 2998, 2999,
	2999, 2989, 2988,
	2989, 2999, 3000,
	3000, 2990, 2989,
	2990, 3000, 3001,
	3001, 2991, 2990,
	2601, 2611, 3002,
	3002, 2992, 2601,
	2992, 3002, 3003,
	3003, 2993, 2992,
	2993, 3003, 3004,
	3004, 2994, 2993,
	2994, 3004, 3005,
	3005, 2995, 2994,
	2995, 3005, 3006,
	3006, 2996, 2995,
	2996, 3006, 3007,
	3007, 2997, 2996,
	2997, 3007, 3008,
	3008, 2998, 2997,
	2998, 3008, 3009,
	3009, 2999, 2998,
	2999, 3009, 3010,
	3010, 3000, 2999,
	3000, 3010, 3011,
	3011, 3001, 3000,
	2611, 2621, 3012,
	3012, 3002, 2611,
	3002, 3012, 3013,
	3013, 3003, 3002,
	3003, 3013, 3014,
	3014, 3004, 3003,
	3004, 3014, 3015,
	3015, 3005, 3004,
	3005, 3015, 3016,
	3016, 3006, 3005,
	3006, 3016, 3017,
	3017, 3007, 3006,
	3007, 3017, 3018,
	3018, 3008, 3007,
	3008, 3018, 3019,
	3019, 3009, 3008,
	3009, 3019, 3020,
	3020, 3010, 3009,
	3010, 3020, 3021,
	3021, 3011, 3010,
	2621, 2631, 3022,
	3022, 3012, 2621,
	3012, 3022, 3023,
	3023, 3013, 3012,
	3013, 3023, 3024,
	3024, 3014, 3013,
	3014, 3024, 3025,
	3025, 3015, 3014,
	3015, 3025, 3026,
	3026, 3016, 3015,
	3016, 3026, 3027,
	3027, 3017, 3016,
	3017, 3027, 3028,
	3028, 3018, 3017,
	3018, 3028, 3029,
	3029, 3019, 3018,
	3019, 3029, 3030,
	3030, 3020, 3019,
	3020, 3030, 3031,
	3031, 3021, 3020,
	2631, 2641, 3032,
	3032, 3022, 2631,
	3022, 3032, 3033,
	3033, 3023, 3022,
	3023, 3033, 3034,
	3034, 3024, 3023,
	3024, 3034, 3035,
	3035, 3025, 3024,
	3025, 3035, 3036,
	3036, 3026, 3025,
	3026, 3036, 3037,
	3037, 3027, 3026,
	3027, 3037, 3038,
	3038, 3028, 3027,
	3028, 3038, 3039,
	3039, 3029, 3028,
	3029, 3039, 3040,
	3040, 3030, 3029,
	3030, 3040, 3041,
	3041, 3031, 3030,
	2641, 2651, 3042,
	3042, 3032, 2641,
	3032, 3042, 3043,
	3043, 3033, 3032,
	3033, 3043, 3044,
	3044, 3034, 3033,
	3034, 3044, 3045,
	3045, 3035, 3034,
	3035, 3045, 3046,
	3046, 3036, 3035,
	3036, 3046, 3047,
	3047, 3037, 3036,
	3037, 3047, 3048,
	3048, 3038, 3037,
	3038, 3048, 3049,
	3049, 3039, 3038,
	3039, 3049, 3050,
	3050, 3040, 3039,
	3040, 3050, 3051,
	3051, 3041, 3040,
	2651, 2661, 3052,
	3052, 3042, 2651,
	3042, 3052, 3053,
	3053, 3043, 3042,
	3043, 3053, 3054,
	3054, 3044, 3043,
	3044, 3054, 3055,
	3055, 3045, 3044,
	3045, 3055, 3056,
	3056, 3046, 3045,
	3046, 3056, 3057,
	3057, 3047, 3046,
	3047, 3057, 3058,
	3058, 3048, 3047,
	3048, 3058, 3059,
	3059, 3049, 3048,
	3049, 3059, 3060,
	3060, 3050, 3049,
	3050, 3060, 3061,
	3061, 3051, 3050,
	2661, 2671, 3062,
	3062, 3052, 2661,
	3052, 3062, 3063,
	3063, 3053, 3052,
	3053, 3063, 3064,
	3064, 3054, 3053,
	3054, 3064, 3065,
	3065, 3055, 3054,
	3055, 3065, 3066,
	3066, 3056, 3055,
	3056, 3066, 3067,
	3067, 3057, 3056,
	3057, 3067, 3068,
	3068, 3058, 3057,
	3058, 3068, 3069,
	3069, 3059, 3058,
	3059, 3069, 3070,
	3070, 3060, 3059,
	3060, 3070, 3071,
	3071, 3061, 3060,
	2671, 2681, 3072,
	3072, 3062, 2671,
	3062, 3072, 3073,
	3073, 3063, 3062,
	3063, 3073, 3074,
	3074, 3064, 3063,
	3064, 3074, 3075,
	3075, 3065, 3064,
	3065, 3075, 3076,
	3076, 3066, 3065,
	3066, 3076, 3077,
	3077, 3067, 3066,
	3067, 3077, 3078,
	3078, 3068, 3067,
	3068, 3078, 3079,
	3079, 3069, 3068,
	3069, 3079, 3080,
	3080, 3070, 3069,
	3070, 3080, 3081,
	3081, 3071, 3070,
	2681, 2691, 3082,
	3082, 3072, 2681,
	3072, 3082, 3083,
	3083, 3073, 3072,
	3073, 3083, 3084,
	3084, 3074, 3073,
	3074, 3084, 3085,
	3085, 3075, 3074,
	3075, 3085, 3086,
	3086, 3076, 3075,
	3076, 3086, 3087,
	3087, 3077, 3076,
	3077, 3087, 3088,
	3088, 3078, 3077,
	3078, 3088, 3089,
	3089, 3079, 3078,
	3079, 3089, 3090,
	3090, 3080, 3079,
	3080, 3090, 3091,
	3091, 3081, 3080,
	2691, 2701, 3092,
	3092, 3082, 2691,
	3082, 3092, 3093,
	3093, 3083, 3082,
	3083, 3093, 3094,
	3094, 3084, 3083,
	3084, 3094, 3095,
	3095, 3085, 3084,
	3085, 3095, 3096,
	3096, 3086, 3085,
	3086, 3096, 3097,
	3097, 3087, 3086,
	3087, 3097, 3098,
	3098, 3088, 3087,
	3088, 3098, 3099,
	3099, 3089, 3088,
	3089, 3099, 3100,
	3100, 3090, 3089,
	3090, 3100, 3101,
	3101, 3091, 3090,
	2701, 2711, 3102,
	3102, 3092, 2701,
	3092, 3102, 3103,
	3103, 3093, 3092,
	3093, 3103, 3104,
	3104, 3094, 3093,
	3094, 3104, 3105,
	3105, 3095, 3094,
	3095, 3105, 3106,
	3106, 3096, 3095,
	3096, 3106, 3107,
	3107, 3097, 3096,
	3097, 3107, 3108,
	3108, 3098, 3097,
	3098, 3108, 3109,
	3109, 3099, 3098,
	3099, 3109, 3110,
	3110, 3100, 3099,
	3100, 3110, 3111,
	3111, 3101, 3100,
	2711, 2721, 3112,
	3112, 3102, 2711,
	3102, 3112, 3113,
	3113, 3103, 3102,
	3103, 3113, 3114,
	3114, 3104, 3103,
	3104, 3114, 3115,
	3115, 3105, 3104,
	3105, 3115, 3116,
	3116, 3106, 3105,
	3106, 3116, 3117,
	3117, 3107, 3106,
	3107, 3117, 3118,
	3118, 3108, 3107,
	3108, 3118, 3119,
	3119, 3109, 3108,
	3109, 3119, 3120,
	3120, 3110, 3109,
	3110, 3120, 3121,
	3121, 3111, 3110,
	2721, 2731, 3122,
	3122, 3112, 2721,
	3112, 3122, 3123,
	3123, 3113, 3112,
	3113, 3123, 3124,
	3124, 3114, 3113,
	3114, 3124, 3125,
	3125, 3115, 3114,
	3115, 3125, 3126,
	3126, 3116, 3115,
	3116, 3126, 3127,
	3127, 3117, 3116,
	3117, 3127, 3128,
	3128, 3118, 3117,
	3118, 3128, 3129,
	3129, 3119, 3118,
	3119, 3129, 3130,
	3130, 3120, 3119,
	3120, 3130, 3131,
	3131, 3121, 3120,
	2731, 2741, 3132,
	3132, 3122, 2731,
	3122, 3132, 3133,
	3133, 3123, 3122,
	3123, 3133, 3134,
	3134, 3124, 3123,
	3124, 3134, 3135,
	3135, 3125, 3124,
	3125, 3135, 3136,
	3136, 3126, 3125,
	3126, 3136, 3137,
	3137, 3127, 3126,
	3127, 3137, 3138,
	3138, 3128, 3127,
	3128, 3138, 3139,
	3139, 3129, 3128,
	3129, 3139, 3140,
	3140, 3130, 3129,
	3130, 3140, 3141,
	3141, 3131, 3130,
	2741, 2751, 3142,
	3142, 3132, 2741,
	3132, 3142, 3143,
	3143, 3133, 3132,
	3133, 3143, 3144,
	3144, 3134, 3133,
	3134, 3144, 3145,
	3145, 3135, 3134,
	3135, 3145, 3146,
	3146, 3136, 3135,
	3136, 3146, 3147,
	3147, 3137, 3136,
	3137, 3147, 3148,
	3148, 3138, 3137,
	3138, 3148, 3149,
	3149, 3139, 3138,
	3139, 3149, 3150,
	3150, 3140, 3139,
	3140, 3150, 3151,
	3151, 3141, 3140,
	2751, 2761, 3152,
	3152, 3142, 2751,
	3142, 3152, 3153,
	3153, 3143, 3142,
	3143, 3153, 3154,
	3154, 3144, 3143,
	3144, 3154, 3155,
	3155, 3145, 3144,
	3145, 3155, 3156,
	3156, 3146, 3145,
	3146, 3156, 3157,
	3157, 3147, 3146,
	3147, 3157, 3158,
	3158, 3148, 3147,
	3148, 3158, 3159,
	3159, 3149, 3148,
	3149, 3159, 3160,
	3160, 3150, 3149,
	3150, 3160, 3161,
	3161, 3151, 3150,
	2761, 2771, 3162,
	3162, 3152, 2761,
	3152, 3162, 3163,
	3163, 3153, 3152,
	3153, 3163, 3164,
	3164, 3154, 3153,
	3154, 3164, 3165,
	3165, 3155, 3154,
	3155, 3165, 3166,
	3166, 3156, 3155,
	3156, 3166, 3167,
	3167, 3157, 3156,
	3157, 3167, 3168,
	3168, 3158, 3157,
	3158, 3168, 3169,
	3169, 3159, 3158,
	3159, 3169, 3170,
	3170, 3160, 3159,
	3160, 3170, 3171,
	3171, 3161, 3160,
	2771, 2781, 3172,
	3172, 3162, 2771,
	3162, 3172, 3173,
	3173, 3163, 3162,
	3163, 3173, 3174,
	3174, 3164, 3163,
	3164, 3174, 3175,
	3175, 3165, 3164,
	3165, 3175, 3176,
	3176, 3166, 3165,
	3166, 3176, 3177,
	3177, 3167, 3166,
	3167, 3177, 3178,
	3178, 3168, 3167,
	3168, 3178, 3179,
	3179, 3169, 3168,
	3169, 3179, 3180,
	3180, 3170, 3169,
	3170, 3180, 3181,
	3181, 3171, 3170,
	2781, 2791, 3182,
	3182, 3172, 2781,
	3172, 3182, 3183,
	3183, 3173, 3172,
	3173, 3183, 3184,
	3184, 3174, 3173,
	3174, 3184, 3185,
	3185, 3175, 3174,
	3175, 3185, 3186,
	3186, 3176, 3175,
	3176, 3186, 3187,
	3187, 3177, 3176,
	3177, 3187, 3188,
	3188, 3178, 3177,
	3178, 3188, 3189,
	3189, 3179, 3178,
	3179, 3189, 3190,
	3190, 3180, 3179,
	3180, 3190, 3191,
	3191, 3181, 3180,
	2791, 2801, 3192,
	3192, 3182, 2791,
	3182, 3192, 3193,
	3193, 3183, 3182,
	3183, 3193, 3194,
	3194, 3184, 3183,
	3184, 3194, 3195,
	3195, 3185, 3184,
	3185, 3195, 3196,
	3196, 3186, 3185,
	3186, 3196, 3197,
	3197, 3187, 3186,
	3187, 3197, 3198,
	3198, 3188, 3187,
	3188, 3198, 3199,
	3199, 3189, 3188,
	3189, 3199, 3200,
	3200, 3190, 3189,
	3190, 3200, 3201,
	3201, 3191, 3190,
	2801, 2811, 3202,
	3202, 3192, 2801,
	3192, 3202, 3203,
	3203, 3193, 3192,
	3193, 3203, 3204,
	3204, 3194, 3193,
	3194, 3204, 3205,
	3205, 3195, 3194,
	3195, 3205, 3206,
	3206, 3196, 3195,
	3196, 3206, 3207,
	3207, 3197, 3196,
	3197, 3207, 3208,
	3208, 3198, 3197,
	3198, 3208, 3209,
	3209, 3199, 3198,
	3199, 3209, 3210,
	3210, 3200, 3199,
	3200, 3210, 3211,
	3211, 3201, 3200,
	2811, 2821, 3212,
	3212, 3202, 2811,
	3202, 3212, 3213,
	3213, 3203, 3202,
	3203, 3213, 3214,
	3214, 3204, 3203,
	3204, 3214, 3215,
	3215, 3205, 3204,
	3205, 3215, 3216,
	3216, 3206, 3205,
	3206, 3216, 3217,
	3217, 3207, 3206,
	3207, 3217, 3218,
	3218, 3208, 3207,
	3208, 3218, 3219,
	3219, 3209, 3208,
	3209, 3219, 3220,
	3220, 3210, 3209,
	3210, 3220, 3221,
	3221, 3211, 3210,
	2821, 2831, 3222,
	3222, 3212, 2821,
	3212, 3222, 3223,
	3223, 3213, 3212,
	3213, 3223, 3224,
	3224, 3214, 3213,
	3214, 3224, 3225,
	3225, 3215, 3214,
	3215, 3225, 3226,
	3226, 3216, 3215,
	3216, 3226, 3227,
	3227, 3217, 3216,
	3217, 3227, 3228,
	3228, 3218, 3217,
	3218, 3228, 3229,
	3229, 3219, 3218,
	3219, 3229, 3230,
	3230, 3220, 3219,
	3220, 3230, 3231,
	3231, 3221, 3220,
	2831, 2841, 3232,
	3232, 3222, 2831,
	3222, 3232, 3233,
	3233, 3223, 3222,
	3223, 3233, 3234,
	3234, 3224, 3223,
	3224, 3234, 3235,
	3235, 3225, 3224,
	3225, 3235, 3236,
	3236, 3226, 3225,
	3226, 3236, 3237,
	3237, 3227, 3226,
	3227, 3237, 3238,
	3238, 3228, 3227,
	3228, 3238, 3239,
	3239, 3229, 3228,
	3229, 3239, 3240,
	3240, 3230, 3229,
	3230, 3240, 3241,
	3241, 3231, 3230,
	2841, 2461, 2843,
	2843, 3232, 2841,
	3232, 2843, 2845,
	2845, 3233, 3232,
	3233, 2845, 2847,
	2847, 3234, 3233,
	3234, 2847, 2849,
	2849, 3235, 3234,
	3235, 2849, 2851,
	2851, 3236, 3235,
	3236, 2851, 2853,
	2853, 3237, 3236,
	3237, 2853, 2855,
	2855, 3238, 3237,
	3238, 2855, 2857,
	2857, 3239, 3238,
	3239, 2857, 2859,
	2859, 3240, 3239,
	3240, 2859, 2861,
	2861, 3241, 3240
};

#endif
