/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "$(appName).h"

typedef struct viewdata {
	Evas_Object *grid1;
	Evas_Object *grid2;
	Evas_Object *label1;
	Evas_Object *label2;
	Evas_Object *label3;
} viewdata_s;

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *layout;
	Evas_Object *nf;
	Evas_Object *tabbar;
	int current_degree;

	viewdata_s *vd;
} appdata_s;

typedef struct item_data {
	int index;
	Elm_Object_Item *item;
} item_data_s;

static void
win_delete_request_cb(void *data , Evas_Object *obj , void *event_info)
{
	ui_app_exit();
}

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_lower(ad->win);
}

static char*
gl_text_get_cb(void *data, Evas_Object *obj, const char *part)
{
	item_data_s *id = data;
	char buf[1024];

	if (id->index == 0) {
		if (!strcmp(part, "elm.text.main.left.top")) {
			snprintf(buf, 1023, "%s", "07:26");
			return strdup(buf);
		}
		else if (!strcmp(part, "elm.text.sub.right.top")) {
			snprintf(buf, 1023, "%s", "Cardiff");
			return strdup(buf);
		}
		else if (!strcmp(part, "elm.text.sub.left.bottom")) {
			snprintf(buf, 1023, "%s", "Wed, Jan 1");
			return strdup(buf);
		}
		else if (!strcmp(part, "elm.text.sub.right.bottom")) {
			snprintf(buf, 1023, "%s", "wales");
			return strdup(buf);
		}
	}

	if (id->index == 1) {
			if (!strcmp(part, "elm.text.main.left.top")) {
				snprintf(buf, 1023, "%s", "08:26");
				return strdup(buf);
			}
			else if (!strcmp(part, "elm.text.sub.right.top")) {
				snprintf(buf, 1023, "%s", "Hong Kong");
				return strdup(buf);
			}
			else if (!strcmp(part, "elm.text.sub.left.bottom")) {
				snprintf(buf, 1023, "%s", "Wed, Jan 1");
				return strdup(buf);
			}
			else if (!strcmp(part, "elm.text.sub.right.bottom")) {
				snprintf(buf, 1023, "%s", "China");
				return strdup(buf);
			}
		}

	if (id->index == 2) {
			if (!strcmp(part, "elm.text.main.left.top")) {
				snprintf(buf, 1023, "%s", "09:26");
				return strdup(buf);
			}
			else if (!strcmp(part, "elm.text.sub.right.top")) {
				snprintf(buf, 1023, "%s", "Tokyo");
				return strdup(buf);
			}
			else if (!strcmp(part, "elm.text.sub.left.bottom")) {
				snprintf(buf, 1023, "%s", "Wed, Jan 1");
				return strdup(buf);
			}
			else if (!strcmp(part, "elm.text.sub.right.bottom")) {
				snprintf(buf, 1023, "%s", "Japan");
				return strdup(buf);
			}
		}

	return NULL;
}
static Evas_Object*
create_bg(Evas_Object *parent, int type)
{
	Evas_Object *bg;

	bg = elm_bg_add(parent);
	evas_object_size_hint_weight_set(bg, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(bg, EVAS_HINT_FILL, EVAS_HINT_FILL);

	if (type == 1)
		elm_bg_color_set(bg, 0, 0, 0);
	else
		elm_bg_color_set(bg, 0, 40, 40);

	evas_object_show(bg);

	return bg;
}

static Evas_Object*
create_img(Evas_Object *parent, char *filename)
{
	Evas_Object *img;
	char buf[PATH_MAX];

	img = elm_image_add(parent);
	snprintf(buf, sizeof(buf), "%s/%s", ICON_DIR, filename);
	elm_image_file_set(img, buf, NULL);
	evas_object_show(img);

	return img;
}

static Evas_Object*
create_btn(Evas_Object *parent, char *text)
{
	Evas_Object *btn;
	char buf[PATH_MAX];

	btn = elm_button_add(parent);
	evas_object_size_hint_weight_set(btn, EVAS_HINT_EXPAND, 0.0);
	evas_object_size_hint_align_set(btn, EVAS_HINT_FILL, EVAS_HINT_FILL);
	snprintf(buf, sizeof(buf), "%s", text);
	elm_object_text_set(btn, buf);
	evas_object_show(btn);

	return btn;
}

static Evas_Object*
create_alarm_view(appdata_s *ad)
{
	Evas_Object *box, *grid1, *bg1, *label1, *label2, *grid2, *bg2, *img, *label3, *btn;

	box = elm_box_add(ad->nf);
	evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(box, EVAS_HINT_FILL, EVAS_HINT_FILL);

	grid1 = elm_grid_add(box);
	evas_object_size_hint_weight_set(grid1, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(grid1, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(grid1);

	bg1 = create_bg(grid1, 1);
	elm_grid_pack(grid1, bg1, 0, 0, 100, 100);

	label1 = elm_label_add(grid1);
	elm_object_text_set(label1, "<font_size=110><color=#ffffff>07:26</color></font_size>");
	evas_object_show(label1);
	elm_grid_pack(grid1, label1, 22, 8, 100, 100);

	label2 = elm_label_add(grid1);
	elm_object_text_set(label2, "<font_size=22><color=#a6a6a6>wed, January 1</color></font_size>");
	evas_object_show(label2);
	elm_grid_pack(grid1, label2, 35, 78, 100, 100);

	grid2 = elm_grid_add(box);
	evas_object_size_hint_weight_set(grid2, EVAS_HINT_EXPAND, 0.0);
	evas_object_size_hint_align_set(grid2, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_size_hint_min_set(grid2, -1, ELM_SCALE_SIZE(430));
	evas_object_show(grid2);

	bg2 = create_bg(grid2, 2);
	elm_grid_pack(grid2, bg2, 0, 0, 100, 100);

	img = create_img(grid2, "no_alarm.png");
	elm_grid_pack(grid2, img, 32, 32, 36, 36);

	label3 = elm_label_add(grid2);
	elm_object_text_set(label3, "<b><font_size=22><color=#ffffff>No alarms</color></font_size></b>");
	evas_object_show(label3);
	elm_grid_pack(grid2, label3, 40, 68, 100, 100);

	btn = create_btn(box, "Create alarm");

	elm_box_pack_end(box, grid1);
	elm_box_pack_end(box, grid2);
	elm_box_pack_end(box, btn);

	return box;
}

static Evas_Object*
create_landscape_alarm_view(appdata_s *ad)
{
	Evas_Object *box1, *box2, *label1, *label2, *label3, *img, *bg1, *bg2, *grid1, *grid2, *btn;

	box1 = elm_box_add(ad->nf);
	evas_object_size_hint_weight_set(box1, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(box1, EVAS_HINT_FILL, EVAS_HINT_FILL);

	box2 = elm_box_add(box1);
	evas_object_size_hint_weight_set(box2, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(box2, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_box_horizontal_set(box2, EINA_TRUE);

	grid1 = elm_grid_add(box2);
	evas_object_size_hint_weight_set(grid1, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(grid1, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(grid1);

	bg1 = create_bg(grid1, 1);
	elm_grid_pack(grid1, bg1, 0, 0, 100, 100);

	label1 = elm_label_add(grid1);
	elm_object_text_set(label1, "<font_size=100><color=#ffffff>07:26</color></font_size>");
	evas_object_show(label1);
	elm_grid_pack(grid1, label1, 10, 30, 100, 100);

	label2 = elm_label_add(grid1);
	elm_object_text_set(label2, "<font_size=22><color=#a6a6a6>wed, January 1</color></font_size>");
	evas_object_show(label2);
	elm_grid_pack(grid1, label2, 25, 62, 100, 100);

	grid2 = elm_grid_add(box2);
	evas_object_size_hint_weight_set(grid2, 0.0, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(grid2, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_size_hint_min_set(grid2, 480, -1);
	evas_object_show(grid2);

	bg2 = create_bg(grid2, 2);
	elm_grid_pack(grid2, bg2, 0, 0, 100, 100);

	img = create_img(grid2, "no_alarm.png");
	elm_grid_pack(grid2, img, 32, 32, 36, 36);

	label3 = elm_label_add(grid2);
	elm_object_text_set(label3, "<b><font_size=22><color=#ffffff>No alarms</color></font_size></b>");
	evas_object_show(label3);
	elm_grid_pack(grid2, label3, 40, 68, 100, 100);
	evas_object_show(box2);

	elm_box_pack_end(box2, grid1);
	elm_box_pack_end(box2, grid2);

	btn = create_btn(box1, "Create alarm");

	elm_box_pack_end(box1, box2);
	elm_box_pack_end(box1, btn);

	return box1;
}

static Evas_Object*
create_worldclock_view(appdata_s *ad)
{
	Evas_Object *list, *box, *grid1, *bg1, *label1, *label2, *grid2, *label3, *btn;
	Elm_Genlist_Item_Class *itc = NULL;
	int i, num_of_item;
	Elm_Object_Item *it;

	box = elm_box_add(ad->nf);
	evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(box, EVAS_HINT_FILL, EVAS_HINT_FILL);

	grid1 = elm_grid_add(box);
	evas_object_size_hint_weight_set(grid1, EVAS_HINT_EXPAND, 0.0);
	evas_object_size_hint_align_set(grid1, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_size_hint_min_set(grid1, -1, ELM_SCALE_SIZE(265));
	evas_object_show(grid1);

	bg1 = create_bg(grid1, 1);
	elm_grid_pack(grid1, bg1, 0, 0, 100, 100);

	label1 = elm_label_add(grid1);
	elm_object_text_set(label1, "<font_size=110><color=#ffffff>07:26</color></font_size>");
	evas_object_show(label1);

	label2 = elm_label_add(grid1);
	elm_object_text_set(label2, "<font_size=26><color=#00ff00>Cardiff,Wales</color></font_size>");
	evas_object_show(label2);

	label3 = elm_label_add(grid1);
	elm_object_text_set(label3, "<b><font_size=22><color=#a6a6a6>wed, January 1</color></font_size></b>");
	evas_object_show(label3);

	if (ad->current_degree == 0 || ad->current_degree == 180) {
		elm_grid_pack(grid1, label1, 22, 17, 100, 100);
		elm_grid_pack(grid1, label2, 35, 62, 100, 100);
		elm_grid_pack(grid1, label3, 36, 73, 100, 100);
	}
	else {
		elm_grid_pack(grid1, label1, 33, 16, 100, 100);
		elm_grid_pack(grid1, label2, 40, 58, 100, 100);
		elm_grid_pack(grid1, label3, 41, 69, 100, 100);
	}

	grid2 = elm_grid_add(box);
	evas_object_size_hint_weight_set(grid2, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(grid2, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(grid2);

	itc = elm_genlist_item_class_new();
	itc->item_style = "2line.top.4";
	itc->func.text_get = gl_text_get_cb;
	itc->func.content_get = NULL;
	itc->func.del = NULL;

	list = elm_genlist_add(grid2);

	num_of_item = 3;
	for (i = 0; i < num_of_item; i++) {
		item_data_s *id = calloc(sizeof(item_data_s), 1);
		id->index = i;
		it = elm_genlist_item_append(list,
									 itc,
									 id,
									 NULL,
									 ELM_GENLIST_ITEM_NONE,
									 NULL,
									 id);
		id->item = it;
	}
	evas_object_size_hint_weight_set(list, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(list);
	elm_grid_pack(grid2, list, 0, 0, 100, 100);

	btn = create_btn(box, "Add city");

	elm_box_pack_end(box, grid1);
	elm_box_pack_end(box, grid2);
	elm_box_pack_end(box, btn);


	viewdata_s *vd = calloc(1, sizeof(viewdata_s));
	ad->vd = vd;
	ad->vd->grid1 = grid1;
	ad->vd->grid2 = grid2;
	ad->vd->label1 = label1;
	ad->vd->label2 = label2;
	ad->vd->label3 = label3;

	return box;
}

static Evas_Object*
create_timer_view(appdata_s *ad)
{
	Evas_Object *box, *inner_box, *grid1, *bg1, *label1, *label2, *grid2, *table, *btn;
	int i, j, index;
	char buf[PATH_MAX];

	box = elm_box_add(ad->nf);
	evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(box, EVAS_HINT_FILL, EVAS_HINT_FILL);

	grid1 = elm_grid_add(box);
	evas_object_size_hint_weight_set(grid1, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(grid1, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(grid1);

	bg1 = create_bg(grid1, 1);
	elm_grid_pack(grid1, bg1, 0, 0, 100, 100);

	label1 = elm_label_add(grid1);
	elm_object_text_set(label1, "<font_size=110><color=#ffffff>00:00:00</color></font_size>");
	evas_object_show(label1);
	elm_grid_pack(grid1, label1, 6, 22, 100, 100);

	label2 = elm_label_add(grid1);
	elm_object_text_set(label2, "<b><font_size=22><color=#a6a6a6>Hour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;"
								"&nbsp; &nbsp; Min&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Sec</color></font_size></b>");
	evas_object_show(label2);
	elm_grid_pack(grid1, label2, 12, 19, 100, 100);

	grid2 = elm_grid_add(box);
	evas_object_size_hint_weight_set(grid2, EVAS_HINT_EXPAND, 0.0);
	evas_object_size_hint_align_set(grid2, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_size_hint_min_set(grid2, -1, ELM_SCALE_SIZE(430));
	evas_object_show(grid2);

	inner_box = elm_box_add(grid2);
	evas_object_size_hint_weight_set(inner_box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(inner_box, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(inner_box);

	table = elm_table_add(inner_box);
	evas_object_show(table);
	elm_table_padding_set(table, 5, 5);
	elm_table_homogeneous_set(table, EINA_TRUE);

	index = 0;
	for (i = 0 ; i < 4 ; i++) {
		for (j = 0; j < 3; j++) {
			index++;
			if (index == 10)
				snprintf(buf, sizeof(buf), "%s", "<font_size=50>Del</font_size>");
			else if (index == 11)
				snprintf(buf, sizeof(buf), "%s", "<font_size=50>0</font_size>");
			else if (index == 12)
				snprintf(buf, sizeof(buf), "%s", "<font_size=50>Next</font_size>");
			else
				snprintf(buf, sizeof(buf), "%s%d%s", "<font_size=50>", index, "</font_size>");
			btn = create_btn(grid2, buf);
			evas_object_size_hint_min_set(btn, ELM_SCALE_SIZE(150), ELM_SCALE_SIZE(100));
			elm_table_pack(table, btn, j, i, 1, 1);
		}
	}

	elm_box_pack_end(inner_box, table);
	elm_grid_pack(grid2, inner_box, 0, 0, 100, 100);

	btn = create_btn(box, "Start");

	elm_box_pack_end(box, grid1);
	elm_box_pack_end(box, grid2);
	elm_box_pack_end(box, btn);

	return box;
}

static Evas_Object*
create_landscape_timer_view(appdata_s *ad)
{
	Evas_Object *box, *grid1, *bg1, *label1, *label2, *grid2, *table, *btn;
	int i, j, index;
	char buf[PATH_MAX];

	box = elm_box_add(ad->nf);
	evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(box, EVAS_HINT_FILL, EVAS_HINT_FILL);

	grid1 = elm_grid_add(box);
	evas_object_size_hint_weight_set(grid1, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(grid1, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(grid1);

	bg1 = create_bg(grid1, 1);
	elm_grid_pack(grid1, bg1, 0, 0, 100, 100);

	label1 = elm_label_add(grid1);
	elm_object_text_set(label1, "<font_size=110><color=#ffffff>00:00:00</color></font_size>");
	evas_object_show(label1);
	elm_grid_pack(grid1, label1, 24, 30, 100, 100);

	label2 = elm_label_add(grid1);
	elm_object_text_set(label2, "<b><font_size=22><color=#a6a6a6>Hour&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;"
								"&nbsp; &nbsp; Min&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Sec</color></font_size></b>");
	evas_object_show(label2);
	elm_grid_pack(grid1, label2, 28, 20, 100, 100);

	grid2 = elm_grid_add(box);
	evas_object_size_hint_weight_set(grid2, EVAS_HINT_EXPAND, 0.0);
	evas_object_size_hint_align_set(grid2, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_size_hint_min_set(grid2, -1, 150);
	evas_object_show(grid2);

	table = elm_table_add(grid2);
	evas_object_show(table);
	elm_table_padding_set(table, 5, 5);
	elm_table_homogeneous_set(table, EINA_TRUE);

	index = 0;
	for (i = 0 ; i < 2 ; i++) {
		for (j = 0; j < 6; j++) {
			index++;
			if (index == 6)
				snprintf(buf, sizeof(buf), "%s", "<font_size=50>Del</font_size>");
			else if (index == 11)
				snprintf(buf, sizeof(buf), "%s", "<font_size=50>0</font_size>");
			else if (index == 12)
				snprintf(buf, sizeof(buf), "%s", "<font_size=40>Start</font_size>");
			else {
				if (index > 6)
					snprintf(buf, sizeof(buf), "%s%d%s", "<font_size=50>", index -1, "</font_size>");
				else
					snprintf(buf, sizeof(buf), "%s%d%s", "<font_size=50>", index, "</font_size>");
			}
			btn = create_btn(grid2, buf);
			elm_table_pack(table, btn, j, i, 1, 1);
		}
	}

	elm_grid_pack(grid2, table, 0, 0, 100, 100);

	elm_box_pack_end(box, grid1);
	elm_box_pack_end(box, grid2);

	return box;
}

static void
tabbar_item_selected(appdata_s *ad, Elm_Object_Item *it)
{
	Evas_Object *sub_view;
	const char *str = NULL;

	str = elm_object_item_text_get(it);

	if (str && !strcmp(str, "World Clock")) {
		sub_view = create_worldclock_view(ad);
	}
	else if (str && !strcmp(str, "Timer")) {
		if (ad->current_degree == 0 || ad->current_degree == 180)
			sub_view = create_timer_view(ad);
		else
			sub_view = create_landscape_timer_view(ad);
	}
	else {
		if (ad->current_degree == 0 || ad->current_degree == 180)
			sub_view = create_alarm_view(ad);
		else
			sub_view = create_landscape_alarm_view(ad);
	}

	elm_object_content_set(ad->nf, sub_view);
}

static void
tabbar_item_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	Elm_Object_Item *it;

	it = event_info;

	tabbar_item_selected(ad, it);
}

static void
rotation_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	Elm_Object_Item *it;
	const char *str = NULL;
	ad->current_degree = elm_win_rotation_get(obj);

	it = elm_toolbar_selected_item_get(ad->tabbar);
	str = elm_object_item_text_get(it);

	if (ad->current_degree != 0 && ad->current_degree != 180 && !strcmp(str, "World Clock")) {
		elm_grid_pack_set(ad->vd->label1, 33, 16, 100, 100);
		elm_grid_pack_set(ad->vd->label2, 40, 58, 100, 100);
		elm_grid_pack_set(ad->vd->label3, 41, 69, 100, 100);
	}
	else
		tabbar_item_selected(ad, it);
}

static Evas_Object*
create_toolbar(appdata_s *ad)
{
	Evas_Object *tabbar;

	tabbar = elm_toolbar_add(ad->nf);
	elm_object_style_set(tabbar, "tabbar");
	elm_toolbar_shrink_mode_set(tabbar, ELM_TOOLBAR_SHRINK_NONE);
	elm_toolbar_transverse_expanded_set(tabbar, EINA_TRUE);
	elm_toolbar_select_mode_set(tabbar, ELM_OBJECT_SELECT_MODE_ALWAYS);

	elm_toolbar_item_append(tabbar, ICON_DIR"/icon_alarm.png", "Alarm", tabbar_item_cb, ad);
	elm_toolbar_item_append(tabbar, ICON_DIR"/icon_worldclock.png", "World Clock", tabbar_item_cb, ad);
	elm_toolbar_item_append(tabbar, ICON_DIR"/icon_timer.png", "Timer", tabbar_item_cb, ad);

	return tabbar;
}

static void
create_base_gui(appdata_s *ad)
{
	Evas_Object *bg = NULL;
	Elm_Object_Item *nf_it, *tabbar_it;

	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_conformant_set(ad->win, EINA_TRUE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	if (elm_win_wm_rotation_supported_get(ad->win)) {
		int rots[4] = { 0, 90, 180, 270 };
		elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);
	}

	evas_object_smart_callback_add(ad->win, "wm,rotation,changed", rotation_cb, ad);
	evas_object_smart_callback_add(ad->win, "delete,request", win_delete_request_cb, NULL);
	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

	/* Conformant */
	ad->conform = elm_conformant_add(ad->win);
	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);

	/* Indicator BG */
	bg = elm_bg_add(ad->conform);
	elm_object_style_set(bg, "indicator/headerbg");
	elm_object_part_content_set(ad->conform, "elm.swallow.indicator_bg", bg);
	evas_object_show(bg);

	/* Naviframe */
	ad->nf = elm_naviframe_add(ad->conform);
	elm_object_content_set(ad->conform, ad->nf);
	evas_object_show(ad->nf);
	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, NULL, "tabbar/icon/notitle");

	/* Tabbar */
	ad->tabbar = create_toolbar(ad);
	elm_object_item_part_content_set(nf_it, "tabbar", ad->tabbar);

	/* Set the first view */
	tabbar_it = elm_toolbar_first_item_get(ad->tabbar);
	elm_toolbar_item_selected_set(tabbar_it, EINA_TRUE);

	/* Show window after base gui is set up */
	evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	elm_app_base_scale_set(1.8);
    create_base_gui(ad);

    return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

static void
ui_app_orient_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
	return;
}

static void
ui_app_region_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void
ui_app_low_battery(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void
ui_app_low_memory(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

int
main(int argc, char *argv[])

{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY], APP_EVENT_LOW_BATTERY, ui_app_low_battery, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY], APP_EVENT_LOW_MEMORY, ui_app_low_memory, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED], APP_EVENT_DEVICE_ORIENTATION_CHANGED, ui_app_orient_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED], APP_EVENT_REGION_FORMAT_CHANGED, ui_app_region_changed, &ad);
	ui_app_remove_event_handler(handlers[APP_EVENT_LOW_MEMORY]);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "ui_app_main() is failed. err = %d", ret);
	}

	return ret;
}
