/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global define, tizen, tau, window, history*/

/**
 * Module app.
 */

define({
    name: 'app',
    requires: [
        'views/main'
    ],
    def: function app() {
        'use strict';

        /**
         * Handles back button on device.
         * @param {Event} event
         */
        function onBackButton(event) {
            if (event.keyName === 'back') {
                if (tau.engine.getRouter().activePage.id === 'main-page') {
                    tizen.application.getCurrentApplication().exit();
                } else {
                    history.back();
                }
            }
        }

        /**
         * Initializes application.
         */
        function init() {
            window.addEventListener('tizenhwkey', onBackButton);
        }

        return {
            init: init
        };
    }
});
