/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global define, tizen*/

/**
 * Module date.
 */

define({
    name: 'models/date',
    def: function modelsDate() {
        'use strict';

        /**
         * Pads given number.
         * @param {number} number N umber to pad
         * @returns {string|number}
         */
        function pad(number) {
            if (number < 10) {
                return '0' + number;
            }
            return number;
        }

        /**
         * Converts date object to date string.
         * @param {Date} date
         * @returns {string}
         */
        function getDateString(date) {
            return date.getFullYear() + '-' +
                   // Months are 0-based in JS
                   pad(date.getMonth() + 1) + '-' +
                   pad(date.getDate());
        }

        /**
         * Converts date object to time string.
         * @param {Date} date
         * @returns {string}
         */
        function getTimeString(date) {
            return pad(date.getHours()) + ':' +
                   pad(date.getMinutes());
        }

        /**
         * Converts Date and Time strings to TZDate object.
         * @param {string} date Date string
         * @param {string} time Time string
         * @returns {tizen.TZDate} TZDate object
         */
        function toTZDate(date, time) {
            var dateArray = date ? date.split('-') : null,
                timeArray = time ? time.split(':') : ['0', '0'];

            if (dateArray === null) {
                return null;
            }
            return new tizen.TZDate(
                dateArray[0],
                // Months are 0-based in JS
                Number(dateArray[1]) - 1,
                dateArray[2],
                timeArray[0],
                timeArray[1]
            );
        }

        return {
            getDateString: getDateString,
            getTimeString: getTimeString,
            toTZDate: toTZDate
        };
    }
});
