/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global define, document, tau*/

/**
 * Module popup.
 */

define({
    name: 'views/popup',
    def: function viewsPopup() {
        'use strict';

        /**
         * Shows popup with given text.
         * @param {string} pageId Id of the current page
         * @param {string} text Text to display
         */
        function show(pageId, text) {
            var popupElement = document.getElementById(pageId + '-popup'),
                popupText = document.getElementById(pageId + '-popup-text');

            popupText.innerHTML = text;
            tau.widget.Popup(popupElement).open();
        }

        return {
            show: show
        };
    }
});
