/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global tizen, app, alert, console, document */

var App = null;

(function strict() { // strict mode wrapper
    'use strict';

    /**
     * App constructor.
     * @constructor
     */
    App = function App() {
        return;
    };

    App.prototype = {

        /**
         * Array of requires files.
         * @type Array
         */
        requires: [
            'js/app.model.js',
            'js/app.ui.js',
            'js/app.ui.template.js'
        ],

        /**
         * Initializes application.
         */
        init: function init() {
            this.model = new App.Model();
            this.ui = new App.Ui();
            this.ui.template = new App.Ui.Template();
            this.ui.addEvents();

            this.selectedStorage = 'ALL';
            this.model.addStorageChangeListener(app.onChangePropertyValue);
            this.model.addContentChangeListener(app.onChangePropertyValue);
        },

        /**
         * Obtains folder list and shows it.
         * @param {string} type
         */
        showFolderList: function showFolderList(type) {
            var self = this;

            this.selectedStorage = type;
            this.model.getFolders(
                function success(folders) {
                    self.folders = folders;
                    self.ui.showFolderList(type, folders);
                },
                function onGetFoldersError(err) {
                    alert('GetFolders failed:' + err.message);
                }
            );
        },

        /**
         * Obtains items from folder and shows it.
         * @param {number} folderId
         * @param {string} mediaType
         */
        showFolderItems: function showFolderItems(folderId, mediaType) {
            this.model.getFolderItems(
                folderId,
                mediaType,
                this.folders,
                this.ui.showItemsList.bind(this.ui),
                function onGetFoldersError(err) {
                    alert('GetFolders failed:' + err.message);
                }
            );
        },

        /**
         * Handles tizen event onChangePropertyValue.
         * Shows folder list and highlights buttons.
         */
        onChangePropertyValue: function onChangePropertyValue() {
            var activePage = document
                .getElementsByClassName('ui-page-active')[0].id;
            if (activePage === 'main') {
                app.showFolderList(app.selectedStorage);
                app.ui.highlightStoragetype(app.selectedStorage);
            } else if (activePage === 'items') {
                app.showFolderItems(null, app.ui.lastItemType);
            }

        },

        /**
         * Exits application.
         */
        exit: function exit() {
            try {
                tizen.application.getCurrentApplication().exit();
            } catch (error) {
                console.error('Error: ', error);
            }
        }
    };
}());
