/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global console, define */

/**
 * Sky model module
 * Performs calculations for the balloon in the sky.
 * Based on gravity model.
 */

define({
    name: 'models/sky',
    requires: [
        'models/gravity'
    ],
    def: function appInit(gravityModel) {
        'use strict';

        /**
         * Gravity model module object.
         * @type {Object}
         */
        var gravity = gravityModel;

        /**
         * Sets up sky model properties with given data.
         * @param {object} data
         */
        function setup(data) {
            data.sky = true;
            gravity.setup(data);
        }

        /**
         * Returns sky model data.
         * @return {object}
         */
        function getData() {
            return gravity.getData();
        }

        return {
            setup: setup,
            getData: getData
        };
    }
});
