/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global define, document, console, tizen, tau, window, history, $*/

/**
 * Module app.
 */

define({
    name: 'app',
    requires: [
        'core/application',
        'views/main'
    ],
    def: function app(req) {
        'use strict';

        /**
         * Application module object.
         * @type {Object}
         */
        var application = req.core.application;

        /**
         * Tizen default configuration.
         */
        function tizenConfig() {
            $.mobile.loadingMessageTextVisible = false;
            $.mobile.defaultPageTransition = 'none';

            // Disable context menu
            $(document).on('contextmenu', function onContextMenu() {
                return false;
            });

            // Disable text selection
            $(document).on('pageinit', '[data-role="page"]',
                function onPageInit(e) {
                    $.mobile.tizen.disableSelection($(e.target));
                }
            );
        }

        /**
         * Handles back button on mobile devices.
         * @param {Event} event
         */
        function onMobileBackButton(event) {
            if (event.keyName === 'back') {
                if (document.querySelector('.ui-page-active').id === 'main') {
                    try {
                        application.exit();
                    } catch (error) {
                        console.error('Error: ' + error.message);
                    }
                } else {
                    history.back();
                }
            }
        }

        /**
         * Initializes module.
         */
        function init() {
            tizenConfig();
            window.addEventListener('tizenhwkey', onMobileBackButton);
        }

        return {
            init: init
        };
    }
});
