/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global define*/

/**
 * Capabilities module.
 */

define({
    name: 'helpers/capabilities',
    requires: [
        'models/systemInfo'
    ],
    def: function helpersCapabilities(systemInfo) {
        'use strict';

        /**
         * Tizen feature prefix.
         */
        var FEATURE_PREFIX = 'http://tizen.org/feature/',

            /**
             * List of capabilities to get.
             * @type {array}
             */
            capabilityList = [
                {text: 'Camera', divider: true},
                {text: 'Back', feature: 'camera.back'},
                {text: 'Back flash', feature: 'camera.back.flash'},
                {text: 'Front', feature: 'camera.front'},
                {text: 'Front flash', feature: 'camera.front.flash'},
                {text: 'Location', divider: true},
                {text: 'GPS', feature: 'location.gps'},
                {text: 'WPS', feature: 'location.wps'},
                {text: 'Network', divider: true},
                {text: 'Bluetooth', feature: 'network.bluetooth'},
                {text: 'NFC', feature: 'network.nfc'},
                {text: 'LTE', feature: 'network.telephony.service.lte'},
                {text: 'Sensors', divider: true},
                {text: 'Accelerometer', feature: 'sensor.accelerometer'},
                {text: 'Barometer', feature: 'sensor.barometer'},
                {text: 'Gyroscope', feature: 'sensor.gyroscope'},
                {text: 'Magnetometer', feature: 'sensor.magnetometer'},
                {text: 'Photometer', feature: 'sensor.photometer'},
                {text: 'Proximity', feature: 'sensor.proximity'},
                {text: 'Tiltmeter', feature: 'sensor.tiltmeter'},
                {text: 'Ultraviolet', feature: 'sensor.ultraviolet'},
                {text: 'Other', divider: true},
                {text: 'FM Radio', feature: 'fmradio'}
            ];

        /**
         * Obtains list of device capabilities.
         * @param {function} onSuccess Success callback
         */
        function getCapabilities(onSuccess) {
            var i = 0,
                length = capabilityList.length,
                entry = null,
                supported = false,
                capabilitiesInfo = [];

            for (i = 0; i < length; i += 1) {
                entry = capabilityList[i];
                if (entry.divider) {
                    capabilitiesInfo.push(entry);
                } else {
                    supported = systemInfo.
                        getCapability(FEATURE_PREFIX + entry.feature);
                    capabilitiesInfo.push({text: entry.text, value: supported});
                }
            }

            onSuccess(capabilitiesInfo);
        }

        return {
            getCapabilities: getCapabilities
        };
    }
});
