/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global define*/

/**
 * Date module.
 * @requires {@link Calendar/helpers/date}
 * @namespace Calendar/models/date
 * @memberof Calendar/models
 */
define({
    name: 'models/date',
    requires: [
        'helpers/date'
    ],
    def: function modelsDate(d) {
        'use strict';

        /**
         * Current date.
         * @type {Date}
         */
        var currentDate = new Date();

        /**
         * Returns current date.
         * @memberof Calendar/models/date
         * @return {TZDate}
         */
        function getCurrentDate() {
            return d.clone(currentDate);
        }

        /**
         * Sets current date.
         * @memberof Calendar/models/date
         * @param {Date} date
         */
        function setCurrentDate(date) {
            currentDate = date;
        }

        return {
            getCurrentDate: getCurrentDate,
            setCurrentDate: setCurrentDate
        };
    }

});
