/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global define, window, document, history, tizen*/

/**
 * Init page module.
 * @requires {@link core/event}
 * @requires {@link core/application}
 * @requires {@link core/systeminfo}
 * @requires {@link Calendar/views/monthPage}
 * @namespace Calendar/views/initPage
 * @memberof Calendar/views
 */

define({
    name: 'views/initPage',
    requires: [
        'core/event',
        'core/application',
        'core/systeminfo',
        'views/monthPage'
    ],
    def: function viewsInitPage(req) {
        'use strict';

        /**
         * Core event module.
         * @type {Module}
         */
        var e = req.core.event,

            /**
             * Core application module.
             * @type {Module}
             */
            app = req.core.application,

            /**
             * Core SystemInfo module.
             * @type {Module}
             */
            sysInfo = req.core.systeminfo;

        /**
         * Registers event handlers.
         */
        function bindEvents() {
            // add eventListener for tizenhwkey
            document.addEventListener('tizenhwkey', function onTizenhwkey(e) {
                if (e.keyName === 'back') {
                    app.exit();
                }
            });
            sysInfo.listenBatteryLowState();
        }

        /**
         * Handler onLowBattery state.
         */
        function onLowBattery() {
            app.exit();
        }

        /**
         * Initializes the module.
         * @memberof Calendar/views/initPage
         */
        function init() {
            // bind events to page elements
            bindEvents();
            sysInfo.checkBatteryLowState();
        }

        e.listeners({
            'core.systeminfo.battery.low': onLowBattery
        });

        return {
            init: init
        };
    }

});
