/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var flagConsole = false,
    battery = navigator.battery || navigator.webkitBattery || navigator.mozBattery;

function getWeekDay(date) {
    var str_day = document.getElementById('str_day'),
        day = date.getDay(),
        arr_day = ["MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"];

    if(day < 0 || day > 6) {
        str_day.innerHTML = "";
    }
    else {
        str_day.innerHTML = arr_day[day];
    }
}

function getDate(date) {
    var str_month = document.getElementById('str_month'),
        month = date.getMonth() + 1,
        day = date.getDate();

    if(day < 10){
        day = "0" + day;
    }
    str_month.innerHTML = month + "-" + day;
}

function getTime() {
    var str_hours = document.getElementById('str_hours'),
        str_console = document.getElementById('str_console'),
        str_minutes = document.getElementById('str_minutes'),
        str_second = document.getElementById('str_second'),
        date = tizen.time.getCurrentDateTime();

    getWeekDay(date);
    getDate(date);

    str_hours.innerHTML = date.getHours();
    str_minutes.innerHTML = date.getMinutes();
    str_second.innerHTML = date.getSeconds();
    if (date.getHours() < 10) {
        str_hours.innerHTML = "0" + date.getHours();
    }
    if (date.getMinutes() < 10) {
        str_minutes.innerHTML = "0" + date.getMinutes();
    }
    if (date.getSeconds() < 10) {
        str_second.innerHTML = "0" + date.getSeconds();
    }

    if (flagConsole) {
        str_console.style.visibility = 'visible';
        flagConsole = false;
    } else {
        str_console.style.visibility = 'hidden';
        flagConsole = true;
    }
}

function initDigitalWatch() {
    setInterval(getTime, 500);
}

function getBatteryState() {
    var battery_level = Math.floor(battery.level * 100),
        battery_deg,
        battery_circle = document.getElementById('battery_circle');

    battery_deg = (100 - battery_level) * 3.6 + 90;
    if(battery_deg > 270) {
        battery_deg = battery_deg - 180;
        battery_circle.style.backgroundImage =
            "linear-gradient(" + battery_deg + "deg, transparent 50%, black 50%)," +
            "linear-gradient(90deg, #e6da33 50%, transparent 50%)";
    }
    else {
        battery_circle.style.backgroundImage =
            "linear-gradient(" + battery_deg + "deg, transparent 50%, #e6da33 50%)," +
            "linear-gradient(90deg, #e6da33 50%, transparent 50%)";
    }
}

window.onload = function() {
    document.addEventListener('tizenhwkey', function(e) {
        if (e.keyName === "back") {
            try {
                tizen.application.getCurrentApplication().exit();
            } catch (ignore) {}
        }
    });

    initDigitalWatch();
    battery.addEventListener('chargingchange', getBatteryState);
    battery.addEventListener('chargingtimechange', getBatteryState);
    battery.addEventListener('dischargingtimechange', getBatteryState);
    battery.addEventListener('levelchange', getBatteryState);
};
