/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global $, tizen, app */

/**
 * @class Helpers
 */
function Helpers() {
    'use strict';
    return;
}

(function strict() {
    'use strict';
    Helpers.prototype = {

        /**
         * Checks the length of the string and returns true
         * if its length is greater than 0, false otherwise.
         * @param {string} value The value of the string.
         * @return {boolean}
         */
        checkStringLength: function Helpers_checkStringLength(value) {
            return value.length > 0 ? true : false;
        },

        objectLength: function Helpers_objectLength(obj) {
            var result = 0, prop;
            for (prop in obj) {
                if (obj.hasOwnProperty(prop)) {
                    result += 1;
                }
            }
            return result;
        },

        /**
         * Checks the length of the number and returns true
         * if its length is greater than 0, false otherwise.
         * @param {string} value The value of the number.
         * @return {boolean}
         */
        validateNumberLength: function Helpers_validateNumberLength(value) {
            return value.length > 0 ? true : false;
        },

        /**
         * Checks the value of the number and returns true
         * if its value is greater than 0, false otherwise.
         * @param {number} value The value of the number.
         * @return {boolean}
         */
        isNumberGreaterThanZero:
            function Helpers_isNumberGreaterThanZero(value) {
                return value > 0 ? true : false;
            },

        /**
         * Checks the value of the number and adds "0" before
         * if its value is lower than 10.
         * @param {number} value The value of the number.
         * @return {string|number}
         */
        addZeroBefore: function Helpers_addZeroBefore(value) {
            return value < 10 ? '0' + value : value;
        },

        /**
         * Returns information about the date in a specific format.
         * @param {date} date
         * @return {string} For yesterdays, todays and future dates,
         * it is appropriate string (Yesterday, Today or from Future).
         * For dates older than one day
         * it is date string in day.month.year format.
         */
        getDate: function Helpers_getDate(date) {
            var today = new Date(), yesterday;
            if (today.toDateString() === date.toDateString()) {
                return 'Today';
            }
            yesterday = new Date();
            yesterday.setDate(today.getDate() - 1);
            if (yesterday.toDateString() === date.toDateString()) {
                return 'Yesterday';
            }
            if (today.getTime() < date.getTime()) {
                return 'from Future';
            }
            return date.getDate() + '.' +
                (date.getMonth() + 1) + '.' +
                date.getFullYear();
        },

        /**
         * Checks if the date passed as an argument is today's date.
         * @param {date} date The value of the date to compare.
         * @return {string} Empty string if it is not today's date
         * or "(today)" if it is today's date.
         */
        checkToday: function Helpers_checkToday(date) {
            var today = new Date(), todayString = '';
            if (
                today.getDate() === date.getDate() &&
                    today.getMonth() === date.getMonth() &&
                        today.getFullYear() === date.getFullYear()
            ) {
                todayString = '(today)';
            }
            return todayString;
        },

        /**
         * Extracts full name from contact object.
         * @param {contact} contact The contact object.
         * @param {string} option The optional value for full name
         * if the firstName and lastName are empty.
         * @return {string} Full contact name.
         */
        getCallerName: function Helpers_getCallerName(contact, option) {
            var name = contact.name.displayName;
            return (name && name.length > 0) ? name : option;
        }
    };
}());
