/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/**
 * @class Config
 */
function Config() {
    'use strict';
}

(function strict() {
    'use strict';

    Config.prototype = {
        /**
         * @type {object}
         */
        properties: {
            'templateDir': 'templates',
            'templateExtension': '.tpl'
        },

        /**
         * Returns config value
         * Default value will be returned if given property doesn't exist
         *
         * @param {string} value Config property name
         * @param {*} defaultValue
         * @return {*}
         */
        get: function Config_get(value, defaultValue) {
            if (this.properties.hasOwnProperty(value)) {
                return this.properties[value];
            }
            return defaultValue;
        }
    };
}());
