/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*jslint sloppy: true, todo: true, vars: true, browser: true,
maxcomplexity: 20, devel: true */
/*global $, tizen, app */

/**
 * @class Helpers
 */
function Helpers() {
    'use strict';
}

(function strict() { // strict mode wrapper
    'use strict';
    Helpers.prototype = {

        getSourceName: function Helpers_getSourceName(url) {
            console.log('Helpers_getSourceName: ' + url);
            return url.split('/').pop();
        },

        getFileExtension: function Helpers_getFileExtension(fileName) {
            var splittedFileName = fileName.split('.'), ext = '';
            if (splittedFileName.length > 1) {
                ext = '.' + splittedFileName.pop();
            }
            return ext;
        },

        resolveMimeType: function Helpers_resolveMimeType(ext) {
            var mime = '';

            ext = ext.toLowerCase();

            switch (ext) {
            case '.jpg':
            case '.png':
            case '.gif':
                mime = 'image/*';
                break;
            case '.mp4':
            case '.ogv':
            case '.avi':
                mime = 'video/*';
                break;
            case '.mp3':
                mime = 'audio/mp3';
                break;
            case '.txt':
            case '.doc':
            case '.html':
            case '.ppt':
            case '.xls':
            case '.pdf':
                mime = 'text/*';
            }

            return mime;
        },

        resolveFileIcon: function Helpers_resolveFileIcon(ext) {

            switch (ext.toLowerCase()) {
            case '.jpg':
            case '.png':
            case '.gif':
                return 'myfile_images.png';
            case '.pdf':
                return 'myfile_pdf.png';
            case '.mp3':
                return 'myfile_music.png';
            case '.avi':
            case '.mp4':
            case '.mkv':
                return 'myfile_video.png';
            case '.ppt':
                return 'myfile_ppt.png';
            case '.txt':
                return 'myfile_text.png';
            case '.doc':
                return 'myfile_word.png';
            case '.xls':
                return 'myfile_excel.png';
            case '.html':
            case '.htm':
                return 'myfile_html.png';
            case '.svg':
                return 'myfile_svg.png';
            case '.swf':
                return 'myfile_swf.png';
            default:
                return 'myfile_unsupport.png';
            }
        }

    };
}());
