/*
 * Copyright (c) 2012 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*jslint devel: true*/
/*global $, app, window */
/**
 * @class UiEvents
 */
function UiEvents(parent) {
    'use strict';

    this.ui = parent;
}

(function strict() {
    'use strict';

    UiEvents.prototype = {

        /**
         * Initialization
         * @param {function} callback Initialization callback
         */
        init: function UiEvents_init(callback) {
            this.addPageEvents();
            callback();
        },

        /**
         * Bind events to pages
         */
        addPageEvents: function UiEvents_addPageEvents() {

            $(window).on('tizenhwkey',
                function UiEvents_tizenhwkeyPress(event) {
                    if (event.originalEvent.keyName === 'back') {
                        if ($.mobile.activePage.attr('id') === 'main') {
                            app.exit();
                        } else {
                            app.back();
                        }
                    }
                });

            $('#main-header').on('tap', '#main-url-ok',
                function onUrlOkTap() {
                app.startDownloading($('#main-url-text').val());
            });

            $(window).on('focus', app.refreshDownloadsList.bind(app));

            $('#main').on(
                'pageshow',
                app.refreshDownloadsList.bind(app)
            ).on(
                'tap',
                '.download-navigation-button',
                function onNavigationBtnTap(event) {
                    event.preventDefault();
                    event.stopPropagation();
                    var obj = $(this);
                    if (obj.attr('state') === 'play') {
                        app.pauseDownloading(obj.attr('for-download'));
                    } else if (obj.attr('state') === 'pause') {
                        app.resumeDownloading(
                            obj.attr('for-url'),
                            obj.attr('for-download'),
                            obj.attr('listener-flag')
                        );
                    } else if (obj.attr('state') === 'finished') {
                        app.launchFile(
                            $('#name' + obj.attr('for-download')).text()
                        );
                    } else if (obj.attr('state') === 'canceled') {
                        app.redownload(obj.attr('for-download'));
                    }
                }
            ).on('tap', '.download-delete-button',
                function onDeleteBtnTap(event) {
                event.preventDefault();
                event.stopPropagation();
                var obj = $(this);
                if (obj.attr('state') === 'play') {
                    app.cancelDownloading(obj.attr('for-download'));
                } else if (
                    obj.attr('state') === 'pause' ||
                        obj.attr('state') === 'finished' ||
                            obj.attr('state') === 'canceled' ||
                                obj.attr('state') === 'failed'
                ) {
                    app.deleteDownloading(obj.attr('for-download'));
                }
            });

            $('#clear-all-button').on('tap',
                function onRefreshBtnTap(event) {
                event.preventDefault();
                event.stopPropagation();
                app.clearAllFinished();
            });
        }
    };
}());
