#ifndef __model_H__
#define __model_H__

#include <app.h>
#include <Eina.h>
#include <stdbool.h>

#define PATHS_LIST_ITEMS_COUNT 10

typedef enum { PIT_DATA, PIT_CACHE, PIT_RESOURCE,
				PIT_SHARED_DATA, PIT_SHARED_RESOURCE, PIT_SHARED_TRUSTED,
				PIT_EXTERNAL_DATA, PIT_EXTERNAL_CACHE, PIT_EXTERNAL_SHARED_DATA,
				PIT_TEP_RESOURCE } path_item_type;

struct __modeldata {
	app_event_handler_h handlers[5];
};

typedef struct __modeldata modeldata_s;

extern bool model_init(modeldata_s *md);
extern bool model_add_event_handler(app_event_type_e event_type, app_event_cb callback);
extern bool model_remove_event_handler(app_event_type_e event_type);
extern bool model_get_app_id(char **id);
extern bool model_get_app_name(char **name);
extern bool model_get_app_version(char **version);
extern bool model_get_app_event_low_battery_status(app_event_info_h event_info, app_event_low_battery_status_e *status);
extern bool model_get_app_event_low_memory_status(app_event_info_h event_info, app_event_low_memory_status_e *status);
extern bool model_get_app_event_language(app_event_info_h event_info, char **lang);
extern bool model_get_app_event_region_format(app_event_info_h event_info, char **region);
extern bool model_get_app_event_device_orientation(app_event_info_h event_info, app_device_orientation_e *orientation);
extern bool model_get_app_event_suspended_state(app_event_info_h event_info, app_suspended_state_e *state);
extern bool model_get_app_data_path(char **path);
extern bool model_get_app_cache_path(char **path);
extern bool model_get_app_resource_path(char **path);
extern bool model_get_app_shared_data_path(char **path);
extern bool model_get_app_shared_resource_path(char **path);
extern bool model_get_app_shared_trusted_path(char **path);
extern bool model_get_app_external_data_path(char **path);
extern bool model_get_app_external_cache_path(char **path);
extern bool model_get_app_external_shared_data_path(char **path);
extern bool model_get_app_tep_resource_path(char **path);
extern bool model_get_files_list(const char *path, Eina_List **files);

#endif /* __model_H__ */
