#ifndef __view_H__
#define __view_H__

#include <Evas.h>
#include <Elementary.h>

typedef void(*paths_popup_opened_cb)(const char *path);

struct __viewdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *layout_main_panel;
	Evas_Object *main_toolbar;
	Evas_Object *main_toolbar_item_app;
	Evas_Object *main_toolbar_item_events;
	Evas_Object *main_toolbar_item_paths;
	Evas_Object *layout_app;
	Evas_Object *layout_events;
	Evas_Object *layout_paths;
	Evas_Object *paths_list;
	Evas_Object *popup_paths;
	Evas_Object *popup_files_list;
	paths_popup_opened_cb popup_opened_cb;
};

typedef struct __viewdata viewdata_s;

extern bool view_create_base_gui(viewdata_s *vd, paths_popup_opened_cb callback);
extern void view_destroy_base_gui(viewdata_s *vd);
extern void view_update_application_tab(const char *name, const char *id, const char *version);
extern void view_update_event_low_battery(const char *status_msg);
extern void view_update_event_low_memory(const char *status_msg);
extern void view_update_event_language_changed(const char *language);
extern void view_update_event_region_format_changed(const char *region);
extern void view_update_event_orientation_changed(const char *status_msg);
extern void view_update_event_suspended_state(const char *status_msg);
extern void view_update_paths_tab(char **paths);
extern void view_clear_paths_tab_files_list(void);
extern void view_update_paths_tab_files_list(const char *file_name);

#endif /* __view_H__ */