#include "$(appName).h"
#include "controller.h"
#include "model.h"
#include "view/view.h"

struct __appdata {
	viewdata_s view;
	modeldata_s model;
};

typedef struct __appdata appdata_s;

static bool __create_app(void *data)
{
	/* Hook to take necessary actions before main event loop starts
	   Initialize UI resources and application's data
	   If this function returns true, the main loop of application starts
	   If this function returns false, the application is terminated */
	appdata_s *ad = (appdata_s *)data;

	return controller_init(&ad->view, &ad->model);
}

static void __control_app(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void __pause_app(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void __resume_app(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void __terminate_app(void *data)
{
	/* Release all resources. */
	appdata_s *ad = (appdata_s *)data;

	controller_finit(&ad->view);
}

int main(int argc, char *argv[])
{
	appdata_s ad = {{0,},};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback;

	event_callback.create = __create_app;
	event_callback.terminate = __terminate_app;
	event_callback.pause = __pause_app;
	event_callback.resume = __resume_app;
	event_callback.app_control = __control_app;

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE)
		controller_log(DLOG_ERROR, "Function ui_app_main() failed with error = %d", ret);

	return ret;
}
