#include <dirent.h>
#include "$(appName).h"
#include "model.h"
#include "controller.h"

static modeldata_s *__modeldata = NULL;

bool model_init(modeldata_s *md)
{
	if (!md) {
		controller_log(DLOG_ERROR, "Invalid argument");
		return false;
	}

	__modeldata = md;

	return (__modeldata != NULL);
}

bool model_add_event_handler(app_event_type_e event_type, app_event_cb callback)
{
	int ret = ui_app_add_event_handler(&__modeldata->handlers[event_type], event_type, callback, NULL);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function ui_app_add_event_handler() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_remove_event_handler(app_event_type_e event_type)
{
	int ret = ui_app_remove_event_handler(__modeldata->handlers[event_type]);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function event_remove_event_handler() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_id(char **id)
{
	*id = NULL;

	int ret = app_get_id(id);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_get_id() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_name(char **name)
{
	*name = NULL;

	int ret = app_get_name(name);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_get_name() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_version(char **version)
{
	*version = NULL;

	int ret = app_get_version(version);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_get_version() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_event_low_battery_status(app_event_info_h event_info, app_event_low_battery_status_e *status)
{
	int ret = app_event_get_low_battery_status(event_info, status);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_event_get_low_battery_status() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_event_low_memory_status(app_event_info_h event_info, app_event_low_memory_status_e *status)
{
	int ret = app_event_get_low_memory_status(event_info, status);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_event_get_low_memory_status() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_event_language(app_event_info_h event_info, char **lang)
{
	int ret = app_event_get_language(event_info, lang);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_event_get_language() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_event_region_format(app_event_info_h event_info, char **region)
{
	int ret = app_event_get_region_format(event_info, region);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function model_app_event_get_region_format() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_event_device_orientation(app_event_info_h event_info, app_device_orientation_e *orientation)
{
	int ret = app_event_get_device_orientation(event_info, orientation);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_event_get_device_orientation() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_event_suspended_state(app_event_info_h event_info, app_suspended_state_e *state)
{
	int ret = app_event_get_suspended_state(event_info, state);
	if (ret != APP_ERROR_NONE) {
		controller_log(DLOG_ERROR, "Function app_event_get_suspended_state() failed with error = %d", ret);
		return false;
	}

	return true;
}

bool model_get_app_data_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_data_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_data_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_app_cache_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_cache_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_cache_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_app_resource_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_resource_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_resource_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_app_shared_data_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_shared_data_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_shared_data_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_app_shared_resource_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_shared_resource_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_shared_resource_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_app_shared_trusted_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_shared_trusted_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_shared_trusted_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_app_external_data_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_external_data_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_external_data_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_app_external_cache_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_external_cache_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_external_cache_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_app_external_shared_data_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_external_shared_data_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_external_shared_data_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_app_tep_resource_path(char **path)
{
	*path = NULL;

	char *path_tmp = app_get_tep_resource_path();
	if (!path_tmp) {
		controller_log(DLOG_ERROR, "Function app_get_tep_resource_path() failed");
		return false;
	}

	*path = strdup(path_tmp);
	return true;
}

bool model_get_files_list(const char *path, Eina_List **files)
{
	DIR *dir_h;
	struct dirent *dir;

	*files = NULL;

	dir_h = opendir(path);
	if (!dir_h) {
		controller_log(DLOG_ERROR, "Function opendir() failed");
		return false;
	}

	controller_log(DLOG_INFO, "Files listing for directory: %s", path);

	while ((dir = readdir(dir_h)) != NULL)
		if (dir->d_type == DT_REG) {
			controller_log(DLOG_INFO, dir->d_name);
			*files = eina_list_append(*files, strdup(dir->d_name));
		}

	closedir(dir_h);

	return (eina_list_count(*files) > 0);
}