#ifndef __controller_H__
#define __controller_H__

#include <dlog.h>
#include "model.h"
#include "view.h"
#include "$(appName).h"

extern bool controller_initialize(viewdata_s *vd, modeldata_s *md);
extern void controller_finalize(void);
extern void controller_print_message(log_priority pri, const char *format, ...);
extern void controller_search_app(int selected_operation_id);
extern void controller_send_message(const char *email_address, const char *email_body);
extern void controller_execute(void);
extern void controller_terminate(void);

typedef struct _controller_data {
	app_control_h launch_app_control;
	viewdata_s *viewdata;
} controller_data_s;

#endif /* __controller_H__ */
