#ifndef __model_H__
#define __model_H__

#include <Eina.h>
#include <stdbool.h>

#define APP_CONTROL_OPERATION_COUNT 3

#define COMPOSE_OP_RECIPIENT		"example@tizen.org"
#define COMPOSE_OP_RECIPIENT_CC 	"cc_example@tizen.org"
#define COMPOSE_OP_RECIPIENT_BCC 	"bcc_example@tizen.org"
#define COMPOSE_OP_SUBJECT			"Example message subject"
#define COMPOSE_OP_MESSAGE			"Example message text"

typedef struct _app_control_operation {
	const char *caption;
	const char *operation;
} app_control_operation_s;

typedef struct _app_control_selection {
	char *operation;
	char *appid;
} app_control_selection_s;

typedef struct _modeldata {
	Eina_List *apps_list;
	app_control_selection_s app_ctrl_selection;
} modeldata_s;

extern bool model_create(modeldata_s *md);
extern const char *model_get_operation_caption(int index);
extern const char *model_get_operation_name(int index);
extern void model_free_app_control_selection(void);
extern void model_set_app_control_selection(int selected_operation_id, int selected_appid);
extern bool model_get_app_control_selection(char **operation, char **appid);
extern const char *model_get_application_id(int index);
extern void model_free_app_control_apps_list(void);
extern void model_add_application_id(const char *appid);

#endif /* __model_H__ */
