#ifndef __view_H__
#define __view_H__

#include <Elementary.h>
#include <stdbool.h>
#include "model.h"

typedef struct _viewdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *main_layout;
	Evas_Object *controls_panel_layout;
	Evas_Object *controls_app_launch_box;
	Evas_Object *controls_app_launch_panel_layout;
	Evas_Object *controls_app_launch_operation_rb[APP_CONTROL_OPERATION_COUNT];
	Evas_Object *controls_app_launch_search_bt;
	Evas_Object *controls_app_launch_execute_bt;
	Evas_Object *controls_app_launch_terminate_bt;
	Evas_Object *controls_message_compose_panel_layout;
	Evas_Object *controls_message_compose_address_to_entry;
	Evas_Object *controls_message_compose_text_label;
	Evas_Object *controls_message_compose_send_bt;
	Evas_Object *status_entry;
	Evas_Object *popup_window;
	int radio_button_operation_selected;
	int radio_button_application_selected;
} viewdata_s;

typedef enum {
	BUTTON_SEARCH,
	BUTTON_EXECUTE,
	BUTTON_KILL
} appcontrol_button_type;

extern bool view_create(viewdata_s *vd);
extern bool view_is_shown_popup_window(void);
extern bool view_create_popup_window(void);
extern bool view_add_popup_window_radio_button(const char *caption, bool create_new_group);
extern void view_disable_button(viewdata_s *vd, appcontrol_button_type type, Eina_Bool disabled);
extern void view_set_app_selected(viewdata_s *vd, const char *app_id);

#endif /* __view_H__ */
