#include "$(appName).h"
#include "model.h"
#include "controller.h"

modeldata_s *modeldata;

static app_control_operation_s app_control_operation[APP_CONTROL_OPERATION_COUNT] = {
	{ .caption = "View operation", .operation = APP_CONTROL_OPERATION_VIEW },
	{ .caption = "Pick operation", .operation = APP_CONTROL_OPERATION_PICK },
	{ .caption = "Compose operation", .operation = APP_CONTROL_OPERATION_COMPOSE }
	};

bool model_create(modeldata_s *md)
{
	if (!md)
		return false;

	modeldata = md;

	return true;
}

void model_add_application_id(const char *appid)
{
	modeldata->apps_list = eina_list_append(modeldata->apps_list, strdup(appid));
}

const char *model_get_application_id(int index)
{
	if (!modeldata->apps_list) {
		controller_print_message(DLOG_ERROR, "Applications list is empty.");
		return NULL;
	}

	char *appid = (char *)eina_list_nth((const Eina_List *)modeldata->apps_list, (unsigned int)index);
	if (!appid) {
		controller_print_message(DLOG_ERROR, "eina_list_nth() failed.");
		return NULL;
	}

	return appid;
}

const char *model_get_operation_name(int index)
{
	if (index < 0 || index >= APP_CONTROL_OPERATION_COUNT) {
		controller_print_message(DLOG_ERROR, "Selected operation index is out of range.");
		return NULL;
	}

	return app_control_operation[index].operation;
}

const char *model_get_operation_caption(int index)
{
	if (index < 0 || index >= APP_CONTROL_OPERATION_COUNT) {
		controller_print_message(DLOG_ERROR, "Selected operation index is out of range.");
		return NULL;
	}

	return app_control_operation[index].caption;
}

void model_set_app_control_selection(int selected_operation_id, int selected_appid)
{
	const char *appid = model_get_application_id(selected_appid);
	if (!appid)
		return;

	const char *operation = model_get_operation_name(selected_operation_id);
	if (!operation)
		return;

	modeldata->app_ctrl_selection.operation = strdup(operation);
	modeldata->app_ctrl_selection.appid = strdup(appid);
}

bool model_get_app_control_selection(char **operation, char **appid)
{
	if (operation)
		*operation = modeldata->app_ctrl_selection.operation;

	if (appid)
		*appid = modeldata->app_ctrl_selection.appid;

	return ((operation && *operation != NULL) || !operation) && ((appid && *appid != NULL) || !appid);
}

void model_free_app_control_apps_list(void)
{
	char *appid = NULL;

	EINA_LIST_FREE(modeldata->apps_list, appid) {
		if (!appid)
			continue;

		free(appid);
	}

	modeldata->apps_list = NULL;
}

void model_free_app_control_selection(void)
{
	if (modeldata->app_ctrl_selection.operation) {
		free(modeldata->app_ctrl_selection.operation);
		modeldata->app_ctrl_selection.operation = NULL;
	}
	if (modeldata->app_ctrl_selection.appid) {
		free(modeldata->app_ctrl_selection.appid);
		modeldata->app_ctrl_selection.appid = NULL;
	}
}
