#ifndef __controller_H__
#define __controller_H__

#include <stdbool.h>
#include <dlog.h>
#include "model.h"

extern bool controller_application_init(modeldata_s *md);
extern void controller_application_terminate(modeldata_s *md);
extern unsigned int controller_badge_count_get(const char *app_id);
extern bool controller_badge_new(const char *app_id, unsigned int badge_count);
extern bool controller_badge_remove(const char *app_id);
extern bool controller_badge_update(const char *app_id, unsigned int badge_count);
extern void controller_log(log_priority pri, const char *format, ...);

#endif /* __controller_H__ */