#ifndef __model_H__
#define __model_H__

#include <Eina.h>
#include <stdbool.h>

typedef struct _pkginfo {
	char *pkg_name;
	char *app_id;
} pkginfo_s;

typedef struct _modeldata {
	Eina_List *pkg_list;
} modeldata_s;

extern bool model_packages_list_get(Eina_List **list);
extern void model_packages_list_free(Eina_List *list);
extern bool model_packages_certificate_verify(const char *app_id);
extern bool model_badge_count_get(const char *app_id, unsigned int *badge_count);
extern bool model_badge_count_set(const char *app_id, unsigned int badge_count);
extern bool model_badge_display_get(const char *app_id, bool *display);
extern bool model_badge_display_set(const char *app_id, bool display);
extern bool model_badge_add(const char *app_id);
extern bool model_badge_remove(const char *app_id);

#endif /* __model_H__ */