#include <stdio.h>
#include <Eina.h>
#include "$(appName)-ref.h"
#include "controller.h"
#include "model.h"
#include "view.h"

bool
controller_application_init(modeldata_s *md)
{
	if (!model_packages_list_get(&md->pkg_list)) {
		return false;
	}

	Eina_List *it = NULL;
	pkginfo_s *pkginfo = NULL;

	EINA_LIST_FOREACH(md->pkg_list, it, pkginfo)
		if (model_packages_certificate_verify(pkginfo->app_id))
			view_genlist_item_add(pkginfo);

	return true;
}

void
controller_application_terminate(modeldata_s *md)
{
	model_packages_list_free(md->pkg_list);
}

unsigned int
controller_badge_count_get(const char *app_id)
{
	unsigned int badge_count = 0;

	if (!model_badge_count_get(app_id, &badge_count)) {
		return 0;
	}

	controller_log(DLOG_INFO, "Badge count for %s: %u.", app_id, badge_count);

	return badge_count;
}

bool
controller_badge_new(const char *app_id, unsigned int badge_count)
{
	if (!model_badge_add(app_id)) {
		return false;
	}

	if (!model_badge_display_set(app_id, 1)) {
		return false;
	}

	return model_badge_count_set(app_id, badge_count);
}

bool
controller_badge_remove(const char *app_id)
{
	if (!model_badge_count_set(app_id, 0)) {
		return false;
	}

	if (!model_badge_display_set(app_id, 0)) {
		return false;
	}

	return model_badge_remove(app_id);
}

bool
controller_badge_update(const char *app_id, unsigned int badge_count)
{
	bool display = false;

	if (!model_badge_display_get(app_id, &display)) {
		return false;
	}

	if (!display) {
		return false;
	}

	return model_badge_count_set(app_id, badge_count);
}

void
controller_log(log_priority pri, const char *format, ...)
{
	va_list vl;

	va_start(vl, format);
	dlog_vprint(pri, LOG_TAG, format, vl);
	va_end(vl);
}