/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "bt_noti.h"

#define NOTI_POPUP_TIME 3.0

static void _popup_timeout_cb(void *data, Evas_Object *obj, void *event_info)
{
	_D("popup timeout");
}

static void _popup_block_clicked_cb(void *data, Evas_Object *obj, void *event_info)
{
	ret_if(!obj);

	evas_object_del(obj);
}

HAPI Evas_Object *bt_noti_popup_create(Evas_Object *parent, char *string, Eina_Bool is_block)
{
	Evas_Object *popup = NULL;

	retv_if(!parent, NULL);
	retv_if(!string, NULL);

	popup = elm_popup_add(parent);
	retv_if(!popup, NULL);

	elm_popup_align_set(popup, ELM_NOTIFY_ALIGN_FILL, ELM_NOTIFY_ALIGN_FILL);
	evas_object_size_hint_weight_set(popup, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_text_set(popup, string);

	if (!is_block) {
		evas_object_smart_callback_add(popup, "block,clicked", _popup_block_clicked_cb, NULL);
		elm_popup_timeout_set(popup, NOTI_POPUP_TIME);
		evas_object_smart_callback_add(popup, "timeout", _popup_timeout_cb, NULL);
	}

	evas_object_show(popup);

	return popup;
}
