#ifndef __model_bundle_H__
#define __model_bundle_H__

#include <stdbool.h>
#include <bundle.h>

extern bool model_bundle_create(bundle **bundle_obj);
extern bool model_bundle_destroy(bundle *bundle_obj);
extern bool model_bundle_get_count(bundle *bundle_obj,
										int *count);
extern bool model_bundle_get_type(bundle *bundle_obj,
									const char *key,
									int *type);
extern bool model_bundle_foreach(bundle *bundle_obj,
									bundle_iterator_t func_cb);
extern bool model_bundle_add_string(bundle **bundle_obj,
										const char *key,
										const char *value);
extern bool model_bundle_get_string(bundle *bundle_obj,
										const char *key,
										char **value);
extern bool model_bundle_add_string_array(bundle **bundle_obj,
											const char *key,
											char **value,
											int value_count);
extern bool model_bundle_get_string_array(bundle *bundle_obj,
											const char *key,
											const char ***value,
											int *value_len);
extern bool model_bundle_add_byte(bundle **bundle_obj,
									const char *key,
									int value);
extern bool model_bundle_get_byte(bundle *bundle_obj,
									const char *key,
									int *value);
extern bool model_bundle_get_keyval_type(const bundle_keyval_t *kv,
											int *type);
extern bool model_bundle_get_keyval_basic_val(const bundle_keyval_t *kv,
												void **value);

#endif /* __model_bundle_H__ */