#ifndef __model_H__
#define __model_H__

#include <stdbool.h>
#include <Eina.h>

typedef enum {BUNDLE_VALUE_TYPE_BYTE,
				BUNDLE_VALUE_TYPE_STRING,
				BUNDLE_VALUE_TYPE_MAX} bundle_value_type_t;

typedef struct _bundledata {
	char *key;
	void *value;
	bundle_value_type_t type;
} bundledata_s;

typedef struct _modeldata {
	Eina_List *items_list;
	int msg_port_rcv_id;
} modeldata_s;

extern bool model_create_data(modeldata_s *md);
extern void model_destroy_data(modeldata_s *md);
extern bundledata_s *model_create_bundledata(char *key,
												void *ptr_value,
												int val_size,
												bundle_value_type_t value_type);
extern bool model_add_list_item(bundledata_s *bundledata);
extern bool model_get_data_list(Eina_List **bundle_data_list);
extern modeldata_s *model_get_data(void);

#endif /* __model_H__ */