#ifndef __defines_H__
#define __defines_H__

#define TEXT_LABEL_COLOR_R 225
#define TEXT_LABEL_COLOR_G 225
#define TEXT_LABEL_COLOR_B 225
#define TEXT_LABEL_COLOR_A 255

#define ENTRY_BG_COLOR_R 225
#define ENTRY_BG_COLOR_G 225
#define ENTRY_BG_COLOR_B 225
#define ENTRY_BG_COLOR_A 255

#define EDJ_MAIN_FILE_NAME "edje/$(appName)-ref.edj"
#define GROUP_MAIN "main"
#define PART_MAIN_BACKGROUND "main_background"
#define PART_MAIN_PANEL "main_panel"
#define PART_MAIN_TOOLBAR "main_toolbar"
#define PART_MAIN_CONTENT "main_content"

#define MAIN_BACKGROUND_MARGIN_H 0.02
#define MAIN_BACKGROUND_MARGIN_V 0.01
#define MAIN_TOOLBAR_TOP 0.0
#define MAIN_TOOLBAR_HEIGHT 0.065
#define MAIN_CONTENT_MARGIN_V 0.01
#define MAIN_CONTENT_TOP\
			(MAIN_TOOLBAR_TOP+MAIN_TOOLBAR_HEIGHT+MAIN_CONTENT_MARGIN_V)

#define EDJ_DATA_SOURCE_FILE_NAME "edje/data_source.edj"
#define GROUP_DATA_SOURCE "data_source"
#define PART_DATA_SOURCE_BACKGROUND "data_source_background"
#define PART_DATA_SOURCE_EDIT_PANEL "data_source_edit_panel"
#define PART_DATA_SOURCE_LIST_PANEL "data_source_list_panel"
#define PART_DATA_SOURCE_BUTTONS_PANEL "data_source_buttons_panel"

#define DATA_SOURCE_EDIT_PANEL_TOP 0.0
#define DATA_SOURCE_EDIT_PANEL_HEIGHT 0.4
#define DATA_SOURCE_BUTTONS_PANEL_TOP 0.9
#define DATA_SOURCE_BUTTONS_PANEL_HEIGHT 0.1
#define DATA_SOURCE_LIST_PANEL_TOP\
			(DATA_SOURCE_EDIT_PANEL_TOP+DATA_SOURCE_EDIT_PANEL_HEIGHT)
#define DATA_SOURCE_LIST_PANEL_HEIGHT\
			(DATA_SOURCE_BUTTONS_PANEL_TOP-(DATA_SOURCE_EDIT_PANEL_HEIGHT))

#define EDJ_DATA_SINK_FILE_NAME "edje/data_sink.edj"
#define GROUP_DATA_SINK "data_sink"
#define PART_DATA_SINK_BACKGROUND "data_sink_background"
#define PART_DATA_SINK_ENTRY "data_sink_entry"

#define EDJ_DATA_SOURCE_EDIT_PANEL_FILE_NAME\
			"edje/data_source_edit_panel.edj"
#define GROUP_DATA_SOURCE_EDIT_PANEL\
			"data_source_edit_panel"
#define PART_DATA_SOURCE_EDIT_PANEL_BACKGROUND\
			"data_source_edit_panel_background"
#define PART_DATA_SOURCE_EDIT_PANEL_KEY_PANEL\
			"data_source_edit_panel_key_panel"
#define PART_DATA_SOURCE_EDIT_PANEL_KEY_PANEL_ENTRY_BACKGROUND\
			"data_source_edit_panel_key_panel_entry_background"
#define PART_DATA_SOURCE_EDIT_PANEL_KEY_PANEL_ENTRY\
			"data_source_edit_panel_key_panel_entry"
#define PART_DATA_SOURCE_EDIT_PANEL_VALUE_PANEL\
			"data_source_edit_panel_value_panel"
#define PART_DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_ENTRY_BACKGROUND\
			"data_source_edit_panel_value_panel_entry_background"
#define PART_DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_ENTRY\
			"data_source_edit_panel_value_panel_entry"
#define PART_DATA_SOURCE_EDIT_PANEL_TYPE_PANEL\
			"data_source_edit_panel_type_panel"
#define PART_DATA_SOURCE_EDIT_PANEL_TYPE_PANEL_ENTRY\
			"data_source_edit_panel_type_panel_entry"

#define DATA_SOURCE_EDIT_PANEL_KEY_PANEL_TOP 0.0
#define DATA_SOURCE_EDIT_PANEL_KEY_PANEL_HEIGHT 0.33
#define DATA_SOURCE_EDIT_PANEL_KEY_PANEL_LABEL_WIDTH 0.3
#define DATA_SOURCE_EDIT_PANEL_KEY_PANEL_ENTRY_LEFT\
			DATA_SOURCE_EDIT_PANEL_KEY_PANEL_LABEL_WIDTH
#define DATA_SOURCE_EDIT_PANEL_KEY_PANEL_ENTRY_HEIGHT 0.7
#define DATA_SOURCE_EDIT_PANEL_KEY_PANEL_ENTRY_TOP\
			((1.0-DATA_SOURCE_EDIT_PANEL_KEY_PANEL_ENTRY_HEIGHT)/2)
#define DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_TOP\
			(DATA_SOURCE_EDIT_PANEL_KEY_PANEL_TOP+DATA_SOURCE_EDIT_PANEL_KEY_PANEL_HEIGHT)
#define DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_HEIGHT 0.27
#define DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_LABEL_WIDTH 0.3
#define DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_ENTRY_LEFT\
			DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_LABEL_WIDTH
#define DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_ENTRY_HEIGHT 0.7
#define DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_ENTRY_TOP\
			((1.0-DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_ENTRY_HEIGHT)/2)
#define DATA_SOURCE_EDIT_PANEL_TYPE_PANEL_TOP\
			(DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_TOP+DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_HEIGHT)
#define DATA_SOURCE_EDIT_PANEL_TYPE_PANEL_HEIGHT\
			(1.0-DATA_SOURCE_EDIT_PANEL_KEY_PANEL_HEIGHT-DATA_SOURCE_EDIT_PANEL_VALUE_PANEL_HEIGHT)
#define DATA_SOURCE_EDIT_PANEL_TYPE_PANEL_LABEL_WIDTH 0.3
#define DATA_SOURCE_EDIT_PANEL_TYPE_PANEL_ENTRY_LEFT\
			DATA_SOURCE_EDIT_PANEL_TYPE_PANEL_LABEL_WIDTH

#define EDJ_DATA_SOURCE_LIST_PANEL_FILE_NAME\
			"edje/data_source_list_panel.edj"
#define GROUP_DATA_SOURCE_LIST_PANEL\
			"data_source_list_panel"
#define PART_DATA_SOURCE_LIST_PANEL_BACKGROUND\
			"data_source_list_panel_background"
#define PART_DATA_SOURCE_LIST_PANEL_CHECKBOX_PANEL\
			"data_source_list_panel_checkbox_panel"
#define PART_DATA_SOURCE_LIST_PANEL_CHECKBOX_LABEL\
			"data_source_list_panel_checkbox_label"
#define PART_DATA_SOURCE_LIST_PANEL_CHECKBOX\
			"data_source_list_panel_checkbox"
#define PART_DATA_SOURCE_LIST_PANEL_LIST\
			"data_source_list_panel_list"

#define DATA_SOURCE_LIST_PANEL_CHECKBOX_PANEL_TOP 0.0
#define DATA_SOURCE_LIST_PANEL_CHECKBOX_PANEL_HEIGHT 0.20
#define DATA_SOURCE_LIST_PANEL_CHECKBOX_LABEL_WIDTH 0.6
#define DATA_SOURCE_LIST_PANEL_CHECKBOX_LEFT\
			DATA_SOURCE_LIST_PANEL_CHECKBOX_LABEL_WIDTH
#define DATA_SOURCE_LIST_PANEL_CHECKBOX_TOP 0.05
#define DATA_SOURCE_LIST_PANEL_CHECKBOX_HEIGHT 0.95
#define DATA_SOURCE_LIST_PANEL_LIST_TOP\
			(DATA_SOURCE_LIST_PANEL_CHECKBOX_PANEL_TOP+DATA_SOURCE_LIST_PANEL_CHECKBOX_PANEL_HEIGHT)
#define DATA_SOURCE_LIST_PANEL_LIST_HEIGHT 1.0-(DATA_SOURCE_LIST_PANEL_LIST_TOP)

#define EDJ_DATA_SOURCE_BUTTONS_PANEL_FILE_NAME\
			"edje/data_source_buttons_panel.edj"
#define GROUP_DATA_SOURCE_BUTTONS_PANEL\
			"data_source_buttons_panel"
#define PART_DATA_SOURCE_BUTTONS_PANEL_BACKGROUND\
			"data_source_buttons_panel_background"
#define PART_DATA_SOURCE_BUTTONS_PANEL_ADD\
			"data_source_buttons_panel_add"
#define PART_DATA_SOURCE_BUTTONS_PANEL_SEND\
			"data_source_buttons_panel_send"

#define DATA_SOURCE_BUTTONS_PANEL_MARGIN_H 0.02
#define DATA_SOURCE_BUTTONS_PANEL_MARGIN_V 0.1
#define DATA_SOURCE_BUTTONS_PANEL_BUTTON_WIDTH\
			(1.0-4*DATA_SOURCE_BUTTONS_PANEL_MARGIN_H)/2
#define DATA_SOURCE_BUTTONS_PANEL_BUTTON_HEIGHT\
			(1.0-2*DATA_SOURCE_BUTTONS_PANEL_MARGIN_V)
#define DATA_SOURCE_BUTTONS_PANEL_BUTTON_TOP DATA_SOURCE_BUTTONS_PANEL_MARGIN_V
#define DATA_SOURCE_BUTTONS_PANEL_BUTTON_ADD_LEFT\
			DATA_SOURCE_BUTTONS_PANEL_MARGIN_H
#define DATA_SOURCE_BUTTONS_PANEL_BUTTON_SEND_LEFT\
			(DATA_SOURCE_BUTTONS_PANEL_BUTTON_ADD_LEFT+DATA_SOURCE_BUTTONS_PANEL_BUTTON_WIDTH+2*DATA_SOURCE_BUTTONS_PANEL_MARGIN_H)

#endif /* __defines_H__ */