#include <stdio.h>
#include <Eina.h>
#include <dlog.h>
#include "$(appName)-ref.h"
#include "controller/controller.h"
#include "controller/controller-data-source.h"
#include "model/model-bundle.h"
#include "model/model-message-port.h"

#define BUNDLE_HEADER_KEY "HEADER"
#define BUNDLE_HEADER_DATA_KEY "HEADER_DATA"

static bool __data_source_add_bundle_data(bundle *bundle_obj,
											Eina_List *bundle_data_list);

static bool __data_source_create_bundle_header(bundle **bundle_obj,
													bool include_header)
{
	Eina_List *bundle_data_list = NULL;
	Eina_List *tmp = NULL;
	unsigned int items_count = 0;
	char **key_array = NULL;
	bundledata_s *bundledata = NULL;
	int i = 0;

	if (!bundle_obj) {
		controller_log(DLOG_ERROR, "Wrong input arguments.");
		return false;
	}

	if (!model_bundle_add_byte(bundle_obj, BUNDLE_HEADER_KEY,
								(int)include_header))
		return false;

	if (!include_header)
		return true;

	if (!model_get_data_list(&bundle_data_list))
		return false;

	items_count = eina_list_count(bundle_data_list);
	if (items_count == 0)
		return true;

	key_array = (char **)malloc(sizeof(char *) * items_count);
	if (!key_array)
		return false;

	EINA_LIST_FOREACH(bundle_data_list, tmp, bundledata) {
		key_array[i] = strdup(bundledata->key);
		i++;
	}

	bool ret = model_bundle_add_string_array(bundle_obj,
												BUNDLE_HEADER_DATA_KEY,
												key_array,
												items_count);

	for (i = 0; i < items_count; i++) {
		if (!key_array[i])
			continue;

		free(key_array[i]);
	}

	free(key_array);

	return ret;
}

bool controller_data_source_send_message(bool include_header)
{
	Eina_List *bundle_data_list = NULL;
	bundle *bundle_msg = NULL;

	if (!model_get_data_list(&bundle_data_list))
		return false;

	if (!model_bundle_create(&bundle_msg))
		return false;

	if (!__data_source_create_bundle_header(&bundle_msg, include_header)) {
		model_bundle_destroy(bundle_msg);
		return false;
	}

	if (!__data_source_add_bundle_data(bundle_msg, bundle_data_list)) {
		model_bundle_destroy(bundle_msg);
		return false;
	}

	bool ret = model_message_port_send_message(bundle_msg);
	if (ret)
		controller_log(DLOG_INFO, "Message sent successfully.");

	model_bundle_destroy(bundle_msg);

	return ret;
}

static bool __data_source_append_bundle_data(bundle *bundle_obj,
												bundledata_s *bundledata)
{
	if (!bundle_obj || !bundledata ||
		!bundledata->key || !bundledata->value) {
		controller_log(DLOG_ERROR, "Wrong input arguments.");
		return false;
	}

	switch (bundledata->type) {
	case BUNDLE_VALUE_TYPE_BYTE:
		if (!model_bundle_add_byte(&bundle_obj,
									bundledata->key,
									*((int *)bundledata->value)))
			return false;
		break;
	case BUNDLE_VALUE_TYPE_STRING:
		if (!model_bundle_add_string(&bundle_obj,
										bundledata->key,
										(char *)bundledata->value))
			return false;
		break;
	default:
		controller_log(DLOG_ERROR, "Wrong bundle data type identifier.");
		return false;
	}

	return true;
}

static bool __data_source_add_bundle_data(bundle *bundle_obj,
											Eina_List *bundle_data_list)
{
	Eina_List *tmp = NULL;
	bundledata_s *bundledata = NULL;

	if (!bundle_data_list || !bundle_obj) {
		controller_log(DLOG_ERROR, "Wrong input arguments.");
		return false;
	}

	EINA_LIST_FOREACH(bundle_data_list, tmp, bundledata)
		__data_source_append_bundle_data(bundle_obj, bundledata);

	return true;
}