#include <stdio.h>
#include <Eina.h>
#include "$(appName)-ref.h"
#include "controller/controller.h"
#include "controller/controller-data-sink.h"
#include "model/model.h"
#include "view/view.h"

bool controller_initialization(viewdata_s *vd, modeldata_s *md)
{
	return (model_create_data(md) &&
			view_create_base_gui(vd) &&
			controller_data_sink_create());
}

void controller_terminate(viewdata_s *vd, modeldata_s *md)
{
	controller_data_sink_destroy();
	view_destroy_base_gui(vd);
	model_destroy_data(md);
}

void controller_append_message(const char *message)
{
	if (!message)
		return;

	view_add_sink_message("<color=#00ff00>");
	view_add_sink_message(message);
	view_add_sink_message("</color>");
	view_add_sink_message("<br>");
}

void controller_log(log_priority pri, const char *format, ...)
{
	va_list vl;

	va_start(vl, format);
	dlog_vprint(pri, LOG_TAG, format, vl);
	va_end(vl);
}

bool controller_check_same_string(const char *s1, const char *s2)
{
	if (!s1 && !s2) {
		return true;
	} else if (!s1 || !s2) {
		return false;
	}

	return (strncmp(s1, s2, strlen(s1)) == 0 && strlen(s1) == strlen(s2));
}
