#include "$(appName)-ref.h"
#include "model/model.h"
#include "model/model-message-port.h"
#include "controller/controller.h"

#define MESSAGE_PORT_RCV_NAME PACKAGE"_msg_port_local_rcv"

static const char *__error_code_to_string(int error_code)
{
	switch (error_code) {
	case MESSAGE_PORT_ERROR_NONE:
		return "MESSAGE_PORT_ERROR_NONE";
	case MESSAGE_PORT_ERROR_IO_ERROR:
		return "MESSAGE_PORT_ERROR_IO_ERROR";
	case MESSAGE_PORT_ERROR_OUT_OF_MEMORY:
		return "MESSAGE_PORT_ERROR_OUT_OF_MEMORY";
	case MESSAGE_PORT_ERROR_INVALID_PARAMETER:
		return "MESSAGE_PORT_ERROR_INVALID_PARAMETER";
	case MESSAGE_PORT_ERROR_PORT_NOT_FOUND:
		return "MESSAGE_PORT_ERROR_PORT_NOT_FOUND";
	case MESSAGE_PORT_ERROR_CERTIFICATE_NOT_MATCH:
		return "MESSAGE_PORT_ERROR_CERTIFICATE_NOT_MATCH";
	case MESSAGE_PORT_ERROR_MAX_EXCEEDED:
		return "MESSAGE_PORT_ERROR_MAX_EXCEEDED";
	case MESSAGE_PORT_ERROR_RESOURCE_UNAVAILABLE:
		return "MESSAGE_PORT_ERROR_RESOURCE_UNAVAILABLE";
	default:
		return "Unknown error";
	}
}

bool model_message_port_check_exists(void)
{
	return (model_get_data()->msg_port_rcv_id > 0);
}

bool model_message_port_create(message_port_message_cb func_cb)
{
	int ret = message_port_register_local_port(MESSAGE_PORT_RCV_NAME,
													func_cb,
													NULL);
	if (ret == MESSAGE_PORT_ERROR_IO_ERROR ||
		ret == MESSAGE_PORT_ERROR_OUT_OF_MEMORY ||
		ret == MESSAGE_PORT_ERROR_INVALID_PARAMETER ||
		ret == MESSAGE_PORT_ERROR_PORT_NOT_FOUND ||
		ret == MESSAGE_PORT_ERROR_CERTIFICATE_NOT_MATCH ||
		ret == MESSAGE_PORT_ERROR_MAX_EXCEEDED ||
		ret == MESSAGE_PORT_ERROR_RESOURCE_UNAVAILABLE) {
		controller_log(DLOG_ERROR,
						"Function message_port_register_local_port() failed"
						" with error: %d (%s).",
						ret,
						__error_code_to_string(ret));
		return false;
	}

	model_get_data()->msg_port_rcv_id = ret;

	return true;
}

bool model_message_port_destroy(void)
{
	int ret = message_port_unregister_local_port(
											model_get_data()->msg_port_rcv_id);
	if (ret != MESSAGE_PORT_ERROR_NONE) {
		controller_log(DLOG_ERROR,
						"Function message_port_unregister_local_port()"
						" failed with error: %d (%s).",
						ret,
						__error_code_to_string(ret));
		return false;
	}

	model_get_data()->msg_port_rcv_id = 0;

	return true;
}

bool model_message_port_send_message(bundle *message)
{
	int ret = message_port_send_message(PACKAGE,
										MESSAGE_PORT_RCV_NAME,
										message);
	if (ret != MESSAGE_PORT_ERROR_NONE) {
		controller_log(DLOG_ERROR,
						"Function message_port_send_message() failed"
						" with error: %d (%s).",
						ret,
						__error_code_to_string(ret));
		return false;
	}

	return true;
}
