#include "$(appName)-ref.h"
#include "model/model.h"
#include "controller/controller.h"

static modeldata_s *modeldata = NULL;

bool model_create_data(modeldata_s *md)
{
	if (!md) {
		controller_log(DLOG_ERROR, "Wrong input arguments.");
		return false;
	}

	modeldata = md;

	return true;
}

void model_destroy_data(modeldata_s *md)
{
	if (!md) {
		controller_log(DLOG_ERROR, "Wrong input arguments.");
		return;
	}

	if (md->items_list)
		md->items_list = eina_list_free(md->items_list);
}

bundledata_s *model_create_bundledata(char *key,
										void *ptr_value,
										int val_size,
										bundle_value_type_t value_type)
{
	if (!key || !ptr_value) {
		controller_log(DLOG_ERROR, "Wrong input arguments.");
		return NULL;
	}

	bundledata_s *bundledata = (bundledata_s *)malloc(sizeof(bundledata_s));
	if (!bundledata)
		return NULL;

	bundledata->key = strdup(key);
	bundledata->value = (void *)malloc(val_size);
	memcpy(bundledata->value, ptr_value, val_size);
	bundledata->type = value_type;

	return bundledata;
}

bool model_add_list_item(bundledata_s *bundledata)
{
	if (!bundledata) {
		controller_log(DLOG_ERROR, "Wrong input arguments.");
		return false;
	}

	modeldata->items_list = eina_list_append(modeldata->items_list,
												(const void *)bundledata);

	return true;
}

bool model_get_data_list(Eina_List **bundle_data_list)
{
	*bundle_data_list = modeldata->items_list;

	bool is_empty = (*bundle_data_list == NULL);

	if (is_empty)
		controller_log(DLOG_ERROR, "Bundle data list is empty.");

	return !is_empty;
}

modeldata_s *model_get_data(void)
{
	return modeldata;
}