/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __CREATE_GROUP_H__
#define __CREATE_GROUP_H__

/**
 *@brief Checks if the group with certain name already exist.
 *@param[in]    group_name        Group name
 *@return true if group exist, otherwise false
 */
bool sc_gcreate_is_group_exist(const char *group_name);

/**
 *@brief Creates new group in contacts database with certain name.
 *@param[in]    group_name        Group name
 *@return true if successfully created, otherwise false
 */
bool sc_gcreate_db_create_group(const char *group_name);

#endif /* __CREATE_GROUP_H__ */
