/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __GROUP_EDIT_MEMBER_H__
#define __GROUP_EDIT_MEMBER_H__

#include <contacts.h>
#include <Eina.h>

typedef struct {
	int contact_id;
	char *name;
	Eina_Bool is_checked;
} group_edit_member_check_data;

/**
 *@brief Retrieves a list of contacts records which are not present in group.
 *@remark return value MUST be destroyed with contacts_list_destroy by you
 *@param[in]    group_id        Id of group
 *@return records list on success, otherwise NULL
 */
contacts_list_h sc_gedit_member_add_contact_list_get(int group_id);

/**
 *@brief Retrieves a list of contacts records which are present in group.
 *@remark return value MUST be destroyed with contacts_list_destroy by you
 *@param[in]    group_id        Id of group
 *@return records list on success, otherwise NULL
 */
contacts_list_h sc_gedit_member_remove_contact_list_get(int group_id);

/**
 *@brief Retrieves a list of group_edit_member_check_data.
 *@remark return value MUST be destroyed with eina_list_free by you
 *@param[in]    group_id        Id of group
 *@param[in]    list            Contacts list
 *@return records list on success, otherwise NULL
 */
Eina_List *sc_gedit_member_check_data_list_get(int group_id, contacts_list_h list);

#endif /* __GROUP_EDIT_MEMBER_H__ */
